/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip;

import java.io.Serializable;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class SipConnector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(SipConnector.class);
    private String transport;
    private int port;
    private String ipAddress;
    private boolean useStun;
    private String stunServerAddress;
    private int stunServerPort;
    private String staticServerAddress;
    private int staticServerPort;
    private boolean useStaticAddress;
    private boolean replaceStaticServerAddressForInternalRoutingRequest = true;

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getStunServerAddress() {
        return this.stunServerAddress;
    }

    public void setStunServerAddress(String stunServerAddress) {
        this.stunServerAddress = stunServerAddress;
    }

    public int getStunServerPort() {
        return this.stunServerPort;
    }

    public void setStunServerPort(int stunServerPort) {
        this.stunServerPort = stunServerPort;
    }

    public boolean isUseStun() {
        return this.useStun;
    }

    public void setUseStun(boolean useStun) {
        this.useStun = useStun;
    }

    public String getStaticServerAddress() {
        return this.staticServerAddress;
    }

    public void setStaticServerAddress(String staticServerAddress) {
        this.staticServerAddress = staticServerAddress;
    }

    public int getStaticServerPort() {
        return this.staticServerPort;
    }

    public void setStaticServerPort(int staticServerPort) {
        this.staticServerPort = staticServerPort;
    }

    public boolean isUseStaticAddress() {
        return this.useStaticAddress;
    }

    public void setUseStaticAddress(boolean useStaticAddress) {
        this.useStaticAddress = useStaticAddress;
    }

    public boolean isReplaceStaticServerAddressForInternalRoutingRequest() {
        return this.replaceStaticServerAddressForInternalRoutingRequest;
    }

    public void setReplaceStaticServerAddressForInternalRoutingRequest(boolean value) {
        this.replaceStaticServerAddressForInternalRoutingRequest = value;
    }

    public void closeAllSockets() {
        if (this.transport.equalsIgnoreCase("udp")) {
            logger.warn((Object)"Cannot close TCP sockets on UDP connector");
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MBean Server = " + mbeanServer));
            }
            Set<ObjectName> queryNames = mbeanServer.queryNames(new ObjectName("*:type=GlobalRequestProcessor,*"), null);
            for (ObjectName objectName : queryNames) {
                if (!objectName.getCanonicalName().toLowerCase().contains("sip-tcp") && !objectName.getCanonicalName().toLowerCase().contains("sip-tls")) continue;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Invoking closeAllTcpSockets()");
                }
                mbeanServer.invoke(objectName, "closeAllTcpSockets", null, null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error closing the TCP sockets", (Throwable)e);
        }
    }

    private MBeanServer getMBeanServer() {
        return MBeanServerFactory.findMBeanServer(null).iterator().next();
    }

    public void sendHeartBeat(String ipAddress, int port) throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> queryNames = mbeanServer.queryNames(new ObjectName("*:type=Service,*"), null);
        for (ObjectName objectName : queryNames) {
            mbeanServer.invoke(objectName, "sendHeartBeat", new Object[]{this.ipAddress, this.port, this.transport, ipAddress, port}, new String[]{String.class.getName(), "int", String.class.getName(), String.class.getName(), "int"});
        }
    }

    public boolean setKeepAliveTimeout(String ipAddress, int port, long timeout) throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> queryNames = mbeanServer.queryNames(new ObjectName("*:type=Service,*"), null);
        boolean changed = false;
        for (ObjectName objectName : queryNames) {
            changed = (Boolean)mbeanServer.invoke(objectName, "setKeepAliveTimeout", new Object[]{this, ipAddress, port, timeout}, new String[]{SipConnector.class.getName(), String.class.getName(), "int", "long"});
            if (!changed) continue;
            return changed;
        }
        return false;
    }

    public boolean closeReliableConnection(String ipAddress, int port) throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> queryNames = mbeanServer.queryNames(new ObjectName("*:type=Service,*"), null);
        boolean changed = false;
        for (ObjectName objectName : queryNames) {
            changed = (Boolean)mbeanServer.invoke(objectName, "closeReliableConnection", new Object[]{this, ipAddress, port}, new String[]{SipConnector.class.getName(), String.class.getName(), "int"});
            if (!changed) continue;
            return changed;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.transport == null ? 0 : this.transport.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipConnector other = (SipConnector)obj;
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.transport == null ? other.transport != null : !this.transport.equals(other.transport));
    }

    public String toString() {
        return "SipConnector [ipAddress=" + this.ipAddress + ", port=" + this.port + ", transport=" + this.transport + "]";
    }
}

