/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.address;

import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.Parameterable;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.RFC2396UrlDecoder;

public abstract class ParameterableImpl
implements Parameterable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_SEPARATOR = ";";
    private static final String PARAM_NAME_VALUE_SEPARATOR = "=";
    protected Map<String, String> parameters = new ConcurrentHashMap<String, String>();
    protected transient Parameters header = null;
    protected AddressImpl.ModifiableRule isModifiable = AddressImpl.ModifiableRule.Modifiable;

    protected ParameterableImpl() {
        this.parameters = new ConcurrentHashMap<String, String>();
    }

    public ParameterableImpl(Header header, Map<String, String> params, AddressImpl.ModifiableRule isModifiable) {
        this.isModifiable = isModifiable;
        if (header instanceof Parameters) {
            this.header = (Parameters)header;
        }
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                this.parameters.put(e.getKey(), e.getValue());
            }
        }
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new NullPointerException("the parameter given in parameter is null !");
        }
        String value = this.parameters.get(name);
        if (value != null) {
            return RFC2396UrlDecoder.decode(value);
        }
        if ("lr".equals(name)) {
            return "";
        }
        return null;
    }

    public Iterator<String> getParameterNames() {
        return this.parameters.keySet().iterator();
    }

    public void removeParameter(String name) {
        if (name == null) {
            throw new NullPointerException("parameter name is null ! ");
        }
        if (this.isModifiable == AddressImpl.ModifiableRule.NotModifiable) {
            throw new IllegalStateException("it is forbidden to modify the parameters");
        }
        if (name.equalsIgnoreCase("tag") && (this.isModifiable == AddressImpl.ModifiableRule.From || this.isModifiable == AddressImpl.ModifiableRule.To)) {
            throw new IllegalStateException("it is forbidden to remove the tag parameter on To or From Header");
        }
        if (name.equalsIgnoreCase("branch") && this.isModifiable == AddressImpl.ModifiableRule.Via) {
            throw new IllegalStateException("it is forbidden to set the branch parameter on the Via Header");
        }
        this.parameters.remove(name);
        if (this.header != null) {
            this.header.removeParameter(name);
        }
    }

    public void setParameter(String name, String value) {
        if (name == null) {
            throw new NullPointerException("parameter name is null ! ");
        }
        if (value == null) {
            this.removeParameter(name);
            return;
        }
        if (this.isModifiable == AddressImpl.ModifiableRule.NotModifiable) {
            throw new IllegalStateException("it is forbidden to modify the parameters");
        }
        if (name.equalsIgnoreCase("tag") && (this.isModifiable == AddressImpl.ModifiableRule.From || this.isModifiable == AddressImpl.ModifiableRule.To)) {
            throw new IllegalStateException("it is forbidden to set the tag parameter on To or From Header");
        }
        if (name.equalsIgnoreCase("branch") && this.isModifiable == AddressImpl.ModifiableRule.Via) {
            throw new IllegalStateException("it is forbidden to set the branch parameter on the Via Header");
        }
        this.parameters.put(name.toLowerCase(), value);
        if (this.header != null) {
            try {
                this.header.setParameter(name, "".equals(value) ? null : value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Problem setting parameter", e);
            }
        }
    }

    public Set<Map.Entry<String, String>> getParameters() {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (Map.Entry<String, String> nameValue : this.parameters.entrySet()) {
            retval.put(nameValue.getKey(), RFC2396UrlDecoder.decode(nameValue.getValue()));
        }
        return retval.entrySet();
    }

    public Map<String, String> getInternalParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        boolean firstTime = true;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (!firstTime) {
                retVal.append(PARAM_SEPARATOR);
            }
            firstTime = false;
            String value = entry.getValue();
            if (value != null && value.length() > 0) {
                retVal.append(entry.getKey()).append(PARAM_NAME_VALUE_SEPARATOR).append(value);
                continue;
            }
            retVal.append(entry.getKey());
        }
        return retVal.toString();
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        if (this.header != null) {
            for (Map.Entry<String, String> nameValue : this.parameters.entrySet()) {
                try {
                    this.header.setParameter(nameValue.getKey(), nameValue.getValue());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Problem setting parameter", e);
                }
            }
        }
    }

    public abstract Object clone();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterableImpl other = (ParameterableImpl)obj;
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }
}

