/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.header.extensions.JoinHeader;
import gov.nist.javax.sip.header.extensions.ReplacesHeader;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Iterator;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipApplicationRoutingRegionType;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import javax.servlet.sip.ar.SipTargetedRequestType;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.GenericURIImpl;
import org.mobicents.servlet.sip.address.RFC2396UrlDecoder;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.SipSessionRoutingType;
import org.mobicents.servlet.sip.core.descriptor.MobicentsSipServletMapping;
import org.mobicents.servlet.sip.core.dispatchers.DispatchTask;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.RequestDispatcher;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class InitialRequestDispatcher
extends RequestDispatcher {
    private static final Logger logger = Logger.getLogger(InitialRequestDispatcher.class);

    @Override
    public void dispatchMessage(SipProvider sipProvider, SipServletMessageImpl sipServletMessage) throws DispatcherException {
        Parameters poppedAddress;
        SipApplicationRouter sipApplicationRouter = this.sipApplicationDispatcher.getSipApplicationRouter();
        MobicentsSipFactory sipFactoryImpl = this.sipApplicationDispatcher.getSipFactory();
        SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)sipServletMessage;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Routing of Initial Request " + sipServletRequest));
        }
        Request request = (Request)sipServletRequest.getMessage();
        RouteHeader poppedRoute = sipServletRequest.getPoppedRouteHeader();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("popped route : " + poppedRoute));
        }
        MobicentsSipSession sipSessionImpl = sipServletRequest.getSipSession();
        Serializable stateInfo = null;
        SipApplicationRouterInfo applicationRouterInfo = null;
        SipApplicationRoutingDirective sipApplicationRoutingDirective = SipApplicationRoutingDirective.NEW;
        SipApplicationRoutingRegion routingRegion = null;
        if (poppedRoute != null) {
            Parameters poppedAddress2 = (Parameters)poppedRoute.getAddress().getURI();
            String directive = poppedAddress2.getParameter("directive");
            if (directive != null && directive.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("directive before the request has been routed back to container : " + directive));
                }
                sipApplicationRoutingDirective = (SipApplicationRoutingDirective)SipApplicationRoutingDirective.valueOf(SipApplicationRoutingDirective.class, (String)directive);
                String regionLabel = poppedAddress2.getParameter("region_label");
                String regionType = poppedAddress2.getParameter("region_type");
                if (regionLabel != null) {
                    routingRegion = new SipApplicationRoutingRegion(regionLabel, (SipApplicationRoutingRegionType)SipApplicationRoutingRegionType.valueOf(SipApplicationRoutingRegionType.class, (String)regionType));
                }
                String previousAppName = poppedAddress2.getParameter("previousappname");
                String previousAppId = poppedAddress2.getParameter("previousappid");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("application name before the request has been routed back to container : " + previousAppName));
                    logger.debug((Object)("application session id before the request has been routed back to container : " + previousAppId));
                }
                SipContext sipContext = this.sipApplicationDispatcher.findSipApplication(previousAppName);
                SipSessionKey sipSessionKey = SessionManagerUtil.getSipSessionKey(previousAppId, previousAppName, (Message)request, false);
                sipSessionImpl = sipContext.getSipManager().getSipSession((MobicentsSipSessionKey)sipSessionKey, false, sipFactoryImpl, null);
                stateInfo = sipSessionImpl.getStateInfo();
                applicationRouterInfo = sipSessionImpl.getNextSipApplicationRouterInfo();
                sipSessionImpl.setNextSipApplicationRouterInfo(null);
                sipServletRequest.setSipSession(sipSessionImpl);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("state info before the request has been routed back to container : " + stateInfo));
                    logger.debug((Object)("router info before the request has been routed back to container : " + applicationRouterInfo));
                }
            }
        } else if (sipSessionImpl != null) {
            stateInfo = sipSessionImpl.getStateInfo();
            sipApplicationRoutingDirective = sipServletRequest.getRoutingDirective();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("previous state info : " + stateInfo));
            }
        }
        URI requestURI = request.getRequestURI();
        String targetedApplicationKey = requestURI instanceof Parameters ? ((Parameters)requestURI).getParameter("org.mobicents.servlet.sip.ApplicationSessionKey") : null;
        MobicentsSipApplicationSession encodeURISipApplicationSession = this.retrieveTargetedApplication(targetedApplicationKey);
        SipTargetedRequestInfo targetedRequestInfo = null;
        if (encodeURISipApplicationSession != null) {
            targetedRequestInfo = new SipTargetedRequestInfo(SipTargetedRequestType.ENCODED_URI, encodeURISipApplicationSession.getApplicationName());
        } else if (poppedRoute != null && (encodeURISipApplicationSession = this.retrieveTargetedApplication(targetedApplicationKey = (poppedAddress = (Parameters)poppedRoute.getAddress().getURI()).getParameter("org.mobicents.servlet.sip.ApplicationSessionKey"))) != null) {
            targetedRequestInfo = new SipTargetedRequestInfo(SipTargetedRequestType.ENCODED_URI, encodeURISipApplicationSession.getApplicationName());
        }
        SipTargetedRequestInfo joinReplacesTargetedRequestInfo = null;
        MobicentsSipSession joinReplacesCorrespondingSession = null;
        JoinHeader joinHeader = (JoinHeader)request.getHeader("Join");
        ReplacesHeader replacesHeader = (ReplacesHeader)request.getHeader("Replaces");
        if (joinHeader != null || replacesHeader != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("One Join or Replaces Header has been found : JoinHeader = " + joinHeader + ", ReplacesHeader = " + replacesHeader));
            }
            if (!"INVITE".equals(request.getMethod())) {
                throw new DispatcherException(400, "A Join or Replaces Header cannot be present in a request other than INVITE as per RFC 3911, Section 4 or RFC 3891, Section 3. Check your request " + request);
            }
            if (joinHeader != null && replacesHeader != null) {
                throw new DispatcherException(400, "A Join Header and a Replaces Header cannot be present as per RFC 3911, Section 4 in the same request " + request);
            }
            Dialog joinReplacesDialog = null;
            if (joinHeader != null) {
                joinReplacesDialog = ((SipStackExt)sipProvider.getSipStack()).getJoinDialog(joinHeader);
            }
            if (replacesHeader != null) {
                joinReplacesDialog = ((SipStackExt)sipProvider.getSipStack()).getReplacesDialog(replacesHeader);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("joinReplacesDialog = " + joinReplacesDialog + ", targetedRequestInfo = " + targetedRequestInfo));
            }
            if (targetedRequestInfo == null && (joinReplacesDialog != null || targetedRequestInfo != null)) {
                if (joinReplacesDialog != null && (TransactionApplicationData)joinReplacesDialog.getApplicationData() != null && !"INVITE".equals(((TransactionApplicationData)joinReplacesDialog.getApplicationData()).getSipServletMessage().getMethod())) {
                    throw new DispatcherException(481, "Join/Replaces header field matches a dialog which was not created with an INVITE as per RFC 3911, Section 4 or RFC 3891, Section 3 in the request " + request);
                }
                if (joinReplacesDialog != null && DialogState.TERMINATED.equals((Object)joinReplacesDialog.getState())) {
                    throw new DispatcherException(603, "Join/Replaces header field matches a dialog which has already terminated as per RFC 3911, Section 4 or RFC 3891, Section 3 in the request " + request);
                }
            }
            if ((joinReplacesCorrespondingSession = this.retrieveSipSession(joinReplacesDialog)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following matching sip session has been found for the Join or Replaces Header " + joinReplacesCorrespondingSession.getKey()));
                }
                SipTargetedRequestType sipTargetedRequestType = null;
                if (joinHeader != null) {
                    sipTargetedRequestType = SipTargetedRequestType.JOIN;
                }
                if (replacesHeader != null) {
                    sipTargetedRequestType = SipTargetedRequestType.REPLACES;
                }
                joinReplacesTargetedRequestInfo = new SipTargetedRequestInfo(sipTargetedRequestType, joinReplacesCorrespondingSession.getKey().getApplicationName());
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"no matching sip session found for the Join or Replaces Header");
            }
        }
        if (joinReplacesTargetedRequestInfo != null) {
            targetedRequestInfo = joinReplacesTargetedRequestInfo;
        }
        sipServletRequest.setReadOnly(true);
        if (applicationRouterInfo == null) {
            applicationRouterInfo = sipApplicationRouter.getNextApplication((SipServletRequest)sipServletRequest, routingRegion, sipApplicationRoutingDirective, targetedRequestInfo, stateInfo);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("application name selected by the AR before re routing this request back to the container " + applicationRouterInfo.getNextApplicationName()));
        }
        sipServletRequest.setReadOnly(false);
        if (this.checkRouteModifier(applicationRouterInfo, sipServletRequest)) {
            return;
        }
        if (applicationRouterInfo.getNextApplicationName() == null) {
            this.dispatchOutsideContainer(sipServletRequest);
        } else {
            this.dispatchInsideContainer(sipProvider, applicationRouterInfo, sipServletRequest, sipFactoryImpl, joinReplacesCorrespondingSession, encodeURISipApplicationSession);
        }
    }

    private void dispatchInsideContainer(SipProvider sipProvider, SipApplicationRouterInfo applicationRouterInfo, SipServletRequestImpl sipServletRequest, MobicentsSipFactory sipFactoryImpl, MobicentsSipSession joinReplacesSipSession, MobicentsSipApplicationSession encodeURISipApplicationSession) throws DispatcherException {
        String nextApplicationName = applicationRouterInfo.getNextApplicationName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching the request event to " + nextApplicationName));
        }
        Request request = (Request)sipServletRequest.getMessage();
        sipServletRequest.setCurrentApplicationName(nextApplicationName);
        SipContext sipContext = this.sipApplicationDispatcher.findSipApplication(nextApplicationName);
        if (sipContext == null) {
            throw new DispatcherException(500, "No matching deployed application has been found !");
        }
        SipManager sipManager = sipContext.getSipManager();
        if (applicationRouterInfo.getSubscriberURI() != null) {
            try {
                URI subscriberUri = SipFactoryImpl.addressFactory.createAddress(applicationRouterInfo.getSubscriberURI()).getURI();
                URIImpl jainSipSubscriberUri = null;
                jainSipSubscriberUri = subscriberUri instanceof javax.sip.address.SipURI ? new SipURIImpl((javax.sip.address.SipURI)subscriberUri, AddressImpl.ModifiableRule.NotModifiable) : (subscriberUri instanceof javax.sip.address.TelURL ? new TelURLImpl((javax.sip.address.TelURL)subscriberUri) : new GenericURIImpl(subscriberUri));
                sipServletRequest.setSubscriberURI(jainSipSubscriberUri);
            }
            catch (ParseException pe) {
                throw new DispatcherException(500, "Impossible to parse the subscriber URI returned by the Application Router " + applicationRouterInfo.getSubscriberURI() + ", please put one of DAR:<HeaderName> with Header containing a valid URI or an exlicit valid URI ", (Throwable)pe);
            }
        }
        MobicentsSipApplicationSession sipApplicationSession = encodeURISipApplicationSession;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("the encoded URI Sip Application Session is " + sipApplicationSession));
        }
        if (joinReplacesSipSession != null && nextApplicationName.equals(joinReplacesSipSession.getKey().getApplicationName())) {
            JoinHeader joinHeader = (JoinHeader)request.getHeader("Join");
            ReplacesHeader replacesHeader = (ReplacesHeader)request.getHeader("Replaces");
            String headerName = null;
            if (joinHeader != null) {
                headerName = "Join";
            } else if (replacesHeader != null) {
                headerName = "Replaces";
            }
            sipApplicationSession = joinReplacesSipSession.getSipApplicationSession();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reusing the application session from the Join/Replaces " + sipApplicationSession.getId()));
            }
            SipApplicationSessionKey sipApplicationSessionKey = InitialRequestDispatcher.makeAppSessionKey(sipContext, sipServletRequest, nextApplicationName);
            sipContext.getSipSessionsUtil().addCorrespondingSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, sipApplicationSession.getKey(), headerName);
        } else if (sipApplicationSession == null) {
            String jvmRoute;
            SipApplicationSessionKey sipApplicationSessionKey = InitialRequestDispatcher.makeAppSessionKey(sipContext, sipServletRequest, nextApplicationName);
            sipApplicationSession = sipManager.getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, true);
            if (StaticServiceHolder.sipStandardService.isHttpFollowsSip() && (jvmRoute = StaticServiceHolder.sipStandardService.getJvmRoute()) != null) {
                sipApplicationSession.setJvmRoute(jvmRoute);
            }
        }
        MobicentsSipApplicationSession appSession = sipApplicationSession;
        SipSessionKey sessionKey = SessionManagerUtil.getSipSessionKey(appSession.getKey().getId(), nextApplicationName, (Message)request, false);
        MobicentsSipSession sipSessionImpl = sipManager.getSipSession((MobicentsSipSessionKey)sessionKey, true, sipFactoryImpl, appSession);
        sipServletRequest.setSipSession(sipSessionImpl);
        if (joinReplacesSipSession != null && nextApplicationName.equals(joinReplacesSipSession.getKey().getApplicationName())) {
            JoinHeader joinHeader = (JoinHeader)request.getHeader("Join");
            ReplacesHeader replacesHeader = (ReplacesHeader)request.getHeader("Replaces");
            String headerName = null;
            if (joinHeader != null) {
                headerName = "Join";
            } else if (replacesHeader != null) {
                headerName = "Replaces";
            }
            sipContext.getSipSessionsUtil().addCorrespondingSipSession(sipSessionImpl, joinReplacesSipSession, headerName);
        }
        sipSessionImpl.setStateInfo(applicationRouterInfo.getStateInfo());
        sipSessionImpl.setRoutingRegion(applicationRouterInfo.getRoutingRegion());
        sipServletRequest.setRoutingRegion(applicationRouterInfo.getRoutingRegion());
        if (sipServletRequest.getSubscriberURI() != null) {
            sipSessionImpl.setSipSubscriberURI(sipServletRequest.getSubscriberURI().toString());
        }
        long cSeq = ((CSeqHeader)request.getHeader("CSeq")).getSeqNumber();
        sipSessionImpl.setCseq(cSeq);
        if (request.getMethod().equals("INVITE")) {
            sipSessionImpl.setRequestsPending(sipSessionImpl.getRequestsPending() + 1);
            sipSessionImpl.setAckReceived(cSeq, false);
        }
        InitialDispatchTask dispatchTask = new InitialDispatchTask(sipServletRequest, sipProvider);
        sipContext.enterSipApp(sipApplicationSession, sipSessionImpl, false, true);
        ViaHeader via = (ViaHeader)request.getHeader("Via");
        sipSessionImpl.setTransport(via.getTransport());
        this.handleSipOutbound(sipServletRequest);
        if (this.sipApplicationDispatcher.isBypassRequestExecutor() || ConcurrencyControlMode.Transaction.equals((Object)sipContext.getConcurrencyControlMode())) {
            dispatchTask.dispatchAndHandleExceptions();
        } else {
            this.getConcurrencyModelExecutorService(sipContext, sipServletRequest).execute(dispatchTask);
        }
    }

    private void dispatchOutsideContainer(SipServletRequestImpl sipServletRequest) throws DispatcherException {
        Request request = (Request)sipServletRequest.getMessage();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Dispatching the request event outside the container");
        }
        if (request.getRequestURI() instanceof TelURL) {
            throw new DispatcherException(500, "cannot dispatch a request with a tel url request uri outside the container ");
        }
        javax.sip.address.SipURI sipRequestUri = (javax.sip.address.SipURI)request.getRequestURI();
        String host = sipRequestUri.getHost();
        int port = sipRequestUri.getPort();
        String transport = JainSipUtils.findTransport((Message)request);
        boolean isAnotherDomain = this.sipApplicationDispatcher.isExternal(host, port, transport);
        ListIterator<String> routeHeaders = sipServletRequest.getHeaders("Route");
        if (isAnotherDomain || routeHeaders.hasNext()) {
            try {
                this.forwardRequestStatefully(sipServletRequest, SipSessionRoutingType.PREVIOUS_SESSION, SipRouteModifier.NO_ROUTE);
            }
            catch (Exception e) {
                throw new DispatcherException(500, "Unexpected Exception while trying to forward statefully the following initial request " + request, (Throwable)e);
            }
        } else {
            throw new DispatcherException(404, "the Request-URI does not point to another domain, and there is no Route header,the container should not send the request as it will cause a loop. Instead, the container must reject the request with 404 Not Found final response with no Retry-After header. You may want to check your dar configuration file to see if the request can be handled or make sure you use the correct Application Router jar.");
        }
    }

    private final boolean checkRouteModifier(SipApplicationRouterInfo applicationRouterInfo, SipServletRequestImpl sipServletRequest) throws DispatcherException {
        SipRouteModifier sipRouteModifier = applicationRouterInfo.getRouteModifier();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("the AR returned the following sip route modifier" + sipRouteModifier));
        }
        if (sipRouteModifier != null) {
            Request request = (Request)sipServletRequest.getMessage();
            String[] routes = applicationRouterInfo.getRoutes();
            switch (sipRouteModifier) {
                case ROUTE: {
                    Address routeAddress = null;
                    RouteHeader applicationRouterInfoRouteHeader = null;
                    try {
                        routeAddress = SipFactoryImpl.addressFactory.createAddress(routes[0]);
                        applicationRouterInfoRouteHeader = SipFactoryImpl.headerFactory.createRouteHeader(routeAddress);
                        if (this.sipApplicationDispatcher.isRouteExternal(applicationRouterInfoRouteHeader)) {
                            for (int i = routes.length - 1; i >= 0; --i) {
                                routeAddress = SipFactoryImpl.addressFactory.createAddress(routes[i]);
                                URI routeURI = routeAddress.getURI();
                                if (routeURI.isSipURI()) {
                                    ((javax.sip.address.SipURI)routeURI).setLrParam();
                                }
                                RouteHeader routeHeader = SipFactoryImpl.headerFactory.createRouteHeader(routeAddress);
                                try {
                                    request.addFirst((Header)routeHeader);
                                    continue;
                                }
                                catch (SipException e) {
                                    throw new DispatcherException(500, "Unexpected Exception while trying to add a route header to route externally the following initial request " + request, (Throwable)e);
                                }
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Routing the request externally " + sipServletRequest));
                            }
                            request.setRequestURI(SipFactoryImpl.addressFactory.createURI(routes[0]));
                            try {
                                this.forwardRequestStatefully(sipServletRequest, null, sipRouteModifier);
                                return true;
                            }
                            catch (Exception e) {
                                throw new DispatcherException(500, "Unexpected Exception while trying to forward statefully the following initial request " + request, (Throwable)e);
                            }
                        }
                        sipServletRequest.setPoppedRoute(applicationRouterInfoRouteHeader);
                        break;
                    }
                    catch (ParseException e) {
                        throw new DispatcherException(500, "Impossible to parse the route returned by the application router into a compliant address", (Throwable)e);
                    }
                }
                case NO_ROUTE: {
                    break;
                }
                case ROUTE_BACK: {
                    try {
                        SipURI sipURI = (SipURI)this.sipApplicationDispatcher.getOutboundInterfaces().get(0);
                        sipURI.setParameter("modifier", "route_back");
                        Header routeHeader = SipFactoryImpl.headerFactory.createHeader("Route", sipURI.toString());
                        try {
                            request.addFirst(routeHeader);
                            for (int i = routes.length - 1; i >= 0; --i) {
                                routeHeader = SipFactoryImpl.headerFactory.createHeader("Route", routes[i]);
                                request.addFirst(routeHeader);
                            }
                        }
                        catch (SipException e) {
                            throw new DispatcherException(500, "Unexpected Exception while trying to add a route header to route externally the following initial request " + request, (Throwable)e);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Routing the request externally " + sipServletRequest));
                        }
                        try {
                            this.forwardRequestStatefully(sipServletRequest, null, sipRouteModifier);
                            return true;
                        }
                        catch (Exception e) {
                            throw new DispatcherException(500, "Unexpected Exception while trying to forward statefully the following subsequent request " + request, (Throwable)e);
                        }
                    }
                    catch (ParseException e) {
                        throw new DispatcherException(500, "Impossible to parse the route returned by the application router into a compliant address", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    private final MobicentsSipApplicationSession retrieveTargetedApplication(String targetedApplicationKey) {
        if (targetedApplicationKey != null && targetedApplicationKey.length() > 0) {
            SipApplicationSessionKey targetedApplicationSessionKey;
            targetedApplicationKey = RFC2396UrlDecoder.decode(targetedApplicationKey);
            try {
                targetedApplicationSessionKey = SessionManagerUtil.parseSipApplicationSessionKey(targetedApplicationKey);
            }
            catch (ParseException e) {
                logger.error((Object)("Couldn't parse the targeted application key " + targetedApplicationKey), (Throwable)e);
                return null;
            }
            SipContext sipContext = this.sipApplicationDispatcher.findSipApplication(targetedApplicationSessionKey.getApplicationName());
            if (sipContext != null) {
                return sipContext.getSipManager().getSipApplicationSession((MobicentsSipApplicationSessionKey)targetedApplicationSessionKey, false);
            }
        }
        return null;
    }

    private MobicentsSipSession retrieveSipSession(Dialog dialog) {
        if (dialog != null) {
            Iterator iterator = this.sipApplicationDispatcher.findSipApplications();
            while (iterator.hasNext()) {
                SipContext sipContext = (SipContext)iterator.next();
                SipManager sipManager = sipContext.getSipManager();
                Iterator sipSessionsIt = sipManager.getAllSipSessions();
                while (sipSessionsIt.hasNext()) {
                    MobicentsSipSession mobicentsSipSession = (MobicentsSipSession)sipSessionsIt.next();
                    MobicentsSipSessionKey sessionKey = mobicentsSipSession.getKey();
                    if (!sessionKey.getCallId().trim().equals(dialog.getCallId().getCallId())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("found session with the same Call Id " + sessionKey + ", to Tag " + sessionKey.getToTag()));
                        logger.debug((Object)("dialog localParty = " + dialog.getLocalParty().getURI() + ", localTag " + dialog.getLocalTag()));
                        logger.debug((Object)("dialog remoteParty = " + dialog.getRemoteParty().getURI() + ", remoteTag " + dialog.getRemoteTag()));
                    }
                    if (!(sessionKey.getFromTag().equals(dialog.getLocalTag()) && sessionKey.getToTag().equals(dialog.getRemoteTag()) ? mobicentsSipSession.getProxy() == null : sessionKey.getFromTag().equals(dialog.getRemoteTag()) && sessionKey.getToTag().equals(dialog.getLocalTag()) && mobicentsSipSession.getProxy() == null)) continue;
                    return mobicentsSipSession;
                }
            }
        }
        return null;
    }

    public static class InitialDispatchTask
    extends DispatchTask {
        InitialDispatchTask(SipServletRequestImpl sipServletRequest, SipProvider sipProvider) {
            super(sipServletRequest, sipProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() throws DispatcherException {
            SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)this.sipServletMessage;
            MobicentsSipSession sipSessionImpl = sipServletRequest.getSipSession();
            MobicentsSipApplicationSession appSession = sipSessionImpl.getSipApplicationSession();
            SipContext sipContext = appSession.getSipContext();
            Request request = (Request)sipServletRequest.getMessage();
            boolean batchStarted = sipContext.enterSipAppHa(true);
            try {
                sipSessionImpl.setSessionCreatingTransactionRequest((MobicentsSipServletMessage)sipServletRequest);
                String sipSessionHandlerName = sipSessionImpl.getHandler();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sipSessionHandlerName = " + sipSessionHandlerName));
                }
                if (sipSessionHandlerName == null || sipSessionHandlerName.length() < 1) {
                    String mainServlet = appSession.getCurrentRequestHandler();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("current request Handler = " + sipSessionHandlerName));
                    }
                    if (sipContext.isMainServlet() && mainServlet != null && mainServlet.length() > 0) {
                        sipSessionHandlerName = mainServlet;
                    } else {
                        MobicentsSipServletMapping sipServletMapping = sipContext.findSipServletMappings((SipServletRequest)sipServletRequest);
                        if (sipServletMapping == null && sipContext.getSipRubyController() == null) {
                            logger.error((Object)"Sending 404 because no matching servlet found for this request ");
                            MessageDispatcher.sendErrorResponse(404, sipServletRequest, this.sipProvider);
                            return;
                        }
                        if (sipServletMapping != null) {
                            sipSessionHandlerName = sipServletMapping.getServletName();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("servlet mapping Handler Name= " + sipSessionHandlerName));
                            }
                        }
                    }
                    if (sipSessionHandlerName != null) {
                        try {
                            sipSessionImpl.setHandler(sipSessionHandlerName);
                        }
                        catch (ServletException e) {
                            throw new DispatcherException(500, "An unexpected servlet exception occured while routing an initial request", (Throwable)e);
                        }
                    }
                }
                try {
                    MessageDispatcher.callServlet(sipServletRequest);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Request event dispatched to " + sipContext.getApplicationName()));
                    }
                }
                catch (ServletException e) {
                    throw new DispatcherException(500, "An unexpected servlet exception occured while routing the following initial request " + request, (Throwable)e);
                }
                catch (IOException e) {
                    throw new DispatcherException(500, "An unexpected IO exception occured while routing the following initial request " + request, (Throwable)e);
                }
            }
            finally {
                sipSessionImpl.setRoutingRegion(null);
                sipSessionImpl.setSipSubscriberURI(null);
                sipContext.exitSipAppHa((MobicentsSipServletRequest)sipServletRequest, null, batchStarted);
                sipContext.exitSipApp(appSession, sipSessionImpl);
            }
        }
    }
}

