/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.MobicentsSipServlet;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.descriptor.MobicentsSipServletMapping;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;

public abstract class MessageDispatcher {
    private static final Logger logger = Logger.getLogger(MessageDispatcher.class);
    public static final String ROUTE_PARAM_DIRECTIVE = "directive";
    public static final String ROUTE_PARAM_REGION_LABEL = "region_label";
    public static final String ROUTE_PARAM_REGION_TYPE = "region_type";
    public static final String ROUTE_PARAM_PREV_APPLICATION_NAME = "previousappname";
    public static final String ROUTE_PARAM_PREV_APP_ID = "previousappid";
    public static final String RR_PARAM_SERVER_NAME = "as";
    public static final String RR_PARAM_APPLICATION_NAME = "appname";
    public static final String RR_PARAM_PROXY_APP = "proxy";
    public static final String BRANCH_MAGIC_COOKIE = "z9hG4bK";
    public static final String APP_ID = "app_id";
    public static final String ROUTE_PARAM_NODE_HOST = "node_host";
    public static final String ROUTE_PARAM_NODE_PORT = "node_port";
    protected SipApplicationDispatcher sipApplicationDispatcher = null;
    public static final String SIP_OUTBOUND_PARAM_OB = "ob";
    public static final String SIP_OUTBOUND_PARAM_REG_ID = "reg-id";

    public static void sendErrorResponse(int errorCode, SipServletRequestImpl sipServletRequest, SipProvider sipProvider) {
        MessageDispatcher.sendErrorResponse(errorCode, (ServerTransaction)sipServletRequest.getTransaction(), (Request)sipServletRequest.getMessage(), sipProvider);
        if (sipServletRequest.getSipSession() != null) {
            sipServletRequest.getSipSession().updateStateOnResponse((MobicentsSipServletResponse)((SipServletResponseImpl)sipServletRequest.createResponse(500)), false);
        }
    }

    public static void sendErrorResponse(int errorCode, ServerTransaction transaction, Request request, SipProvider sipProvider) {
        try {
            Response response = SipFactoryImpl.messageFactory.createResponse(errorCode, request);
            if (transaction != null) {
                transaction.sendResponse(response);
            } else {
                sipProvider.sendResponse(response);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Problem while sending the error response to the following request " + request.toString()), (Throwable)e);
        }
    }

    protected static SipApplicationSessionKey makeAppSessionKey(SipContext sipContext, SipServletRequestImpl sipServletRequestImpl, String applicationName) throws DispatcherException {
        String appGeneratedKey = null;
        Method appKeyMethod = null;
        if (sipServletRequestImpl.isInitial() && sipContext != null) {
            appKeyMethod = sipContext.getSipApplicationKeyMethod();
        }
        if (appKeyMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("For request target to application " + sipContext.getApplicationName() + ", using the following annotated method to generate the application key " + appKeyMethod));
            }
            sipServletRequestImpl.setReadOnly(true);
            Servlet servlet = null;
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(sipContext.getSipContextClassLoader());
            Class<?> methodDeclaringClass = appKeyMethod.getDeclaringClass();
            MobicentsSipServlet sipServletImpl = sipContext.findSipServletByClassName(methodDeclaringClass.getCanonicalName());
            if (sipServletImpl != null) {
                try {
                    Method newMethod;
                    servlet = sipServletImpl.allocate();
                    appKeyMethod = newMethod = servlet.getClass().getMethod(appKeyMethod.getName(), appKeyMethod.getParameterTypes());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking the application key method " + appKeyMethod.getName() + ", on the following servlet " + methodDeclaringClass.getCanonicalName()));
                    }
                }
                catch (ServletException e) {
                    throw new DispatcherException(500, "Couldn't allocate the sip servlet to invoke the key annotated method !", (Throwable)e);
                }
                catch (SecurityException e) {
                    throw new DispatcherException(500, "Couldn't allocate the sip servlet to invoke the key annotated method !", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new DispatcherException(500, "Couldn't allocate the sip servlet to invoke the key annotated method !", (Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            try {
                appGeneratedKey = (String)appKeyMethod.invoke((Object)servlet, sipServletRequestImpl);
            }
            catch (IllegalArgumentException e) {
                throw new DispatcherException(500, "Couldn't invoke the app session key annotated method !", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new DispatcherException(500, "Couldn't invoke the app session key annotated method !", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new DispatcherException(500, "A Problem occured while invoking the app session key annotated method !", (Throwable)e);
            }
            finally {
                sipServletRequestImpl.setReadOnly(false);
                if (sipServletImpl != null) {
                    try {
                        sipServletImpl.deallocate(servlet);
                    }
                    catch (ServletException e) {
                        throw new DispatcherException(500, "Couldn't deallocate the sip servlet to invoke the key annotated method !", (Throwable)e);
                    }
                }
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("For request target to application " + sipContext.getApplicationName() + ", following annotated method " + appKeyMethod + " generated the application key : " + appGeneratedKey));
            }
        }
        SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(applicationName, null, appGeneratedKey);
        return sipApplicationSessionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callServletForOrphanRequest(SipContext sipContext, SipServletRequestImpl request) throws DispatcherException, ServletException, IOException {
        MobicentsSipServlet sipServletImpl;
        String servletHandler;
        String mainServlet = servletHandler = sipContext.getServletHandler();
        if (sipContext.isMainServlet() && mainServlet != null && mainServlet.length() > 0) {
            servletHandler = mainServlet;
        } else {
            MobicentsSipServletMapping sipServletMapping = sipContext.findSipServletMappings((SipServletRequest)request);
            if (sipServletMapping == null && sipContext.getSipRubyController() == null) {
                logger.error((Object)"Sending 404 because no matching servlet found for this request ");
                throw new DispatcherException(404);
            }
            if (sipServletMapping != null) {
                servletHandler = sipServletMapping.getServletName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("servlet mapping Handler Name= " + servletHandler));
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("current request Handler " + servletHandler + " for orphan Request = " + request));
        }
        if ((sipServletImpl = sipContext.findSipServletByName(servletHandler)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dispatching orphan request " + request.toString() + " to servlet " + servletHandler));
            }
            Servlet servlet = sipServletImpl.allocate();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipContext();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking instance " + servlet));
                    }
                    servlet.service((ServletRequest)request, null);
                }
                finally {
                    sipServletImpl.deallocate(servlet);
                }
            }
            finally {
                sipContext.exitSipContext(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callServletForOrphanResponse(SipContext sipContext, SipServletResponse response) throws DispatcherException, ServletException, IOException {
        MobicentsSipServlet sipServletImpl;
        String servletHandler;
        String mainServlet = servletHandler = sipContext.getServletHandler();
        SipServletResponseImpl responseExt = (SipServletResponseImpl)response;
        responseExt.setOrphan(true);
        responseExt.setCurrentApplicationName(sipContext.getApplicationName());
        if (sipContext.isMainServlet() && mainServlet != null && mainServlet.length() > 0) {
            servletHandler = mainServlet;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("servlet mapping Handler Name= " + servletHandler));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("current request Handler " + servletHandler + " for orphan Request = " + response));
        }
        if ((sipServletImpl = sipContext.findSipServletByName(servletHandler)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dispatching orphan request " + response.toString() + " to servlet " + servletHandler));
            }
            Servlet servlet = sipServletImpl.allocate();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipContext();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking instance " + servlet));
                    }
                    if (response.getStatus() > 100) {
                        servlet.service(null, (ServletResponse)response);
                    }
                }
                finally {
                    sipServletImpl.deallocate(servlet);
                }
            }
            finally {
                sipContext.exitSipContext(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callServlet(MobicentsSipServletRequest request) throws ServletException, IOException {
        block20: {
            MobicentsSipSession session = request.getSipSession();
            String sessionHandler = session.getHandler();
            MobicentsSipApplicationSession sipApplicationSessionImpl = session.getSipApplicationSession();
            SipContext sipContext = sipApplicationSessionImpl.getSipContext();
            MobicentsSipServlet sipServletImpl = sipContext.findSipServletByName(sessionHandler);
            if (sipServletImpl != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dispatching request " + request.toString() + " to following App/servlet => " + session.getKey().getApplicationName() + "/" + session.getHandler() + " on following sip session " + session.getId()));
                }
                Servlet servlet = sipServletImpl.allocate();
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    sipContext.enterSipContext();
                    if (!MessageDispatcher.securityCheck(request)) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking instance " + servlet));
                    }
                    try {
                        servlet.service((ServletRequest)request, null);
                        break block20;
                    }
                    finally {
                        sipServletImpl.deallocate(servlet);
                    }
                }
                finally {
                    sipContext.exitSipContext(oldClassLoader);
                }
            }
            if (sipContext.getSipRubyController() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dispatching request " + request.toString() + " to following App/ruby controller => " + request.getSipSession().getKey().getApplicationName() + "/" + sipContext.getSipRubyController().getName()));
                }
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader cl = sipContext.getSipContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    sipContext.getSipRubyController().routeSipMessageToRubyApp(sipContext.getServletContext(), (SipServletMessage)request);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            logger.error((Object)("no handler found for sip session " + session.getKey() + " and request " + request));
            Transaction transaction = request.getTransaction();
            if (transaction != null) {
                TransactionApplicationData tad = (TransactionApplicationData)transaction.getApplicationData();
                if (tad != null) {
                    tad.cleanUp();
                }
                transaction.setApplicationData(null);
                try {
                    transaction.terminate();
                }
                catch (ObjectInUseException e) {
                    logger.error((Object)("transaction " + transaction.getBranchId() + " for request " + request + " couldn't be terminated"));
                }
            }
            request.setSipSession(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callServlet(MobicentsSipServletResponse response) throws ServletException, IOException {
        MobicentsSipSession session = response.getSipSession();
        String sessionHandler = session.getHandler();
        MobicentsSipApplicationSession sipApplicationSessionImpl = session.getSipApplicationSession();
        SipContext sipContext = sipApplicationSessionImpl.getSipContext();
        MobicentsSipServlet sipServletImpl = sipContext.findSipServletByName(sessionHandler);
        if (sipServletImpl == null || sipServletImpl.isUnavailable()) {
            if (sipContext.getSipRubyController() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dispatching response " + response.toString() + " to following App/ruby controller => " + response.getSipSession().getKey().getApplicationName() + "/" + sipContext.getSipRubyController().getName()));
                }
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader cl = sipContext.getSipContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    sipContext.getSipRubyController().routeSipMessageToRubyApp(sipContext.getServletContext(), (SipServletMessage)response);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            } else {
                logger.warn((Object)(sessionHandler + " is unavailable, dropping response " + response));
            }
        } else {
            Servlet servlet = sipServletImpl.allocate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dispatching response " + response.toString() + " to following App/servlet => " + session.getKey().getApplicationName() + "/" + session.getHandler() + " on following sip session " + session.getId()));
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipContext();
                try {
                    servlet.service(null, (ServletResponse)response);
                }
                finally {
                    sipServletImpl.deallocate(servlet);
                }
            }
            finally {
                sipContext.exitSipContext(oldClassLoader);
            }
        }
    }

    public static boolean securityCheck(MobicentsSipServletRequest request) {
        MobicentsSipApplicationSession appSession = request.getSipApplicationSession(true);
        SipContext sipStandardContext = appSession.getSipContext();
        boolean authorized = sipStandardContext.authorize(request);
        return authorized;
    }

    public abstract void dispatchMessage(SipProvider var1, SipServletMessageImpl var2) throws DispatcherException;

    public final ExecutorService getConcurrencyModelExecutorService(SipContext sipContext, SipServletMessageImpl sipServletMessage) {
        return this.sipApplicationDispatcher.getAsynchronousExecutor();
    }
}

