/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.dispatchers.DispatchTask;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.session.DistributableSipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyImpl;

public class ResponseDispatcher
extends MessageDispatcher {
    private static final Logger logger = Logger.getLogger(ResponseDispatcher.class);

    @Override
    public void dispatchMessage(SipProvider sipProvider, SipServletMessageImpl sipServletMessage) throws DispatcherException {
        SipFactoryImpl sipFactoryImpl = (SipFactoryImpl)this.sipApplicationDispatcher.getSipFactory();
        final SipServletResponseImpl sipServletResponse = (SipServletResponseImpl)sipServletMessage;
        final Response response = sipServletResponse.getResponse();
        ListIterator viaHeaders = response.getHeaders("Via");
        ViaHeader viaHeader = (ViaHeader)viaHeaders.next();
        final String branch = viaHeader.getBranch();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("viaHeader = " + viaHeader.toString()));
            logger.debug((Object)("viaHeader branch = " + branch));
        }
        if (!this.sipApplicationDispatcher.isViaHeaderExternal(viaHeader)) {
            SipContext sipContext;
            String strippedBranchId;
            int indexOfUnderscore;
            ClientTransaction clientTransaction = (ClientTransaction)sipServletResponse.getTransaction();
            final Dialog dialog = sipServletResponse.getDialog();
            TransactionApplicationData applicationData = null;
            SipServletRequestImpl tmpOriginalRequest = null;
            if (clientTransaction != null) {
                applicationData = (TransactionApplicationData)clientTransaction.getApplicationData();
                if (applicationData.getSipServletMessage() instanceof SipServletRequestImpl) {
                    tmpOriginalRequest = (SipServletRequestImpl)applicationData.getSipServletMessage();
                    if (applicationData.getHops() != null && response.getStatusCode() >= 200) {
                        applicationData.getHops().clear();
                    }
                }
                applicationData.addSipServletResponse(sipServletResponse);
                ViaHeader nextViaHeader = null;
                if (viaHeaders.hasNext()) {
                    nextViaHeader = (ViaHeader)viaHeaders.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("nextViaHeader = " + nextViaHeader.toString()));
                        logger.debug((Object)("viaHeader branch = " + nextViaHeader.getBranch()));
                    }
                }
                this.checkInitialRemoteInformation(sipServletMessage, nextViaHeader);
            } else if (dialog != null) {
                applicationData = (TransactionApplicationData)dialog.getApplicationData();
                if (applicationData != null) {
                    if (applicationData.getSipServletMessage() instanceof SipServletRequestImpl) {
                        tmpOriginalRequest = (SipServletRequestImpl)applicationData.getSipServletMessage();
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"application data is null, it means that this is a forked response, please enable stack property support for it through gov.nist.javax.sip.MAX_FORK_TIME_SECONDS");
                    logger.debug((Object)("Dropping forked response " + response));
                    return;
                }
            }
            if (tmpOriginalRequest == null) {
                SIPTransaction tx = null;
                tx = clientTransaction != null ? (SIPTransaction)clientTransaction : ((SIPTransactionStack)sipProvider.getSipStack()).findTransaction((SIPMessage)response, true);
                if (tx != null) {
                    tmpOriginalRequest = (SipServletRequestImpl)sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(tx.getRequest(), null, null, null, false);
                }
            }
            final SipServletRequestImpl originalRequest = tmpOriginalRequest;
            sipServletResponse.setOriginalRequest(originalRequest);
            if (applicationData != null) {
                String appNameNotDeployed = applicationData.getAppNotDeployed();
                if (appNameNotDeployed != null && appNameNotDeployed.length() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("appNameNotDeployed = " + appNameNotDeployed + " forwarding the response."));
                    }
                    this.forwardResponseStatefully(sipServletResponse);
                    return;
                }
                boolean noAppReturned = applicationData.isNoAppReturned();
                if (noAppReturned) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"isNoAppReturned forwarding the response.");
                    }
                    this.forwardResponseStatefully(sipServletResponse);
                    return;
                }
                String modifier = applicationData.getModifier();
                if (modifier != null && modifier.length() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("modifier = " + modifier + " forwarding the response."));
                    }
                    this.forwardResponseStatefully(sipServletResponse);
                    return;
                }
            }
            if ((indexOfUnderscore = (strippedBranchId = branch.substring("z9hG4bK".length())).indexOf("_")) == -1) {
                if (sipServletResponse.getStatus() == 100) {
                    return;
                }
                throw new DispatcherException("the via header branch " + branch + " for the response is wrong the response does not reuse the one from the original request");
            }
            String appId = strippedBranchId.substring(0, indexOfUnderscore);
            indexOfUnderscore = strippedBranchId.indexOf("_");
            if (indexOfUnderscore == -1) {
                throw new DispatcherException("the via header branch " + branch + " for the response is wrong the response does not reuse the one from the original request");
            }
            if ((indexOfUnderscore = (strippedBranchId = strippedBranchId.substring(indexOfUnderscore + 1)).indexOf("_")) == -1) {
                throw new DispatcherException("the via header branch " + branch + " for the response is wrong the response does not reuse the one from the original request");
            }
            String appNameHashed = strippedBranchId.substring(0, indexOfUnderscore);
            String appName = this.sipApplicationDispatcher.getApplicationNameFromHash(appNameHashed);
            if (appName == null) {
                throw new DispatcherException("the via header branch " + branch + " for the response is missing the appname previsouly set by the container");
            }
            boolean inverted = false;
            if (dialog != null && dialog.isServer()) {
                inverted = true;
            }
            if ((sipContext = this.sipApplicationDispatcher.findSipApplication(appName)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The application " + appName + " is not deployed anymore, fowarding response statefully to the next app in chain if any"));
                }
                this.forwardResponseStatefully(sipServletResponse);
                return;
            }
            SipManager sipManager = sipContext.getSipManager();
            SipSessionKey sessionKey = SessionManagerUtil.getSipSessionKey(appId, appName, (Message)response, inverted);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to find session with following session key " + sessionKey));
            }
            SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(appName, appId, null);
            MobicentsSipApplicationSession sipApplicationSession = null;
            if (sipManager instanceof DistributableSipManager) {
                sipApplicationSession = sipManager.getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, false);
            }
            MobicentsSipSession tmpSession = null;
            tmpSession = sipManager.getSipSession((MobicentsSipSessionKey)sessionKey, false, (MobicentsSipFactory)sipFactoryImpl, sipApplicationSession);
            if (tmpSession == null) {
                sessionKey = SessionManagerUtil.getSipSessionKey(appId, appName, (Message)response, !inverted);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to find session with following session key " + sessionKey));
                }
                tmpSession = sipManager.getSipSession((MobicentsSipSessionKey)sessionKey, false, (MobicentsSipFactory)sipFactoryImpl, sipApplicationSession);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("session found is " + tmpSession));
                if (tmpSession == null) {
                    sipManager.dumpSipSessions();
                }
            }
            if (tmpSession == null) {
                block54: {
                    if (sipFactoryImpl.isRouteOrphanRequests()) {
                        try {
                            response.removeFirst("Via");
                            SIPTransaction stx = ((SIPTransactionStack)sipProvider.getSipStack()).findTransaction((SIPMessage)response, true);
                            if (stx != null) {
                                SipServletRequestImpl request = (SipServletRequestImpl)sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(stx.getRequest(), null, null, null, false);
                                SipServletResponseImpl orphanResponse = (SipServletResponseImpl)sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletResponse(response, null, null, dialog, true, false);
                                request.setOrphan(true);
                                orphanResponse.setAppSessionId(appId);
                                orphanResponse.setOriginalRequest(request);
                                ResponseDispatcher.callServletForOrphanResponse(sipContext, (SipServletResponse)orphanResponse);
                                stx.sendMessage((SIPMessage)response);
                                break block54;
                            }
                            if (sipServletResponse.getRequest() != null) break block54;
                            ToHeader toHeader = (ToHeader)response.getHeader("To");
                            FromHeader fromHeader = (FromHeader)response.getHeader("From");
                            URI uri = ((ToHeader)response.getHeader("To")).getAddress().getURI();
                            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
                            CallIdHeader callid = (CallIdHeader)response.getHeader("Call-ID");
                            ViaHeader via = (ViaHeader)response.getHeader("Via");
                            LinkedList<ViaHeader> vialist = new LinkedList<ViaHeader>();
                            vialist.add(via);
                            MaxForwardsHeader mf = sipFactoryImpl.getHeaderFactory().createMaxForwardsHeader(80);
                            ContentTypeHeader cth = sipFactoryImpl.getHeaderFactory().createContentTypeHeader("orphan", "orphan");
                            try {
                                Request r = sipFactoryImpl.getMessageFactory().createRequest(uri, cseq.getMethod(), callid, cseq, fromHeader, toHeader, vialist, mf, cth, new byte[0]);
                                SipServletRequestImpl req = (SipServletRequestImpl)sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(r, null, null, dialog, false);
                                req.setOrphan(true);
                                sipServletResponse.setOriginalRequest(req);
                                sipServletResponse.setAppSessionId(appId);
                                ResponseDispatcher.callServletForOrphanResponse(sipContext, (SipServletResponse)sipServletResponse);
                                sipProvider.sendResponse(response);
                            }
                            catch (Exception e) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"failed sending artificial request for response ");
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"Problem routing orphaned response", (Throwable)e);
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Dropping the response since no active sip session has been found for it : " + response + ", it may already have been invalidated"));
                    }
                }
                return;
            }
            if (tmpSession.getProxy() == null && sipServletResponse.isRetransmission()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retransmission received for a non proxy application, dropping the response " + response));
                }
                return;
            }
            sipServletResponse.setSipSession(tmpSession);
            if (sipServletResponse.getRequest() == null && tmpSession.getProxy() != null) {
                for (ProxyBranch pbi : tmpSession.getProxy().getProxyBranches()) {
                    ProxyBranchImpl pb = (ProxyBranchImpl)pbi;
                    Request r = (Request)((SipServletRequestImpl)pb.getRequest()).getMessage();
                    ViaHeader via1 = (ViaHeader)r.getHeader("Via");
                    ViaHeader via2 = (ViaHeader)response.getHeader("Via");
                    if (!via1.getBranch().equals(via2.getBranch())) continue;
                    sipServletResponse.setOriginalRequest((SipServletRequestImpl)pb.getRequest());
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("route response on following session " + tmpSession.getId()));
            }
            final MobicentsSipSession session = tmpSession;
            final TransactionApplicationData finalApplicationData = applicationData;
            DispatchTask dispatchTask = new DispatchTask(sipServletResponse, sipProvider){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispatch() throws DispatcherException {
                    block37: {
                        int status = sipServletResponse.getStatus();
                        boolean batchStarted = false;
                        if (status != 100) {
                            batchStarted = sipContext.enterSipAppHa(true);
                        }
                        try {
                            session.setSessionCreatingTransactionRequest((MobicentsSipServletMessage)sipServletResponse);
                            session.setSessionCreatingDialog(dialog);
                            if (originalRequest != null) {
                                originalRequest.setResponse(sipServletResponse);
                            }
                            if ("SUBSCRIBE".equals(sipServletResponse.getMethod()) && status >= 200 && status <= 300 && session.getProxy() == null) {
                                session.addSubscription((MobicentsSipServletMessage)sipServletResponse);
                            }
                            ProxyBranchImpl proxyBranch = null;
                            if (finalApplicationData != null) {
                                proxyBranch = finalApplicationData.getProxyBranch();
                            }
                            if (session.getProxy() != null) {
                                if (proxyBranch == null) {
                                    proxyBranch = session.getProxy().getFinalBranchForSubsequentRequests();
                                }
                                if (proxyBranch == null) {
                                    TransactionApplicationData tad;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Attempting to recover lost transaction app data for " + branch));
                                    }
                                    if ((tad = (TransactionApplicationData)session.getProxy().getTransactionMap().get(branch)) != null) {
                                        proxyBranch = tad.getProxyBranch();
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Sucessfully recovered app data for " + branch + " " + tad));
                                        }
                                    }
                                }
                                if (proxyBranch == null) {
                                    logger.warn((Object)"A proxy retransmission has arrived without knowing which proxybranch to use (tx data lost)");
                                    if (session.getProxy().getSupervised() && status != 100) {
                                        MessageDispatcher.callServlet(sipServletResponse);
                                    }
                                    ResponseDispatcher.this.forwardResponseStatefully(sipServletResponse);
                                }
                            }
                            if (proxyBranch != null) {
                                sipServletResponse.setProxyBranch(proxyBranch);
                                session.updateStateOnResponse((MobicentsSipServletResponse)sipServletResponse, true);
                                proxyBranch.setResponse(sipServletResponse);
                                ProxyImpl proxy = (ProxyImpl)session.getProxy();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Is Supervised enabled for this proxy branch ? " + proxy.getSupervised()));
                                }
                                if (proxy.getSupervised() && status != 100) {
                                    MessageDispatcher.callServlet(sipServletResponse);
                                }
                                if (status == 487 && proxy.allResponsesHaveArrived()) {
                                    session.setState(SipSession.State.TERMINATED);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Received 487 on a proxy branch and we are not waiting on other branches. Setting state to TERMINATED for session " + session));
                                    }
                                }
                                if (sipServletResponse.getMethod().equals("INVITE") && sipServletResponse.getRequest() != null && sipServletResponse.getRequest().isInitial() && proxy.getBestResponseSent() >= 200 && (status <= 200 || status >= 300)) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("best final response sent " + proxy.getBestResponseSent() + ", response status " + status + " not forwarding response"));
                                    }
                                    return;
                                }
                                proxyBranch.onResponse(sipServletResponse, status);
                                break block37;
                            }
                            if (sipServletResponse.isRetransmission()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("the following response is dropped since this is a retransmission " + response));
                                }
                                return;
                            }
                            if (100 == status) {
                                session.updateStateOnResponse((MobicentsSipServletResponse)sipServletResponse, true);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"the response is dropped accordingly to JSR 289 since this a 100 for a non proxy application");
                                }
                                return;
                            }
                            if (sipServletResponse.getTransaction() == null && sipServletResponse.getDialog() == null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("the following response is dropped since there is no client transaction nor dialog for it : " + response));
                                }
                                return;
                            }
                            try {
                                session.updateStateOnResponse((MobicentsSipServletResponse)sipServletResponse, true);
                                MessageDispatcher.callServlet(sipServletResponse);
                                ResponseDispatcher.this.forwardResponseStatefully(sipServletResponse);
                            }
                            catch (ServletException e) {
                                throw new DispatcherException("Unexpected servlet exception while processing the response : " + response, (Throwable)e);
                            }
                            catch (IOException e) {
                                throw new DispatcherException("Unexpected io exception while processing the response : " + response, (Throwable)e);
                            }
                            catch (Throwable e) {
                                throw new DispatcherException("Unexpected exception while processing response : " + response, e);
                            }
                        }
                        finally {
                            if (status != 100) {
                                sipContext.exitSipAppHa(null, (MobicentsSipServletResponse)sipServletResponse, batchStarted);
                            }
                            sipContext.exitSipApp(session.getSipApplicationSession(), session);
                        }
                    }
                }
            };
            sipContext.enterSipApp(session.getSipApplicationSession(), session, false, true);
            if (this.sipApplicationDispatcher.isBypassResponseExecutor() || ConcurrencyControlMode.Transaction.equals((Object)sipContext.getConcurrencyControlMode())) {
                dispatchTask.dispatchAndHandleExceptions();
            } else {
                this.getConcurrencyModelExecutorService(sipContext, sipServletMessage).execute(dispatchTask);
            }
        } else {
            this.forwardResponseStatefully(sipServletResponse);
        }
    }

    private final void forwardResponseStatefully(SipServletResponseImpl sipServletResponse) {
        Response response = sipServletResponse.getResponse();
        ListIterator viaHeadersLeft = response.getHeaders("Via");
        if (viaHeadersLeft.hasNext()) {
            viaHeadersLeft.next();
        }
        if (viaHeadersLeft.hasNext()) {
            ClientTransaction clientTransaction = (ClientTransaction)sipServletResponse.getTransaction();
            Dialog dialog = sipServletResponse.getDialog();
            Response newResponse = (Response)response.clone();
            ((MessageExt)newResponse).setApplicationData(null);
            newResponse.removeFirst("Via");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("forwarding the response statefully " + newResponse));
            }
            TransactionApplicationData applicationData = null;
            if (clientTransaction != null) {
                applicationData = (TransactionApplicationData)clientTransaction.getApplicationData();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ctx application Data " + applicationData));
                }
            } else if (dialog != null) {
                applicationData = (TransactionApplicationData)dialog.getApplicationData();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dialog application data " + applicationData));
                }
            }
            if (applicationData != null) {
                ServerTransaction serverTransaction = (ServerTransaction)applicationData.getTransaction();
                try {
                    serverTransaction.sendResponse(newResponse);
                }
                catch (SipException e) {
                    logger.error((Object)"cannot forward the response statefully", (Throwable)e);
                }
                catch (InvalidArgumentException e) {
                    logger.error((Object)"cannot forward the response statefully", (Throwable)e);
                }
            } else {
                try {
                    String transport = JainSipUtils.findTransport((Message)newResponse);
                    SipProvider sipProvider = this.sipApplicationDispatcher.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
                    sipProvider.sendResponse(newResponse);
                }
                catch (SipException e) {
                    logger.error((Object)"cannot forward the response statelessly", (Throwable)e);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Not forwarding the response statefully. It was either an endpoint or a B2BUA, ie an endpoint too " + response));
        }
    }

    public void checkInitialRemoteInformation(SipServletMessageImpl sipServletMessage, ViaHeader nextViaHeader) {
        SIPTransaction transaction = (SIPTransaction)sipServletMessage.getTransaction();
        String remoteAddr = transaction.getPeerAddress();
        int remotePort = transaction.getPeerPort();
        if (transaction.getPeerPacketSourceAddress() != null) {
            remoteAddr = transaction.getPeerPacketSourceAddress().getHostAddress();
            remotePort = transaction.getPeerPacketSourcePort();
        }
        String initialRemoteAddr = remoteAddr;
        int initialRemotePort = remotePort;
        String initialRemoteTransport = transaction.getTransport();
        TransactionApplicationData transactionApplicationData = sipServletMessage.getTransactionApplicationData();
        if (this.sipApplicationDispatcher.isExternal(initialRemoteAddr, initialRemotePort, initialRemoteTransport)) {
            transactionApplicationData.setInitialRemoteHostAddress(initialRemoteAddr);
            transactionApplicationData.setInitialRemotePort(initialRemotePort);
            transactionApplicationData.setInitialRemoteTransport(initialRemoteTransport);
            if (nextViaHeader != null && !this.sipApplicationDispatcher.isViaHeaderExternal(nextViaHeader)) {
                sipServletMessage.setHeaderInternal("MSS_Initial_Remote_Addr", initialRemoteAddr, true);
                sipServletMessage.setHeaderInternal("MSS_Initial_Remote_Port", "" + initialRemotePort, true);
                sipServletMessage.setHeaderInternal("MSS_Initial_Remote_Transport", initialRemoteTransport, true);
            }
        } else {
            String remoteAddressHeader = sipServletMessage.getHeader("MSS_Initial_Remote_Addr");
            String remotePortHeader = sipServletMessage.getHeader("MSS_Initial_Remote_Port");
            String remoteTransportHeader = sipServletMessage.getHeader("MSS_Initial_Remote_Transport");
            int intRemotePort = -1;
            if (remotePortHeader != null) {
                intRemotePort = Integer.parseInt(remotePortHeader);
            }
            if (remoteAddressHeader == null && remoteTransportHeader == null && remotePortHeader == null) {
                transactionApplicationData.setInitialRemoteHostAddress(initialRemoteAddr);
                transactionApplicationData.setInitialRemotePort(initialRemotePort);
                transactionApplicationData.setInitialRemoteTransport(initialRemoteTransport);
            } else {
                transactionApplicationData.setInitialRemoteHostAddress(remoteAddressHeader);
                transactionApplicationData.setInitialRemotePort(intRemotePort);
                transactionApplicationData.setInitialRemoteTransport(remoteTransportHeader);
                if (nextViaHeader == null || this.sipApplicationDispatcher.isViaHeaderExternal(nextViaHeader)) {
                    sipServletMessage.removeHeaderInternal("MSS_Initial_Remote_Addr", true);
                    sipServletMessage.removeHeaderInternal("MSS_Initial_Remote_Port", true);
                    sipServletMessage.removeHeaderInternal("MSS_Initial_Remote_Transport", true);
                }
            }
        }
    }
}

