/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionActivationListener;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionBindingEvent;
import javax.servlet.sip.SipApplicationSessionBindingListener;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipApplicationSessionAsynchronousWork;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipListeners;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.session.ConvergedSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionAsyncTask;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionEventType;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.core.timers.MobicentsServletTimer;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerTask;
import org.mobicents.servlet.sip.message.MobicentsSipApplicationSessionFacade;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.notification.SessionActivationNotificationCause;
import org.mobicents.servlet.sip.notification.SipApplicationSessionActivationEvent;
import org.mobicents.servlet.sip.utils.JvmRouteUtil;

public class SipApplicationSessionImpl
implements MobicentsSipApplicationSession {
    private static final Logger logger = Logger.getLogger(SipApplicationSessionImpl.class);
    protected Map<String, Object> sipApplicationSessionAttributeMap;
    protected transient Set<SipSessionKey> sipSessions = new CopyOnWriteArraySet<SipSessionKey>();
    protected transient Set<String> httpSessions;
    protected SipApplicationSessionKey key;
    protected long lastAccessedTime;
    protected long creationTime;
    protected long expirationTime;
    protected boolean expired;
    protected transient SipApplicationSessionTimerTask expirationTimerTask;
    protected transient ConcurrentHashMap<String, ServletTimer> servletTimers;
    protected transient AtomicBoolean isValidInternal;
    protected transient boolean isValid;
    protected boolean invalidateWhenReady = true;
    protected boolean readyToInvalidate = false;
    protected transient SipContext sipContext;
    protected String currentRequestHandler;
    protected transient Semaphore semaphore;
    protected transient MobicentsSipApplicationSessionFacade facade = null;
    protected long sipApplicationSessionTimeout = -1L;
    protected String jvmRoute;
    protected boolean orphan = false;

    protected Map<String, Object> getAttributeMap() {
        if (this.sipApplicationSessionAttributeMap == null) {
            this.sipApplicationSessionAttributeMap = new ConcurrentHashMap<String, Object>();
        }
        return this.sipApplicationSessionAttributeMap;
    }

    protected SipApplicationSessionImpl(SipApplicationSessionKey key, SipContext sipContext) {
        this.key = key;
        this.creationTime = System.currentTimeMillis();
        this.expired = false;
        this.isValid = true;
        this.isValidInternal = new AtomicBoolean(true);
        if (sipContext != null) {
            int sipContextTimeout;
            this.sipContext = sipContext;
            this.currentRequestHandler = sipContext.getServletHandler();
            if (ConcurrencyControlMode.SipApplicationSession.equals((Object)sipContext.getConcurrencyControlMode())) {
                this.semaphore = new Semaphore(1);
            }
            if ((sipContextTimeout = sipContext.getSipApplicationSessionTimeout()) > 0) {
                this.sipApplicationSessionTimeout = (long)(sipContextTimeout * 60) * 1000L;
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("The sip application session " + key + " will never expire "));
            }
        }
        this.setLastAccessedTime(this.creationTime);
    }

    public void notifySipApplicationSessionListeners(SipApplicationSessionEventType sipApplicationSessionEventType) {
        List listeners = this.sipContext.getListeners().getSipApplicationSessionListeners();
        if (listeners.size() > 0) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            this.sipContext.enterSipContext();
            SipApplicationSessionEvent event = new SipApplicationSessionEvent((SipApplicationSession)this.getFacade());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notifying sip application session listeners of context " + this.key.getApplicationName() + " of following event " + (Object)((Object)sipApplicationSessionEventType)));
            }
            for (SipApplicationSessionListener sipApplicationSessionListener : listeners) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying sip application session listener " + sipApplicationSessionListener.getClass().getName() + " of context " + this.key.getApplicationName() + " of following event " + (Object)((Object)sipApplicationSessionEventType)));
                    }
                    if (SipApplicationSessionEventType.CREATION.equals((Object)sipApplicationSessionEventType)) {
                        sipApplicationSessionListener.sessionCreated(event);
                        continue;
                    }
                    if (SipApplicationSessionEventType.DELETION.equals((Object)sipApplicationSessionEventType)) {
                        sipApplicationSessionListener.sessionDestroyed(event);
                        continue;
                    }
                    if (SipApplicationSessionEventType.EXPIRATION.equals((Object)sipApplicationSessionEventType)) {
                        sipApplicationSessionListener.sessionExpired(event);
                        continue;
                    }
                    if (!SipApplicationSessionEventType.READYTOINVALIDATE.equals((Object)sipApplicationSessionEventType)) continue;
                    sipApplicationSessionListener.sessionReadyToInvalidate(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipApplicationSessionListener threw exception", t);
                }
            }
            this.sipContext.exitSipContext(oldClassLoader);
        }
    }

    public boolean addSipSession(MobicentsSipSession mobicentsSipSession) {
        boolean wasNotPresent = this.sipSessions.add((SipSessionKey)mobicentsSipSession.getKey());
        if (logger.isDebugEnabled() && wasNotPresent) {
            logger.debug((Object)("Added sip session " + mobicentsSipSession.getKey() + " to sip app session " + this.getKey()));
        }
        this.readyToInvalidate = false;
        return wasNotPresent;
    }

    public SipSessionKey removeSipSession(MobicentsSipSession mobicentsSipSession) {
        Iterator itDerivedSessions;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to remove sip session " + mobicentsSipSession));
        }
        SipSessionKey key = (SipSessionKey)mobicentsSipSession.getKey();
        MobicentsSipSession parentSession = mobicentsSipSession.getParentSession();
        if (parentSession != null) {
            itDerivedSessions = parentSession.getDerivedSipSessions();
            if (itDerivedSessions.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("parent session " + parentSession.getKey() + " still contains derived sip sessions so not removing"));
                    logger.debug((Object)"Derived sip sessions left are : ");
                    while (itDerivedSessions.hasNext()) {
                        MobicentsSipSession derivedSipSession = (MobicentsSipSession)itDerivedSessions.next();
                        logger.debug((Object)("Derived sip session : " + derivedSipSession.getKey()));
                    }
                }
                return null;
            }
            if (parentSession.isValidInternal()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("not removing parent sip session " + parentSession.getKey() + " without derived sessions since it's still valid"));
                }
                return null;
            }
        }
        if ((itDerivedSessions = mobicentsSipSession.getDerivedSipSessions()).hasNext()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sip Session " + mobicentsSipSession.getKey() + " still contains derived sip sessions so not removing"));
                logger.debug((Object)"Derived sip sessions left are : ");
                while (itDerivedSessions.hasNext()) {
                    MobicentsSipSession derivedSipSession = (MobicentsSipSession)itDerivedSessions.next();
                    logger.debug((Object)("Derived sip session : " + derivedSipSession.getKey()));
                }
            }
            return null;
        }
        if (this.sipSessions != null) {
            boolean wasPresent = this.sipSessions.remove(key);
            if (logger.isDebugEnabled() && wasPresent) {
                logger.debug((Object)("Removed sip session " + key + " from sip app session " + this.getKey()));
            }
            return key;
        }
        return null;
    }

    public boolean addHttpSession(HttpSession httpSession) {
        if (this.httpSessions == null) {
            this.httpSessions = new CopyOnWriteArraySet<String>();
        }
        boolean wasNotPresent = this.httpSessions.add(JvmRouteUtil.removeJvmRoute(httpSession.getId()));
        if (logger.isDebugEnabled() && wasNotPresent) {
            logger.debug((Object)("Added http session " + JvmRouteUtil.removeJvmRoute(httpSession.getId()) + " to sip app session " + this.getKey()));
        }
        this.readyToInvalidate = false;
        String jvmRoute = JvmRouteUtil.extractJvmRoute(httpSession.getId());
        if (jvmRoute != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JVM Route " + jvmRoute + " for just added http session " + JvmRouteUtil.removeJvmRoute(httpSession.getId())));
            }
            this.setJvmRoute(jvmRoute);
        }
        return wasNotPresent;
    }

    public boolean removeHttpSession(HttpSession httpSession) {
        if (this.httpSessions != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to remove http session " + JvmRouteUtil.removeJvmRoute(httpSession.getId())));
            }
            boolean wasPresent = this.httpSessions.remove(JvmRouteUtil.removeJvmRoute(httpSession.getId()));
            if (logger.isDebugEnabled() && wasPresent) {
                logger.debug((Object)("Removed http session " + JvmRouteUtil.removeJvmRoute(httpSession.getId()) + " from sip app session " + this.getKey()));
            }
            return wasPresent;
        }
        return false;
    }

    public HttpSession findHttpSession(String sessionId) {
        String id = JvmRouteUtil.removeJvmRoute(sessionId);
        if (this.httpSessions != null && this.httpSessions.contains(id)) {
            try {
                return (HttpSession)this.sipContext.getSipManager().findSession(id);
            }
            catch (IOException e) {
                logger.error((Object)("An Unexpected exception happened while retrieving the http session " + id), (Throwable)e);
            }
        }
        return null;
    }

    public void encodeURI(URI uri) {
        uri.setParameter("org.mobicents.servlet.sip.ApplicationSessionKey", this.getId());
    }

    public URL encodeURL(URL url) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        String urlStr = url.toExternalForm();
        try {
            URL ret = urlStr.contains("?") ? new URL(url + "&" + "org.mobicents.servlet.sip.ApplicationSessionKey" + "=" + this.getId()) : new URL(url + "?" + "org.mobicents.servlet.sip.ApplicationSessionKey" + "=" + this.getId());
            return ret;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed encoding URL : " + url, e);
        }
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        return this.getAttributeMap().get(name);
    }

    public Iterator<String> getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        return this.getAttributeMap().keySet().iterator();
    }

    public long getCreationTime() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        return this.creationTime;
    }

    public long getExpirationTime() {
        if (!this.isValid()) {
            throw new IllegalStateException("this sip application session is not valid anymore");
        }
        if (this.expirationTimerTask == null) {
            return 0L;
        }
        long delay = this.expirationTimerTask.getDelay();
        if (delay <= 0L) {
            return 0L;
        }
        if (this.expired) {
            return Long.MIN_VALUE;
        }
        return this.expirationTime;
    }

    public String getId() {
        return this.key.toString();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    protected void setLastAccessedTime(long lastAccessTime) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("lastAccessedTime set to " + lastAccessTime));
        }
        this.lastAccessedTime = lastAccessTime;
        if (this.sipApplicationSessionTimeout > 0L) {
            this.expirationTime = this.lastAccessedTime + this.sipApplicationSessionTimeout;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting expirationTime to " + this.expirationTime + " on sip application session " + this.key));
                logger.debug((Object)("Re-Scheduling sip application session " + this.key + " to expire in " + this.sipApplicationSessionTimeout / 60L / 1000L + " minutes"));
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(this.expirationTime);
                logger.debug((Object)("sip application session " + this.key + " will expires at " + new SimpleDateFormat("MM/yyyy/dd hh:mm:ss.SSS").format(calendar.getTime())));
            }
        }
    }

    public void access() {
        this.setLastAccessedTime(System.currentTimeMillis());
    }

    public Iterator<?> getSessions() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        Set<MobicentsSipSession> sipSessions = this.getSipSessions(false);
        Set<HttpSession> httpSessions = this.getHttpSessions();
        HashSet<Object> protocolSessions = new HashSet<Object>();
        protocolSessions.addAll(httpSessions);
        protocolSessions.addAll(sipSessions);
        return protocolSessions.iterator();
    }

    public Iterator<?> getSessions(String protocol) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol given in argument is null");
        }
        if ("SIP".equalsIgnoreCase(protocol)) {
            return this.getSipSessions(false).iterator();
        }
        if ("HTTP".equalsIgnoreCase(protocol)) {
            return this.getHttpSessions().iterator();
        }
        throw new IllegalArgumentException(protocol + " sessions are not handled by this container");
    }

    public Set<MobicentsSipSession> getSipSessions(boolean internal) {
        HashSet<MobicentsSipSession> retSipSessions = new HashSet<MobicentsSipSession>();
        if (this.sipSessions != null) {
            for (SipSessionKey sipSessionKey : this.sipSessions) {
                MobicentsSipSession sipSession = this.sipContext.getSipManager().getSipSession((MobicentsSipSessionKey)sipSessionKey, false, null, (MobicentsSipApplicationSession)this);
                if (sipSession == null) continue;
                if (sipSession.isValidInternal()) {
                    if (internal) {
                        retSipSessions.add(sipSession);
                    } else {
                        retSipSessions.add(sipSession.getFacade());
                    }
                }
                Iterator derivedSessionsIterator = sipSession.getDerivedSipSessions();
                while (derivedSessionsIterator.hasNext()) {
                    MobicentsSipSession derivedSipSession = (MobicentsSipSession)derivedSessionsIterator.next();
                    if (internal) {
                        retSipSessions.add(derivedSipSession);
                        continue;
                    }
                    retSipSessions.add(derivedSipSession.getFacade());
                }
            }
        }
        return retSipSessions;
    }

    protected Set<HttpSession> getHttpSessions() {
        HashSet<HttpSession> retHttpSessions = new HashSet<HttpSession>();
        if (this.httpSessions != null) {
            for (String id : this.httpSessions) {
                try {
                    HttpSession httpSession = (HttpSession)this.sipContext.getSipManager().findSession(id);
                    if (httpSession == null) continue;
                    retHttpSessions.add(httpSession);
                }
                catch (IOException e) {
                    logger.error((Object)("An Unexpected exception happened while retrieving the http session " + id), (Throwable)e);
                }
            }
        }
        return retHttpSessions;
    }

    public SipSession getSipSession(String id) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to find a session with the id " + id));
            this.dumpSipSessions();
        }
        boolean isPresent = false;
        SipSessionKey sipSessionKey = null;
        try {
            sipSessionKey = SessionManagerUtil.parseSipSessionKey(id);
            isPresent = this.sipSessions.contains(sipSessionKey);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (isPresent) {
            return this.sipContext.getSipManager().getSipSession((MobicentsSipSessionKey)sipSessionKey, false, null, (MobicentsSipApplicationSession)this).getFacade();
        }
        return null;
    }

    private void dumpSipSessions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sessions contained in the following app session " + this.key));
            for (SipSessionKey sessionKey : this.sipSessions) {
                logger.debug((Object)("session key " + sessionKey));
            }
        }
    }

    public Collection<ServletTimer> getTimers() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        if (this.servletTimers != null) {
            return this.servletTimers.values();
        }
        return new HashMap().values();
    }

    public void addServletTimer(ServletTimer servletTimer) {
        if (this.servletTimers == null) {
            this.servletTimers = new ConcurrentHashMap(1);
        }
        this.servletTimers.putIfAbsent(servletTimer.getId(), servletTimer);
    }

    public void removeServletTimer(ServletTimer servletTimer, boolean updateAppSessionReadyToInvalidateState) {
        if (this.servletTimers != null) {
            this.servletTimers.remove(servletTimer.getId());
        }
        if (updateAppSessionReadyToInvalidateState) {
            this.updateReadyToInvalidateState();
        }
    }

    public void invalidate() {
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean bypassCheck) {
        boolean wasValid = this.isValidInternal.compareAndSet(true, false);
        if (!wasValid) {
            if (!bypassCheck) {
                throw new IllegalStateException("SipApplicationSession " + this.key + " already invalidated !");
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SipApplicationSession " + this.key + " already invalidated, doing nothing"));
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Invalidating the following sip application session " + this.key));
        }
        for (MobicentsSipSession mobicentsSipSession : this.getSipSessions(true)) {
            if (!mobicentsSipSession.isValidInternal()) continue;
            boolean lockSession = false;
            if (bypassCheck && this.sipContext.getConcurrencyControlMode() == ConcurrencyControlMode.SipSession) {
                lockSession = true;
            }
            try {
                if (lockSession) {
                    this.sipContext.enterSipApp((MobicentsSipApplicationSession)this, mobicentsSipSession, false, true);
                }
                mobicentsSipSession.invalidate();
            }
            finally {
                if (!lockSession) continue;
                this.sipContext.exitSipApp((MobicentsSipApplicationSession)this, mobicentsSipSession);
            }
        }
        for (HttpSession httpSession : this.getHttpSessions()) {
            if (httpSession instanceof ConvergedSession) {
                ConvergedSession convergedSession = (ConvergedSession)httpSession;
                if (!convergedSession.isValidIntern()) continue;
                convergedSession.invalidate();
                continue;
            }
            try {
                httpSession.invalidate();
            }
            catch (IllegalStateException ignore) {}
        }
        if (this.sipApplicationSessionAttributeMap != null) {
            for (String string : this.getAttributeMap().keySet()) {
                this.removeAttribute(string, true);
            }
        }
        if (this.servletTimers != null) {
            for (Map.Entry entry : this.servletTimers.entrySet()) {
                ServletTimer timerEntry = (ServletTimer)entry.getValue();
                if (timerEntry == null) continue;
                timerEntry.cancel();
            }
        }
        if (!this.expired && this.expirationTimerTask != null) {
            this.cancelExpirationTimer();
        }
        SipManager manager = this.sipContext.getSipManager();
        manager.removeSipApplicationSession((MobicentsSipApplicationSessionKey)this.key);
        this.sipContext.getSipSessionsUtil().removeCorrespondingSipApplicationSession((MobicentsSipApplicationSessionKey)this.key);
        long l = System.currentTimeMillis();
        int timeAlive = (int)((l - this.creationTime) / 1000L);
        SipManager sipManager = manager;
        synchronized (sipManager) {
            if (timeAlive > manager.getSipApplicationSessionMaxAliveTime()) {
                manager.setSipApplicationSessionMaxAliveTime(timeAlive);
            }
            int numExpired = manager.getExpiredSipApplicationSessions();
            manager.setExpiredSipApplicationSessions(++numExpired);
            int average = manager.getSipApplicationSessionAverageAliveTime();
            average = (average * (numExpired - 1) + timeAlive) / numExpired;
            manager.setSipApplicationSessionAverageAliveTime(average);
        }
        this.notifySipApplicationSessionListeners(SipApplicationSessionEventType.DELETION);
        this.isValid = false;
        this.expirationTimerTask = null;
        if (this.httpSessions != null) {
            this.httpSessions.clear();
        }
        if (this.servletTimers != null) {
            this.servletTimers.clear();
        }
        if (this.sipApplicationSessionAttributeMap != null) {
            this.sipApplicationSessionAttributeMap.clear();
        }
        if (this.sipSessions != null) {
            this.sipSessions.clear();
        }
        this.httpSessions = null;
        this.sipSessions = null;
        this.sipApplicationSessionAttributeMap = null;
        this.servletTimers = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("The following sip application session " + this.key + " has been invalidated"));
        }
        this.currentRequestHandler = null;
        this.facade = null;
    }

    public void cancelAllTimers() {
        this.cancelExpirationTimer();
        if (this.servletTimers != null) {
            for (ServletTimer timer : this.servletTimers.values()) {
                ((MobicentsServletTimer)timer).cancel(false, false);
            }
        }
    }

    private void cancelExpirationTimer() {
        if (this.expirationTimerTask != null) {
            this.sipContext.getSipApplicationSessionTimerService().cancel(this.expirationTimerTask);
        }
        if (this.expirationTimerTask != null) {
            this.expirationTimerTask.setSipApplicationSession(null);
            this.expirationTimerTask = null;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValidInternal() {
        return this.isValidInternal.get();
    }

    protected void setValid(boolean isValid) {
        this.isValidInternal.set(isValid);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, false);
    }

    public void removeAttribute(String name, boolean byPassValidCheck) {
        SipListeners listeners;
        List listenersList;
        if (!byPassValidCheck && !this.isValid()) {
            throw new IllegalStateException("Can not bind object to session that has been invalidated!!");
        }
        if (name == null) {
            return;
        }
        SipApplicationSessionBindingEvent event = null;
        Object value = this.getAttributeMap().remove(name);
        if (value != null && value instanceof SipApplicationSessionBindingListener) {
            event = new SipApplicationSessionBindingEvent((SipApplicationSession)this, name);
            ((SipApplicationSessionBindingListener)value).valueUnbound(event);
        }
        if ((listenersList = (listeners = this.sipContext.getListeners()).getSipApplicationSessionAttributeListeners()).size() > 0) {
            if (event == null) {
                event = new SipApplicationSessionBindingEvent((SipApplicationSession)this, name);
            }
            for (SipApplicationSessionAttributeListener listener : listenersList) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("notifying SipApplicationSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute removed on key " + this.key));
                }
                try {
                    listener.attributeRemoved(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipApplicationSessionAttributeListener threw exception", t);
                }
            }
        }
    }

    public void setAttribute(String key, Object attribute) {
        block20: {
            SipListeners listeners;
            List listenersList;
            Object previousValue;
            Object oldValue;
            if (!this.isValid()) {
                throw new IllegalStateException("Can not bind object to session that has been invalidated!!");
            }
            if (key == null) {
                throw new NullPointerException("Name of attribute to bind cant be null!!!");
            }
            if (attribute == null) {
                throw new NullPointerException("Attribute that is to be bound cant be null!!!");
            }
            SipApplicationSessionBindingEvent event = null;
            if (attribute instanceof SipApplicationSessionBindingListener && attribute != (oldValue = this.getAttributeMap().get(key))) {
                event = new SipApplicationSessionBindingEvent((SipApplicationSession)this, key);
                try {
                    ((SipApplicationSessionBindingListener)attribute).valueBound(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionBindingListener threw exception", t);
                }
            }
            if ((previousValue = this.getAttributeMap().put(key, attribute)) != null && previousValue != attribute && previousValue instanceof SipApplicationSessionBindingListener) {
                try {
                    ((SipApplicationSessionBindingListener)previousValue).valueUnbound(new SipApplicationSessionBindingEvent((SipApplicationSession)this, key));
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionBindingListener threw exception", t);
                }
            }
            if ((listenersList = (listeners = this.sipContext.getListeners()).getSipApplicationSessionAttributeListeners()).size() <= 0) break block20;
            if (event == null) {
                event = new SipApplicationSessionBindingEvent((SipApplicationSession)this, key);
            }
            if (previousValue == null) {
                for (SipApplicationSessionAttributeListener listener : listenersList) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying SipApplicationSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute added on key " + key));
                    }
                    try {
                        listener.attributeAdded(event);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipApplicationSessionAttributeListener threw exception", t);
                    }
                }
            } else {
                for (SipApplicationSessionAttributeListener listener : listenersList) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying SipApplicationSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute replaced on key " + key));
                    }
                    try {
                        listener.attributeReplaced(event);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipApplicationSessionAttributeListener threw exception", t);
                    }
                }
            }
        }
    }

    public int setExpires(int deltaMinutes) {
        if (!this.isValid()) {
            throw new IllegalStateException("Impossible to change the sip application session timeout when it has been invalidated !");
        }
        this.expired = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Postponing the expiratin of the sip application session " + this.key + " to expire in " + deltaMinutes + " minutes."));
        }
        if (deltaMinutes <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The sip application session " + this.key + " won't expire anymore "));
            }
            if (this.expirationTimerTask != null) {
                this.cancelExpirationTimer();
                this.sipApplicationSessionTimeout = deltaMinutes;
            }
            return Integer.MAX_VALUE;
        }
        long deltaMilliseconds = 0L;
        this.sipApplicationSessionTimeout = deltaMilliseconds = (long)deltaMinutes * 1000L * 60L;
        this.expirationTime = System.currentTimeMillis() + deltaMilliseconds;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting expirationTime to " + this.expirationTime + " on sip application session " + this.key));
            logger.debug((Object)("Re-Scheduling sip application session " + this.key + " to expire in " + deltaMinutes + " minutes"));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.expirationTime);
            logger.debug((Object)("sip application session " + this.key + " will expires at " + new SimpleDateFormat().format(calendar.getTime())));
        }
        if (this.expirationTimerTask != null) {
            this.cancelExpirationTimer();
        }
        this.expirationTimerTask = this.sipContext.getSipApplicationSessionTimerService().createSipApplicationSessionTimerTask((MobicentsSipApplicationSession)this);
        this.expirationTimerTask = this.sipContext.getSipApplicationSessionTimerService().schedule(this.expirationTimerTask, deltaMilliseconds, TimeUnit.MILLISECONDS);
        return deltaMinutes;
    }

    public boolean hasTimerListener() {
        return this.sipContext.getListeners().getTimerListener() != null;
    }

    public SipContext getSipContext() {
        return this.sipContext;
    }

    public SipApplicationSessionKey getKey() {
        return this.key;
    }

    public void setKey(SipApplicationSessionKey key) {
        this.key = key;
    }

    public String getApplicationName() {
        return this.key.getApplicationName();
    }

    public ServletTimer getTimer(String id) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        if (this.servletTimers != null) {
            return this.servletTimers.get(id);
        }
        return null;
    }

    public void passivate() {
        SipApplicationSessionActivationEvent event = null;
        if (this.sipApplicationSessionAttributeMap != null) {
            Set<String> keySet = this.getAttributeMap().keySet();
            for (String key : keySet) {
                Object attribute = this.getAttributeMap().get(key);
                if (!(attribute instanceof SipApplicationSessionActivationListener)) continue;
                if (event == null) {
                    event = new SipApplicationSessionActivationEvent((SipApplicationSession)this, SessionActivationNotificationCause.PASSIVATION);
                }
                try {
                    ((SipApplicationSessionActivationListener)attribute).sessionWillPassivate(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipApplicationSessionActivationListener threw exception", t);
                }
            }
        }
    }

    public void activate() {
        SipApplicationSessionActivationEvent event = null;
        if (this.sipApplicationSessionAttributeMap != null) {
            Set<String> keySet = this.sipApplicationSessionAttributeMap.keySet();
            for (String key : keySet) {
                Object attribute = this.sipApplicationSessionAttributeMap.get(key);
                if (!(attribute instanceof SipApplicationSessionActivationListener)) continue;
                if (event == null) {
                    event = new SipApplicationSessionActivationEvent((SipApplicationSession)this, SessionActivationNotificationCause.ACTIVATION);
                }
                try {
                    ((SipApplicationSessionActivationListener)attribute).sessionDidActivate(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipApplicationSessionActivationListener threw exception", t);
                }
            }
        }
    }

    public boolean getInvalidateWhenReady() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        return this.invalidateWhenReady;
    }

    public Object getSession(String id, SipApplicationSession.Protocol protocol) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol is null");
        }
        switch (protocol) {
            case SIP: {
                return this.getSipSession(id);
            }
            case HTTP: {
                return this.findHttpSession(id);
            }
        }
        return null;
    }

    public boolean isReadyToInvalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        this.updateReadyToInvalidateState();
        return this.readyToInvalidate;
    }

    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        this.invalidateWhenReady = invalidateWhenReady;
    }

    public void onSipSessionReadyToInvalidate(MobicentsSipSession mobicentsSipSession) {
        this.removeSipSession(mobicentsSipSession);
        this.updateReadyToInvalidateState();
    }

    private void updateReadyToInvalidateState() {
        if (this.isValidInternal() && !this.readyToInvalidate) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("underlying sip sessions " + this.getSipSessions(true).size()));
            }
            for (MobicentsSipSession sipSession : this.getSipSessions(true)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Is Sip Session Key " + sipSession.getKey() + " ready to be invalidated, " + "isvalidInternal " + sipSession.isValidInternal() + ", isReadyToInvalidate " + sipSession.isReadyToInvalidateInternal()));
                }
                if (!sipSession.isValidInternal() || sipSession.isReadyToInvalidate()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sip Session not ready to be invalidated : " + sipSession.getKey()));
                }
                return;
            }
            for (HttpSession httpSession : this.getHttpSessions()) {
                ConvergedSession convergedSession;
                if (!(httpSession instanceof ConvergedSession) || !(convergedSession = (ConvergedSession)httpSession).isValidIntern()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Http Session not ready to be invalidated : " + convergedSession.getId()));
                }
                return;
            }
            if (this.servletTimers == null || this.servletTimers.size() <= 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("All sip sessions and http session are ready to be invalidated, no timers alive, can invalidate this application session " + this.key));
                }
                this.readyToInvalidate = true;
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.servletTimers.size() + " Timers still alive, cannot invalidate this application session " + this.key));
            }
        } else {
            if (logger.isDebugEnabled() && !this.isValidInternal()) {
                logger.debug((Object)("Sip application session already invalidated " + this.key));
            }
            this.readyToInvalidate = true;
        }
    }

    public void tryToInvalidate() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("tryToInvalidate:[isValidInternal=" + this.isValidInternal() + ",readyToInvalidate=" + this.readyToInvalidate + ",invalidateWhenReady=" + this.invalidateWhenReady + "]"));
        }
        if (this.isValidInternal() && this.readyToInvalidate && this.invalidateWhenReady) {
            boolean allSipSessionsInvalidated = true;
            for (MobicentsSipSession sipSession : this.getSipSessions(true)) {
                if (!sipSession.isValidInternal()) continue;
                allSipSessionsInvalidated = false;
                break;
            }
            boolean allHttpSessionsInvalidated = true;
            for (HttpSession httpSession : this.getHttpSessions()) {
                ConvergedSession convergedSession = (ConvergedSession)httpSession;
                if (!convergedSession.isValidIntern()) continue;
                allHttpSessionsInvalidated = false;
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("tryToInvalidate:[allSipSessionInvalidated=" + allSipSessionsInvalidated + "," + "allHttpSessionsInvalidated=" + allHttpSessionsInvalidated + "]"));
            }
            if (allSipSessionsInvalidated && allHttpSessionsInvalidated) {
                this.notifySipApplicationSessionListeners(SipApplicationSessionEventType.READYTOINVALIDATE);
                if (this.invalidateWhenReady) {
                    this.invalidate(true);
                }
            }
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setCurrentRequestHandler(String currentRequestHandler) {
        this.currentRequestHandler = currentRequestHandler;
        if (this.sipContext != null && !this.sipContext.isMainServlet()) {
            this.sipContext.setServletHandler(currentRequestHandler);
        }
    }

    public String getCurrentRequestHandler() {
        return this.currentRequestHandler;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public MobicentsSipApplicationSession getFacade() {
        if (this.facade == null) {
            if (this.sipContext.isPackageProtectionEnabled()) {
                final SipApplicationSessionImpl fsession = this;
                this.facade = (MobicentsSipApplicationSessionFacade)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new MobicentsSipApplicationSessionFacade(fsession);
                    }
                });
            } else {
                this.facade = new MobicentsSipApplicationSessionFacade(this);
            }
        }
        return this.facade;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public void setJvmRoute(String jvmRoute) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting JVM route to " + jvmRoute));
        }
        this.jvmRoute = jvmRoute;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MobicentsSipApplicationSession) {
            return ((MobicentsSipApplicationSession)obj).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    public void setExpirationTimerTask(SipApplicationSessionTimerTask expirationTimerTask) {
        this.expirationTimerTask = expirationTimerTask;
    }

    public SipApplicationSessionTimerTask getExpirationTimerTask() {
        return this.expirationTimerTask;
    }

    public long getSipApplicationSessionTimeout() {
        return this.sipApplicationSessionTimeout;
    }

    public void setExpired(boolean hasExpired) {
        this.expired = hasExpired;
    }

    public long getExpirationTimeInternal() {
        return this.expirationTime;
    }

    public void scheduleAsynchronousWork(SipApplicationSessionAsynchronousWork work) {
        this.sipContext.getSipApplicationDispatcher().getAsynchronousExecutor().execute(new SipApplicationSessionAsyncTask(this.key, work, (SipFactoryImpl)this.sipContext.getSipApplicationDispatcher().getSipFactory()));
    }

    public void acquire() {
        if (this.semaphore != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before semaphore acquire for sipApplicationSession=" + this + " semaphore=" + this.semaphore));
            }
            try {
                while (!this.semaphore.tryAcquire(30000L, TimeUnit.MILLISECONDS)) {
                    logger.warn((Object)("Failed to acquire session semaphore " + this.semaphore + " for 30 secs. We will unlock the " + "semaphore no matter what because the " + "transaction is about to timeout. THIS " + "MIGHT ALSO BE CONCURRENCY CONTROL RISK." + " app Session is" + this));
                    this.semaphore.release();
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)("Problem acquiring semaphore on app session " + this), (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("After semaphore acquire for sipApplicationSession=" + this + " semaphore=" + this.semaphore));
            }
        }
    }

    public void release() {
        if (this.semaphore != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before Semaphore released for sipApplicationSession=" + this + " semaphore=" + this.semaphore));
            }
            if (this.semaphore.availablePermits() > 0) {
                logger.warn((Object)("About to release semaphore but we expected permits = 0. We will adjust to normal " + this.semaphore + " app session=" + this));
                while (this.semaphore.availablePermits() > 0) {
                    try {
                        this.semaphore.acquire();
                    }
                    catch (Exception e) {}
                }
            }
            if (this.semaphore.availablePermits() < 0) {
                logger.warn((Object)("About to release semaphore but we expected permits = 0. We will adjust to normal " + this.semaphore + " app session=" + this));
                while (this.semaphore.availablePermits() < 0) {
                    try {
                        this.semaphore.release();
                    }
                    catch (Exception exception) {}
                }
            }
            this.semaphore.release();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("After Semaphore released for sipApplicationSession=" + this + " semaphore=" + this.semaphore));
            }
        }
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public void setOrphan(boolean orphan) {
        this.orphan = orphan;
    }
}

