/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.SipSession;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionEventType;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionEventType;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerTask;
import org.mobicents.servlet.sip.message.SipFactoryImpl;

public abstract class SipManagerDelegate {
    private static final Logger logger = Logger.getLogger(SipManagerDelegate.class);
    protected ConcurrentHashMap<SipApplicationSessionKey, MobicentsSipApplicationSession> sipApplicationSessions = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, MobicentsSipApplicationSession> sipApplicationSessionsByAppGeneratedKey = new ConcurrentHashMap();
    protected ConcurrentHashMap<SipSessionKey, MobicentsSipSession> sipSessions = new ConcurrentHashMap();
    protected SipFactoryImpl sipFactoryImpl;
    protected SipContext container;
    protected int maxActiveSipSessions = -1;
    protected int maxActiveSipApplicationSessions = -1;
    protected int rejectedSipSessions = 0;
    protected int rejectedSipApplicationSessions = 0;
    private int sipSessionMaxAliveTime;
    private int sipSessionAverageAliveTime;
    private int expiredSipSessions = 0;
    private int sipApplicationSessionMaxAliveTime;
    private int sipApplicationSessionAverageAliveTime;
    private int expiredSipApplicationSessions = 0;
    protected int sipSessionCounter = 0;
    protected int sipApplicationSessionCounter = 0;
    private int lastUpdatedSasCreationCounter = 0;
    private long lastSipApplicationSessionUpdatedTime = 0L;
    private double lastAverageSasCreationPerSecond = 0.0;
    private int lastUpdatedSsCreationCounter = 0;
    private long lastSipSessionUpdatedTime = 0L;
    private double lastAverageSsCreationPerSecond = 0.0;

    public SipFactoryImpl getSipFactoryImpl() {
        return this.sipFactoryImpl;
    }

    public void setSipFactoryImpl(SipFactoryImpl sipFactoryImpl) {
        this.sipFactoryImpl = sipFactoryImpl;
    }

    public SipContext getContainer() {
        return this.container;
    }

    public void setContainer(SipContext container) {
        this.container = container;
    }

    public MobicentsSipSession removeSipSession(MobicentsSipSessionKey key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing a sip session with the key : " + key));
        }
        return this.sipSessions.remove(key);
    }

    public MobicentsSipApplicationSession removeSipApplicationSession(MobicentsSipApplicationSessionKey key) {
        String appGeneratedKey;
        MobicentsSipApplicationSession sipApplicationSession;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing a sip application session with the key : " + key));
        }
        if ((sipApplicationSession = this.sipApplicationSessions.remove(key)) != null && (appGeneratedKey = sipApplicationSession.getKey().getAppGeneratedKey()) != null) {
            this.sipApplicationSessionsByAppGeneratedKey.remove(appGeneratedKey);
        }
        return sipApplicationSession;
    }

    public MobicentsSipApplicationSession getSipApplicationSession(SipApplicationSessionKey key, boolean create) {
        MobicentsSipApplicationSession sipApplicationSessionImpl = null;
        String appGeneratedKey = key.getAppGeneratedKey();
        if (appGeneratedKey != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("trying to find sip application session with generated key " + appGeneratedKey));
            }
            sipApplicationSessionImpl = this.sipApplicationSessionsByAppGeneratedKey.get(appGeneratedKey);
        }
        if (sipApplicationSessionImpl == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("trying to find sip application session with key " + key));
            }
            sipApplicationSessionImpl = this.sipApplicationSessions.get(key);
        }
        if (sipApplicationSessionImpl == null && create) {
            sipApplicationSessionImpl = this.createSipApplicationSession(key);
        }
        return sipApplicationSessionImpl;
    }

    protected MobicentsSipApplicationSession createSipApplicationSession(SipApplicationSessionKey key) {
        MobicentsSipApplicationSession sipApplicationSessionImpl = null;
        MobicentsSipApplicationSession newSipApplicationSessionImpl = this.getNewMobicentsSipApplicationSession(key, this.container);
        String appGeneratedKey = key.getAppGeneratedKey();
        if (appGeneratedKey != null) {
            sipApplicationSessionImpl = this.sipApplicationSessionsByAppGeneratedKey.putIfAbsent(appGeneratedKey, newSipApplicationSessionImpl);
            if (sipApplicationSessionImpl == null) {
                this.sipApplicationSessions.putIfAbsent(key, newSipApplicationSessionImpl);
                this.scheduleExpirationTimer(newSipApplicationSessionImpl);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding a sip application session with the key : " + key));
                }
                sipApplicationSessionImpl = newSipApplicationSessionImpl;
            }
        } else {
            sipApplicationSessionImpl = this.sipApplicationSessions.putIfAbsent(key, newSipApplicationSessionImpl);
            if (sipApplicationSessionImpl == null) {
                this.scheduleExpirationTimer(newSipApplicationSessionImpl);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding a sip application session with the key : " + key));
                }
                sipApplicationSessionImpl = newSipApplicationSessionImpl;
            }
        }
        return sipApplicationSessionImpl;
    }

    protected void scheduleExpirationTimer(MobicentsSipApplicationSession sipApplicationSession) {
        SipContext sipContext = sipApplicationSession.getSipContext();
        if (sipContext != null) {
            if (sipContext.getSipApplicationSessionTimeout() > 0) {
                SipApplicationSessionTimerTask expirationTimerTask = sipContext.getSipApplicationSessionTimerService().createSipApplicationSessionTimerTask(sipApplicationSession);
                expirationTimerTask = sipContext.getSipApplicationSessionTimerService().schedule(expirationTimerTask, sipApplicationSession.getSipApplicationSessionTimeout(), TimeUnit.MILLISECONDS);
                sipApplicationSession.setExpirationTimerTask(expirationTimerTask);
            }
            sipApplicationSession.notifySipApplicationSessionListeners(SipApplicationSessionEventType.CREATION);
        }
    }

    public MobicentsSipSession getSipSession(SipSessionKey key, boolean create, SipFactoryImpl sipFactoryImpl, MobicentsSipApplicationSession sipApplicationSessionImpl) {
        if (create && sipFactoryImpl == null) {
            throw new IllegalArgumentException("the sip factory should not be null");
        }
        MobicentsSipSession sipSessionImpl = this.sipSessions.get(key);
        if (sipSessionImpl == null && create) {
            sipSessionImpl = this.createSipSession(key, create, sipFactoryImpl, sipApplicationSessionImpl);
        }
        if (sipSessionImpl != null) {
            return this.setToTag(key, sipSessionImpl);
        }
        return sipSessionImpl;
    }

    protected MobicentsSipSession createSipSession(SipSessionKey key, boolean create, SipFactoryImpl sipFactoryImpl, MobicentsSipApplicationSession sipApplicationSessionImpl) {
        MobicentsSipSession sipSessionImpl = null;
        MobicentsSipSession newSipSessionImpl = this.getNewMobicentsSipSession(key, sipFactoryImpl, sipApplicationSessionImpl);
        if (sipApplicationSessionImpl.getSipContext() != null) {
            newSipSessionImpl.notifySipSessionListeners(SipSessionEventType.CREATION);
        }
        if ((sipSessionImpl = this.sipSessions.putIfAbsent(key, newSipSessionImpl)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding a sip session with the key : " + key));
            }
            sipSessionImpl = newSipSessionImpl;
        }
        return sipSessionImpl;
    }

    protected MobicentsSipSession setToTag(SipSessionKey key, MobicentsSipSession sipSession) {
        String currentKeyToTag = key.getToTag();
        MobicentsSipSessionKey existingKey = sipSession.getKey();
        String toTag = existingKey.getToTag();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Totag " + toTag + " currentKeyToTag " + currentKeyToTag));
        }
        if (toTag == null && currentKeyToTag != null) {
            existingKey.setToTag(currentKeyToTag, false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting the To tag " + currentKeyToTag + " to the session " + key));
            }
        } else if (currentKeyToTag != null && !toTag.equals(currentKeyToTag)) {
            MobicentsSipSession derivedSipSession = sipSession.findDerivedSipSession(currentKeyToTag);
            if (derivedSipSession == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Original session " + key + " with To Tag " + toTag + " creates new derived session with following to Tag " + currentKeyToTag));
                }
                key.setToTag(currentKeyToTag, true);
                derivedSipSession = this.createDerivedSipSession(sipSession, key);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Original session " + key + " with To Tag " + toTag + " already has a derived session differnt than the following to Tag " + currentKeyToTag + " - reusing it"));
            }
            return derivedSipSession;
        }
        return sipSession;
    }

    public void changeSessionKey(SipSessionKey oldKey, SipSessionKey newKey) {
        MobicentsSipSession session = this.sipSessions.get(oldKey);
        if (session == null) {
            throw new IllegalArgumentException("oldKey doesn't exist in this application session.");
        }
        this.sipSessions.put(newKey, session);
        this.sipSessions.remove(oldKey);
    }

    protected MobicentsSipSession createDerivedSipSession(MobicentsSipSession parentSipSession, SipSessionKey sessionKey) {
        MobicentsSipSession sipSessionImpl = this.getNewMobicentsSipSession(sessionKey, this.sipFactoryImpl, parentSipSession.getSipApplicationSession());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created derived session " + sipSessionImpl + " with sessionKey " + sessionKey + " for parent session " + parentSipSession + " with parent session key " + parentSipSession.getKey()));
        }
        sipSessionImpl.setSipSessionAttributeMap(parentSipSession.getSipSessionAttributeMap());
        try {
            sipSessionImpl.setHandler(parentSipSession.getHandler());
        }
        catch (ServletException e) {
            logger.error((Object)"Problem creating derived session", (Throwable)e);
        }
        sipSessionImpl.setState(SipSession.State.INITIAL);
        sipSessionImpl.setStateInfo(parentSipSession.getStateInfo());
        sipSessionImpl.setProxy(parentSipSession.getProxy());
        if (parentSipSession.getSipSubscriberURI() != null) {
            sipSessionImpl.setSipSubscriberURI(parentSipSession.getSipSubscriberURI());
        }
        sipSessionImpl.setUserPrincipal(parentSipSession.getUserPrincipal());
        sipSessionImpl.setParentSession(parentSipSession);
        parentSipSession.addDerivedSipSessions(sipSessionImpl);
        if (parentSipSession.getSipApplicationSession().getSipContext() != null) {
            sipSessionImpl.notifySipSessionListeners(SipSessionEventType.CREATION);
        }
        return sipSessionImpl;
    }

    public Iterator<MobicentsSipSession> getAllSipSessions() {
        return this.sipSessions.values().iterator();
    }

    public int getNumberOfSipApplicationSessions() {
        return this.sipApplicationSessions.size();
    }

    public int getNumberOfSipSessions() {
        return this.sipSessions.size();
    }

    public Iterator<MobicentsSipApplicationSession> getAllSipApplicationSessions() {
        return this.sipApplicationSessions.values().iterator();
    }

    public MobicentsSipApplicationSession findSipApplicationSession(HttpSession httpSession) {
        for (MobicentsSipApplicationSession sipApplicationSessionImpl : this.sipApplicationSessions.values()) {
            if (sipApplicationSessionImpl.findHttpSession(httpSession.getId()) == null) continue;
            return sipApplicationSessionImpl;
        }
        return null;
    }

    public void dumpSipSessions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sip sessions present in the session manager");
            for (SipSessionKey sipSessionKey : this.sipSessions.keySet()) {
                logger.debug((Object)sipSessionKey.toString());
            }
        }
    }

    public void dumpSipApplicationSessions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sip application sessions present in the session manager");
            for (SipApplicationSessionKey sipApplicationSessionKey : this.sipApplicationSessions.keySet()) {
                logger.debug((Object)(sipApplicationSessionKey.toString() + "/hashed_app_name=" + this.sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(sipApplicationSessionKey.getApplicationName())));
            }
        }
    }

    public void removeAllSessions() {
        ArrayList<SipSessionKey> sipSessionsToRemove = new ArrayList<SipSessionKey>();
        for (SipSessionKey sipSessionKey : this.sipSessions.keySet()) {
            sipSessionsToRemove.add(sipSessionKey);
        }
        for (SipSessionKey sipSessionKey : sipSessionsToRemove) {
            this.removeSipSession(sipSessionKey);
        }
        ArrayList<SipApplicationSessionKey> sipApplicationSessionsToRemove = new ArrayList<SipApplicationSessionKey>();
        for (SipApplicationSessionKey sipApplicationSessionKey : this.sipApplicationSessions.keySet()) {
            sipApplicationSessionsToRemove.add(sipApplicationSessionKey);
        }
        for (SipApplicationSessionKey sipApplicationSessionKey : sipApplicationSessionsToRemove) {
            this.removeSipApplicationSession(sipApplicationSessionKey);
        }
    }

    protected abstract MobicentsSipSession getNewMobicentsSipSession(SipSessionKey var1, SipFactoryImpl var2, MobicentsSipApplicationSession var3);

    protected abstract MobicentsSipApplicationSession getNewMobicentsSipApplicationSession(SipApplicationSessionKey var1, SipContext var2);

    public int getMaxActiveSipSessions() {
        return this.maxActiveSipSessions;
    }

    public void setMaxActiveSipSessions(int max) {
        this.maxActiveSipSessions = max;
    }

    public int getMaxActiveSipApplicationSessions() {
        return this.maxActiveSipApplicationSessions;
    }

    public void setMaxActiveSipApplicationSessions(int max) {
        this.maxActiveSipApplicationSessions = max;
    }

    public int getRejectedSipSessions() {
        return this.rejectedSipSessions;
    }

    public void setRejectedSipSessions(int rejectedSipSessions) {
        this.rejectedSipSessions = rejectedSipSessions;
    }

    public int getRejectedSipApplicationSessions() {
        return this.rejectedSipApplicationSessions;
    }

    public void setRejectedSipApplicationSessions(int rejectedSipApplicationSessions) {
        this.rejectedSipApplicationSessions = rejectedSipApplicationSessions;
    }

    public void setSipSessionCounter(int sipSessionCounter) {
        this.sipSessionCounter = sipSessionCounter;
    }

    public int getSipSessionCounter() {
        return this.sipSessionCounter;
    }

    public int getActiveSipSessions() {
        return this.sipSessions.size();
    }

    public int getSipSessionMaxAliveTime() {
        return this.sipSessionMaxAliveTime;
    }

    public void setSipSessionMaxAliveTime(int sipSessionMaxAliveTime) {
        this.sipSessionMaxAliveTime = sipSessionMaxAliveTime;
    }

    public int getSipSessionAverageAliveTime() {
        return this.sipSessionAverageAliveTime;
    }

    public void setSipSessionAverageAliveTime(int sipSessionAverageAliveTime) {
        this.sipSessionAverageAliveTime = sipSessionAverageAliveTime;
    }

    public void setSipApplicationSessionCounter(int sipApplicationSessionCounter) {
        this.sipApplicationSessionCounter = sipApplicationSessionCounter;
    }

    public int getSipApplicationSessionCounter() {
        return this.sipApplicationSessionCounter;
    }

    public int getActiveSipApplicationSessions() {
        return this.sipApplicationSessions.size();
    }

    public int getSipApplicationSessionMaxAliveTime() {
        return this.sipApplicationSessionMaxAliveTime;
    }

    public void setSipApplicationSessionMaxAliveTime(int sipApplicationSessionMaxAliveTime) {
        this.sipApplicationSessionMaxAliveTime = sipApplicationSessionMaxAliveTime;
    }

    public int getSipApplicationSessionAverageAliveTime() {
        return this.sipApplicationSessionAverageAliveTime;
    }

    public void setSipApplicationSessionAverageAliveTime(int sipApplicationSessionAverageAliveTime) {
        this.sipApplicationSessionAverageAliveTime = sipApplicationSessionAverageAliveTime;
    }

    public int getExpiredSipSessions() {
        return this.expiredSipSessions;
    }

    public void setExpiredSipSessions(int expiredSipSessions) {
        this.expiredSipSessions = expiredSipSessions;
    }

    public int getExpiredSipApplicationSessions() {
        return this.expiredSipApplicationSessions;
    }

    public void setExpiredSipApplicationSessions(int expiredSipApplicationSessions) {
        this.expiredSipApplicationSessions = expiredSipApplicationSessions;
    }

    public double getNumberOfSipApplicationSessionCreationPerSecond() {
        return this.lastAverageSasCreationPerSecond;
    }

    public double getNumberOfSipSessionCreationPerSecond() {
        return this.lastAverageSsCreationPerSecond;
    }

    public void updateStats() {
        int elapsedNumberOfSsCreationCounter;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("updating sip manager " + this.container.getApplicationName() + " statistics"));
        }
        long now = System.currentTimeMillis();
        int elapsedNumberOfSasCreationCounter = this.sipApplicationSessionCounter - this.lastUpdatedSasCreationCounter;
        if (elapsedNumberOfSasCreationCounter > 0) {
            double elapsedSasCreationUpdatedTimeInSeconds = (now - this.lastSipApplicationSessionUpdatedTime) / 1000L;
            double elapsedAverageSasCreationPerSecond = (double)elapsedNumberOfSasCreationCounter / elapsedSasCreationUpdatedTimeInSeconds;
            this.lastAverageSasCreationPerSecond = (this.lastAverageSasCreationPerSecond + elapsedAverageSasCreationPerSecond) / 2.0;
        }
        this.lastUpdatedSasCreationCounter = this.sipApplicationSessionCounter;
        this.lastSipApplicationSessionUpdatedTime = now;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("elapsedNumberOfSasCreationCounter " + elapsedNumberOfSasCreationCounter));
            logger.trace((Object)("lastUpdatedSasCreationCounter " + this.lastUpdatedSasCreationCounter));
            logger.trace((Object)("lastSipApplicationSessionUpdatedTime " + this.lastSipApplicationSessionUpdatedTime));
        }
        if ((elapsedNumberOfSsCreationCounter = this.sipSessionCounter - this.lastUpdatedSsCreationCounter) > 0) {
            double elapsedSsCreationUpdatedTimeInSeconds = (now - this.lastSipSessionUpdatedTime) / 1000L;
            double elapsedAverageSsCreationPerSecond = (double)elapsedNumberOfSsCreationCounter / elapsedSsCreationUpdatedTimeInSeconds;
            this.lastAverageSsCreationPerSecond = (this.lastAverageSsCreationPerSecond + elapsedAverageSsCreationPerSecond) / 2.0;
        }
        this.lastUpdatedSsCreationCounter = this.sipSessionCounter;
        this.lastSipSessionUpdatedTime = now;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("elapsedNumberOfSsCreationCounter " + elapsedNumberOfSsCreationCounter));
            logger.trace((Object)("lastUpdatedSsCreationCounter " + this.lastUpdatedSsCreationCounter));
            logger.trace((Object)("lastSipSessionUpdatedTime " + this.lastSipSessionUpdatedTime));
        }
    }
}

