/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.header.HeaderExt;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipFactory;
import javax.sip.Transaction;
import javax.sip.header.AcceptLanguageHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentLanguageHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderAddress;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.ReplicationStrategy;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.ParameterableHeaderImpl;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.security.SipPrincipal;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public abstract class SipServletMessageImpl
implements MobicentsSipServletMessage,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)SipServletMessageImpl.class.getCanonicalName());
    private static final String CONTENT_TYPE_TEXT = "text";
    private static final String CONTENT_TYPE_MULTIPART = "multipart";
    private static final String MULTIPART_BOUNDARY = "boundary";
    private static final String MULTIPART_START = "start";
    private static final String MULTIPART_BOUNDARY_DELIM = "--";
    private static final String LINE_RETURN_DELIM = "\n";
    public static final String REL100_OPTION_TAG = "100rel";
    protected Message message;
    protected SipFactoryImpl sipFactoryImpl;
    protected MobicentsSipSessionKey sessionKey;
    protected transient MobicentsSipSession sipSession;
    protected Map<String, Object> attributes;
    private transient Transaction transaction;
    private String transactionId;
    private boolean transactionType;
    protected TransactionApplicationData transactionApplicationData;
    protected SipServletMessage.HeaderForm headerForm = SipServletMessage.HeaderForm.DEFAULT;
    protected transient String transport = null;
    protected String currentApplicationName = null;
    protected transient SipPrincipal userPrincipal;
    protected boolean isMessageSent;
    protected transient Dialog dialog;
    protected transient String method;
    boolean orphan;
    private String appSessionId;

    public SipServletMessageImpl() {
    }

    protected SipServletMessageImpl(Message message, SipFactoryImpl sipFactoryImpl, Transaction transaction, MobicentsSipSession sipSession, Dialog dialog) {
        if (sipFactoryImpl == null) {
            throw new NullPointerException("Null factory");
        }
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        this.sipFactoryImpl = sipFactoryImpl;
        this.message = message;
        this.transaction = transaction;
        if (sipSession != null) {
            this.sessionKey = sipSession.getKey();
        }
        if (transaction != null && this.getMethod().equals("INVITE") && transaction.getApplicationData() != null) {
            this.transactionApplicationData = (TransactionApplicationData)transaction.getApplicationData();
        }
        if (this.transactionApplicationData == null) {
            this.transactionApplicationData = new TransactionApplicationData(this);
        }
        this.isMessageSent = false;
        this.dialog = dialog;
        if (sipSession != null && dialog != null) {
            sipSession.setSessionCreatingDialog(dialog);
            if (dialog.getApplicationData() == null) {
                dialog.setApplicationData((Object)this.transactionApplicationData);
            }
        }
        if (transaction != null && transaction.getApplicationData() == null) {
            transaction.setApplicationData((Object)this.transactionApplicationData);
        }
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("This message is in committed state. You can not modify it");
        }
    }

    public void addAcceptLanguage(Locale locale) {
        this.checkCommitted();
        AcceptLanguageHeader ach = SipFactoryImpl.headerFactory.createAcceptLanguageHeader(locale);
        this.message.addHeader((Header)ach);
    }

    public void addAddressHeader(String name, Address addr, boolean first) throws IllegalArgumentException {
        this.checkCommitted();
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding address header [" + hName + "] as first [" + first + "] value [" + addr + "]"));
        }
        if (SipServletMessageImpl.isSystemHeaderAndNotGruu(this.getModifiableRule(hName), (Parameterable)addr.getURI())) {
            logger.error((Object)("Error, can't add system header [" + hName + "]"));
            throw new IllegalArgumentException("Header[" + hName + "] is system header, cant add, modify it!!!");
        }
        if (hName.equalsIgnoreCase("From") || hName.equalsIgnoreCase("To")) {
            logger.error((Object)("Error, can't add From or To header [" + hName + "]"));
            throw new IllegalArgumentException("Can't add From or To header, see JSR 289 Section 4.1.2");
        }
        try {
            String nameToAdd = this.getCorrectHeaderName(hName);
            Header h = SipFactoryImpl.headerFactory.createHeader(nameToAdd, addr.toString());
            if (first) {
                this.message.addFirst(h);
            } else {
                this.message.addLast(h);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error adding header", e);
        }
    }

    public void addHeaderInternal(String name, String value, boolean bypassSystemHeaderCheck) {
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding header under name [" + hName + "]"));
        }
        if (!bypassSystemHeaderCheck && SipServletMessageImpl.isSystemHeader(this.getModifiableRule(hName))) {
            logger.error((Object)("Cant add system header [" + hName + "]"));
            throw new IllegalArgumentException("Header[" + hName + "] is system header, cant add,cant modify it!!!");
        }
        String nameToAdd = this.getCorrectHeaderName(hName);
        try {
            if (JainSipUtils.SINGLETON_HEADER_NAMES.contains(name)) {
                Header header = SipFactory.getInstance().createHeaderFactory().createHeader(nameToAdd, value);
                this.message.setHeader(header);
            } else if (JainSipUtils.LIST_HEADER_NAMES.contains(name)) {
                List headers = SipFactory.getInstance().createHeaderFactory().createHeaders(name + ":" + value);
                for (Header header : headers) {
                    this.message.addHeader(header);
                }
            } else {
                Header header = SipFactory.getInstance().createHeaderFactory().createHeader(name, value);
                this.message.addLast(header);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal args supplied ", ex);
        }
    }

    public void setHeaderInternal(String name, String value, boolean bypassSystemHeaderCheck) {
        if (name == null) {
            throw new NullPointerException("name parameter is null");
        }
        if (value == null) {
            throw new NullPointerException("value parameter is null");
        }
        if (!bypassSystemHeaderCheck && SipServletMessageImpl.isSystemHeader(this.getModifiableRule(name))) {
            throw new IllegalArgumentException(name + " is a system header !");
        }
        try {
            Header header = SipFactory.getInstance().createHeaderFactory().createHeader(name, value);
            this.message.setHeader(header);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating header!", e);
        }
    }

    public void addHeader(String name, String value) {
        this.checkCommitted();
        this.addHeaderInternal(name, value, false);
    }

    public void addParameterableHeader(String name, Parameterable param, boolean first) {
        this.checkCommitted();
        try {
            String hName = SipServletMessageImpl.getFullHeaderName(name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding parametrable header under name [" + hName + "] as first [" + first + "] value [" + param + "]"));
            }
            String body = param.toString();
            String nameToAdd = this.getCorrectHeaderName(hName);
            Header header = SipFactoryImpl.headerFactory.createHeader(nameToAdd, body);
            if (first) {
                this.message.addFirst(header);
            } else {
                this.message.addLast(header);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal args supplied", ex);
        }
    }

    public Locale getAcceptLanguage() {
        Locale preferredLocale = null;
        float q = 0.0f;
        ListIterator it = this.message.getHeaders("Accept-Language");
        while (it.hasNext()) {
            AcceptLanguageHeader alh = (AcceptLanguageHeader)it.next();
            if (preferredLocale == null) {
                preferredLocale = alh.getAcceptLanguage();
                q = alh.getQValue();
                continue;
            }
            if (!(alh.getQValue() > q)) continue;
            preferredLocale = alh.getAcceptLanguage();
            q = alh.getQValue();
        }
        return preferredLocale;
    }

    public Iterator<Locale> getAcceptLanguages() {
        LinkedList<Locale> ll = new LinkedList<Locale>();
        ListIterator it = this.message.getHeaders("Accept-Language");
        while (it.hasNext()) {
            AcceptLanguageHeader alh = (AcceptLanguageHeader)it.next();
            ll.add(alh.getAcceptLanguage());
        }
        return ll.iterator();
    }

    public Address getAddressHeader(String name) throws ServletParseException {
        String nameToSearch;
        ListIterator headers;
        ListIterator lit;
        if (name == null) {
            throw new NullPointerException();
        }
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching address header for name [" + hName + "]"));
        }
        if ((lit = (headers = this.message.getHeaders(nameToSearch = this.getCorrectHeaderName(hName)))) != null && lit.hasNext()) {
            Header first = (Header)lit.next();
            if (first instanceof HeaderAddress) {
                try {
                    if (this.isCommitted()) {
                        return new AddressImpl((HeaderAddress)first, AddressImpl.ModifiableRule.NotModifiable);
                    }
                    return new AddressImpl((HeaderAddress)first, this.getModifiableRule(hName));
                }
                catch (ParseException e) {
                    throw new ServletParseException("Bad address " + first);
                }
            }
            Parameterable parametrable = SipServletMessageImpl.createParameterable(first, first.getName(), this.message instanceof Request);
            try {
                logger.debug((Object)("parametrable Value " + parametrable.getValue()));
                if (this.isCommitted()) {
                    return new AddressImpl(SipFactoryImpl.addressFactory.createAddress(parametrable.getValue()), ((ParameterableHeaderImpl)parametrable).getInternalParameters(), AddressImpl.ModifiableRule.NotModifiable);
                }
                return new AddressImpl(SipFactoryImpl.addressFactory.createAddress(parametrable.getValue()), ((ParameterableHeaderImpl)parametrable).getInternalParameters(), this.getModifiableRule(hName));
            }
            catch (ParseException e) {
                throw new ServletParseException("Impossible to parse the following header " + name + " as an address.", (Throwable)e);
            }
        }
        return null;
    }

    public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        LinkedList<AddressImpl> retval = new LinkedList<AddressImpl>();
        String nameToSearch = this.getCorrectHeaderName(hName);
        ListIterator it = this.message.getHeaders(nameToSearch);
        while (it.hasNext()) {
            AddressImpl addressImpl;
            Header header = (Header)it.next();
            if (header instanceof HeaderAddress) {
                HeaderAddress aph = (HeaderAddress)header;
                try {
                    addressImpl = new AddressImpl(aph, this.getModifiableRule(hName));
                    retval.add(addressImpl);
                    continue;
                }
                catch (ParseException ex) {
                    throw new ServletParseException("Bad header", (Throwable)ex);
                }
            }
            Parameterable parametrable = SipServletMessageImpl.createParameterable(header, header.getName(), this.message instanceof Request);
            try {
                addressImpl = new AddressImpl(SipFactoryImpl.addressFactory.createAddress(parametrable.getValue()), ((ParameterableHeaderImpl)parametrable).getInternalParameters(), this.getModifiableRule(hName));
                retval.add(addressImpl);
            }
            catch (ParseException e) {
                throw new ServletParseException("Impossible to parse the following header " + name + " as an address.", (Throwable)e);
            }
        }
        return retval.listIterator();
    }

    public SipApplicationSession getApplicationSession() {
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession(true);
        if (sipApplicationSession == null) {
            return null;
        }
        return sipApplicationSession.getFacade();
    }

    public SipApplicationSession getApplicationSession(boolean create) {
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession(create);
        if (sipApplicationSession == null) {
            return null;
        }
        return sipApplicationSession.getFacade();
    }

    public MobicentsSipApplicationSession getSipApplicationSession(boolean create) {
        MobicentsSipApplicationSession sipApplicationSession;
        MobicentsSipSession sipSession = this.getSipSession();
        if (sipSession != null && (sipApplicationSession = sipSession.getSipApplicationSession()) != null) {
            return sipApplicationSession;
        }
        String applicationName = this.getCurrentApplicationName();
        if (this.sessionKey != null) {
            applicationName = this.sessionKey.getApplicationName();
        } else if (this instanceof SipServletRequestImpl && this.isOrphan()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Orphans session " + applicationName + " " + this.sessionKey));
            }
            this.orphan = true;
            this.sessionKey = SessionManagerUtil.getSipSessionKey(SessionManagerUtil.getSipApplicationSessionKey(applicationName, this.getAppSessionId(), null).getId(), applicationName, this.message, false);
        }
        if (applicationName != null && this.sessionKey != null) {
            SipContext sipContext = this.sipFactoryImpl.getSipApplicationDispatcher().findSipApplication(applicationName);
            SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(applicationName, this.sessionKey.getApplicationSessionId(), null);
            MobicentsSipApplicationSession applicationSession = sipContext.getSipManager().getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, create);
            if (applicationSession != null) {
                applicationSession.setOrphan(this.isOrphan());
            }
            return applicationSession;
        }
        return null;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name can not be null.");
        }
        return this.getAttributeMap().get(name);
    }

    public Enumeration<String> getAttributeNames() {
        Vector<String> names = new Vector<String>(this.getAttributeMap().keySet());
        return names.elements();
    }

    public String getCallId() {
        CallIdHeader id = (CallIdHeader)this.message.getHeader(this.getCorrectHeaderName("Call-ID"));
        if (id != null) {
            return id.getCallId();
        }
        return null;
    }

    public String getCharacterEncoding() {
        if (this.message.getContentEncoding() != null) {
            return this.message.getContentEncoding().getEncoding();
        }
        ContentTypeHeader cth = (ContentTypeHeader)this.message.getHeader("Content-Type");
        if (cth == null) {
            return null;
        }
        return cth.getParameter("charset");
    }

    public Object getContent() throws IOException, UnsupportedEncodingException {
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.message.getHeader("Content-Type");
        if (contentTypeHeader != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Content type " + contentTypeHeader.getContentType()));
            logger.debug((Object)("Content sub type " + contentTypeHeader.getContentSubType()));
        }
        if (contentTypeHeader != null && CONTENT_TYPE_TEXT.equals(contentTypeHeader.getContentType())) {
            String charset;
            String content = null;
            content = this.message.getRawContent() != null ? ((charset = this.getCharacterEncoding()) == null ? new String(this.message.getRawContent()) : new String(this.message.getRawContent(), charset)) : "";
            return content;
        }
        if (contentTypeHeader != null && CONTENT_TYPE_MULTIPART.equals(contentTypeHeader.getContentType())) {
            try {
                return new MimeMultipart((DataSource)new ByteArrayDataSource(this.message.getRawContent(), contentTypeHeader.toString().replaceAll("Content-Type: ", "")));
            }
            catch (MessagingException e) {
                logger.warn((Object)"Problem with multipart message.", (Throwable)e);
                return this.message.getRawContent();
            }
        }
        return this.message.getRawContent();
    }

    private static MimeMultipart getContentAsMimeMultipart(ContentTypeHeader contentTypeHeader, byte[] rawContent) {
        String delimiter = contentTypeHeader.getParameter(MULTIPART_BOUNDARY);
        String start = contentTypeHeader.getParameter(MULTIPART_START);
        MimeMultipart mimeMultipart = new MimeMultipart(contentTypeHeader.getContentSubType());
        if (delimiter == null) {
            MimeBodyPart mbp = new MimeBodyPart();
            ByteArrayDataSource ds = new ByteArrayDataSource(rawContent, contentTypeHeader.getContentSubType());
            try {
                mbp.setDataHandler(new DataHandler((DataSource)ds));
                mimeMultipart.addBodyPart((BodyPart)mbp);
            }
            catch (MessagingException e) {
                throw new IllegalArgumentException("couldn't create the multipart object from the message content " + rawContent, e);
            }
        } else {
            String[] fragments;
            for (String fragment : fragments = new String(rawContent).split(MULTIPART_BOUNDARY_DELIM + delimiter)) {
                int indexOfStart;
                String trimmedFragment = fragment.trim();
                if (trimmedFragment.length() <= 0 || MULTIPART_BOUNDARY_DELIM.equals(trimmedFragment)) continue;
                String fragmentHeaders = null;
                String fragmentBody = fragment;
                if (start != null && start.length() > 0 && (indexOfStart = fragment.indexOf(start)) != -1) {
                    fragmentHeaders = fragmentBody.substring(0, indexOfStart + start.length());
                    fragmentBody = fragmentBody.substring(indexOfStart + start.length()).trim();
                }
                MimeBodyPart mbp = new MimeBodyPart();
                try {
                    String contentType = contentTypeHeader.getContentSubType();
                    if (fragmentBody.startsWith("Content-Type")) {
                        int indexOfLineReturn = fragmentBody.indexOf(LINE_RETURN_DELIM);
                        contentType = fragmentBody.substring(0, indexOfLineReturn - 1).trim();
                        fragmentBody = fragmentBody.substring(indexOfLineReturn).trim();
                    }
                    mbp.setContent((Object)fragmentBody, contentType);
                    mbp.addHeaderLine(contentType);
                    if (fragmentHeaders != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(fragmentHeaders, LINE_RETURN_DELIM);
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken().trim();
                            if (token == null || token.length() <= 0) continue;
                            mbp.addHeaderLine(token);
                        }
                    }
                    mimeMultipart.addBodyPart((BodyPart)mbp);
                }
                catch (MessagingException e) {
                    throw new IllegalArgumentException("couldn't create the multipart object from the message content " + rawContent, e);
                }
            }
        }
        return mimeMultipart;
    }

    public Locale getContentLanguage() {
        if (this.message.getContentLanguage() != null) {
            return this.message.getContentLanguage().getContentLanguage();
        }
        return null;
    }

    public int getContentLength() {
        if (this.message.getContentLength() != null) {
            return this.message.getContentLength().getContentLength();
        }
        return 0;
    }

    public String getContentType() {
        ContentTypeHeader cth = (ContentTypeHeader)this.message.getHeader(this.getCorrectHeaderName("Content-Type"));
        if (cth != null) {
            return ((HeaderExt)cth).getValue();
        }
        return null;
    }

    public int getExpires() {
        if (this.message.getExpires() != null) {
            return this.message.getExpires().getExpires();
        }
        return -1;
    }

    public Address getFrom() {
        FromHeader from = (FromHeader)this.message.getHeader(this.getCorrectHeaderName("From"));
        try {
            return new AddressImpl((HeaderAddress)from, AddressImpl.ModifiableRule.From);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Couldn't parse From Header " + from, e);
        }
    }

    public String getHeader(String name) {
        String nameToSearch = this.getCorrectHeaderName(name);
        String value = null;
        if (this.message.getHeader(nameToSearch) != null) {
            value = ((SIPHeader)this.message.getHeader(nameToSearch)).getValue();
        }
        return value;
    }

    public SipServletMessage.HeaderForm getHeaderForm() {
        return this.headerForm;
    }

    public Iterator<String> getHeaderNames() {
        return this.message.getHeaderNames();
    }

    public ListIterator<String> getHeaders(String name) {
        String nameToSearch = this.getCorrectHeaderName(name);
        ArrayList<String> result = new ArrayList<String>();
        try {
            ListIterator list = this.message.getHeaders(nameToSearch);
            while (list != null && list.hasNext()) {
                Header h = (Header)list.next();
                result.add(((SIPHeader)h).getHeaderValue());
            }
        }
        catch (Exception e) {
            logger.fatal((Object)("Couldnt fetch headers, original name[" + name + "], name searched[" + nameToSearch + "]"), (Throwable)e);
            return result.listIterator();
        }
        return result.listIterator();
    }

    public final String getMethod() {
        if (this.method == null) {
            this.method = this.message instanceof Request ? ((Request)this.message).getMethod() : ((CSeqHeader)this.message.getHeader("CSeq")).getMethod();
        }
        return this.method;
    }

    public Parameterable getParameterableHeader(String name) throws ServletParseException {
        if (name == null) {
            throw new NullPointerException("Parametrable header name cant be null!!!");
        }
        String nameToSearch = this.getCorrectHeaderName(name);
        Header h = this.message.getHeader(nameToSearch);
        if (!SipServletMessageImpl.isParameterable(name)) {
            throw new ServletParseException(name + " header is not parameterable !");
        }
        if (h == null) {
            return null;
        }
        return SipServletMessageImpl.createParameterable(h, SipServletMessageImpl.getFullHeaderName(name), this.message instanceof Request);
    }

    public ListIterator<Parameterable> getParameterableHeaders(String name) throws ServletParseException {
        ListIterator headers = this.message.getHeaders(this.getCorrectHeaderName(name));
        ArrayList<Parameterable> result = new ArrayList<Parameterable>();
        while (headers != null && headers.hasNext()) {
            result.add(SipServletMessageImpl.createParameterable((Header)headers.next(), SipServletMessageImpl.getFullHeaderName(name), this.message instanceof Request));
        }
        if (!SipServletMessageImpl.isParameterable(name)) {
            throw new ServletParseException(name + " header is not parameterable !");
        }
        return result.listIterator();
    }

    public String getProtocol() {
        return "SIP/2.0";
    }

    public byte[] getRawContent() throws IOException {
        if (this.message != null) {
            return this.message.getRawContent();
        }
        return null;
    }

    public String getInitialRemoteAddr() {
        return this.transactionApplicationData.getInitialRemoteHostAddress();
    }

    public int getInitialRemotePort() {
        return this.transactionApplicationData.getInitialRemotePort();
    }

    public String getInitialTransport() {
        return this.transactionApplicationData.getInitialRemoteTransport();
    }

    public String getRemoteAddr() {
        if (this.getTransaction() != null) {
            if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null && ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress().getHostAddress() != null) {
                return ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress().getHostAddress();
            }
            return ((SIPTransaction)this.getTransaction()).getPeerAddress();
        }
        ViaHeader via = (ViaHeader)this.message.getHeader("Via");
        boolean isExternal = this.sipFactoryImpl.getSipApplicationDispatcher().isViaHeaderExternal(via);
        if (this.message instanceof Request && !isExternal) {
            return null;
        }
        if (via == null) {
            return null;
        }
        return via.getHost();
    }

    public int getRemotePort() {
        int port = -1;
        if (this.getTransaction() != null) {
            port = ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null ? ((SIPTransaction)this.getTransaction()).getPeerPacketSourcePort() : ((SIPTransaction)this.getTransaction()).getPeerPort();
        } else {
            ViaHeader via = (ViaHeader)this.message.getHeader("Via");
            boolean isExternal = this.sipFactoryImpl.getSipApplicationDispatcher().isViaHeaderExternal(via);
            if (this.message instanceof Request && !isExternal) {
                return -1;
            }
            if (via != null) {
                port = via.getPort();
            }
        }
        if (port <= 0) {
            return 5060;
        }
        return port;
    }

    public String getTransport() {
        if (this.getTransaction() != null) {
            return ((SIPTransaction)this.getTransaction()).getTransport();
        }
        return null;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public SipSession getSession() {
        return this.getSession(true);
    }

    public SipSession getSession(boolean create) {
        MobicentsSipSession session = this.getSipSession();
        if (session == null && create) {
            MobicentsSipApplicationSession sipApplicationSessionImpl = this.getSipApplicationSession(create);
            SipSessionKey sessionKey = SessionManagerUtil.getSipSessionKey(sipApplicationSessionImpl.getKey().getId(), this.currentApplicationName, this.message, false);
            session = sipApplicationSessionImpl.getSipContext().getSipManager().getSipSession((MobicentsSipSessionKey)sessionKey, create, (MobicentsSipFactory)this.sipFactoryImpl, sipApplicationSessionImpl);
            session.setSessionCreatingTransactionRequest((MobicentsSipServletMessage)this);
            session.setOrphan(this.isOrphan());
            sessionKey = session.getKey();
        }
        if (session != null) {
            return session.getFacade();
        }
        return null;
    }

    public final MobicentsSipSession getSipSession() {
        if (this.sipSession == null && this.sessionKey != null) {
            String applicationName = this.sessionKey.getApplicationName();
            SipContext sipContext = this.sipFactoryImpl.getSipApplicationDispatcher().findSipApplication(applicationName);
            SipApplicationSessionKey sipApplicationSessionKey = new SipApplicationSessionKey(this.sessionKey.getApplicationSessionId(), this.sessionKey.getApplicationName(), null);
            MobicentsSipApplicationSession sipApplicationSession = sipContext.getSipManager().getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, false);
            this.sipSession = sipContext.getSipManager().getSipSession(this.sessionKey, false, (MobicentsSipFactory)this.sipFactoryImpl, sipApplicationSession);
        }
        return this.sipSession;
    }

    public void setSipSession(MobicentsSipSession session) {
        this.sipSession = session;
        this.sessionKey = session != null ? session.getKey() : null;
    }

    public MobicentsSipSessionKey getSipSessionKey() {
        return this.sessionKey;
    }

    public void setSipSessionKey(MobicentsSipSessionKey sessionKey) {
        this.sessionKey = sessionKey;
    }

    public Address getTo() {
        ToHeader to = (ToHeader)this.message.getHeader(this.getCorrectHeaderName("To"));
        try {
            return new AddressImpl((HeaderAddress)to, AddressImpl.ModifiableRule.From);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Couldn't parse From Header " + to, e);
        }
    }

    public SipPrincipal getUserPrincipal() {
        if (this.userPrincipal == null && this.getSipSession() != null) {
            this.userPrincipal = this.getSipSession().getUserPrincipal();
        }
        return this.userPrincipal;
    }

    public void setUserPrincipal(SipPrincipal principal) {
        this.userPrincipal = principal;
    }

    public boolean isSecure() {
        return "TLS".equalsIgnoreCase(JainSipUtils.findTransport(this.message));
    }

    public boolean isUserInRole(String role) {
        if (this.userPrincipal != null) {
            return this.userPrincipal.isUserInRole(role);
        }
        return false;
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void removeHeader(String name) {
        this.checkCommitted();
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (hName.trim().equalsIgnoreCase("Contact")) {
            String header = this.getHeader(hName);
            if (SipServletMessageImpl.isSystemHeaderAndNotGruu(this.getModifiableRule(hName), header)) {
                throw new IllegalArgumentException("Cant remove system header[" + hName + "]");
            }
        } else if (SipServletMessageImpl.isSystemHeader(this.getModifiableRule(hName))) {
            throw new IllegalArgumentException("Cant remove system header[" + hName + "]");
        }
        if (hName.equalsIgnoreCase("From") || hName.equalsIgnoreCase("To")) {
            logger.error((Object)("Error, can't remove From or To header [" + hName + "]"));
            throw new IllegalArgumentException("Cant remove From or To header, see JSR 289 Section 4.1.2");
        }
        String nameToSearch = this.getCorrectHeaderName(hName);
        this.message.removeHeader(nameToSearch);
    }

    public void removeHeaderInternal(String name, boolean bypassSystemHeaderCheck) {
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing header under name [" + hName + "]"));
        }
        if (!bypassSystemHeaderCheck && SipServletMessageImpl.isSystemHeader(this.getModifiableRule(hName))) {
            logger.error((Object)("Cant remove system header [" + hName + "]"));
            throw new IllegalArgumentException("Header[" + hName + "] is system header, can't remove it!!!");
        }
        String nameToRemove = this.getCorrectHeaderName(hName);
        try {
            this.message.removeHeader(nameToRemove);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal args supplied ", ex);
        }
    }

    public abstract void send() throws IOException;

    public void setAcceptLanguage(Locale locale) {
        this.checkCommitted();
        AcceptLanguageHeader alh = SipFactoryImpl.headerFactory.createAcceptLanguageHeader(locale);
        this.message.setHeader((Header)alh);
    }

    public void setAddressHeader(String name, Address addr) {
        this.checkCommitted();
        String hName = SipServletMessageImpl.getFullHeaderName(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting address header [" + name + "] to value [" + addr + "]"));
        }
        if (SipServletMessageImpl.isSystemHeaderAndNotGruu(this.getModifiableRule(hName), (Parameterable)addr.getURI())) {
            logger.error((Object)("Error, can't set system header [" + hName + "]"));
            throw new IllegalArgumentException("Cant set system header, it is maintained by container!!");
        }
        if (hName.equalsIgnoreCase("From") || hName.equalsIgnoreCase("To")) {
            logger.error((Object)("Error, can't set From or To header [" + hName + "]"));
            throw new IllegalArgumentException("Cant set From or To header, see JSR 289 Section 4.1.2");
        }
        String headerNameToAdd = this.getCorrectHeaderName(hName);
        try {
            Header h = SipFactoryImpl.headerFactory.createHeader(headerNameToAdd, addr.toString());
            this.message.setHeader(h);
        }
        catch (ParseException e) {
            logger.error((Object)("Parsing problem while setting address header with name " + name + " and address " + addr), (Throwable)e);
        }
    }

    public void setAttribute(String name, Object o) {
        if (name == null) {
            throw new NullPointerException("Attribute name can not be null.");
        }
        this.getAttributeMap().put(name, o);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        new String("testEncoding".getBytes(), enc);
        this.checkCommitted();
        try {
            this.message.setContentEncoding(SipFactoryImpl.headerFactory.createContentEncodingHeader(enc));
        }
        catch (Exception ex) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
        if (this.getSipSession().getProxy() == null) {
            this.checkMessageState();
        }
        this.checkContentType(contentType);
        this.checkCommitted();
        if (contentType != null && contentType.length() > 0) {
            this.addHeader("Content-Type", contentType);
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.message.getHeader("Content-Type");
            String charset = this.getCharacterEncoding();
            try {
                if (contentType.contains(CONTENT_TYPE_MULTIPART) && content instanceof Multipart) {
                    Multipart multipart = (Multipart)content;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    multipart.writeTo((OutputStream)os);
                    this.message.setContent((Object)((Object)os).toString(), contentTypeHeader);
                } else {
                    Object tmpContent = content;
                    if (tmpContent instanceof String && charset != null) {
                        new String("testEncoding".getBytes(charset));
                        tmpContent = new String(((String)tmpContent).getBytes());
                    }
                    this.message.setContent(content, contentTypeHeader);
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw uee;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parse error reading content " + content + " with content type " + contentType, e);
            }
        }
    }

    protected abstract void checkMessageState();

    private void checkContentType(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("the content type cannot be null");
        }
        int indexOfSlash = contentType.indexOf("/");
        if (indexOfSlash != -1 ? !JainSipUtils.IANA_ALLOWED_CONTENT_TYPES.contains(contentType.substring(0, indexOfSlash)) : !JainSipUtils.IANA_ALLOWED_CONTENT_TYPES.contains(contentType.toLowerCase())) {
            throw new IllegalArgumentException("the given content type " + contentType + " is not allowed");
        }
    }

    public void setContentLanguage(Locale locale) {
        this.checkCommitted();
        ContentLanguageHeader contentLanguageHeader = SipFactoryImpl.headerFactory.createContentLanguageHeader(locale);
        this.message.setContentLanguage(contentLanguageHeader);
    }

    public void setContentLength(int len) {
        this.checkMessageState();
        this.checkCommitted();
        try {
            ContentLengthHeader h = SipFactoryImpl.headerFactory.createContentLengthHeader(len);
            this.message.setHeader((Header)h);
        }
        catch (InvalidArgumentException e) {
            throw new IllegalStateException("Impossible to set a content length lower than 0", e);
        }
    }

    public void setContentType(String type) {
        this.checkContentType(type);
        this.checkCommitted();
        String name = this.getCorrectHeaderName("Content-Type");
        try {
            Header h = SipFactoryImpl.headerFactory.createHeader(name, type);
            this.message.removeHeader(this.getCorrectHeaderName("Content-Type"));
            this.message.addHeader(h);
        }
        catch (ParseException e) {
            logger.error((Object)"Error while setting content type header !!!", (Throwable)e);
        }
    }

    public void setExpires(int seconds) {
        try {
            ExpiresHeader expiresHeader = SipFactoryImpl.headerFactory.createExpiresHeader(seconds);
            expiresHeader.setExpires(seconds);
            this.message.setExpires(expiresHeader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error setting expiration header!", e);
        }
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name parameter is null");
        }
        if (value == null) {
            throw new NullPointerException("value parameter is null");
        }
        if (SipServletMessageImpl.isSystemHeader(this.getModifiableRule(name))) {
            throw new IllegalArgumentException(name + " is a system header !");
        }
        this.checkCommitted();
        try {
            if (JainSipUtils.LIST_HEADER_NAMES.contains(name)) {
                this.message.removeHeader(name);
                List headers = SipFactory.getInstance().createHeaderFactory().createHeaders(name + ":" + value);
                for (Header header : headers) {
                    this.message.addHeader(header);
                }
            } else {
                Header header = SipFactory.getInstance().createHeaderFactory().createHeader(name, value);
                this.message.setHeader(header);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating header!", e);
        }
    }

    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        this.headerForm = form;
        if (form == SipServletMessage.HeaderForm.DEFAULT) {
            return;
        }
    }

    public void setParameterableHeader(String name, Parameterable param) {
        this.checkCommitted();
        if (SipServletMessageImpl.isSystemHeader(this.getModifiableRule(name))) {
            throw new IllegalArgumentException(name + " is a system header !");
        }
        try {
            this.message.setHeader(SipFactoryImpl.headerFactory.createHeader(name, param.toString()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Impossible to set this parameterable header", e);
        }
    }

    public abstract AddressImpl.ModifiableRule getModifiableRule(String var1);

    public static boolean isSystemHeader(AddressImpl.ModifiableRule modifiableRule) {
        return modifiableRule == AddressImpl.ModifiableRule.NotModifiable || modifiableRule == AddressImpl.ModifiableRule.ContactSystem || modifiableRule == AddressImpl.ModifiableRule.ProxyRecordRouteNotModifiable;
    }

    public static boolean isSystemHeaderAndNotGruu(AddressImpl.ModifiableRule modifiableRule, Parameterable parameterable) {
        boolean isSettingGruu = false;
        if (modifiableRule == AddressImpl.ModifiableRule.ContactSystem && (parameterable.getParameter("gruu") != null || parameterable.getParameter("gr") != null)) {
            isSettingGruu = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting gruu so modifying contact header address is allowed");
            }
        }
        return !isSettingGruu && SipServletMessageImpl.isSystemHeader(modifiableRule);
    }

    public static boolean isSystemHeaderAndNotGruu(AddressImpl.ModifiableRule modifiableRule, String value) {
        boolean isSettingGruu = false;
        if (modifiableRule == AddressImpl.ModifiableRule.ContactSystem && (value.indexOf("gruu") != -1 || value.indexOf("gr=") != -1)) {
            isSettingGruu = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting gruu so modifying contact header address is allowed");
            }
        }
        return !isSettingGruu && SipServletMessageImpl.isSystemHeader(modifiableRule);
    }

    public static boolean isAddressTypeHeader(String headerName) {
        return JainSipUtils.ADDRESS_HEADER_NAMES.contains(SipServletMessageImpl.getFullHeaderName(headerName));
    }

    protected static String getFullHeaderName(String headerName) {
        String fullName = null;
        fullName = JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.containsKey(headerName) ? JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.get(headerName) : headerName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching full header name for [" + headerName + "] returning [" + fullName + "]"));
        }
        return fullName;
    }

    public static String getCompactName(String headerName) {
        String compactName = null;
        compactName = JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.containsKey(headerName) ? JainSipUtils.HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.get(headerName) : JainSipUtils.HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.get(headerName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching compact header name for [" + headerName + "] returning [" + compactName + "]"));
        }
        return compactName;
    }

    public String getCorrectHeaderName(String name) {
        return SipServletMessageImpl.getCorrectHeaderName(name, this.headerForm);
    }

    protected static String getCorrectHeaderName(String name, SipServletMessage.HeaderForm form) {
        if (form == SipServletMessage.HeaderForm.DEFAULT) {
            return name;
        }
        if (form == SipServletMessage.HeaderForm.COMPACT) {
            String compact = SipServletMessageImpl.getCompactName(name);
            if (compact != null) {
                return compact;
            }
            return name;
        }
        if (form == SipServletMessage.HeaderForm.LONG) {
            return SipServletMessageImpl.getFullHeaderName(name);
        }
        throw new IllegalStateException("No default form of a header set!!!");
    }

    public Transaction getTransaction() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transaction " + this.transaction + " transactionId = " + this.transactionId + " transactionType " + this.transactionType));
        }
        if (this.transaction == null && this.transactionId != null) {
            this.setTransaction((Transaction)((ClusteredSipStack)StaticServiceHolder.sipStandardService.getSipStack()).findTransaction(this.transactionId, this.transactionType));
            if (this.transaction != null) {
                this.transactionApplicationData = (TransactionApplicationData)this.transaction.getApplicationData();
            }
        }
        return this.transaction;
    }

    public String toString() {
        return this.message.toString();
    }

    public TransactionApplicationData getTransactionApplicationData() {
        return this.transactionApplicationData;
    }

    public Message getMessage() {
        return this.message;
    }

    public Dialog getDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        if (this.getTransaction() != null) {
            return this.getTransaction().getDialog();
        }
        return null;
    }

    public void setTransaction(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting transaction " + transaction + " on message " + this));
        }
        this.transaction = transaction;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    protected static int countChars(String string, char c) {
        int count = 0;
        for (int w = 0; w < string.length(); ++w) {
            if (string.charAt(w) != c) continue;
            ++count;
        }
        return count;
    }

    protected static Parameterable createParameterable(Header header, String hName, boolean isRequest) throws ServletParseException {
        String headerName;
        boolean isNotModifiable;
        AddressImpl.ModifiableRule modifiableRule;
        String whole = header.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating parametrable for [" + hName + "] from [" + whole + "]"));
        }
        String stringHeader = whole.substring(whole.indexOf(":") + 1).trim();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String value = stringHeader;
        String displayName = null;
        if (stringHeader.trim().indexOf("\"") == 0) {
            String displayNameString = stringHeader.substring(1);
            int nextIndexOfDoubleQuote = displayNameString.indexOf("\"");
            displayName = stringHeader.substring(0, nextIndexOfDoubleQuote + 2);
            stringHeader = stringHeader.substring(nextIndexOfDoubleQuote + 2).trim();
        }
        boolean hasLaRaQuotes = false;
        if (stringHeader.trim().indexOf("<") == 0) {
            int indexOfBracket = (stringHeader = stringHeader.substring(1)).indexOf(">");
            if (indexOfBracket != -1) {
                hasLaRaQuotes = true;
            }
            value = stringHeader.substring(0, indexOfBracket);
            String restOfHeader = stringHeader.substring(indexOfBracket + 1);
            if (restOfHeader.length() > 1 && restOfHeader.contains(";")) {
                restOfHeader = restOfHeader.replaceFirst(";", "");
                String[] split = restOfHeader.split(";");
                ArrayList<StringBuffer> resplitListWithQuotes = new ArrayList<StringBuffer>();
                int resplitIndex = 0;
                boolean addToPrevious = false;
                for (int q = 0; q < split.length; ++q) {
                    int countQuotes = SipServletMessageImpl.countChars(split[q], '\"');
                    if (countQuotes % 2 != 0) {
                        if (addToPrevious) {
                            ((StringBuffer)resplitListWithQuotes.get(resplitIndex - 1)).append(";" + split[q]);
                            addToPrevious = false;
                            continue;
                        }
                        resplitListWithQuotes.add(new StringBuffer(split[q]));
                        ++resplitIndex;
                        addToPrevious = true;
                        continue;
                    }
                    if (addToPrevious) {
                        ((StringBuffer)resplitListWithQuotes.get(resplitIndex - 1)).append(";" + split[q]);
                        continue;
                    }
                    resplitListWithQuotes.add(new StringBuffer(split[q]));
                    ++resplitIndex;
                }
                if (addToPrevious) {
                    throw new RuntimeException("Unclosed quote sign in this string " + whole);
                }
                String[] newSplit = new String[resplitListWithQuotes.size()];
                for (int q = 0; q < resplitListWithQuotes.size(); ++q) {
                    newSplit[q] = ((StringBuffer)resplitListWithQuotes.get(q)).toString();
                }
                for (String pair : split = newSplit) {
                    int indexOfEq = pair.indexOf(61);
                    String key = null;
                    String val = null;
                    if (indexOfEq < 0) {
                        key = pair;
                        val = "";
                    } else {
                        key = pair.substring(0, indexOfEq);
                        val = indexOfEq + 1 > pair.length() ? "" : pair.substring(indexOfEq + 1);
                    }
                    paramMap.put(key, val);
                }
            }
        } else if (value.length() > 1 && value.contains(";")) {
            String[] split;
            String parameters = value.substring(value.indexOf(";") + 1);
            value = value.substring(0, value.indexOf(";"));
            for (String pair : split = parameters.split(";")) {
                String[] vals = pair.split("=");
                if (vals.length > 2) {
                    logger.error((Object)("Wrong parameter format, expected value and name, got [" + pair + "]"));
                    throw new ServletParseException("Wrong parameter format, expected value or name[" + pair + "]");
                }
                paramMap.put(vals[0], vals.length == 2 ? vals[1] : "");
            }
        } else if (value.length() > 1 && value.contains(",")) {
            String[] split;
            for (String pair : split = value.split(",")) {
                String[] vals = pair.split("=");
                if (vals.length > 2) {
                    logger.error((Object)("Wrong parameter format, expected value and name, got [" + pair + "]"));
                    throw new ServletParseException("Wrong parameter format, expected value or name[" + pair + "]");
                }
                String paramValue = vals[1];
                if (vals.length < 2) {
                    paramValue = "";
                } else if (vals.length == 2 && vals[1].indexOf(34) == 0 && vals[1].lastIndexOf(34) == vals[1].length() - 1) {
                    paramValue = vals[1].substring(1, vals[1].length() - 1);
                }
                paramMap.put(vals[0], paramValue);
            }
        }
        if (hasLaRaQuotes) {
            value = "<" + value + ">";
        }
        if (displayName != null) {
            value = displayName.concat(value);
        }
        AddressImpl.ModifiableRule modifiableRule2 = modifiableRule = (isNotModifiable = JainSipUtils.SYSTEM_HEADERS.contains(headerName = header.getName())) ? AddressImpl.ModifiableRule.NotModifiable : AddressImpl.ModifiableRule.Modifiable;
        if (headerName.equalsIgnoreCase("From")) {
            modifiableRule = isRequest ? AddressImpl.ModifiableRule.From : AddressImpl.ModifiableRule.NotModifiable;
        }
        if (headerName.equalsIgnoreCase("To")) {
            modifiableRule = isRequest ? AddressImpl.ModifiableRule.To : AddressImpl.ModifiableRule.NotModifiable;
        }
        if (headerName.equalsIgnoreCase("Via")) {
            modifiableRule = isRequest ? AddressImpl.ModifiableRule.Via : AddressImpl.ModifiableRule.NotModifiable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("modifiableRule for [" + hName + "] from [" + whole + "] is " + (Object)((Object)modifiableRule)));
        }
        ParameterableHeaderImpl parameterable = new ParameterableHeaderImpl(header, value, paramMap, modifiableRule);
        return parameterable;
    }

    public static boolean isParameterable(String header) {
        return JainSipUtils.PARAMETERABLE_HEADER_NAMES.contains(header);
    }

    public String getCurrentApplicationName() {
        return this.currentApplicationName;
    }

    public void setCurrentApplicationName(String currentApplicationName) {
        this.currentApplicationName = currentApplicationName;
    }

    public String getLocalAddr() {
        SIPTransaction sipTransaction = (SIPTransaction)this.getTransaction();
        if (sipTransaction != null) {
            return sipTransaction.getHost();
        }
        String transport = JainSipUtils.findTransport(this.message);
        MobicentsExtendedListeningPoint listeningPoint = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
        return listeningPoint.getHost(true);
    }

    public int getLocalPort() {
        SIPTransaction sipTransaction = (SIPTransaction)this.getTransaction();
        if (sipTransaction != null) {
            return sipTransaction.getPort();
        }
        String transport = JainSipUtils.findTransport(this.message);
        MobicentsExtendedListeningPoint listeningPoint = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
        return listeningPoint.getPort();
    }

    protected boolean containsRel100(Message message) {
        ListIterator supportedHeaders;
        ListIterator requireHeaders = message.getHeaders("Require");
        if (requireHeaders != null) {
            while (requireHeaders.hasNext()) {
                if (!REL100_OPTION_TAG.equals(((SIPHeader)requireHeaders.next()).getValue())) continue;
                return true;
            }
        }
        if ((supportedHeaders = message.getHeaders("Supported")) != null) {
            while (supportedHeaders.hasNext()) {
                if (!REL100_OPTION_TAG.equals(((SIPHeader)supportedHeaders.next()).getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void cleanUp();

    protected Map<String, Object> getAttributeMap() {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap<String, Object>();
        }
        return this.attributes;
    }

    protected void setAttributeMap(Map<String, Object> atttributes) {
        this.attributes = atttributes;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int attributesSize;
        this.sipFactoryImpl = (SipFactoryImpl)in.readObject();
        String sessionKeyString = in.readUTF();
        if (sessionKeyString.length() > 0) {
            try {
                this.sessionKey = SessionManagerUtil.parseSipSessionKey(sessionKeyString);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("SIP Sesion Key " + sessionKeyString + " previously serialized could not be reparsed", e);
            }
        }
        if ((attributesSize = in.readInt()) > 0) {
            Object[][] attributesArray = (Object[][])in.readObject();
            this.attributes = new ConcurrentHashMap<String, Object>();
            for (int i = 0; i < attributesSize; ++i) {
                String key = (String)attributesArray[0][i];
                Object value = attributesArray[1][i];
                this.attributes.put(key, value);
            }
        }
        if (in.readBoolean()) {
            this.transactionApplicationData = (TransactionApplicationData)in.readObject();
        }
        this.headerForm = SipServletMessage.HeaderForm.valueOf((String)in.readUTF());
        this.currentApplicationName = in.readUTF();
        if (this.currentApplicationName.equals("")) {
            this.currentApplicationName = null;
        }
        this.isMessageSent = in.readBoolean();
        if (ReplicationStrategy.EarlyDialog == StaticServiceHolder.sipStandardService.getReplicationStrategy()) {
            this.transactionId = in.readUTF();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("readExternal transactionId = " + this.transactionId));
            }
            if (this.transactionId != null) {
                if (this.transactionId.equals("")) {
                    this.transactionId = null;
                } else {
                    this.transactionType = in.readBoolean();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("readExternal transactionType = " + this.transactionType));
                    }
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sipFactoryImpl);
        if (this.sessionKey != null) {
            out.writeUTF(this.sessionKey.toString());
        } else if (null == this.sipSession) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.sipSession.getId());
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            out.writeInt(this.attributes.size());
            Object[][] attributesArray = new Object[2][this.attributes.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                attributesArray[0][i] = entry.getKey();
                attributesArray[1][i] = entry.getValue();
                ++i;
            }
            out.writeObject(attributesArray);
        } else {
            out.writeInt(0);
        }
        if (this.transactionApplicationData != null) {
            out.writeBoolean(true);
            out.writeObject(this.transactionApplicationData);
        } else {
            out.writeBoolean(false);
        }
        out.writeUTF(this.headerForm.toString());
        if (this.currentApplicationName != null) {
            out.writeUTF(this.currentApplicationName);
        } else {
            out.writeUTF("");
        }
        out.writeBoolean(this.isMessageSent);
        if (ReplicationStrategy.EarlyDialog == StaticServiceHolder.sipStandardService.getReplicationStrategy()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("writeExternal transaction = " + this.transaction));
            }
            if (this.transaction == null) {
                out.writeUTF("");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("writeExternal transactionId = " + this.transaction.getBranchId() + " transactionType " + (this.transaction instanceof ServerTransaction)));
                }
                out.writeUTF(this.transaction.getBranchId());
                out.writeBoolean(this.transaction instanceof ServerTransaction);
            }
        }
        out.writeUTF(this.message.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipServletMessageImpl other = (SipServletMessageImpl)obj;
        return !(this.message == null ? other.message != null : !this.message.equals((Object)other.message));
    }

    public void setOrphan(boolean orphan) {
        this.orphan = orphan;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getAppSessionId() {
        return this.appSessionId;
    }

    public void setAppSessionId(String appSessionId) {
        this.appSessionId = appSessionId;
    }

    public boolean isMessageSent() {
        return this.isMessageSent;
    }
}

