/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.address;

import gov.nist.javax.sip.header.ParametersExt;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.sip.address.SipURI;
import javax.sip.address.TelURL;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.HeaderAddress;
import javax.sip.header.Parameters;
import org.mobicents.servlet.sip.address.GenericURIImpl;
import org.mobicents.servlet.sip.address.ParameterableHeaderImpl;
import org.mobicents.servlet.sip.address.ParameterableImpl;
import org.mobicents.servlet.sip.address.RFC2396UrlDecoder;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;

public class AddressImpl
extends ParameterableImpl
implements Address {
    private static final long serialVersionUID = 1L;
    private static final String Q_PARAM_NAME = "q";
    private static final String EXPIRES_PARAM_NAME = "expires";
    private static final String PARAM_SEPARATOR = ";";
    private static final String PARAM_NAME_VALUE_SEPARATOR = "=";
    private javax.sip.address.Address address;

    public javax.sip.address.Address getAddress() {
        return this.address;
    }

    public AddressImpl() {
    }

    public AddressImpl(javax.sip.address.Address address, Map<String, String> parameters, ModifiableRule isModifiable) {
        this.isModifiable = isModifiable;
        this.address = address;
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    public AddressImpl(HeaderAddress header, ModifiableRule modifiable) throws ParseException {
        if (header instanceof Parameters) {
            this.header = (Parameters)header;
        }
        this.address = header.getAddress();
        this.parameters = header instanceof Parameters ? AddressImpl.getParameters((Parameters)header) : new ConcurrentHashMap<String, String>();
        this.isModifiable = modifiable;
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }

    public int getExpires() {
        String expires = this.getParameter(EXPIRES_PARAM_NAME);
        if (expires != null) {
            return Integer.parseInt(expires);
        }
        return ((SipURI)this.address.getURI()).getParameter(EXPIRES_PARAM_NAME) == null ? -1 : Integer.parseInt(((SipURI)this.address.getURI()).getParameter(EXPIRES_PARAM_NAME));
    }

    public float getQ() {
        String q = this.getParameter(Q_PARAM_NAME);
        if (q != null) {
            return Float.parseFloat(q);
        }
        return ((SipURI)this.address.getURI()).getParameter(Q_PARAM_NAME) == null ? -1.0f : Float.parseFloat(((SipURI)this.address.getURI()).getParameter(Q_PARAM_NAME));
    }

    public javax.servlet.sip.URI getURI() {
        URI localUri = this.getAddress().getURI();
        if (localUri instanceof SipURI) {
            return new SipURIImpl((SipURI)localUri, this.isModifiable);
        }
        if (localUri instanceof TelURL) {
            return new TelURLImpl((TelURL)localUri);
        }
        if (localUri instanceof URI) {
            GenericURIImpl uri = new GenericURIImpl(localUri);
            ((Parameterable)uri).setValue(localUri.toString());
            return uri;
        }
        throw new IllegalArgumentException("unsupported operation - unknown scheme");
    }

    public boolean isWildcard() {
        return this.getAddress().isWildcard();
    }

    public void setDisplayName(String name) {
        if (SipServletMessageImpl.isSystemHeader(this.isModifiable)) {
            throw new IllegalStateException("this Address is used in a context where it cannot be modified");
        }
        try {
            this.getAddress().setDisplayName(name);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("illegal name ", e);
        }
    }

    public void setExpires(int seconds) throws IllegalArgumentException {
        URI uri = this.getAddress().getURI();
        if (uri instanceof SipURI) {
            if (seconds == -1) {
                this.removeParameter(EXPIRES_PARAM_NAME);
                return;
            }
        } else {
            throw new IllegalArgumentException("Can only set parameter for Sip URI");
        }
        this.setParameter(EXPIRES_PARAM_NAME, Integer.toString(seconds));
    }

    public void setQ(float q) {
        if ((double)q == -1.0) {
            this.removeParameter(Q_PARAM_NAME);
            return;
        }
        if ((double)q > 1.0 || q < 0.0f) {
            throw new IllegalArgumentException("the new qvalue isn't between 0.0 and 1.0 (inclusive) and isn't -1.0.");
        }
        this.setParameter(Q_PARAM_NAME, Float.toString(q));
    }

    public void setURI(javax.servlet.sip.URI uri) {
        if (SipServletMessageImpl.isSystemHeader(this.isModifiable)) {
            throw new IllegalStateException("this Address is used in a context where it cannot be modified");
        }
        this.getAddress().setURI(((URIImpl)uri).uri);
    }

    @Override
    public Object clone() {
        AddressImpl retval = new AddressImpl();
        retval.address = (javax.sip.address.Address)this.address.clone();
        retval.parameters = ParameterableHeaderImpl.cloneParameters(this.parameters);
        return retval;
    }

    @Override
    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.address.toString());
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                if (this.address.getURI() instanceof Parameters && ((Parameters)this.address.getURI()).getParameter((String)entry.getKey()) != null) continue;
                String value = (String)entry.getValue();
                if (value != null && value.length() > 0) {
                    retval.append(PARAM_SEPARATOR).append((String)entry.getKey()).append(PARAM_NAME_VALUE_SEPARATOR).append(value);
                    continue;
                }
                retval.append(PARAM_SEPARATOR).append((String)entry.getKey());
            }
        }
        return retval.toString();
    }

    public String getValue() {
        return this.toString();
    }

    public void setValue(String value) {
        try {
            ContactHeader contactHeader = (ContactHeader)SipFactoryImpl.headerFactory.createHeader("Contact", value);
            this.address = SipFactoryImpl.addressFactory.createAddress(value);
            this.parameters = AddressImpl.getParameters((Parameters)contactHeader);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal argument", ex);
        }
    }

    public void setAddress(javax.sip.address.Address address) {
        this.address = address;
    }

    @Override
    public void setParameter(String name, String value) {
        super.setParameter(name, value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressImpl other = (AddressImpl)obj;
        if (this.address.getURI() == null ? other.address.getURI() != null : !this.address.getURI().equals(other.address.getURI())) {
            return false;
        }
        if (this.parameters == null) {
            if (other.parameters != null) {
                return false;
            }
        } else {
            for (String pname : this.parameters.keySet()) {
                String p1 = (String)this.parameters.get(pname);
                String p2 = (String)other.parameters.get(pname);
                if (p1 == null || p2 == null || RFC2396UrlDecoder.decode(p1).equalsIgnoreCase(RFC2396UrlDecoder.decode(p2))) continue;
                return false;
            }
        }
        return true;
    }

    public static final Map<String, String> getParameters(Parameters headerParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator parameterNames = headerParams.getParameterNames();
        while (parameterNames.hasNext()) {
            String name = (String)parameterNames.next();
            String value = null;
            value = headerParams instanceof ParametersExt ? ((ParametersExt)headerParams).getParameter(name, false) : headerParams.getParameter(name);
            params.put(name, value);
        }
        return params;
    }

    public static enum ModifiableRule {
        NotModifiable,
        ProxyRecordRouteNotModifiable,
        ContactSystem,
        ContactNotSystem,
        Modifiable,
        From,
        To,
        Via;

    }
}

