/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.lang.reflect.Field;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.timers.ProxyTimerService;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;
import org.mobicents.servlet.sip.utils.NamingThreadFactory;

public class DefaultProxyTimerService
extends ScheduledThreadPoolExecutor
implements ProxyTimerService {
    private static final Logger logger = Logger.getLogger((String)DefaultProxyTimerService.class.getName());
    protected static volatile int numCancelled = 0;
    public static final int SCHEDULER_THREAD_POOL_DEFAULT_SIZE = 4;

    public DefaultProxyTimerService(String applicationName) {
        super(4, new NamingThreadFactory(applicationName + "_sip_default_proxy_timer_service"));
        this.schedulePurgeTaskIfNeeded();
    }

    public DefaultProxyTimerService(int corePoolSize) {
        super(corePoolSize);
        this.schedulePurgeTaskIfNeeded();
    }

    public DefaultProxyTimerService(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.schedulePurgeTaskIfNeeded();
    }

    public DefaultProxyTimerService(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
        this.schedulePurgeTaskIfNeeded();
    }

    public DefaultProxyTimerService(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
        this.schedulePurgeTaskIfNeeded();
    }

    private void schedulePurgeTaskIfNeeded() {
        int purgePeriod = StaticServiceHolder.sipStandardService.getCanceledTimerTasksPurgePeriod();
        if (purgePeriod > 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Purging canceled timer tasks...");
                        }
                        DefaultProxyTimerService.this.purge();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Purging canceled timer tasks completed.");
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"failed to execute purge", (Throwable)e);
                    }
                }
            };
            this.scheduleWithFixedDelay(r, purgePeriod, purgePeriod, TimeUnit.MINUTES);
        }
    }

    public void cancel(TimerTask task) {
        ScheduledFuture future = null;
        Object[] array = super.getQueue().toArray();
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof ScheduledFuture)) continue;
            future = (ScheduledFuture)array[i];
            try {
                Field callableField = future.getClass().getDeclaredField("callable");
                callableField.setAccessible(true);
                Object callable = callableField.get(future);
                callableField.setAccessible(false);
                if (callable == null) continue;
                Field taskField = callable.getClass().getDeclaredField("task");
                taskField.setAccessible(true);
                TimerTask scheduledTask = null;
                if (taskField.get(callable) instanceof TimerTask) {
                    scheduledTask = (TimerTask)taskField.get(callable);
                }
                taskField.setAccessible(false);
                if (scheduledTask == null || !scheduledTask.equals(task)) continue;
                break;
            }
            catch (Exception e) {
                logger.warn((Object)"Couldn't clean the timer from the JVM GC ", (Throwable)e);
            }
        }
        if (future != null) {
            boolean removed = super.remove((Runnable)((Object)future));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("expiration timer on sip proxy task" + task + " removed : " + removed));
            }
            boolean cancelled = future.cancel(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("expiration timer on sip proxy task" + task + " Cancelled : " + cancelled));
            }
            future = null;
            if (++numCancelled % 100 == 0) {
                super.purge();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"expiration timer future is null, thus cannot be Cancelled");
        }
    }

    public boolean isStarted() {
        return super.isTerminated();
    }

    public void schedule(TimerTask task, long delay) {
        super.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        super.shutdownNow();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Stopped timer service " + this));
        }
    }

    public void start() {
        this.prestartAllCoreThreads();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Started timer service " + this));
        }
    }
}

