/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import java.io.Serializable;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.sip.Address;
import javax.sip.Transaction;
import javax.sip.address.Hop;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.message.MobicentsTransactionApplicationData;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;

public class TransactionApplicationData
implements Serializable,
MobicentsTransactionApplicationData {
    private static final long serialVersionUID = 9170581635026591070L;
    private static final Logger logger = Logger.getLogger(TransactionApplicationData.class);
    private ProxyBranchImpl proxyBranch;
    private SipServletMessageImpl sipServletMessage;
    private String method;
    private MobicentsSipSessionKey sipSessionKey;
    private Set<SipServletResponseImpl> sipServletResponses;
    private transient Transaction transaction;
    private transient String initialRemoteHostAddress;
    private transient int initialRemotePort;
    private transient String initialRemoteTransport;
    private transient Address initialPoppedRoute;
    private transient AtomicInteger rseqNumber;
    private transient String appNotDeployed = null;
    private transient boolean noAppReturned = false;
    private transient String modifier = null;
    private transient boolean canceled = false;
    private transient Queue<Hop> hops = null;

    public TransactionApplicationData(SipServletMessageImpl sipServletMessage) {
        this.sipServletMessage = sipServletMessage;
        this.sipServletResponses = null;
    }

    public void setProxyBranch(ProxyBranchImpl proxyBranch) {
        this.proxyBranch = proxyBranch;
    }

    public ProxyBranchImpl getProxyBranch() {
        return this.proxyBranch;
    }

    public SipServletMessageImpl getSipServletMessage() {
        return this.sipServletMessage;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public void addSipServletResponse(SipServletResponseImpl sipServletResponse) {
        if (this.sipServletResponses == null) {
            this.sipServletResponses = new CopyOnWriteArraySet<SipServletResponseImpl>();
        }
        this.sipServletResponses.add(sipServletResponse);
    }

    public Set<SipServletResponseImpl> getSipServletResponses() {
        return this.sipServletResponses;
    }

    public void setInitialRemoteHostAddress(String initialRemoteHostAddress) {
        this.initialRemoteHostAddress = initialRemoteHostAddress;
    }

    public String getInitialRemoteHostAddress() {
        return this.initialRemoteHostAddress;
    }

    public void setInitialRemotePort(int initialRemotePort) {
        this.initialRemotePort = initialRemotePort;
    }

    public int getInitialRemotePort() {
        return this.initialRemotePort;
    }

    public void setInitialRemoteTransport(String initialRemoteTransport) {
        this.initialRemoteTransport = initialRemoteTransport;
    }

    public String getInitialRemoteTransport() {
        return this.initialRemoteTransport;
    }

    public Address getInitialPoppedRoute() {
        return this.initialPoppedRoute;
    }

    public void setInitialPoppedRoute(Address initialPoppedRoute) {
        this.initialPoppedRoute = initialPoppedRoute;
    }

    public AtomicInteger getRseqNumber() {
        if (this.rseqNumber == null) {
            this.rseqNumber = new AtomicInteger(1);
        }
        return this.rseqNumber;
    }

    public void setRseqNumber(AtomicInteger rseqNumber) {
        this.rseqNumber = rseqNumber;
    }

    public void setAppNotDeployed(String appNotDeployed) {
        this.appNotDeployed = appNotDeployed;
    }

    public String getAppNotDeployed() {
        return this.appNotDeployed;
    }

    public void setNoAppReturned(boolean noAppReturned) {
        this.noAppReturned = noAppReturned;
    }

    public boolean isNoAppReturned() {
        return this.noAppReturned;
    }

    public void setSipServletMessage(SipServletMessageImpl message) {
        this.sipServletMessage = message;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getModifier() {
        return this.modifier;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void cleanUp() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"cleaning up the application data");
        }
        this.initialPoppedRoute = null;
        this.proxyBranch = null;
        if (this.sipServletResponses != null) {
            this.sipServletResponses.clear();
            this.sipServletResponses = null;
        }
        this.transaction = null;
        this.rseqNumber = null;
        if (this.hops != null && this.hops.size() <= 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"cleaning up tx app data hops");
            }
            this.hops.clear();
            this.hops = null;
        }
    }

    public void cleanUpMessage() {
        if (this.sipServletMessage != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"cleaning up the application data from the sipservletmessage");
            }
            this.sipServletMessage.cleanUp();
            if (this.sipServletMessage instanceof SipServletRequestImpl) {
                ((SipServletRequestImpl)this.sipServletMessage).cleanUpLastResponses();
            }
            this.sipSessionKey = this.sipServletMessage.getSipSessionKey();
            this.method = this.sipServletMessage.getMethod();
            this.sipServletMessage = null;
        }
    }

    public void setHops(Queue<Hop> hops) {
        this.hops = hops;
    }

    public Queue<Hop> getHops() {
        return this.hops;
    }

    public MobicentsSipSessionKey getSipSessionKey() {
        if (this.sipServletMessage != null) {
            return this.sipServletMessage.getSipSessionKey();
        }
        return this.sipSessionKey;
    }

    public String getMethod() {
        if (this.sipServletMessage != null) {
            return this.sipServletMessage.getMethod();
        }
        return this.method;
    }
}

