/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.proxy;

import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.MessageExt;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.TelURL;
import javax.sip.header.ContactHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.ha.javax.sip.ReplicationStrategy;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxyBranch;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.timers.ProxyTimerService;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyTerminationInfo;
import org.mobicents.servlet.sip.proxy.ProxyUtils;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class ProxyImpl
implements MobicentsProxy,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ProxyImpl.class);
    private SipServletRequestImpl originalRequest;
    private transient SipServletResponseImpl bestResponse;
    private transient ProxyBranchImpl bestBranch;
    private boolean recurse = true;
    private int proxyTimeout;
    private int proxy1xxTimeout;
    private int seqSearchTimeout;
    private boolean supervised = true;
    private boolean recordRoutingEnabled;
    private boolean appSpecifiedRecordRoutingEnabled = false;
    private boolean parallel = true;
    private boolean addToPath;
    private boolean sipOutboundSupport;
    private int bestResponseSent = -1;
    protected transient SipURIImpl pathURI;
    protected transient String recordRouteURIString;
    protected transient SipURI recordRouteURI;
    private transient SipURI outboundInterface;
    private transient SipFactoryImpl sipFactoryImpl;
    private boolean isNoCancel;
    private final transient Map<String, TransactionApplicationData> transactionMap = new ConcurrentHashMap<String, TransactionApplicationData>();
    private transient Map<URI, ProxyBranchImpl> proxyBranches;
    private boolean started;
    private boolean ackReceived = false;
    private ProxyBranchImpl finalBranchForSubsequentRequests;
    private String previousNode;
    private String callerFromTag;
    private transient ProxyTimerService proxyTimerService;
    private boolean storeTerminationInfo = false;
    private ProxyTerminationInfo terminationInfo;

    public ProxyImpl() {
    }

    public ProxyImpl(SipServletRequestImpl request, SipFactoryImpl sipFactoryImpl) {
        this.proxyTimerService = request.getSipApplicationSession(false).getSipContext().getProxyTimerService();
        this.originalRequest = request;
        this.sipFactoryImpl = sipFactoryImpl;
        this.proxyBranches = new LinkedHashMap<URI, ProxyBranchImpl>();
        this.proxyTimeout = 180;
        this.proxy1xxTimeout = -1;
        String outboundInterfaceStringified = ((MobicentsSipSession)request.getSession()).getOutboundInterface();
        if (outboundInterfaceStringified != null) {
            try {
                this.outboundInterface = (SipURI)sipFactoryImpl.createURI(outboundInterfaceStringified);
            }
            catch (ServletParseException e) {
                throw new IllegalArgumentException("couldn't parse the outbound interface " + this.outboundInterface, e);
            }
        }
        this.callerFromTag = ((MessageExt)request.getMessage()).getFromHeader().getTag();
        this.previousNode = this.extractPreviousNodeFromRequest(request);
        this.putTransaction(this.originalRequest);
    }

    public void putTransaction(SipServletRequestImpl request) {
        String txId = ((ViaHeader)request.getMessage().getHeader("Via")).getBranch();
        TransactionApplicationData txData = request.getTransactionApplicationData();
        if (txData != null && this.transactionMap.put(txId, txData) == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Transaction " + txId + " added to proxy."));
        }
    }

    public void removeTransaction(String txId) {
        if (this.transactionMap.remove(txId) != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Transaction " + txId + " removed from proxy."));
        }
        this.checkAndCleanProxy();
    }

    public void checkAndCleanProxy() {
        if (this.transactionMap.size() == 0 && this.originalRequest != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cleaning Proxy to optimize perf " + this));
            }
            this.originalRequest.cleanUp();
            this.originalRequest.cleanUpLastResponses();
            this.originalRequest = null;
            if (this.recordRouteURI != null) {
                this.recordRouteURIString = this.recordRouteURI.toString();
                this.recordRouteURI = null;
            }
            if (this.finalBranchForSubsequentRequests != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cleaning proxy finalBranchForSubsequentRequests to optimize perf " + this));
                }
                this.finalBranchForSubsequentRequests.cancelTimer();
                this.finalBranchForSubsequentRequests.setResponse(null);
                this.finalBranchForSubsequentRequests.setOriginalRequest(null);
                this.finalBranchForSubsequentRequests.setOutgoingRequest(null);
            }
        }
    }

    private String extractPreviousNodeFromRequest(SipServletRequestImpl request) {
        ContactHeader contact = (ContactHeader)request.getMessage().getHeader("Contact");
        if (contact != null) {
            return ((javax.sip.address.SipURI)contact.getAddress().getURI()).toString();
        }
        try {
            RecordRouteHeader rrh = (RecordRouteHeader)request.getMessage().getHeader("Record-Route");
            if (rrh != null) {
                return ((javax.sip.address.SipURI)rrh.getAddress().getURI()).toString();
            }
            ListIterator viaHeaders = request.getMessage().getHeaders("Via");
            ViaHeader lastVia = null;
            while (viaHeaders.hasNext()) {
                lastVia = (ViaHeader)viaHeaders.next();
            }
            String uriString = ((Via)lastVia).getSentBy().toString();
            SipURI uri = this.sipFactoryImpl.createSipURI(null, uriString);
            if (lastVia.getTransport() != null) {
                uri.setTransportParam(lastVia.getTransport());
            } else {
                uri.setTransportParam("udp");
            }
            return uri.toString();
        }
        catch (Exception e) {
            logger.error((Object)"Failed parsing previous address ", (Throwable)e);
            return null;
        }
    }

    public void cancel() {
        if (this.ackReceived) {
            throw new IllegalStateException("There has been an ACK received. Can not cancel more brnaches, the INVITE tx has finished.");
        }
        this.cancelAllExcept(null, null, null, null, true);
    }

    public void cancel(String[] protocol, int[] reasonCode, String[] reasonText) {
        if (this.ackReceived) {
            throw new IllegalStateException("There has been an ACK received. Can not cancel more brnaches, the INVITE tx has finished.");
        }
        this.cancelAllExcept(null, protocol, reasonCode, reasonText, true);
    }

    public void cancelAllExcept(ProxyBranch except, String[] protocol, int[] reasonCode, String[] reasonText, boolean throwExceptionIfCannotCancel) {
        if (logger.isDebugEnabled()) {
            if (except == null) {
                logger.debug((Object)"Cancelling all Branches");
            } else {
                logger.debug((Object)("Cancelling all Branches except " + except + " with outgoing resquest " + except.getRequest()));
            }
        }
        for (MobicentsProxyBranch mobicentsProxyBranch : this.proxyBranches.values()) {
            if (mobicentsProxyBranch.equals(except)) continue;
            try {
                mobicentsProxyBranch.cancel(protocol, reasonCode, reasonText);
            }
            catch (IllegalStateException e) {
                if (throwExceptionIfCannotCancel) {
                    throw e;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Problem cancelling proxy branch " + mobicentsProxyBranch.getTargetURI() + " lastResponse " + mobicentsProxyBranch.getResponse() + " isCancelled " + mobicentsProxyBranch.isCanceled() + " isStarted " + mobicentsProxyBranch.isStarted() + " isTimedOut " + mobicentsProxyBranch.isTimedOut()));
            }
        }
    }

    public List<ProxyBranch> createProxyBranches(List<? extends URI> targets) {
        ArrayList<ProxyBranch> list = new ArrayList<ProxyBranch>();
        for (URI uRI : targets) {
            if (uRI == null) {
                throw new NullPointerException("URI can't be null");
            }
            if (!JainSipUtils.checkScheme(uRI.toString())) {
                throw new IllegalArgumentException("Scheme " + uRI.getScheme() + " is not supported");
            }
            ProxyBranchImpl branch = new ProxyBranchImpl(uRI, this);
            branch.setRecordRoute(this.recordRoutingEnabled);
            branch.setRecurse(this.recurse);
            list.add((ProxyBranch)branch);
            this.proxyBranches.put(uRI, branch);
        }
        return list;
    }

    public boolean getAddToPath() {
        return this.addToPath;
    }

    public SipServletRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public boolean getParallel() {
        return this.parallel;
    }

    public SipURI getPathURI() {
        if (!this.addToPath) {
            throw new IllegalStateException("You must setAddToPath(true) before getting URI");
        }
        return this.pathURI;
    }

    public ProxyBranch getProxyBranch(URI uri) {
        return (ProxyBranch)this.proxyBranches.get(uri);
    }

    public List<ProxyBranch> getProxyBranches() {
        return new ArrayList<ProxyBranchImpl>(this.proxyBranches.values());
    }

    public Map<URI, ProxyBranchImpl> getProxyBranchesMap() {
        return this.proxyBranches;
    }

    public MobicentsProxyBranch getFinalBranchForSubsequentRequests() {
        return this.finalBranchForSubsequentRequests;
    }

    public int getProxyTimeout() {
        return this.proxyTimeout;
    }

    public boolean getRecordRoute() {
        return this.recordRoutingEnabled;
    }

    public SipURI getRecordRouteURI() {
        if (!this.recordRoutingEnabled) {
            throw new IllegalStateException("You must setRecordRoute(true) before getting URI");
        }
        if (this.recordRouteURI == null && this.recordRouteURIString != null) {
            try {
                this.recordRouteURI = new SipURIImpl(((SipURIImpl)this.sipFactoryImpl.createURI(this.recordRouteURIString)).getSipURI(), AddressImpl.ModifiableRule.ProxyRecordRouteNotModifiable);
                this.recordRouteURIString = null;
            }
            catch (ServletParseException e) {
                logger.error((Object)("A problem occured while setting the target URI while proxying a request " + this.recordRouteURIString), (Throwable)e);
                return null;
            }
        }
        return this.recordRouteURI;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public int getSequentialSearchTimeout() {
        return this.seqSearchTimeout;
    }

    public boolean getStateful() {
        return true;
    }

    public boolean getSupervised() {
        return this.supervised;
    }

    public void proxyTo(List<? extends URI> uris) {
        for (URI uRI : uris) {
            if (uRI == null) {
                throw new NullPointerException("URI can't be null");
            }
            if (!JainSipUtils.checkScheme(uRI.toString())) {
                throw new IllegalArgumentException("Scheme " + uRI.getScheme() + " is not supported");
            }
            ProxyBranchImpl branch = new ProxyBranchImpl(uRI, this);
            branch.setRecordRoute(this.recordRoutingEnabled);
            branch.setRecurse(this.recurse);
            this.proxyBranches.put(uRI, branch);
        }
        this.startProxy();
    }

    public void proxyTo(URI uri) {
        RouteHeader routeHeader;
        if (uri == null) {
            throw new NullPointerException("URI can't be null");
        }
        if (!JainSipUtils.checkScheme(uri.toString()) && ((routeHeader = (RouteHeader)this.originalRequest.getMessage().getHeader("Route")) == null || routeHeader != null && !JainSipUtils.checkScheme(routeHeader.getAddress().getURI().toString()))) {
            throw new IllegalArgumentException("Scheme " + uri.getScheme() + " is not supported");
        }
        ProxyBranchImpl branch = new ProxyBranchImpl(uri, this);
        branch.setRecordRoute(this.recordRoutingEnabled);
        branch.setRecurse(this.recurse);
        this.proxyBranches.put(uri, branch);
        this.startProxy();
    }

    public void setAddToPath(boolean p) {
        if (this.started) {
            throw new IllegalStateException("Cannot set a record route on an already started proxy");
        }
        if (this.pathURI == null) {
            this.pathURI = new SipURIImpl(JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), null), AddressImpl.ModifiableRule.Modifiable);
            this.pathURI.setLrParam(true);
            this.pathURI.setIsModifiable(AddressImpl.ModifiableRule.NotModifiable);
        }
        this.addToPath = p;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setProxyTimeout(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Negative or zero timeout not allowed");
        }
        this.proxyTimeout = seconds;
        for (ProxyBranchImpl proxyBranch : this.proxyBranches.values()) {
            boolean inactive = proxyBranch.isCanceled() || proxyBranch.isTimedOut();
            if (inactive) continue;
            proxyBranch.setProxyBranchTimeout(seconds);
        }
    }

    public void setRecordRoute(boolean rr) {
        if (this.started) {
            throw new IllegalStateException("Cannot set a record route on an already started proxy");
        }
        if (rr) {
            javax.sip.address.SipURI flowUri;
            Message message = null;
            if (this.originalRequest != null) {
                message = this.originalRequest.getMessage();
            }
            if ((flowUri = this.originalRequest.getSipSession().getFlow()) != null) {
                this.recordRouteURIString = flowUri.toString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using Session Flow URI as record route URI " + this.recordRouteURIString));
                }
            } else {
                this.recordRouteURIString = JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), message).toString();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Record routing enabled for proxy, Record Route used will be : " + this.recordRouteURIString));
            }
        }
        this.recordRoutingEnabled = rr;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setSequentialSearchTimeout(int seconds) {
        this.seqSearchTimeout = seconds;
    }

    public void setStateful(boolean stateful) {
    }

    public void setSupervised(boolean supervised) {
        this.supervised = supervised;
    }

    public void startProxy() {
        if (this.ackReceived) {
            throw new IllegalStateException("Can't start. ACK has been received.");
        }
        if (!this.originalRequest.isInitial()) {
            throw new IllegalStateException("Applications should not attempt to proxy subsequent requests. Proxying the initial request is sufficient to carry all subsequent requests through the same path.");
        }
        if (this.originalRequest.getMethod().equals("INVITE") && !this.started) {
            TransactionState transactionState = null;
            if (this.originalRequest.getTransaction() != null) {
                transactionState = this.originalRequest.getTransaction().getState();
            }
            if (transactionState == null || transactionState == TransactionState.TRYING) {
                if (this.originalRequest.getTransaction().getState() == null) {
                    logger.info((Object)"Sending 100 Trying to the source");
                }
                SipServletResponse sipServletResponse = this.originalRequest.createResponse(100);
                try {
                    sipServletResponse.send();
                }
                catch (IOException e) {
                    logger.error((Object)"Cannot send the 100 Trying", (Throwable)e);
                }
            }
        }
        this.started = true;
        if (this.parallel) {
            for (MobicentsProxyBranch mobicentsProxyBranch : this.proxyBranches.values()) {
                if (mobicentsProxyBranch.isStarted()) continue;
                mobicentsProxyBranch.start();
            }
        } else {
            this.startNextUntriedBranch();
        }
    }

    public SipURI getOutboundInterface() {
        return this.outboundInterface;
    }

    public void onFinalResponse(ProxyBranchImpl branch) throws DispatcherException {
        SipServletResponseImpl response = (SipServletResponseImpl)branch.getResponse();
        int status = response.getStatus();
        if (!this.isNoCancel && response.getTransaction() != null && this.getParallel() && (status >= 200 && status < 300 || status >= 600 && status < 700)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cancelling all other branches in this proxy");
            }
            this.cancelAllExcept((ProxyBranch)branch, null, null, null, false);
        }
        if (status >= 300 && status < 400 && this.recurse) {
            ListIterator headers = response.getMessage().getHeaders("Contact");
            while (headers.hasNext()) {
                ContactHeader contactHeader = (ContactHeader)headers.next();
                javax.sip.address.URI addressURI = contactHeader.getAddress().getURI();
                URIImpl contactURI = null;
                if (addressURI instanceof javax.sip.address.SipURI) {
                    contactURI = new SipURIImpl((javax.sip.address.SipURI)addressURI, AddressImpl.ModifiableRule.NotModifiable);
                } else if (addressURI instanceof TelURL) {
                    contactURI = new TelURLImpl((TelURL)addressURI);
                }
                ProxyBranchImpl recurseBranch = new ProxyBranchImpl(contactURI, this);
                recurseBranch.setRecordRoute(this.recordRoutingEnabled);
                recurseBranch.setRecurse(this.recurse);
                this.proxyBranches.put(contactURI, recurseBranch);
                branch.addRecursedBranch(branch);
                if (!this.parallel) continue;
                recurseBranch.start();
            }
        }
        if (this.bestResponse == null || this.bestResponse.getStatus() > status) {
            if (this.bestResponse != null) {
                if (status < 400) {
                    this.bestResponse = response;
                    this.bestBranch = branch;
                }
            } else {
                this.bestResponse = response;
                this.bestBranch = branch;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Best response so far is " + this.bestResponse));
        }
        if (this.parallel && this.allResponsesHaveArrived()) {
            this.finalBranchForSubsequentRequests = this.bestBranch;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"All responses have arrived, sending final response for parallel proxy");
            }
            this.sendFinalResponse(this.bestResponse, this.bestBranch);
        } else if (this.parallel && this.originalRequest != null && this.originalRequest.getMethod().equalsIgnoreCase("INVITE") && status >= 200 && status < 300) {
            this.finalBranchForSubsequentRequests = this.bestBranch;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"not all responses have arrived, but sending 2xx final response for parallel proxy");
            }
            this.sendFinalResponse(this.bestResponse, this.bestBranch);
        } else if (!this.parallel) {
            int bestResponseStatus = this.bestResponse.getStatus();
            if (bestResponseStatus >= 200 && bestResponseStatus < 300) {
                this.finalBranchForSubsequentRequests = this.bestBranch;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Sending final response for sequential proxy");
                }
                this.sendFinalResponse(this.bestResponse, this.bestBranch);
            } else if (this.allResponsesHaveArrived()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"All responses have arrived for sequential proxy and we are sending the best one");
                }
                this.sendFinalResponse(this.bestResponse, this.bestBranch);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Trying new branch in proxy");
                }
                this.startNextUntriedBranch();
            }
        }
    }

    public void onBranchTimeOut(ProxyBranchImpl branch) throws DispatcherException {
        if (this.bestBranch == null) {
            this.bestBranch = branch;
        }
        if (this.allResponsesHaveArrived()) {
            this.sendFinalResponse(this.bestResponse, this.bestBranch);
        } else if (!this.parallel) {
            branch.cancel();
            this.startNextUntriedBranch();
            branch.onBranchTerminated();
        }
    }

    public void startNextUntriedBranch() {
        if (this.parallel) {
            throw new IllegalStateException("This method is only for sequantial proxying");
        }
        for (MobicentsProxyBranch mobicentsProxyBranch : this.proxyBranches.values()) {
            if (mobicentsProxyBranch.isStarted() || mobicentsProxyBranch.isCanceled()) continue;
            mobicentsProxyBranch.start();
            return;
        }
    }

    public boolean allResponsesHaveArrived() {
        for (MobicentsProxyBranch mobicentsProxyBranch : this.proxyBranches.values()) {
            SipServletResponse response = mobicentsProxyBranch.getResponse();
            if (!mobicentsProxyBranch.isStarted() && !mobicentsProxyBranch.isCanceled()) {
                return false;
            }
            if (!mobicentsProxyBranch.isStarted() || mobicentsProxyBranch.isTimedOut() || (this.parallel || mobicentsProxyBranch.isCanceled()) && !this.parallel || response != null && response.getStatus() >= 200) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void sendFinalResponse(MobicentsSipServletResponse response, ProxyBranchImpl proxyBranch) throws DispatcherException {
        SipServletResponseImpl proxiedResponse;
        block36: {
            int bestResponseStatus;
            block35: {
                if (proxyBranch.isTimedOut()) {
                    try {
                        MobicentsSipServletResponse timeoutResponse = (MobicentsSipServletResponse)this.originalRequest.createResponse(408);
                        timeoutResponse.setProxyBranch((MobicentsProxyBranch)proxyBranch);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Proxy branch has timed out");
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"All responses have arrived, sending final response for parallel proxy");
                        }
                        try {
                            MessageDispatcher.callServlet(timeoutResponse);
                        }
                        catch (ServletException e) {
                            throw new DispatcherException("Unexpected servlet exception while processing the response : " + response, (Throwable)e);
                        }
                        catch (IOException e) {
                            throw new DispatcherException("Unexpected io exception while processing the response : " + response, (Throwable)e);
                        }
                        catch (Throwable e) {
                            throw new DispatcherException("Unexpected exception while processing response : " + response, e);
                        }
                        timeoutResponse.send();
                        this.bestResponseSent = 408;
                        return;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to send a timeout response", e);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Proxy branch has NOT timed out");
                }
                if (this.supervised) {
                    try {
                        response.setBranchResponse(false);
                        MessageDispatcher.callServlet(response);
                    }
                    catch (ServletException e) {
                        throw new DispatcherException("Unexpected servlet exception while processing the response : " + response, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new DispatcherException("Unexpected io exception while processing the response : " + response, (Throwable)e);
                    }
                    catch (Throwable e) {
                        throw new DispatcherException("Unexpected exception while processing response : " + response, e);
                    }
                }
                bestResponseStatus = response.getStatus();
                if (!this.parallel) break block35;
                if (this.allResponsesHaveArrived()) break block36;
                if (this.originalRequest != null && this.originalRequest.getMethod().equalsIgnoreCase("INVITE") && bestResponseStatus >= 200 && bestResponseStatus < 300) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"This is a 2XX to an INVITE, it has to be forwarded upstream");
                    }
                    break block36;
                } else {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug((Object)"The application has started new branches so we are waiting for responses on those");
                    return;
                }
            }
            if (!(bestResponseStatus >= 200 && bestResponseStatus < 300 || this.allResponsesHaveArrived())) {
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)"The application has started new branches so we are waiting for responses on those");
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"All responses have arrived, sending final response for parallel proxy");
        }
        if ((proxiedResponse = ProxyUtils.createProxiedResponse(response, proxyBranch)) == null || proxiedResponse.getMessage() == null) {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)"Response was dropped because getProxyUtils().createProxiedResponse(response, proxyBranch) returned null");
            return;
        }
        try {
            String branch = ((Via)proxiedResponse.getMessage().getHeader("Via")).getBranch();
            Transaction transaction = null;
            List<ProxyBranchImpl.TransactionRequest> list = proxyBranch.ongoingTransactions;
            // MONITORENTER : list
            for (ProxyBranchImpl.TransactionRequest tr : proxyBranch.ongoingTransactions) {
                if (!tr.branchId.equals(branch)) continue;
                transaction = tr.request.getTransaction();
                proxiedResponse.setTransaction(transaction);
                proxiedResponse.setOriginalRequest(tr.request);
                break;
            }
            // MONITOREXIT : list
            if (transaction != null && !transaction.getState().equals((Object)TransactionState.COMPLETED) && !transaction.getState().equals((Object)TransactionState.TERMINATED)) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sending out proxied final response with existing transaction " + proxiedResponse));
                    }
                    proxiedResponse.send();
                    this.bestResponseSent = proxiedResponse.getStatus();
                    this.proxyBranches.clear();
                    this.originalRequest = null;
                    if (!this.storeTerminationInfo) return;
                    if (!proxiedResponse.getRequest().isInitial()) return;
                    if (this.getRecordRouteURI() == null) return;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("storing termination Info for request " + proxiedResponse.getRequest()));
                    }
                    this.terminationInfo = new ProxyTerminationInfo(proxiedResponse, this.getRecordRouteURI(), this);
                    this.terminationInfo.setCallerCSeq(((MessageExt)proxiedResponse.getRequest()).getCSeqHeader().getSeqNumber());
                    return;
                }
                catch (Exception e) {
                    logger.error((Object)"A problem occured while proxying the final response", (Throwable)e);
                    return;
                }
            }
            Message message = proxiedResponse.getMessage();
            String transport = JainSipUtils.findTransport(message);
            SipProvider sipProvider = this.getSipFactoryImpl().getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending out proxied final response retransmission " + proxiedResponse));
                }
                sipProvider.sendResponse((Response)message);
                return;
            }
            catch (SipException e) {
                logger.error((Object)"A problem occured while proxying the final response retransmission", (Throwable)e);
                return;
            }
        }
        finally {
            this.bestBranch = null;
            this.bestResponse = null;
        }
    }

    public SipServletResponseImpl getBestResponse() {
        return this.bestResponse;
    }

    public void setOriginalRequest(MobicentsSipServletRequest originalRequest) {
        if (this.storeTerminationInfo) {
            if (((MessageExt)originalRequest.getMessage()).getFromHeader().getTag().equals(this.callerFromTag)) {
                this.terminationInfo.setCallerCSeq(((MessageExt)originalRequest.getMessage()).getCSeqHeader().getSeqNumber());
            } else {
                this.terminationInfo.setCalleeCSeq(((MessageExt)originalRequest.getMessage()).getCSeqHeader().getSeqNumber());
            }
        }
        this.originalRequest = (SipServletRequestImpl)originalRequest;
    }

    public boolean getNoCancel() {
        return this.isNoCancel;
    }

    public void setNoCancel(boolean isNoCancel) {
        this.isNoCancel = isNoCancel;
    }

    public SipFactoryImpl getSipFactoryImpl() {
        return this.sipFactoryImpl;
    }

    public void setMobicentsSipFactory(MobicentsSipFactory sipFactoryImpl) {
        this.sipFactoryImpl = (SipFactoryImpl)sipFactoryImpl;
    }

    public void setOutboundInterface(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        String address = inetAddress.getHostAddress();
        List list = this.sipFactoryImpl.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + inetAddress.getHostAddress() + " not found");
        }
        this.outboundInterface = networkInterface;
    }

    public void setOutboundInterface(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        String address = inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        List list = this.sipFactoryImpl.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + address + " not found");
        }
        this.outboundInterface = networkInterface;
    }

    public void setOutboundInterface(SipURI outboundInterface) {
        if (outboundInterface == null) {
            throw new NullPointerException("outbound Interface param shouldn't be null");
        }
        List list = this.sipFactoryImpl.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.equals((Object)outboundInterface)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + outboundInterface + " not found");
        }
        this.outboundInterface = networkInterface;
    }

    public void setAckReceived(boolean received) {
        this.ackReceived = received;
    }

    public boolean getAckReceived() {
        return this.ackReceived;
    }

    public String getPreviousNode() {
        return this.previousNode;
    }

    public String getCallerFromTag() {
        return this.callerFromTag;
    }

    public void setCallerFromTag(String initiatorFromTag) {
        this.callerFromTag = initiatorFromTag;
    }

    public Map<String, TransactionApplicationData> getTransactionMap() {
        return this.transactionMap;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (ReplicationStrategy.EarlyDialog == StaticServiceHolder.sipStandardService.getReplicationStrategy() && in.readBoolean()) {
            this.originalRequest = (SipServletRequestImpl)in.readObject();
        }
        this.recurse = in.readBoolean();
        this.proxyTimeout = in.readInt();
        this.seqSearchTimeout = in.readInt();
        this.supervised = in.readBoolean();
        this.recordRoutingEnabled = in.readBoolean();
        this.parallel = in.readBoolean();
        this.addToPath = in.readBoolean();
        this.isNoCancel = in.readBoolean();
        this.started = in.readBoolean();
        this.ackReceived = in.readBoolean();
        this.finalBranchForSubsequentRequests = (ProxyBranchImpl)in.readObject();
        if (this.finalBranchForSubsequentRequests != null) {
            this.finalBranchForSubsequentRequests.setProxy(this);
        }
        this.previousNode = in.readUTF();
        this.callerFromTag = in.readUTF();
        this.storeTerminationInfo = in.readBoolean();
        if (this.storeTerminationInfo) {
            this.terminationInfo = (ProxyTerminationInfo)in.readObject();
            this.terminationInfo.setProxy(this);
        }
        this.proxyBranches = new LinkedHashMap<URI, ProxyBranchImpl>();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (ReplicationStrategy.EarlyDialog == StaticServiceHolder.sipStandardService.getReplicationStrategy()) {
            if (this.originalRequest != null && this.originalRequest.getMethod().equalsIgnoreCase("INVITE")) {
                out.writeBoolean(true);
                out.writeObject(this.originalRequest);
            } else {
                out.writeBoolean(false);
            }
        }
        out.writeBoolean(this.recurse);
        out.writeInt(this.proxyTimeout);
        out.writeInt(this.seqSearchTimeout);
        out.writeBoolean(this.supervised);
        out.writeBoolean(this.recordRoutingEnabled);
        out.writeBoolean(this.parallel);
        out.writeBoolean(this.addToPath);
        out.writeBoolean(this.isNoCancel);
        out.writeBoolean(this.started);
        out.writeBoolean(this.ackReceived);
        out.writeObject(this.finalBranchForSubsequentRequests);
        out.writeUTF(this.previousNode);
        out.writeUTF(this.callerFromTag);
        out.writeBoolean(this.storeTerminationInfo);
        if (this.storeTerminationInfo) {
            out.writeObject(this.terminationInfo);
        }
    }

    public int getProxy1xxTimeout() {
        return this.proxy1xxTimeout;
    }

    public void setProxy1xxTimeout(int timeout) {
        this.proxy1xxTimeout = timeout;
    }

    public ProxyTimerService getProxyTimerService() {
        return this.proxyTimerService;
    }

    public void storeTerminationInformation(boolean store) throws IllegalStateException {
        if (null != this.finalBranchForSubsequentRequests) {
            throw new IllegalStateException("Proxy has been established.");
        }
        this.storeTerminationInfo = store;
    }

    public void terminateSession(SipSession session, int calleeResponseCode, String calleeResponseText, int callerResponseCode, String callerResponseText) throws IllegalStateException, IOException {
        if (null == this.finalBranchForSubsequentRequests) {
            throw new IllegalStateException("Proxy has not yet been established. Before final response use cancel.");
        }
        if (!this.storeTerminationInfo || this.terminationInfo == null) {
            logger.error((Object)("storeTerminationInfo = " + this.storeTerminationInfo));
            if (this.terminationInfo == null) {
                logger.error((Object)"terminationInfo = null");
            }
            throw new IllegalStateException("No termination information stored.Call storeTerminationInformation before final response arrives.");
        }
        this.terminationInfo.terminate(session, calleeResponseCode, calleeResponseText, callerResponseCode, callerResponseText);
    }

    public boolean isTerminationSent() {
        if (this.terminationInfo == null) {
            return false;
        }
        return this.terminationInfo.isTerminationSent();
    }

    public int getBestResponseSent() {
        return this.bestResponseSent;
    }

    public boolean getSipOutboundSupport() {
        return this.sipOutboundSupport;
    }

    public void setSipOutboundSupport(boolean sipOutboundSupport) {
        this.sipOutboundSupport = sipOutboundSupport;
    }

    public void setRecordRouteURI(SipURI uri) {
        this.recordRouteURI = uri;
        this.recordRouteURIString = null;
        this.appSpecifiedRecordRoutingEnabled = true;
    }

    public boolean isAppSpecifiedRecordRoutingEnabled() {
        return this.appSpecifiedRecordRoutingEnabled;
    }
}

