/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipApplicationSessionAsynchronousWork;
import org.mobicents.javax.servlet.sip.SipSessionAsynchronousWork;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionsUtil;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionAsyncTask;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionAsyncTask;
import org.mobicents.servlet.sip.core.session.SipSessionKey;

public class SipSessionsUtilImpl
implements MobicentsSipSessionsUtil,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SipSessionsUtilImpl.class);
    private transient SipContext sipContext;
    private transient ConcurrentHashMap<MobicentsSipSessionKey, MobicentsSipSession> joinSession;
    private transient ConcurrentHashMap<MobicentsSipSessionKey, MobicentsSipSession> replacesSession;
    private ConcurrentHashMap<MobicentsSipApplicationSessionKey, MobicentsSipApplicationSessionKey> joinApplicationSession;
    private ConcurrentHashMap<MobicentsSipApplicationSessionKey, MobicentsSipApplicationSessionKey> replacesApplicationSession;

    public SipSessionsUtilImpl(SipContext sipContext) {
        this.sipContext = sipContext;
        this.joinSession = new ConcurrentHashMap();
        this.replacesSession = new ConcurrentHashMap();
        this.joinApplicationSession = new ConcurrentHashMap();
        this.replacesApplicationSession = new ConcurrentHashMap();
    }

    public SipApplicationSession getApplicationSessionById(String applicationSessionId) {
        return this.getApplicationSessionById(applicationSessionId, true);
    }

    public SipApplicationSession getApplicationSessionById(String applicationSessionId, boolean isContainerManaged) {
        SipApplicationSessionKey applicationSessionKey;
        if (applicationSessionId == null) {
            throw new NullPointerException("the given id is null !");
        }
        try {
            applicationSessionKey = SessionManagerUtil.parseSipApplicationSessionKey(applicationSessionId);
        }
        catch (ParseException e) {
            logger.error((Object)("the given application session id : " + applicationSessionId + " couldn't be parsed correctly "), (Throwable)e);
            return null;
        }
        if (applicationSessionKey.getApplicationName().equals(this.sipContext.getApplicationName())) {
            MobicentsSipApplicationSession sipApplicationSession = this.sipContext.getSipManager().getSipApplicationSession((MobicentsSipApplicationSessionKey)applicationSessionKey, false);
            if (sipApplicationSession == null) {
                return null;
            }
            this.sipContext.enterSipApp(sipApplicationSession, null, true, isContainerManaged);
            return sipApplicationSession.getFacade();
        }
        logger.warn((Object)("the given application session id : " + applicationSessionId + " tried to be retrieved from incorret application " + this.sipContext.getApplicationName()));
        return null;
    }

    public SipApplicationSession getApplicationSessionByKey(String applicationSessionKey, boolean create) {
        return this.getApplicationSessionByKey(applicationSessionKey, create, true);
    }

    public SipApplicationSession getApplicationSessionByKey(String applicationSessionKey, boolean create, boolean isContainerManaged) {
        if (applicationSessionKey == null) {
            throw new NullPointerException("the given key is null !");
        }
        SipApplicationSessionKey sipApplicationSessionKey = new SipApplicationSessionKey(null, this.sipContext.getApplicationName(), applicationSessionKey);
        MobicentsSipApplicationSession sipApplicationSession = this.sipContext.getSipManager().getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, create);
        if (sipApplicationSession == null) {
            return null;
        }
        this.sipContext.enterSipApp(sipApplicationSession, null, true, isContainerManaged);
        return sipApplicationSession.getFacade();
    }

    public SipSession getCorrespondingSipSession(SipSession sipSession, String headerName) {
        MobicentsSipSession correspondingSipSession = null;
        if (headerName.equalsIgnoreCase("Join")) {
            correspondingSipSession = this.joinSession.get(((MobicentsSipSession)sipSession).getKey());
        } else if (headerName.equalsIgnoreCase("Replaces")) {
            correspondingSipSession = this.replacesSession.get(((MobicentsSipSession)sipSession).getKey());
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces");
        }
        return correspondingSipSession;
    }

    public void addCorrespondingSipSession(MobicentsSipSession newSession, MobicentsSipSession correspondingSipSession, String headerName) {
        if ("Join".equalsIgnoreCase(headerName)) {
            this.joinSession.putIfAbsent(newSession.getKey(), correspondingSipSession);
        } else if ("Replaces".equalsIgnoreCase(headerName)) {
            this.replacesSession.putIfAbsent(newSession.getKey(), correspondingSipSession);
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces, was : " + headerName);
        }
    }

    public void removeCorrespondingSipSession(MobicentsSipSessionKey sipSession) {
        this.joinSession.remove(sipSession);
        this.replacesSession.remove(sipSession);
    }

    public MobicentsSipApplicationSessionKey getCorrespondingSipApplicationSession(MobicentsSipApplicationSessionKey sipApplicationSessionKey, String headerName) {
        MobicentsSipApplicationSessionKey correspondingSipApplicationSession = null;
        if (headerName.equalsIgnoreCase("Join")) {
            correspondingSipApplicationSession = this.joinApplicationSession.get(sipApplicationSessionKey);
        } else if (headerName.equalsIgnoreCase("Replaces")) {
            correspondingSipApplicationSession = this.replacesApplicationSession.get(sipApplicationSessionKey);
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces");
        }
        return correspondingSipApplicationSession;
    }

    public void addCorrespondingSipApplicationSession(MobicentsSipApplicationSessionKey newApplicationSession, MobicentsSipApplicationSessionKey correspondingSipApplicationSession, String headerName) {
        if (headerName.equalsIgnoreCase("Join")) {
            this.joinApplicationSession.putIfAbsent(newApplicationSession, correspondingSipApplicationSession);
        } else if (headerName.equalsIgnoreCase("Replaces")) {
            this.replacesApplicationSession.putIfAbsent(newApplicationSession, correspondingSipApplicationSession);
        } else {
            throw new IllegalArgumentException("headerName argument should either be one of Join or Replaces");
        }
    }

    public void removeCorrespondingSipApplicationSession(MobicentsSipApplicationSessionKey sipApplicationSession) {
        MobicentsSipApplicationSessionKey sipApplicationSessionKey;
        this.joinApplicationSession.remove(sipApplicationSession);
        this.replacesApplicationSession.remove(sipApplicationSession);
        Iterator<MobicentsSipApplicationSessionKey> it = this.joinApplicationSession.values().iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            sipApplicationSessionKey = it.next();
            if (!sipApplicationSessionKey.equals(sipApplicationSession)) continue;
            this.joinApplicationSession.remove(sipApplicationSessionKey);
            found = true;
        }
        it = this.replacesApplicationSession.values().iterator();
        found = false;
        while (it.hasNext() && !found) {
            sipApplicationSessionKey = it.next();
            if (!sipApplicationSessionKey.equals(sipApplicationSession)) continue;
            this.replacesApplicationSession.remove(sipApplicationSessionKey);
            found = true;
        }
    }

    public void scheduleAsynchronousWork(String sipSessionId, SipSessionAsynchronousWork work) {
        SipSessionKey sipSessionKey;
        try {
            sipSessionKey = SessionManagerUtil.parseSipSessionKey(sipSessionId);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("the given application session id : " + sipSessionId + " couldn't be parsed correctly ", e);
        }
        this.sipContext.getSipApplicationDispatcher().getAsynchronousExecutor().execute(new SipSessionAsyncTask(sipSessionKey, work, this.sipContext.getSipApplicationDispatcher().getSipFactory()));
    }

    public void scheduleAsynchronousWork(String sipApplicationSessionId, SipApplicationSessionAsynchronousWork work) {
        SipApplicationSessionKey applicationSessionKey;
        try {
            applicationSessionKey = SessionManagerUtil.parseSipApplicationSessionKey(sipApplicationSessionId);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("the given application session id : " + sipApplicationSessionId + " couldn't be parsed correctly ", e);
        }
        this.sipContext.getSipApplicationDispatcher().getAsynchronousExecutor().execute(new SipApplicationSessionAsyncTask(applicationSessionKey, work, this.sipContext.getSipApplicationDispatcher().getSipFactory()));
    }
}

