/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerService;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerTask;
import org.mobicents.servlet.sip.core.timers.StandardSasTimerTask;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class StandardSipApplicationSessionTimerService
extends Timer
implements SipApplicationSessionTimerService {
    private static final Logger logger = Logger.getLogger((String)StandardSipApplicationSessionTimerService.class.getName());
    private static volatile int numCancelled = 0;
    private AtomicBoolean started = new AtomicBoolean(false);

    public StandardSipApplicationSessionTimerService(String applicationName) {
        super(applicationName + "_sip_standard_sas_timer_service");
        this.schedulePurgeTaskIfNeeded();
    }

    private void schedulePurgeTaskIfNeeded() {
        int purgePeriod = StaticServiceHolder.sipStandardService.getCanceledTimerTasksPurgePeriod();
        if (purgePeriod > 0) {
            TimerTask t = new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Purging canceled timer tasks...");
                        }
                        StandardSipApplicationSessionTimerService.this.purge();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Purging canceled timer tasks completed.");
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"failed to execute purge", (Throwable)e);
                    }
                }
            };
            purgePeriod = purgePeriod * 60 * 1000;
            super.scheduleAtFixedRate(t, purgePeriod, (long)purgePeriod);
        }
    }

    public SipApplicationSessionTimerTask createSipApplicationSessionTimerTask(MobicentsSipApplicationSession sipApplicationSession) {
        return new StandardSasTimerTask(sipApplicationSession);
    }

    public boolean cancel(SipApplicationSessionTimerTask expirationTimerTask) {
        boolean cancelled = ((StandardSasTimerTask)expirationTimerTask).cancel();
        if (++numCancelled % 100 == 0) {
            super.purge();
        }
        return cancelled;
    }

    public SipApplicationSessionTimerTask schedule(SipApplicationSessionTimerTask expirationTimerTask, long delay, TimeUnit unit) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduling sip application session " + expirationTimerTask.getSipApplicationSession().getKey() + " to expire in " + (double)delay / 1000.0 / 60.0 + " minutes"));
        }
        super.schedule((TimerTask)((StandardSasTimerTask)expirationTimerTask), delay);
        return expirationTimerTask;
    }

    public void stop() {
        this.started.set(false);
        super.cancel();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Stopped timer service " + this));
        }
    }

    public void start() {
        this.started.set(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started timer service " + this));
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

