/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip;

import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.Transaction;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public final class JainSipUtils {
    private static final Logger logger = Logger.getLogger(JainSipUtils.class);
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_PORT_NUMBER = 1024;
    public static final String GLOBAL_IPADDRESS = "0.0.0.0";
    public static final Set<String> CONTACT_HEADER_METHODS = new TreeSet<String>(new SipFactoryImpl.NamesComparator());
    public static final Set<String> DIALOG_CREATING_METHODS;
    public static final Set<String> DIALOG_TERMINATING_METHODS;
    public static final String INITIAL_REMOTE_ADDR_HEADER_NAME = "MSS_Initial_Remote_Addr";
    public static final String INITIAL_REMOTE_PORT_HEADER_NAME = "MSS_Initial_Remote_Port";
    public static final String INITIAL_REMOTE_TRANSPORT_HEADER_NAME = "MSS_Initial_Remote_Transport";
    public static final Set<String> SYSTEM_HEADERS;
    public static final Set<String> ADDRESS_HEADER_NAMES;
    public static final Set<String> PARAMETERABLE_HEADER_NAMES;
    public static final Map<String, String> HEADER_COMPACT_2_FULL_NAMES_MAPPINGS;
    public static final Map<String, String> HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS;
    public static final Set<String> IANA_ALLOWED_CONTENT_TYPES;
    public static final Set<String> SINGLETON_HEADER_NAMES;
    public static final Set<String> LIST_HEADER_NAMES;
    private static final String[] ALLOWED_ADDRESS_SCHEMES;
    public static final int MAX_FORWARD_HEADER_VALUE = 70;
    private static ThreadLocal<MessageDigest> localDigest;

    private JainSipUtils() {
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("i", "Call-ID");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("f", "From");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("t", "To");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("v", "Via");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("m", "Contact");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("u", "Allow-Events");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("e", "Content-Encoding");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("l", "Content-Length");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("c", "Content-Type");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("o", "Event");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("r", "Refer-To");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("b", "Referred-By");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("d", "Content-Disposition");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("x", "Session-Expires");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("s", "Subject");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS.put("k", "Supported");
        throw new AssertionError();
    }

    public static int getAddressOutboundness(String address) {
        if (address.startsWith("127.0")) {
            return 0;
        }
        if (address.startsWith("192.168")) {
            return 1;
        }
        if (address.startsWith("10.")) {
            return 2;
        }
        if (address.startsWith("172.16") || address.startsWith("172.17") || address.startsWith("172.18") || address.startsWith("172.19") || address.startsWith("172.20") || address.startsWith("172.21") || address.startsWith("172.22") || address.startsWith("172.23") || address.startsWith("172.24") || address.startsWith("172.25") || address.startsWith("172.26") || address.startsWith("172.27") || address.startsWith("172.28") || address.startsWith("172.29") || address.startsWith("172.30") || address.startsWith("172.31")) {
            return 3;
        }
        if (address.indexOf(".") > 0) {
            return 4;
        }
        return -1;
    }

    public static String getMostOutboundAddress(List<String> addresses) {
        String bestAddr = "127.0.0.1";
        int bestAddrOutboundness = -2;
        for (String address : addresses) {
            int addrOutboundness = JainSipUtils.getAddressOutboundness(address);
            if (addrOutboundness <= bestAddrOutboundness) continue;
            bestAddr = address;
            bestAddrOutboundness = addrOutboundness;
        }
        return bestAddr;
    }

    public static ViaHeader createViaHeader(SipNetworkInterfaceManager sipNetworkInterfaceManager, Request request, String branch, String outboundInterface) {
        MobicentsExtendedListeningPoint listeningPoint = null;
        listeningPoint = JainSipUtils.findListeningPoint(sipNetworkInterfaceManager, request, outboundInterface);
        boolean usePublicAddress = JainSipUtils.findUsePublicAddress(sipNetworkInterfaceManager, (Message)request, listeningPoint);
        return listeningPoint.createViaHeader(branch, usePublicAddress);
    }

    public static String createBranch(String appSessionId, String appname) {
        return JainSipUtils.createBranch(appSessionId, appname, UUID.randomUUID().toString());
    }

    public static String createBranch(String appSessionId, String appname, String random) {
        return "z9hG4bK" + appSessionId + "_" + appname + "_" + random;
    }

    public static ContactHeader createContactHeader(SipNetworkInterfaceManager sipNetworkInterfaceManager, Request request, String displayName, String userName, String outboundInterface) {
        MobicentsExtendedListeningPoint listeningPoint = JainSipUtils.findListeningPoint(sipNetworkInterfaceManager, request, outboundInterface);
        boolean usePublicAddress = JainSipUtils.findUsePublicAddress(sipNetworkInterfaceManager, (Message)request, listeningPoint);
        ContactHeader ch = null;
        ch = outboundInterface != null ? listeningPoint.createContactHeader(displayName, userName, usePublicAddress, outboundInterface) : listeningPoint.createContactHeader(displayName, userName, usePublicAddress);
        if (StaticServiceHolder.sipStandardService.isMd5ContactUserPart()) {
            CallIdHeader callId = (CallIdHeader)request.getHeader("Call-ID");
            String username = JainSipUtils.getHash(callId.getCallId().getBytes());
            SipURI uri = (SipURI)ch.getAddress().getURI();
            try {
                uri.setUser(username);
                ch.getAddress().setDisplayName(null);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Can't create contact header user part with MD5", e);
            }
        }
        return ch;
    }

    public static MobicentsExtendedListeningPoint findListeningPoint(SipNetworkInterfaceManager sipNetworkInterfaceManager, Request request, String outboundInterface) {
        MobicentsExtendedListeningPoint listeningPoint;
        if (outboundInterface == null) {
            String transport = JainSipUtils.findTransport((Message)request);
            listeningPoint = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false);
        } else {
            SipURI outboundInterfaceURI = null;
            try {
                outboundInterfaceURI = (SipURI)SipFactoryImpl.addressFactory.createURI(outboundInterface);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("couldn't parse the outbound interface " + outboundInterface, e);
            }
            listeningPoint = sipNetworkInterfaceManager.findMatchingListeningPoint(outboundInterfaceURI, false);
        }
        return listeningPoint;
    }

    private static String getHash(byte[] b) {
        MessageDigest md = localDigest.get();
        if (md == null) {
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            localDigest.set(md);
        }
        md.reset();
        md.update(b);
        byte[] hash = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            sb.append(Integer.toHexString(hash[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(hash[i] & 0xF));
        }
        String rv = sb.toString();
        return rv;
    }

    public static SipURI createRecordRouteURI(SipNetworkInterfaceManager sipNetworkInterfaceManager, Message message) {
        String transport = JainSipUtils.findTransport(message);
        return JainSipUtils.createRecordRouteURI(sipNetworkInterfaceManager, message, transport);
    }

    public static SipURI createRecordRouteURI(SipNetworkInterfaceManager sipNetworkInterfaceManager, Message message, String transport) {
        MobicentsExtendedListeningPoint listeningPoint = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false);
        boolean usePublicAddress = JainSipUtils.findUsePublicAddress(sipNetworkInterfaceManager, message, listeningPoint);
        return listeningPoint.createRecordRouteURI(usePublicAddress);
    }

    public static boolean findUsePublicAddress(SipNetworkInterfaceManager sipNetworkInterfaceManager, Message message, MobicentsExtendedListeningPoint listeningPoint) {
        boolean usePublicAddress = false;
        if (listeningPoint.isUseStaticAddress()) {
            usePublicAddress = true;
        } else if (listeningPoint.getGlobalIpAddress() != null) {
            usePublicAddress = sipNetworkInterfaceManager.findUsePublicAddress(message);
        }
        return usePublicAddress;
    }

    public static String findTransport(Message message) {
        String viaTransport;
        if (message == null) {
            return "UDP";
        }
        String transport = (String)((SIPMessage)message).getApplicationData();
        if (transport != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AppData Transport " + transport));
            }
            return transport;
        }
        ViaHeader topmostViaHeader = (ViaHeader)message.getHeader("Via");
        if (topmostViaHeader != null && (viaTransport = topmostViaHeader.getTransport()) != null && viaTransport.length() > 0) {
            transport = viaTransport;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Via Transport " + transport));
            }
        }
        if (transport == null && message instanceof Request) {
            transport = JainSipUtils.findRouteOrRequestUriTransport((Request)message);
        }
        ((SIPMessage)message).setApplicationData((Object)transport);
        return transport;
    }

    public static String findRouteOrRequestUriTransport(Request request) {
        RouteHeader route = (RouteHeader)request.getHeader("Route");
        if (route != null) {
            URI uri = route.getAddress().getURI();
            return JainSipUtils.findURITransport(uri, request.getContentLength().getContentLength());
        }
        URI ruri = request.getRequestURI();
        return JainSipUtils.findURITransport(ruri, request.getContentLength().getContentLength());
    }

    public static String findURITransport(URI uri, int messageContentLength) {
        String transport = "UDP";
        if (uri instanceof SipURI) {
            SipURI sipURI = (SipURI)uri;
            if (sipURI.isSecure()) {
                transport = "TLS";
            } else {
                String transportParam = sipURI.getTransportParam();
                if (transportParam != null && transportParam.equalsIgnoreCase("TLS")) {
                    transport = "TLS";
                } else if (transportParam != null && transportParam.equalsIgnoreCase("WS")) {
                    transport = "WS";
                } else if (transportParam != null && transportParam.equalsIgnoreCase("WSS")) {
                    transport = "WSS";
                } else if (transportParam != null && transportParam.equalsIgnoreCase("TCP") || messageContentLength > 4096) {
                    transport = "TCP";
                }
            }
        }
        return transport;
    }

    public static boolean checkScheme(String address) {
        String tmpAddress = address;
        for (String scheme : ALLOWED_ADDRESS_SCHEMES) {
            int start = tmpAddress.indexOf("<");
            if (start >= 0) {
                int end = tmpAddress.indexOf(">");
                tmpAddress = tmpAddress.substring(start + 1, end);
            }
            if (!scheme.equalsIgnoreCase(tmpAddress.substring(0, scheme.length()))) continue;
            return true;
        }
        return false;
    }

    public static void terminateTransaction(Transaction transaction) {
        if (transaction != null && transaction instanceof SIPClientTransaction) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("terminating transaction " + transaction + " with transaction id " + transaction.getBranchId()));
            }
            try {
                transaction.terminate();
            }
            catch (ObjectInUseException e) {
                logger.error((Object)("Couldn't terminate the transaction " + transaction + " with transaction id " + transaction.getBranchId()));
            }
        }
    }

    public static void setTransactionTimers(TransactionExt transaction, SipApplicationDispatcher sipApplicationDispatcher) {
        transaction.setRetransmitTimer(sipApplicationDispatcher.getBaseTimerInterval());
        transaction.setTimerT2(sipApplicationDispatcher.getT2Interval());
        transaction.setTimerT4(sipApplicationDispatcher.getT4Interval());
        transaction.setTimerD(sipApplicationDispatcher.getTimerDInterval());
    }

    public static void optimizeRouteHeaderAddressForInternalRoutingrequest(SipConnector sipConnector, Request request, MobicentsSipSession session, SipFactoryImpl sipFactoryImpl, String transport) {
        RouteHeader rh = (RouteHeader)request.getHeader("Route");
        URI uri = null;
        uri = rh != null ? rh.getAddress().getURI() : request.getRequestURI();
        if (uri.isSipURI()) {
            SipURI sipUri = (SipURI)uri;
            JainSipUtils.optimizeUriForInternalRoutingRequest(sipConnector, sipUri, session, sipFactoryImpl, transport);
        }
    }

    public static void optimizeUriForInternalRoutingRequest(SipConnector sipConnector, SipURI sipUri, MobicentsSipSession session, SipFactoryImpl sipFactoryImpl, String transport) {
        SipNetworkInterfaceManager sipNetworkInterfaceManager = sipFactoryImpl.getSipNetworkInterfaceManager();
        try {
            boolean isExternal = sipFactoryImpl.getSipApplicationDispatcher().isExternal(sipUri.getHost(), sipUri.getPort(), transport);
            if (!isExternal) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The request is going internally due to sipUri = " + sipUri));
                }
                if (!sipConnector.isReplaceStaticServerAddressForInternalRoutingRequest() && sipConnector.getStaticServerAddress() != null && (sipConnector.getStaticServerAddress().equals(sipUri.getHost()) || sipConnector.getStaticServerAddress().equals(sipUri.getHost() + ":" + sipUri.getPort()))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Avoiding URI optimization due to connector configuration and URI points to the static server address.");
                    }
                    return;
                }
                MobicentsExtendedListeningPoint lp = null;
                if (session.getOutboundInterface() != null) {
                    SipURI outboundInterfaceURI = (SipURI)SipFactoryImpl.addressFactory.createURI(session.getOutboundInterface());
                    lp = sipNetworkInterfaceManager.findMatchingListeningPoint(outboundInterfaceURI, false);
                } else {
                    lp = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false);
                }
                sipUri.setHost(lp.getHost(false));
                sipUri.setPort(lp.getPort());
                sipUri.setTransportParam(lp.getTransport());
            }
        }
        catch (ParseException e) {
            logger.error((Object)"AR optimization error", (Throwable)e);
        }
    }

    public static void optimizeViaHeaderAddressForStaticAddress(SipConnector sipConnector, Request request, SipFactoryImpl sipFactoryImpl, String transport) throws ParseException, InvalidArgumentException {
        URI uri = request.getRequestURI();
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        RouteHeader route = (RouteHeader)request.getHeader("Route");
        if (route != null) {
            uri = route.getAddress().getURI();
        }
        if (uri.isSipURI()) {
            SipURI sipUri = (SipURI)uri;
            String host = sipUri.getHost();
            int port = sipUri.getPort();
            if (sipFactoryImpl.getSipApplicationDispatcher().isExternal(host, port, transport)) {
                viaHeader.setHost(sipConnector.getStaticServerAddress());
                viaHeader.setPort(sipConnector.getStaticServerPort());
            }
        }
    }

    static {
        CONTACT_HEADER_METHODS.add("INVITE");
        CONTACT_HEADER_METHODS.add("SUBSCRIBE");
        CONTACT_HEADER_METHODS.add("NOTIFY");
        CONTACT_HEADER_METHODS.add("REFER");
        CONTACT_HEADER_METHODS.add("UPDATE");
        CONTACT_HEADER_METHODS.add("OPTIONS");
        CONTACT_HEADER_METHODS.add("MESSAGE");
        DIALOG_CREATING_METHODS = new TreeSet<String>(new SipFactoryImpl.NamesComparator());
        DIALOG_TERMINATING_METHODS = new TreeSet<String>(new SipFactoryImpl.NamesComparator());
        DIALOG_CREATING_METHODS.add("INVITE");
        DIALOG_CREATING_METHODS.add("SUBSCRIBE");
        DIALOG_CREATING_METHODS.add("REFER");
        DIALOG_TERMINATING_METHODS.add("CANCEL");
        DIALOG_TERMINATING_METHODS.add("BYE");
        SYSTEM_HEADERS = new HashSet<String>();
        SYSTEM_HEADERS.add("Call-ID");
        SYSTEM_HEADERS.add("CSeq");
        SYSTEM_HEADERS.add("Via");
        SYSTEM_HEADERS.add("Route");
        SYSTEM_HEADERS.add("Record-Route");
        SYSTEM_HEADERS.add("Path");
        SYSTEM_HEADERS.add("RSeq");
        SYSTEM_HEADERS.add("RAck");
        SYSTEM_HEADERS.add(INITIAL_REMOTE_ADDR_HEADER_NAME);
        SYSTEM_HEADERS.add(INITIAL_REMOTE_PORT_HEADER_NAME);
        SYSTEM_HEADERS.add(INITIAL_REMOTE_TRANSPORT_HEADER_NAME);
        ADDRESS_HEADER_NAMES = new HashSet<String>();
        ADDRESS_HEADER_NAMES.add("From");
        ADDRESS_HEADER_NAMES.add("To");
        ADDRESS_HEADER_NAMES.add("Contact");
        ADDRESS_HEADER_NAMES.add("Route");
        ADDRESS_HEADER_NAMES.add("Record-Route");
        ADDRESS_HEADER_NAMES.add("Reply-To");
        ADDRESS_HEADER_NAMES.add("Alert-Info");
        ADDRESS_HEADER_NAMES.add("Call-Info");
        ADDRESS_HEADER_NAMES.add("Error-Info");
        ADDRESS_HEADER_NAMES.add("Refer-To");
        ADDRESS_HEADER_NAMES.add("P-Asserted-Identity");
        PARAMETERABLE_HEADER_NAMES = new HashSet<String>();
        PARAMETERABLE_HEADER_NAMES.add("From");
        PARAMETERABLE_HEADER_NAMES.add("To");
        PARAMETERABLE_HEADER_NAMES.add("Contact");
        PARAMETERABLE_HEADER_NAMES.add("Route");
        PARAMETERABLE_HEADER_NAMES.add("Record-Route");
        PARAMETERABLE_HEADER_NAMES.add("Reply-To");
        PARAMETERABLE_HEADER_NAMES.add("Accept");
        PARAMETERABLE_HEADER_NAMES.add("Accept-Encoding");
        PARAMETERABLE_HEADER_NAMES.add("Alert-Info");
        PARAMETERABLE_HEADER_NAMES.add("Call-Info");
        PARAMETERABLE_HEADER_NAMES.add("Content-Disposition");
        PARAMETERABLE_HEADER_NAMES.add("Content-Type");
        PARAMETERABLE_HEADER_NAMES.add("Error-Info");
        PARAMETERABLE_HEADER_NAMES.add("Retry-After");
        PARAMETERABLE_HEADER_NAMES.add("Via");
        PARAMETERABLE_HEADER_NAMES.add("WWW-Authenticate");
        PARAMETERABLE_HEADER_NAMES.add("Proxy-Authenticate");
        PARAMETERABLE_HEADER_NAMES.add("Authorization");
        PARAMETERABLE_HEADER_NAMES.add("Proxy-Authorization");
        PARAMETERABLE_HEADER_NAMES.add("Event");
        PARAMETERABLE_HEADER_NAMES.add("Subscription-State");
        HEADER_COMPACT_2_FULL_NAMES_MAPPINGS = new HashMap<String, String>();
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS = new HashMap<String, String>();
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Call-ID", "i");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("From", "f");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("To", "t");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Via", "v");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Contact", "m");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Allow-Events", "u");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Content-Encoding", "e");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Content-Length", "l");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Content-Type", "c");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Event", "o");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Refer-To", "r");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Content-Disposition", "d");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Subject", "s");
        HEADER_FULL_TO_COMPACT_NAMES_MAPPINGS.put("Supported", "k");
        IANA_ALLOWED_CONTENT_TYPES = new HashSet<String>();
        IANA_ALLOWED_CONTENT_TYPES.add("application");
        IANA_ALLOWED_CONTENT_TYPES.add("audio");
        IANA_ALLOWED_CONTENT_TYPES.add("example");
        IANA_ALLOWED_CONTENT_TYPES.add("image");
        IANA_ALLOWED_CONTENT_TYPES.add("message");
        IANA_ALLOWED_CONTENT_TYPES.add("model");
        IANA_ALLOWED_CONTENT_TYPES.add("multipart");
        IANA_ALLOWED_CONTENT_TYPES.add("text");
        IANA_ALLOWED_CONTENT_TYPES.add("video");
        SINGLETON_HEADER_NAMES = new HashSet<String>();
        SINGLETON_HEADER_NAMES.add("From");
        SINGLETON_HEADER_NAMES.add("To");
        SINGLETON_HEADER_NAMES.add("CSeq");
        SINGLETON_HEADER_NAMES.add("Call-ID");
        SINGLETON_HEADER_NAMES.add("Max-Forwards");
        SINGLETON_HEADER_NAMES.add("Content-Length");
        SINGLETON_HEADER_NAMES.add("Content-Disposition");
        SINGLETON_HEADER_NAMES.add("Content-Type");
        SINGLETON_HEADER_NAMES.add("Content-Length");
        SINGLETON_HEADER_NAMES.add("Content-Type");
        SINGLETON_HEADER_NAMES.add("Date");
        SINGLETON_HEADER_NAMES.add("Content-Type");
        SINGLETON_HEADER_NAMES.add("Expires");
        SINGLETON_HEADER_NAMES.add("Min-Expires");
        SINGLETON_HEADER_NAMES.add("MIME-Version");
        SINGLETON_HEADER_NAMES.add("Min-Expires");
        SINGLETON_HEADER_NAMES.add("Organization");
        SINGLETON_HEADER_NAMES.add("Priority");
        SINGLETON_HEADER_NAMES.add("Reply-To");
        SINGLETON_HEADER_NAMES.add("Retry-After");
        SINGLETON_HEADER_NAMES.add("Priority");
        SINGLETON_HEADER_NAMES.add("Server");
        SINGLETON_HEADER_NAMES.add("Subject");
        SINGLETON_HEADER_NAMES.add("Timestamp");
        SINGLETON_HEADER_NAMES.add("User-Agent");
        SINGLETON_HEADER_NAMES.add("WWW-Authenticate");
        SINGLETON_HEADER_NAMES.add("Proxy-Authenticate");
        SINGLETON_HEADER_NAMES.add("Proxy-Authorization");
        SINGLETON_HEADER_NAMES.add("Authorization");
        SINGLETON_HEADER_NAMES.add("Authentication-Info");
        LIST_HEADER_NAMES = new HashSet<String>();
        LIST_HEADER_NAMES.add("Accept-Encoding");
        LIST_HEADER_NAMES.add("Accept-Language");
        LIST_HEADER_NAMES.add("Accept");
        LIST_HEADER_NAMES.add("Alert-Info");
        LIST_HEADER_NAMES.add("Allow-Events");
        LIST_HEADER_NAMES.add("Allow");
        LIST_HEADER_NAMES.add("Call-Info");
        LIST_HEADER_NAMES.add("Contact");
        LIST_HEADER_NAMES.add("Content-Encoding");
        LIST_HEADER_NAMES.add("Content-Language");
        LIST_HEADER_NAMES.add("Error-Info");
        LIST_HEADER_NAMES.add("In-Reply-To");
        LIST_HEADER_NAMES.add("Proxy-Require");
        LIST_HEADER_NAMES.add("Reason");
        LIST_HEADER_NAMES.add("Record-Route");
        LIST_HEADER_NAMES.add("Require");
        LIST_HEADER_NAMES.add("Route");
        LIST_HEADER_NAMES.add("Supported");
        LIST_HEADER_NAMES.add("Unsupported");
        LIST_HEADER_NAMES.add("Via");
        LIST_HEADER_NAMES.add("Warning");
        LIST_HEADER_NAMES.add("P-Asserted-Identity");
        LIST_HEADER_NAMES.add("P-Associated-URI");
        LIST_HEADER_NAMES.add("Path");
        LIST_HEADER_NAMES.add("P-Media-Authorization");
        LIST_HEADER_NAMES.add("Privacy");
        LIST_HEADER_NAMES.add("P-Visited-Network-ID");
        LIST_HEADER_NAMES.add("Security-Client");
        LIST_HEADER_NAMES.add("Security-Server");
        LIST_HEADER_NAMES.add("Security-Verify");
        LIST_HEADER_NAMES.add("Service-Route");
        ALLOWED_ADDRESS_SCHEMES = new String[]{"sip", "sips", "tel", "tels"};
        localDigest = new ThreadLocal();
    }
}

