/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import gov.nist.javax.sip.ServerTransactionExt;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.sip.SipSession;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.header.ReasonHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.dispatchers.DispatchTask;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.RequestDispatcher;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;

public class CancelRequestDispatcher
extends RequestDispatcher {
    private static final Logger logger = Logger.getLogger(CancelRequestDispatcher.class);

    @Override
    public void dispatchMessage(SipProvider sipProvider, SipServletMessageImpl sipServletMessage) throws DispatcherException {
        ServerTransaction cancelTransaction;
        SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)sipServletMessage;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Routing of Cancel Request " + sipServletRequest));
        }
        if ((cancelTransaction = (ServerTransaction)sipServletRequest.getTransaction()) != null && !TransactionState.TERMINATED.equals((Object)cancelTransaction.getState())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending 200 to Cancel " + sipServletRequest));
            }
            try {
                SipServletResponseImpl cancelResponse = (SipServletResponseImpl)sipServletRequest.createResponse(200, "Canceling");
                Response cancelJsipResponse = (Response)cancelResponse.getMessage();
                cancelTransaction.sendResponse(cancelJsipResponse);
                this.sipApplicationDispatcher.updateResponseStatistics(cancelJsipResponse, false);
            }
            catch (SipException e) {
                throw new DispatcherException(500, "Impossible to send the ok to the CANCEL", (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                throw new DispatcherException(500, "Impossible to send the ok to the CANCEL", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("checking what to do with the CANCEL " + sipServletRequest));
            }
            CancelDispatchTask dispatchTask = new CancelDispatchTask(sipServletRequest, sipProvider);
            this.sipApplicationDispatcher.getAsynchronousExecutor().execute(dispatchTask);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retransmission received for CANCEL " + sipServletRequest + ", transaction " + cancelTransaction));
            if (cancelTransaction != null) {
                logger.debug((Object)("Cancel Transaction state " + cancelTransaction.getState()));
            }
        }
    }

    private static final void send487Response(Transaction inviteTransaction, SipServletRequestImpl inviteRequest) throws IllegalStateException, DispatcherException {
        SipServletResponseImpl inviteResponse = (SipServletResponseImpl)inviteRequest.createResponse(487);
        inviteRequest.setRoutingState(RoutingState.CANCELLED);
        if (inviteRequest.isInitial()) {
            inviteRequest.getSipSession().setState(SipSession.State.TERMINATED);
        }
        try {
            Response requestTerminatedResponse = (Response)inviteResponse.getMessage();
            ((ServerTransaction)inviteTransaction).sendResponse(requestTerminatedResponse);
            inviteRequest.getSipSession().getSipApplicationSession().getSipContext().getSipApplicationDispatcher().updateResponseStatistics(requestTerminatedResponse, false);
        }
        catch (SipException e) {
            throw new DispatcherException(500, "Impossible to send the 487 to the INVITE transaction corresponding to CANCEL", (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            throw new DispatcherException(500, "Impossible to send the 487 to the INVITE transaction corresponding to CANCEL", (Throwable)e);
        }
    }

    public static class CancelDispatchTask
    extends DispatchTask {
        CancelDispatchTask(SipServletRequestImpl sipServletRequest, SipProvider sipProvider) {
            super(sipServletRequest, sipProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() throws DispatcherException {
            block37: {
                SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)this.sipServletMessage;
                Request request = (Request)sipServletRequest.getMessage();
                ServerTransaction inviteTransaction = ((ServerTransactionExt)sipServletRequest.getTransaction()).getCanceledInviteTransaction();
                if (inviteTransaction == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("couldn't find the original invite transaction for this cancel " + request + ", it may be a retransmission and the transaction has already been terminated"));
                    }
                    return;
                }
                TransactionApplicationData inviteAppData = (TransactionApplicationData)inviteTransaction.getApplicationData();
                if (inviteAppData == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("couldn't find the original transaction app data for this cancel " + request + ", it may be a retransmission and the transaction has already been terminated or is being cleaned up"));
                    }
                    return;
                }
                SipServletRequestImpl inviteRequest = (SipServletRequestImpl)inviteAppData.getSipServletMessage();
                MobicentsSipSession sipSession = inviteRequest.getSipSession();
                sipServletRequest.setSipSession(sipSession);
                sipSession.setRequestsPending(0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("message associated with the inviteAppData of the CANCEL " + inviteRequest));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("invite transaction associated with the inviteAppData of the CANCEL " + inviteTransaction));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("app data of the invite transaction associated with the inviteAppData of the CANCEL " + inviteAppData));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("routing state of the INVITE request for the CANCEL = " + (Object)((Object)inviteRequest.getRoutingState())));
                }
                MobicentsSipApplicationSession sipApplicationSession = sipSession.getSipApplicationSession();
                SipContext sipContext = sipApplicationSession.getSipContext();
                try {
                    sipContext.enterSipApp(sipApplicationSession, sipSession, false, true);
                    MobicentsProxy proxy = sipSession.getProxy();
                    if (proxy != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("proxying the CANCEL " + sipServletRequest));
                        }
                        if (!RoutingState.PROXIED.equals((Object)inviteRequest.getRoutingState())) {
                            try {
                                CancelRequestDispatcher.send487Response((Transaction)inviteTransaction, inviteRequest);
                            }
                            catch (IllegalStateException iae) {
                                logger.info((Object)"request already proxied, dropping the cancel");
                                sipContext.exitSipApp(sipApplicationSession, sipSession);
                                return;
                            }
                        } else {
                            ReasonHeader reasonHeader = (ReasonHeader)sipServletRequest.getMessage().getHeader("Reason");
                            if (reasonHeader != null) {
                                proxy.cancelAllExcept(null, new String[]{reasonHeader.getProtocol()}, new int[]{reasonHeader.getCause()}, new String[]{reasonHeader.getText()}, false);
                            } else {
                                proxy.cancelAllExcept(null, null, null, null, false);
                            }
                        }
                        try {
                            MessageDispatcher.callServlet(sipServletRequest);
                            break block37;
                        }
                        catch (ServletException e) {
                            throw new DispatcherException(500, "An unexpected servlet exception occured while routing the following CANCEL " + request, (Throwable)e);
                        }
                        catch (IOException e) {
                            throw new DispatcherException(500, "An unexpected IO exception occured while routing the following CANCEL " + request, (Throwable)e);
                        }
                        catch (Throwable e) {
                            throw new DispatcherException(500, "An unexpected exception occured while routing the following CANCEL " + request, e);
                        }
                    }
                    if (RoutingState.FINAL_RESPONSE_SENT.equals((Object)inviteRequest.getRoutingState())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"the final response has already been sent, nothing to do here");
                        }
                        break block37;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("invite transaction of the CANCEL " + inviteTransaction));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("invite message : 1xx response was generated ? " + ((SipServletRequestImpl)inviteAppData.getSipServletMessage()).is1xxResponseGenerated()));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("invite message : Final response was generated ? " + ((SipServletRequestImpl)inviteAppData.getSipServletMessage()).isFinalResponseGenerated()));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"replying 487 to INVITE cancelled");
                    }
                    try {
                        CancelRequestDispatcher.send487Response((Transaction)inviteTransaction, inviteRequest);
                    }
                    catch (IllegalStateException iae) {
                        logger.info((Object)"request already proxied, dropping the cancel");
                        sipContext.exitSipApp(sipApplicationSession, sipSession);
                        return;
                    }
                    try {
                        MessageDispatcher.callServlet(sipServletRequest);
                    }
                    catch (ServletException e) {
                        throw new DispatcherException(500, "An unexpected servlet exception occured while routing the following CANCEL " + request, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new DispatcherException(500, "An unexpected IO exception occured while routing the following CANCEL " + request, (Throwable)e);
                    }
                    catch (Throwable e) {
                        throw new DispatcherException(500, "An unexpected exception occured while routing the following CANCEL " + request, e);
                    }
                }
                finally {
                    sipContext.exitSipApp(sipApplicationSession, sipSession);
                }
            }
        }
    }
}

