/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationSessionActivationListener;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionBindingListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipSessionActivationListener;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.ContainerListener;
import org.mobicents.javax.servlet.sip.ProxyBranchListener;
import org.mobicents.servlet.sip.core.MobicentsSipServlet;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipListeners;
import org.mobicents.servlet.sip.listener.SipConnectorListener;

public abstract class SipListenersHolder
implements SipListeners {
    private static final Logger logger = Logger.getLogger(SipListenersHolder.class);
    private List<SipApplicationSessionAttributeListener> sipApplicationSessionAttributeListeners;
    private List<SipApplicationSessionBindingListener> sipApplicationSessionBindingListeners;
    private List<SipApplicationSessionListener> sipApplicationSessionListeners;
    private List<SipApplicationSessionActivationListener> sipApplicationSessionActivationListeners;
    private List<SipSessionActivationListener> sipSessionActivationListeners;
    private List<SipSessionAttributeListener> sipSessionAttributeListeners;
    private List<SipSessionBindingListener> sipSessionBindingListeners;
    private List<SipSessionListener> sipSessionListeners;
    private List<SipServletListener> sipServletsListeners;
    private List<SipErrorListener> sipErrorListeners;
    private List<SipConnectorListener> sipConnectorListeners;
    private List<ProxyBranchListener> proxyBranchListeners;
    private List<ServletContextListener> servletContextListeners;
    protected Map<EventListener, MobicentsSipServlet> listenerServlets;
    private TimerListener timerListener;
    private ContainerListener containerListener;
    protected SipContext sipContext;

    public SipListenersHolder(SipContext sipContext) {
        this.sipContext = sipContext;
        this.sipApplicationSessionAttributeListeners = new ArrayList<SipApplicationSessionAttributeListener>();
        this.sipApplicationSessionBindingListeners = new ArrayList<SipApplicationSessionBindingListener>();
        this.sipApplicationSessionListeners = new ArrayList<SipApplicationSessionListener>();
        this.sipApplicationSessionActivationListeners = new ArrayList<SipApplicationSessionActivationListener>();
        this.sipSessionActivationListeners = new ArrayList<SipSessionActivationListener>();
        this.sipSessionAttributeListeners = new ArrayList<SipSessionAttributeListener>();
        this.sipSessionBindingListeners = new ArrayList<SipSessionBindingListener>();
        this.sipSessionListeners = new ArrayList<SipSessionListener>();
        this.sipServletsListeners = new ArrayList<SipServletListener>();
        this.sipErrorListeners = new ArrayList<SipErrorListener>();
        this.servletContextListeners = new ArrayList<ServletContextListener>();
        this.sipConnectorListeners = new ArrayList<SipConnectorListener>();
        this.proxyBranchListeners = new ArrayList<ProxyBranchListener>();
        this.listenerServlets = new HashMap<EventListener, MobicentsSipServlet>();
    }

    public abstract boolean loadListeners(String[] var1, ClassLoader var2);

    protected void addListenerToBunch(EventListener listener) {
        boolean added = false;
        if (listener instanceof SipApplicationSessionAttributeListener) {
            this.addListener((SipApplicationSessionAttributeListener)listener);
            added = true;
        }
        if (listener instanceof SipApplicationSessionBindingListener) {
            this.addListener((SipApplicationSessionBindingListener)listener);
            added = true;
        }
        if (listener instanceof SipApplicationSessionActivationListener) {
            this.addListener((SipApplicationSessionActivationListener)listener);
            added = true;
        }
        if (listener instanceof SipApplicationSessionListener) {
            this.addListener((SipApplicationSessionListener)listener);
            added = true;
        }
        if (listener instanceof SipSessionActivationListener) {
            this.addListener((SipSessionActivationListener)listener);
            added = true;
        }
        if (listener instanceof SipSessionAttributeListener) {
            this.addListener((SipSessionAttributeListener)listener);
            added = true;
        }
        if (listener instanceof SipSessionBindingListener) {
            this.addListener((SipSessionBindingListener)listener);
            added = true;
        }
        if (listener instanceof SipSessionListener) {
            this.addListener((SipSessionListener)listener);
            added = true;
        }
        if (listener instanceof SipServletListener) {
            this.addListener((SipServletListener)listener);
            added = true;
        }
        if (listener instanceof SipErrorListener) {
            this.addListener((SipErrorListener)listener);
            added = true;
        }
        if (listener instanceof ServletContextListener) {
            this.addListener((ServletContextListener)listener);
            added = true;
        }
        if (listener instanceof TimerListener) {
            this.setTimerListener((TimerListener)listener);
            added = true;
        }
        if (listener instanceof SipConnectorListener) {
            this.addListener((SipConnectorListener)listener);
            added = true;
        }
        if (listener instanceof ProxyBranchListener) {
            this.addListener((ProxyBranchListener)listener);
            added = true;
        }
        if (listener instanceof ContainerListener) {
            this.setContainerListener((ContainerListener)listener);
            added = true;
        }
        if (!added) {
            throw new IllegalArgumentException("Wrong type of LISTENER!!![" + listener + "]");
        }
    }

    public void addListener(SipApplicationSessionAttributeListener listener) {
        this.sipApplicationSessionAttributeListeners.add(listener);
    }

    public void addListener(SipApplicationSessionBindingListener listener) {
        this.sipApplicationSessionBindingListeners.add(listener);
    }

    public void addListener(SipApplicationSessionActivationListener listener) {
        this.sipApplicationSessionActivationListeners.add(listener);
    }

    public void addListener(SipApplicationSessionListener listener) {
        this.sipApplicationSessionListeners.add(listener);
    }

    public void addListener(SipSessionActivationListener listener) {
        this.sipSessionActivationListeners.add(listener);
    }

    public void addListener(SipSessionAttributeListener listener) {
        this.sipSessionAttributeListeners.add(listener);
    }

    public void addListener(SipSessionBindingListener listener) {
        this.sipSessionBindingListeners.add(listener);
    }

    public void addListener(SipSessionListener listener) {
        this.sipSessionListeners.add(listener);
    }

    public void addListener(SipServletListener listener) {
        this.sipServletsListeners.add(listener);
    }

    public void addListener(SipErrorListener listener) {
        this.sipErrorListeners.add(listener);
    }

    public void addListener(ServletContextListener listener) {
        this.servletContextListeners.add(listener);
    }

    public void addListener(SipConnectorListener listener) {
        this.sipConnectorListeners.add(listener);
    }

    public void addListener(ProxyBranchListener listener) {
        this.proxyBranchListeners.add(listener);
    }

    public void setTimerListener(TimerListener listener) {
        if (this.timerListener != null) {
            throw new IllegalArgumentException("the time listener has already been set (" + this.timerListener.getClass().getName() + "), There may be at most one TimerListener defined !");
        }
        this.timerListener = listener;
    }

    public List<SipApplicationSessionAttributeListener> getSipApplicationSessionAttributeListeners() {
        return this.sipApplicationSessionAttributeListeners;
    }

    public List<SipApplicationSessionBindingListener> getSipApplicationSessionBindingListeners() {
        return this.sipApplicationSessionBindingListeners;
    }

    public List<SipApplicationSessionActivationListener> getSipApplicationSessionActivationListeners() {
        return this.sipApplicationSessionActivationListeners;
    }

    public List<SipApplicationSessionListener> getSipApplicationSessionListeners() {
        return this.sipApplicationSessionListeners;
    }

    public List<SipSessionActivationListener> getSipSessionActivationListeners() {
        return this.sipSessionActivationListeners;
    }

    public List<SipSessionAttributeListener> getSipSessionAttributeListeners() {
        return this.sipSessionAttributeListeners;
    }

    public List<SipSessionBindingListener> getSipSessionBindingListeners() {
        return this.sipSessionBindingListeners;
    }

    public List<SipSessionListener> getSipSessionListeners() {
        return this.sipSessionListeners;
    }

    public List<SipServletListener> getSipServletsListeners() {
        return this.sipServletsListeners;
    }

    public List<SipErrorListener> getSipErrorListeners() {
        return this.sipErrorListeners;
    }

    public List<ServletContextListener> getServletContextListeners() {
        return this.servletContextListeners;
    }

    public List<SipConnectorListener> getSipConnectorListeners() {
        return this.sipConnectorListeners;
    }

    public List<ProxyBranchListener> getProxyBranchListeners() {
        return this.proxyBranchListeners;
    }

    public TimerListener getTimerListener() {
        return this.timerListener;
    }

    public void deallocateServletsActingAsListeners() {
        for (SipApplicationSessionAttributeListener sipApplicationSessionAttributeListener : this.sipApplicationSessionAttributeListeners) {
            this.checkDeallocateServlet((EventListener)sipApplicationSessionAttributeListener);
        }
        for (SipApplicationSessionBindingListener sipApplicationSessionBindingListener : this.sipApplicationSessionBindingListeners) {
            this.checkDeallocateServlet((EventListener)sipApplicationSessionBindingListener);
        }
        for (SipApplicationSessionActivationListener sipApplicationSessionActivationListener : this.sipApplicationSessionActivationListeners) {
            this.checkDeallocateServlet((EventListener)sipApplicationSessionActivationListener);
        }
        for (SipApplicationSessionListener sipApplicationSessionListener : this.sipApplicationSessionListeners) {
            this.checkDeallocateServlet((EventListener)sipApplicationSessionListener);
        }
        for (SipSessionActivationListener sipSessionActivationListener : this.sipSessionActivationListeners) {
            this.checkDeallocateServlet((EventListener)sipSessionActivationListener);
        }
        for (SipSessionAttributeListener sipSessionAttributeListener : this.sipSessionAttributeListeners) {
            this.checkDeallocateServlet((EventListener)sipSessionAttributeListener);
        }
        for (SipSessionBindingListener sipSessionBindingListener : this.sipSessionBindingListeners) {
            this.checkDeallocateServlet((EventListener)sipSessionBindingListener);
        }
        for (SipSessionListener sipSessionListener : this.sipSessionListeners) {
            this.checkDeallocateServlet((EventListener)sipSessionListener);
        }
        for (SipServletListener sipServletListener : this.sipServletsListeners) {
            this.checkDeallocateServlet((EventListener)sipServletListener);
        }
        for (SipErrorListener sipErrorListener : this.sipErrorListeners) {
            this.checkDeallocateServlet((EventListener)sipErrorListener);
        }
        for (ServletContextListener servletContextListener : this.servletContextListeners) {
            this.checkDeallocateServlet((EventListener)servletContextListener);
        }
        for (SipConnectorListener sipConnectorListener : this.sipConnectorListeners) {
            this.checkDeallocateServlet((EventListener)sipConnectorListener);
        }
        for (ProxyBranchListener proxyListener : this.proxyBranchListeners) {
            this.checkDeallocateServlet((EventListener)proxyListener);
        }
        this.checkDeallocateServlet((EventListener)this.timerListener);
        this.checkDeallocateServlet((EventListener)this.containerListener);
    }

    public void clean() {
        this.sipApplicationSessionAttributeListeners.clear();
        this.sipApplicationSessionBindingListeners.clear();
        this.sipApplicationSessionActivationListeners.clear();
        this.sipApplicationSessionListeners.clear();
        this.sipSessionActivationListeners.clear();
        this.sipSessionAttributeListeners.clear();
        this.sipSessionBindingListeners.clear();
        this.sipSessionListeners.clear();
        this.sipServletsListeners.clear();
        this.sipErrorListeners.clear();
        this.servletContextListeners.clear();
        this.sipConnectorListeners.clear();
        this.proxyBranchListeners.clear();
        this.listenerServlets.clear();
        this.timerListener = null;
        this.containerListener = null;
    }

    private void checkDeallocateServlet(EventListener eventListener) {
        if (eventListener instanceof SipServlet) {
            try {
                MobicentsSipServlet wrapper = this.listenerServlets.get(eventListener);
                if (wrapper != null) {
                    wrapper.deallocate((Servlet)((SipServlet)eventListener));
                }
            }
            catch (ServletException e) {
                logger.error((Object)("couldn't deallocate listener " + eventListener.getClass().getName()));
            }
        }
    }

    public ContainerListener getContainerListener() {
        return this.containerListener;
    }

    public void setContainerListener(ContainerListener containerListener) {
        if (this.containerListener != null) {
            throw new IllegalArgumentException("the Container listener has already been set (" + this.containerListener.getClass().getName() + "), There may be at most one ContainerListener defined !");
        }
        this.containerListener = containerListener;
    }
}

