/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.timers.ProxyTimerService;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class ProxyTimerServiceImpl
extends Timer
implements ProxyTimerService {
    private static final Logger logger = Logger.getLogger((String)ProxyTimerServiceImpl.class.getName());
    private AtomicBoolean started = new AtomicBoolean(false);
    private static volatile int numCancelled = 0;

    public ProxyTimerServiceImpl(String applicationName) {
        super(applicationName + "_sip_standard_proxy_timer_service");
        this.schedulePurgeTaskIfNeeded();
    }

    private void schedulePurgeTaskIfNeeded() {
        int purgePeriod = StaticServiceHolder.sipStandardService.getCanceledTimerTasksPurgePeriod();
        if (purgePeriod > 0) {
            TimerTask t = new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Purging canceled timer tasks...");
                        }
                        ProxyTimerServiceImpl.this.purge();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Purging canceled timer tasks completed.");
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"failed to execute purge", (Throwable)e);
                    }
                }
            };
            purgePeriod = purgePeriod * 60 * 1000;
            super.scheduleAtFixedRate(t, purgePeriod, (long)purgePeriod);
        }
    }

    public void cancel(TimerTask task) {
        task.cancel();
        if (++numCancelled % 100 == 0) {
            super.purge();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public void schedule(TimerTask task, long delay) {
        super.schedule(task, delay);
    }

    public void stop() {
        this.started.set(false);
        super.cancel();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Stopped proxy timer service " + this));
        }
    }

    public void start() {
        this.started.set(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started proxy timer service " + this));
        }
    }
}

