/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionEventType;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerTask;

public class StandardSasTimerTask
extends TimerTask
implements SipApplicationSessionTimerTask {
    private static final Logger logger = Logger.getLogger(StandardSasTimerTask.class);
    private MobicentsSipApplicationSession sipApplicationSession;

    public StandardSasTimerTask(MobicentsSipApplicationSession mobicentsSipApplicationSession) {
        this.sipApplicationSession = mobicentsSipApplicationSession;
    }

    @Override
    public void run() {
        try {
            long sleep;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("initial kick off of SipApplicationSessionTimerTask running for sip application session " + this.sipApplicationSession.getId()));
            }
            if ((sleep = this.getDelay()) > 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("expirationTime is " + this.sipApplicationSession.getExpirationTimeInternal() + ", now is " + System.currentTimeMillis() + " sleeping for " + sleep / 1000L + " seconds"));
                }
                SipContext sipContext = this.sipApplicationSession.getSipContext();
                SipApplicationSessionTimerTask expirationTimerTask = sipContext.getSipApplicationSessionTimerService().createSipApplicationSessionTimerTask(this.sipApplicationSession);
                this.sipApplicationSession.setExpirationTimerTask(expirationTimerTask);
                sipContext.getSipApplicationSessionTimerService().schedule(expirationTimerTask, sleep, TimeUnit.MILLISECONDS);
            } else {
                this.tryToExpire();
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Timer problem", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToExpire() {
        SipContext sipContext = this.getSipApplicationSession().getSipContext();
        sipContext.enterSipApp(this.getSipApplicationSession(), null, false, true);
        boolean batchStarted = sipContext.enterSipAppHa(true);
        try {
            this.getSipApplicationSession().setExpirationTimerTask(null);
            this.getSipApplicationSession().notifySipApplicationSessionListeners(SipApplicationSessionEventType.EXPIRATION);
            if (this.getDelay() <= 0L) {
                this.getSipApplicationSession().setExpired(true);
                if (this.getSipApplicationSession().isValidInternal()) {
                    this.getSipApplicationSession().invalidate(true);
                }
            } else if (logger.isDebugEnabled() && this.getSipApplicationSession().getExpirationTimerTask() != null) {
                logger.debug((Object)"expiration timer task is non null so the application has extended the session lifetime directly through setExpires");
            }
        }
        finally {
            sipContext.exitSipAppHa(null, null, batchStarted);
            sipContext.exitSipApp(this.getSipApplicationSession(), null);
            this.setSipApplicationSession(null);
        }
    }

    @Override
    public boolean cancel() {
        return super.cancel();
    }

    public long getDelay() {
        if (this.sipApplicationSession != null) {
            return this.sipApplicationSession.getExpirationTimeInternal() - System.currentTimeMillis();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sipapplicationsession has been nullified, return -1");
        }
        return -1L;
    }

    public void setSipApplicationSession(MobicentsSipApplicationSession sipApplicationSession) {
        this.sipApplicationSession = sipApplicationSession;
    }

    public MobicentsSipApplicationSession getSipApplicationSession() {
        return this.sipApplicationSession;
    }
}

