/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipApplicationSessionAsynchronousWork;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionEventType;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerTask;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class MobicentsSipApplicationSessionFacade
implements MobicentsSipApplicationSession,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MobicentsSipApplicationSessionFacade.class);
    private MobicentsSipApplicationSession sipApplicationSession;

    public MobicentsSipApplicationSessionFacade() {
    }

    public MobicentsSipApplicationSession getMobicentstSipApplicationSession() {
        return this.sipApplicationSession;
    }

    public MobicentsSipApplicationSessionFacade(MobicentsSipApplicationSession sipApplicationSession) {
        this.sipApplicationSession = sipApplicationSession;
    }

    public void access() {
        this.sipApplicationSession.access();
    }

    public boolean addHttpSession(HttpSession httpSession) {
        return this.sipApplicationSession.addHttpSession(httpSession);
    }

    public void addServletTimer(ServletTimer servletTimer) {
        this.sipApplicationSession.addServletTimer(servletTimer);
    }

    public boolean addSipSession(MobicentsSipSession mobicentsSipSession) {
        return this.sipApplicationSession.addSipSession(mobicentsSipSession);
    }

    public HttpSession findHttpSession(String id) {
        return this.sipApplicationSession.findHttpSession(id);
    }

    public String getCurrentRequestHandler() {
        return this.sipApplicationSession.getCurrentRequestHandler();
    }

    public MobicentsSipApplicationSessionKey getKey() {
        return this.sipApplicationSession.getKey();
    }

    public SipContext getSipContext() {
        return this.sipApplicationSession.getSipContext();
    }

    public boolean hasTimerListener() {
        return this.sipApplicationSession.hasTimerListener();
    }

    public boolean isExpired() {
        return this.sipApplicationSession.isExpired();
    }

    public void notifySipApplicationSessionListeners(SipApplicationSessionEventType expiration) {
        this.sipApplicationSession.notifySipApplicationSessionListeners(expiration);
    }

    public void onSipSessionReadyToInvalidate(MobicentsSipSession mobicentsSipSession) {
        this.sipApplicationSession.onSipSessionReadyToInvalidate(mobicentsSipSession);
    }

    public boolean removeHttpSession(HttpSession httpSession) {
        return this.sipApplicationSession.removeHttpSession(httpSession);
    }

    public void removeServletTimer(ServletTimer servletTimer, boolean updateAppSessionReadyToInvalidateState) {
        this.sipApplicationSession.removeServletTimer(servletTimer, updateAppSessionReadyToInvalidateState);
    }

    public void setCurrentRequestHandler(String currentRequestHandler) {
        this.sipApplicationSession.setCurrentRequestHandler(currentRequestHandler);
    }

    public void tryToInvalidate() {
        this.sipApplicationSession.tryToInvalidate();
    }

    public void encodeURI(URI uri) {
        this.sipApplicationSession.encodeURI(uri);
    }

    public URL encodeURL(URL url) {
        return this.sipApplicationSession.encodeURL(url);
    }

    public String getApplicationName() {
        return this.sipApplicationSession.getApplicationName();
    }

    public Object getAttribute(String name) {
        return this.sipApplicationSession.getAttribute(name);
    }

    public Iterator<String> getAttributeNames() {
        return this.sipApplicationSession.getAttributeNames();
    }

    public long getCreationTime() {
        return this.sipApplicationSession.getCreationTime();
    }

    public long getExpirationTime() {
        return this.sipApplicationSession.getExpirationTime();
    }

    public String getId() {
        return this.sipApplicationSession.getId();
    }

    public boolean getInvalidateWhenReady() {
        return this.sipApplicationSession.getInvalidateWhenReady();
    }

    public long getLastAccessedTime() {
        return this.sipApplicationSession.getLastAccessedTime();
    }

    public Object getSession(String id, SipApplicationSession.Protocol protocol) {
        return this.sipApplicationSession.getSession(id, protocol);
    }

    public Iterator<?> getSessions() {
        return this.sipApplicationSession.getSessions();
    }

    public Iterator<?> getSessions(String protocol) {
        return this.sipApplicationSession.getSessions(protocol);
    }

    public SipSession getSipSession(String id) {
        return this.sipApplicationSession.getSipSession(id);
    }

    public ServletTimer getTimer(String id) {
        return this.sipApplicationSession.getTimer(id);
    }

    public Collection<ServletTimer> getTimers() {
        return this.sipApplicationSession.getTimers();
    }

    public void invalidate() {
        this.sipApplicationSession.invalidate();
    }

    public boolean isReadyToInvalidate() {
        return this.sipApplicationSession.isReadyToInvalidate();
    }

    public boolean isValid() {
        return this.sipApplicationSession.isValid();
    }

    public boolean isValidInternal() {
        return this.sipApplicationSession.isValidInternal();
    }

    public void removeAttribute(String name) {
        this.sipApplicationSession.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this.sipApplicationSession.setAttribute(name, attribute);
    }

    public int setExpires(int deltaMinutes) {
        return this.sipApplicationSession.setExpires(deltaMinutes);
    }

    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        this.sipApplicationSession.setInvalidateWhenReady(invalidateWhenReady);
    }

    public MobicentsSipApplicationSession getFacade() {
        return this.sipApplicationSession.getFacade();
    }

    @Override
    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        String sipApplicationSessionId = arg0.readUTF();
        SipApplicationSessionKey key = null;
        try {
            key = SessionManagerUtil.parseSipApplicationSessionKey(sipApplicationSessionId);
        }
        catch (ParseException e) {
            logger.error((Object)("Couldn't parse the following sip application session key " + sipApplicationSessionId), (Throwable)e);
            throw new IllegalArgumentException("Couldn't parse the following sip application session key " + sipApplicationSessionId, e);
        }
        SipContext sipContext = StaticServiceHolder.sipStandardService.getSipApplicationDispatcher().findSipApplication(key.getApplicationName());
        this.sipApplicationSession = sipContext.getSipManager().getSipApplicationSession((MobicentsSipApplicationSessionKey)key, false);
    }

    @Override
    public void writeExternal(ObjectOutput arg0) throws IOException {
        arg0.writeUTF(this.sipApplicationSession.getId());
    }

    public String getJvmRoute() {
        return this.sipApplicationSession.getJvmRoute();
    }

    public void setJvmRoute(String jvmRoute) {
        this.sipApplicationSession.setJvmRoute(jvmRoute);
    }

    public boolean equals(Object obj) {
        return this.sipApplicationSession.equals(obj);
    }

    public int hashCode() {
        return this.sipApplicationSession.hashCode();
    }

    public String toString() {
        return this.sipApplicationSession.toString();
    }

    public void setExpirationTimerTask(SipApplicationSessionTimerTask expirationTimerTask) {
        this.sipApplicationSession.setExpirationTimerTask(expirationTimerTask);
    }

    public void setExpired(boolean hasExpired) {
        this.sipApplicationSession.setExpired(hasExpired);
    }

    public long getExpirationTimeInternal() {
        return this.sipApplicationSession.getExpirationTimeInternal();
    }

    public Set<MobicentsSipSession> getSipSessions(boolean internal) {
        return this.sipApplicationSession.getSipSessions(internal);
    }

    public SipApplicationSessionTimerTask getExpirationTimerTask() {
        return this.sipApplicationSession.getExpirationTimerTask();
    }

    public void scheduleAsynchronousWork(SipApplicationSessionAsynchronousWork work) {
        this.sipApplicationSession.scheduleAsynchronousWork(work);
    }

    public long getSipApplicationSessionTimeout() {
        return this.sipApplicationSession.getSipApplicationSessionTimeout();
    }

    public void invalidate(boolean bypassCheck) {
        this.sipApplicationSession.invalidate(true);
    }

    public void acquire() {
        this.sipApplicationSession.acquire();
    }

    public void release() {
        this.sipApplicationSession.release();
    }

    public boolean isOrphan() {
        return this.sipApplicationSession.isOrphan();
    }

    public void setOrphan(boolean orphan) {
        this.sipApplicationSession.setOrphan(orphan);
    }
}

