/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.proxy;

import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.sip.InvalidArgumentException;
import javax.sip.address.URI;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ReasonHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.proxy.ProxyImpl;

public class ProxyTerminationInfo
implements Externalizable {
    private LinkedList<javax.sip.address.Address> calleeRouteSet;
    private LinkedList<javax.sip.address.Address> callerRouteSet;
    private URI calleeContact;
    private URI callerContact;
    private To toHeader;
    private From fromHeader;
    private static final Logger logger = Logger.getLogger(ProxyTerminationInfo.class);
    private String callId;
    private boolean terminationSent;
    private long callerCSeq;
    private long calleeCSeq = 0L;
    private ProxyImpl proxyImpl;

    public ProxyTerminationInfo() {
        this.callerRouteSet = new LinkedList();
        this.calleeRouteSet = new LinkedList();
    }

    public ProxyTerminationInfo(SipServletResponseImpl proxiedResponse, SipURI recordRouteURI, ProxyImpl proxyImpl) {
        org.mobicents.servlet.sip.address.AddressImpl a;
        ListIterator<Address> i;
        if (proxyImpl == null) {
            throw new NullPointerException("Null proxyImpl");
        }
        if (proxiedResponse == null) {
            throw new NullPointerException("Null message");
        }
        this.proxyImpl = proxyImpl;
        SipServletRequest request = proxiedResponse.getRequest();
        SIPResponse nistResponse = (SIPResponse)proxiedResponse.getResponse();
        SIPRequest nistRequest = (SIPRequest)((SipServletRequestImpl)request).getMessage();
        this.toHeader = (To)nistResponse.getTo();
        this.fromHeader = (From)nistResponse.getFrom();
        this.calleeContact = nistResponse.getContactHeader().getAddress().getURI();
        this.callerContact = nistRequest.getContactHeader().getAddress().getURI();
        this.calleeRouteSet = new LinkedList();
        this.callerRouteSet = new LinkedList();
        this.callId = proxiedResponse.getCallId();
        try {
            i = proxiedResponse.getRequest().getAddressHeaders("Record-Route");
        }
        catch (ServletParseException e) {
            throw new IllegalArgumentException("Couldn't get the RecordRoute Headers from the request " + proxiedResponse.getRequest(), e);
        }
        while (i.hasNext()) {
            a = (org.mobicents.servlet.sip.address.AddressImpl)i.next();
            this.callerRouteSet.add(a.getAddress());
        }
        try {
            i = proxiedResponse.getAddressHeaders("Record-Route");
        }
        catch (ServletParseException e) {
            throw new IllegalArgumentException("Couldn't get the RecordRoute Headers from the response " + proxiedResponse, e);
        }
        while (i.hasNext()) {
            a = i.next();
            if (!a.getURI().equals((Object)recordRouteURI)) continue;
            i.previous();
            break;
        }
        while (i.hasPrevious()) {
            a = (org.mobicents.servlet.sip.address.AddressImpl)i.previous();
            this.calleeRouteSet.add(a.getAddress());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            javax.sip.address.Address route;
            int i;
            this.calleeCSeq = in.readLong();
            this.callerCSeq = in.readLong();
            this.calleeContact = SipFactoryImpl.addressFactory.createURI(in.readUTF());
            this.callerContact = SipFactoryImpl.addressFactory.createURI(in.readUTF());
            int routeSetSize = in.readInt();
            for (i = 0; i < routeSetSize; ++i) {
                route = SipFactoryImpl.addressFactory.createAddress(in.readUTF());
                this.callerRouteSet.add(route);
            }
            routeSetSize = in.readInt();
            for (i = 0; i < routeSetSize; ++i) {
                route = SipFactoryImpl.addressFactory.createAddress(in.readUTF());
                this.calleeRouteSet.add(route);
            }
            javax.sip.address.Address toAddress = SipFactoryImpl.addressFactory.createAddress(in.readUTF());
            this.toHeader = (To)SipFactoryImpl.headerFactory.createToHeader(toAddress, in.readUTF());
            javax.sip.address.Address fromAddress = SipFactoryImpl.addressFactory.createAddress(in.readUTF());
            this.fromHeader = (From)SipFactoryImpl.headerFactory.createFromHeader(fromAddress, in.readUTF());
            this.callId = in.readUTF();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Problem occurred while unserializing ProxyTerminationInfo", e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.calleeCSeq);
        out.writeLong(this.callerCSeq);
        out.writeUTF(this.calleeContact.toString());
        out.writeUTF(this.callerContact.toString());
        out.writeInt(this.calleeRouteSet.size());
        for (javax.sip.address.Address a : this.calleeRouteSet) {
            out.writeUTF(a.toString());
        }
        out.writeInt(this.callerRouteSet.size());
        for (javax.sip.address.Address a : this.callerRouteSet) {
            out.writeUTF(a.toString());
        }
        out.writeUTF(this.toHeader.getAddress().toString());
        out.writeUTF(this.toHeader.getTag());
        out.writeUTF(this.fromHeader.getAddress().toString());
        out.writeUTF(this.fromHeader.getTag());
        out.writeUTF(this.callId);
    }

    public void setProxy(ProxyImpl proxyImpl) {
        this.proxyImpl = proxyImpl;
    }

    private void sendBye(SipSession session, URI requestUri, To to, From from, long cSeq, LinkedList<javax.sip.address.Address> routeSet, int responseCode, String responseText) throws IOException {
        Request request;
        try {
            request = SipFactoryImpl.messageFactory.createRequest(requestUri, "BYE", this.proxyImpl.getSipFactoryImpl().getSipApplicationDispatcher().getCallId(null, this.callId), SipFactoryImpl.headerFactory.createCSeqHeader(cSeq, "BYE"), (FromHeader)from, (ToHeader)to, new ArrayList(), SipFactoryImpl.headerFactory.createMaxForwardsHeader(70));
        }
        catch (ParseException e1) {
            throw new IllegalArgumentException("Problem occurred while creating the Proxy BYE on session " + session + " requestURI = " + requestUri + " From = " + from + " To = " + to + " cSeq " + cSeq + " routeSet = " + routeSet, e1);
        }
        catch (InvalidArgumentException e1) {
            throw new IllegalArgumentException("Problem occurred while creating the Proxy BYE on session " + session + " requestURI = " + requestUri + " From = " + from + " To = " + to + " cSeq " + cSeq + " routeSet = " + routeSet, e1);
        }
        if (responseText != null && responseCode > 299 && responseCode < 700) {
            try {
                ReasonHeader reason = SipFactoryImpl.headerFactory.createReasonHeader("sip", responseCode, responseText);
                ((SIPMessage)request).addHeader((Header)reason);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalArgumentException("Failed to build reason header " + responseCode + ":" + responseText);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Failed to build reason header " + responseCode + ":" + responseText);
            }
        }
        for (javax.sip.address.Address javaxAddress : routeSet) {
            Route routeHeader = new Route((AddressImpl)javaxAddress);
            request.addHeader((Header)routeHeader);
        }
        SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)this.proxyImpl.getSipFactoryImpl().getMobicentsSipServletMessageFactory().createSipServletRequest(request, (MobicentsSipSession)session, null, null, false);
        sipServletRequest.send();
    }

    public void terminate(SipSession session, int calleeResponseCode, String calleeResponseText, int callerResponseCode, String callerResponseText) throws IOException {
        if (this.terminationSent) {
            throw new IllegalStateException("Proxy Termination Already Sent !");
        }
        this.sendBye(session, this.calleeContact, this.toHeader, this.fromHeader, this.callerCSeq + 1L, this.calleeRouteSet, calleeResponseCode, calleeResponseText);
        this.sendBye(session, this.callerContact, new To(this.fromHeader), new From(this.toHeader), this.calleeCSeq + 1L, this.callerRouteSet, callerResponseCode, callerResponseText);
        this.terminationSent = true;
    }

    public boolean isTerminationSent() {
        return this.terminationSent;
    }

    public long getCallerCSeq() {
        return this.callerCSeq;
    }

    public void setCallerCSeq(long callerCSeq) {
        this.callerCSeq = callerCSeq;
    }

    public long getCalleeCSeq() {
        return this.calleeCSeq;
    }

    public void setCalleeCSeq(long calleeCSeq) {
        this.calleeCSeq = calleeCSeq;
    }
}

