/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.proxy;

import gov.nist.javax.sip.header.HeaderFactoryExt;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ims.PathHeader;
import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.util.Iterator;
import java.util.ListIterator;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxyBranch;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class ProxyUtils {
    private static final Logger logger = Logger.getLogger(ProxyUtils.class);
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static Request createProxiedRequest(SipServletRequestImpl originalRequest, ProxyBranchImpl proxyBranch, javax.servlet.sip.URI destination, javax.servlet.sip.SipURI outboundInterface, javax.servlet.sip.SipURI routeRecord, javax.servlet.sip.SipURI path) {
        try {
            String paramName;
            Iterator paramNames;
            String branchId;
            MobicentsSipApplicationSessionKey sipAppKey;
            Request clonedRequest = (Request)originalRequest.getMessage().clone();
            String method = clonedRequest.getMethod();
            ProxyImpl proxy = (ProxyImpl)proxyBranch.getProxy();
            SipFactoryImpl sipFactoryImpl = proxy.getSipFactoryImpl();
            ((MessageExt)clonedRequest).setApplicationData(null);
            String outboundTransport = null;
            RouteHeader rHeader = (RouteHeader)clonedRequest.getHeader("Route");
            if (rHeader != null) {
                String nextApp = ((SipURI)rHeader.getAddress().getURI()).getParameter("appname");
                String serverName = ((SipURI)rHeader.getAddress().getURI()).getParameter("as");
                if (sipFactoryImpl.getSipApplicationDispatcher().getApplicationServerId().equals(serverName) && nextApp != null) {
                    String nextSipAppId = ((SipURI)rHeader.getAddress().getURI()).getParameter("app_id");
                    if (nextApp != null) {
                        sipAppKey = originalRequest.getSipSession().getSipApplicationSession().getKey();
                        String thisApp = sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(sipAppKey.getApplicationName());
                        if (nextApp.equals(thisApp) && nextSipAppId.equals(sipAppKey.getId())) {
                            clonedRequest.removeFirst("Route");
                        }
                        rHeader = (RouteHeader)clonedRequest.getHeader("Route");
                    }
                }
                if (rHeader != null && (outboundTransport = ((SipURI)rHeader.getAddress().getURI()).getTransportParam()) == null) {
                    outboundTransport = "UDP";
                }
            }
            if (outboundTransport == null && clonedRequest.getRequestURI().isSipURI()) {
                outboundTransport = ((SipURI)clonedRequest.getRequestURI()).getTransportParam();
                if (destination != null && destination.isSipURI()) {
                    String destinationTransport = ((javax.servlet.sip.SipURI)destination).getTransportParam();
                    if (outboundTransport == null) {
                        outboundTransport = destinationTransport;
                    } else if (!outboundTransport.equalsIgnoreCase(destinationTransport)) {
                        outboundTransport = destinationTransport;
                    }
                }
            }
            if (outboundTransport == null) {
                String rrHeaderTransport = null;
                if (routeRecord != null) {
                    rrHeaderTransport = routeRecord.getTransportParam();
                }
                outboundTransport = rrHeaderTransport == null ? "UDP" : rrHeaderTransport;
            }
            ((MessageExt)clonedRequest).setApplicationData(outboundTransport);
            Via via = (Via)clonedRequest.getHeader("Via");
            String inboundTransport = via.getTransport();
            if (inboundTransport == null) {
                inboundTransport = "UDP";
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Outbound transport = " + outboundTransport + " inbountTransport = " + inboundTransport));
            }
            if (destination != null) {
                Header route;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("request URI on the request to proxy : " + destination));
                }
                if ((route = clonedRequest.getHeader("Route")) == null || originalRequest.isInitial()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("setting request uri as cloned request has no Route headers: " + destination));
                    }
                    clonedRequest.setRequestURI(((URIImpl)destination).getURI());
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("NOT setting request uri as cloned request has at least one Route header: " + route));
                }
            } else {
                SipConnector sipConnector;
                if (method.equals("CANCEL")) {
                    clonedRequest.removeHeader("Via");
                    clonedRequest.removeHeader("Record-Route");
                }
                if ((sipConnector = StaticServiceHolder.sipStandardService.findSipConnector(outboundTransport)) != null && sipConnector.isUseStaticAddress()) {
                    URI uri = clonedRequest.getRequestURI();
                    if (uri.isSipURI()) {
                        SipURI sipUri = (SipURI)uri;
                        JainSipUtils.optimizeUriForInternalRoutingRequest(sipConnector, sipUri, originalRequest.getSipSession(), sipFactoryImpl, outboundTransport);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("setting request uri as cloned request has no Route headers and is using static address: " + destination));
                    }
                }
            }
            MaxForwardsHeader mf = (MaxForwardsHeader)clonedRequest.getHeader("Max-Forwards");
            if (mf == null) {
                mf = SipFactoryImpl.headerFactory.createMaxForwardsHeader(70);
                clonedRequest.addHeader((Header)mf);
            } else {
                mf.setMaxForwards(mf.getMaxForwards() - 1);
            }
            if (method.equals("CANCEL")) {
                clonedRequest.removeHeader("Via");
            }
            sipAppKey = originalRequest.getSipSession().getSipApplicationSession().getKey();
            String appName = sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(sipAppKey.getApplicationName());
            SipServletRequestImpl proxyBranchMatchingRequest = proxyBranch.getMatchingRequest(originalRequest);
            ViaHeader viaHeader = null;
            if (proxy.getOutboundInterface() == null) {
                branchId = null;
                if ("ACK".equals(method) && proxyBranchMatchingRequest != null && proxyBranchMatchingRequest.getTransaction() != null && proxyBranchMatchingRequest.getTransaction().getState() != TransactionState.TERMINATED) {
                    branchId = proxyBranchMatchingRequest.getTransaction().getBranchId();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("reusing original branch id " + branchId));
                    }
                } else {
                    branchId = JainSipUtils.createBranch(sipAppKey.getId(), appName);
                }
                viaHeader = JainSipUtils.createViaHeader(sipFactoryImpl.getSipNetworkInterfaceManager(), clonedRequest, branchId, null);
            } else {
                branchId = null;
                if (proxy.getOutboundInterface().isSecure()) {
                    outboundTransport = "TLS";
                }
                if ("ACK".equals(method) && proxyBranchMatchingRequest != null && proxyBranchMatchingRequest.getTransaction() != null && proxyBranchMatchingRequest.getTransaction().getState() != TransactionState.TERMINATED) {
                    branchId = proxyBranchMatchingRequest.getTransaction().getBranchId();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("reusing original branch id " + branchId));
                    }
                } else {
                    branchId = JainSipUtils.createBranch(sipAppKey.getId(), appName);
                }
                viaHeader = SipFactoryImpl.headerFactory.createViaHeader(proxy.getOutboundInterface().getHost(), proxy.getOutboundInterface().getPort(), outboundTransport, branchId);
            }
            clonedRequest.addHeader((Header)viaHeader);
            if (clonedRequest.getHeader("Route") == null && clonedRequest.getRequestURI().isSipURI()) {
                SipURI sipURI = (SipURI)clonedRequest.getRequestURI();
                String transportFromURI = sipURI.getTransportParam();
                if (transportFromURI == null) {
                    transportFromURI = "UDP";
                }
                if (!transportFromURI.equalsIgnoreCase(outboundTransport)) {
                    sipURI.setTransportParam(outboundTransport);
                }
            }
            if (routeRecord != null && !"REGISTER".equalsIgnoreCase(method)) {
                RecordRouteHeader recordRouteHeader;
                Address rraddress;
                if (!inboundTransport.equalsIgnoreCase(outboundTransport)) {
                    SipURI inboundRURI = JainSipUtils.createRecordRouteURI(sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)clonedRequest, inboundTransport);
                    if (originalRequest.getTransport() != null) {
                        inboundRURI.setTransportParam(originalRequest.getTransport());
                    }
                    paramNames = routeRecord.getParameterNames();
                    while (paramNames.hasNext()) {
                        paramName = (String)paramNames.next();
                        if (paramName.equalsIgnoreCase("transport")) continue;
                        inboundRURI.setParameter(paramName, routeRecord.getParameter(paramName));
                    }
                    inboundRURI.setParameter("as", sipFactoryImpl.getSipApplicationDispatcher().getApplicationServerId());
                    inboundRURI.setParameter("appname", appName);
                    inboundRURI.setParameter("proxy", "true");
                    inboundRURI.setParameter("app_id", sipAppKey.getId());
                    inboundRURI.setLrParam();
                    rraddress = SipFactoryImpl.addressFactory.createAddress(null, (URI)inboundRURI);
                    recordRouteHeader = SipFactoryImpl.headerFactory.createRecordRouteHeader(rraddress);
                    clonedRequest.addFirst((Header)recordRouteHeader);
                }
                SipURI rrURI = null;
                if (proxy.isAppSpecifiedRecordRoutingEnabled()) {
                    rrURI = ((SipURIImpl)proxy.getRecordRouteURI()).getSipURI();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using Record Route URI specified by application on Proxy " + rrURI));
                    }
                } else if (proxyBranch.isAppSpecifiedRecordRoutingEnabled()) {
                    rrURI = ((SipURIImpl)proxyBranch.getRecordRouteURI()).getSipURI();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using Record Route URI specified by application on ProxyBranch " + rrURI));
                    }
                } else if (proxy.getOutboundInterface() == null) {
                    rrURI = JainSipUtils.createRecordRouteURI(sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)clonedRequest, outboundTransport);
                } else {
                    rrURI = ((SipURIImpl)proxy.getOutboundInterface()).getSipURI();
                    rrURI.setTransportParam(outboundTransport);
                }
                paramNames = routeRecord.getParameterNames();
                while (paramNames.hasNext()) {
                    paramName = (String)paramNames.next();
                    if (paramName.equalsIgnoreCase("transport")) continue;
                    rrURI.setParameter(paramName, routeRecord.getParameter(paramName));
                }
                rrURI.setParameter("as", sipFactoryImpl.getSipApplicationDispatcher().getApplicationServerId());
                rrURI.setParameter("appname", appName);
                rrURI.setParameter("proxy", "true");
                rrURI.setParameter("app_id", sipAppKey.getId());
                rrURI.setLrParam();
                rraddress = SipFactoryImpl.addressFactory.createAddress(null, (URI)rrURI);
                recordRouteHeader = SipFactoryImpl.headerFactory.createRecordRouteHeader(rraddress);
                clonedRequest.addFirst((Header)recordRouteHeader);
            }
            if (path != null && "REGISTER".equalsIgnoreCase(method)) {
                SipURI pathURI = JainSipUtils.createRecordRouteURI(sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)clonedRequest);
                paramNames = path.getParameterNames();
                while (paramNames.hasNext()) {
                    paramName = (String)paramNames.next();
                    if (paramName.equals("lr")) {
                        pathURI.setParameter(paramName, null);
                        continue;
                    }
                    pathURI.setParameter(paramName, path.getParameter(paramName));
                }
                Address pathAddress = SipFactoryImpl.addressFactory.createAddress(null, (URI)pathURI);
                PathHeader pathHeader = ((HeaderFactoryExt)SipFactoryImpl.headerFactory).createPathHeader(pathAddress);
                clonedRequest.addFirst((Header)pathHeader);
            }
            ((SIPMessage)clonedRequest).setApplicationData((Object)outboundTransport);
            return clonedRequest;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while creating the proxied request for message " + originalRequest.getMessage(), e);
        }
    }

    public static SipServletResponseImpl createProxiedResponse(MobicentsSipServletResponse sipServetResponse, MobicentsProxyBranch proxyBranch) {
        Response response = (Response)sipServetResponse.getMessage();
        Response clonedResponse = (Response)response.clone();
        ((MessageExt)clonedResponse).setApplicationData(null);
        Transaction transaction = sipServetResponse.getTransaction();
        int status = response.getStatusCode();
        if (transaction != null && ((SIPTransaction)transaction).getMethod().equals("INVITE")) {
            if (100 == status) {
                proxyBranch.cancel1xxTimer();
            }
            if (100 < status && status < 200) {
                proxyBranch.updateTimer(true, sipServetResponse.getSipApplicationSession(false));
            } else if (status >= 200) {
                proxyBranch.cancel1xxTimer();
                proxyBranch.cancelTimer();
            }
        }
        ListIterator viaHeaderIt = clonedResponse.getHeaders("Via");
        viaHeaderIt.next();
        viaHeaderIt.remove();
        if (!viaHeaderIt.hasNext()) {
            return null;
        }
        ProxyImpl proxy = (ProxyImpl)proxyBranch.getProxy();
        SipFactoryImpl sipFactoryImpl = proxy.getSipFactoryImpl();
        SipServletRequestImpl originalRequest = (SipServletRequestImpl)proxy.getOriginalRequest();
        if ("PRACK".equals(sipServetResponse.getMethod())) {
            originalRequest = (SipServletRequestImpl)proxyBranch.getPrackOriginalRequest();
        }
        SipServletResponseImpl newServletResponseImpl = null;
        newServletResponseImpl = transaction != null && originalRequest != null ? (SipServletResponseImpl)sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletResponse(clonedResponse, originalRequest.getTransaction(), originalRequest.getSipSession(), sipServetResponse.getDialog(), false, sipServetResponse.isRetransmission()) : (SipServletResponseImpl)sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletResponse(clonedResponse, null, sipServetResponse.getSipSession(), sipServetResponse.getDialog(), false, sipServetResponse.isRetransmission());
        newServletResponseImpl.setOriginalRequest(originalRequest);
        newServletResponseImpl.setProxiedResponse(true);
        return newServletResponseImpl;
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }
}

