/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.address;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.log4j.Logger;

public class RFC2396UrlDecoder {
    private static final String UTF_8 = "UTF-8";
    static final BitSet CHARACHTERS_DONT_NEED_ECNODING;
    static final int CHARACTER_CASE_DIFF = 32;
    private static final Logger logger;
    private static final char UTF8_ESCAPE_CHAR = '%';

    public static String encode(String s) {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (CHARACHTERS_DONT_NEED_ECNODING.get(c)) {
                out.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    public static String decode(String uri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("uri to decode " + uri));
        }
        if (uri == null) {
            return null;
        }
        if (uri.indexOf(37) < 0) {
            return uri;
        }
        StringBuffer translatedUri = new StringBuffer(uri.length());
        byte[] encodedchars = new byte[uri.length() / 3];
        int i = 0;
        int length = uri.length();
        int encodedcharsLength = 0;
        while (i < length) {
            if (uri.charAt(i) == '%') {
                while (i < length && uri.charAt(i) == '%') {
                    if (i + 2 >= length) continue;
                    try {
                        byte x;
                        encodedchars[encodedcharsLength] = x = (byte)Integer.parseInt(uri.substring(i + 1, i + 3), 16);
                    }
                    catch (NumberFormatException x) {
                        // empty catch block
                    }
                    ++encodedcharsLength;
                    i += 3;
                }
                try {
                    String translatedPart = new String(encodedchars, 0, encodedcharsLength, UTF_8);
                    translatedUri.append(translatedPart);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Problem in decodePath: UTF-8 encoding not supported.");
                }
                encodedcharsLength = 0;
                continue;
            }
            translatedUri.append(uri.charAt(i));
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("decoded uri " + translatedUri));
        }
        return translatedUri.toString();
    }

    static {
        int i;
        logger = Logger.getLogger((String)RFC2396UrlDecoder.class.getCanonicalName());
        CHARACHTERS_DONT_NEED_ECNODING = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            CHARACHTERS_DONT_NEED_ECNODING.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            CHARACHTERS_DONT_NEED_ECNODING.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            CHARACHTERS_DONT_NEED_ECNODING.set(i);
        }
        CHARACHTERS_DONT_NEED_ECNODING.set(45);
        CHARACHTERS_DONT_NEED_ECNODING.set(95);
        CHARACHTERS_DONT_NEED_ECNODING.set(46);
        CHARACHTERS_DONT_NEED_ECNODING.set(42);
        CHARACHTERS_DONT_NEED_ECNODING.set(34);
    }
}

