/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.core.HopImpl;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipContextEvent;
import org.mobicents.servlet.sip.core.SipContextEventImpl;
import org.mobicents.servlet.sip.core.SipContextEventType;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.utils.Inet6Util;

public class SipNetworkInterfaceManagerImpl
implements SipNetworkInterfaceManager {
    private static final Logger logger = Logger.getLogger(SipNetworkInterfaceManagerImpl.class);
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_PORT_NUMBER = 1024;
    Set<MobicentsExtendedListeningPoint> extendedListeningPointList = null;
    List<javax.servlet.sip.SipURI> outboundInterfaces = null;
    Set<String> outboundInterfacesIpAddresses = null;
    private SipApplicationDispatcher sipApplicationDispatcher;
    Map<String, Set<MobicentsExtendedListeningPoint>> transportMappingCacheMap = null;
    Map<String, MobicentsExtendedListeningPoint> extendedListeningPointsCacheMap = null;
    Lock lock = null;

    public SipNetworkInterfaceManagerImpl(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
        this.extendedListeningPointList = new CopyOnWriteArraySet<MobicentsExtendedListeningPoint>();
        this.outboundInterfaces = new CopyOnWriteArrayList<javax.servlet.sip.SipURI>();
        this.outboundInterfacesIpAddresses = new CopyOnWriteArraySet<String>();
        this.transportMappingCacheMap = new HashMap<String, Set<MobicentsExtendedListeningPoint>>();
        this.transportMappingCacheMap.put("TCP".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("UDP".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("SCTP".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("TLS".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("WS".toLowerCase(), new CopyOnWriteArraySet());
        this.transportMappingCacheMap.put("WSS".toLowerCase(), new CopyOnWriteArraySet());
        this.extendedListeningPointsCacheMap = new ConcurrentHashMap<String, MobicentsExtendedListeningPoint>();
        this.lock = new ReentrantLock();
    }

    public Iterator<MobicentsExtendedListeningPoint> getExtendedListeningPoints() {
        return this.extendedListeningPointList.iterator();
    }

    public void addExtendedListeningPoint(MobicentsExtendedListeningPoint extendedListeningPoint) {
        this.extendedListeningPointList.add(extendedListeningPoint);
        this.computeOutboundInterfaces();
        Set<MobicentsExtendedListeningPoint> extendedListeningPoints = this.transportMappingCacheMap.get(extendedListeningPoint.getTransport().toLowerCase());
        boolean added = extendedListeningPoints.add(extendedListeningPoint);
        if (added) {
            if (this.sipApplicationDispatcher.getDNSServerLocator() != null) {
                this.sipApplicationDispatcher.getDNSServerLocator().addSupportedTransport(extendedListeningPoint.getTransport());
            }
            for (String ipAddress : extendedListeningPoint.getIpAddresses()) {
                this.extendedListeningPointsCacheMap.put(ipAddress + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase(), extendedListeningPoint);
            }
            if (extendedListeningPoint.getGlobalIpAddress() != null) {
                this.extendedListeningPointsCacheMap.put(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase(), extendedListeningPoint);
                this.extendedListeningPointsCacheMap.put(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getGlobalPort() + ":" + extendedListeningPoint.getTransport().toLowerCase(), extendedListeningPoint);
            }
            if (extendedListeningPoint.getSipConnector().getHostNames() != null) {
                StringTokenizer tokenizer = new StringTokenizer(extendedListeningPoint.getSipConnector().getHostNames(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String localHostName = tokenizer.nextToken();
                    this.extendedListeningPointsCacheMap.put(localHostName + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase(), extendedListeningPoint);
                    if (this.sipApplicationDispatcher.getDNSServerLocator() == null) continue;
                    this.sipApplicationDispatcher.getDNSServerLocator().mapLocalHostNameToIP(localHostName, new CopyOnWriteArraySet(extendedListeningPoint.getIpAddresses()));
                }
            }
            Iterator sipContextIterator = this.sipApplicationDispatcher.findSipApplications();
            while (sipContextIterator.hasNext()) {
                SipContext sipContext = (SipContext)sipContextIterator.next();
                sipContext.notifySipContextListeners((SipContextEvent)new SipContextEventImpl(SipContextEventType.SIP_CONNECTOR_ADDED, extendedListeningPoint.getSipConnector()));
            }
        }
    }

    public void removeExtendedListeningPoint(MobicentsExtendedListeningPoint extendedListeningPoint) {
        if (this.extendedListeningPointList.contains(extendedListeningPoint)) {
            Iterator sipContextIterator = this.sipApplicationDispatcher.findSipApplications();
            while (sipContextIterator.hasNext()) {
                SipContext sipContext = (SipContext)sipContextIterator.next();
                sipContext.notifySipContextListeners((SipContextEvent)new SipContextEventImpl(SipContextEventType.SIP_CONNECTOR_REMOVED, extendedListeningPoint.getSipConnector()));
            }
            this.extendedListeningPointList.remove(extendedListeningPoint);
            this.computeOutboundInterfaces();
            Set<MobicentsExtendedListeningPoint> extendedListeningPoints = this.transportMappingCacheMap.get(extendedListeningPoint.getTransport().toLowerCase());
            extendedListeningPoints.remove(extendedListeningPoint);
            if (this.sipApplicationDispatcher.getDNSServerLocator() != null) {
                this.sipApplicationDispatcher.getDNSServerLocator().removeSupportedTransport(extendedListeningPoint.getTransport());
            }
            for (String ipAddress : extendedListeningPoint.getIpAddresses()) {
                this.extendedListeningPointsCacheMap.remove(ipAddress + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase());
            }
            if (extendedListeningPoint.getGlobalIpAddress() != null) {
                this.extendedListeningPointsCacheMap.remove(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase());
                this.extendedListeningPointsCacheMap.remove(extendedListeningPoint.getGlobalIpAddress() + "/" + extendedListeningPoint.getGlobalPort() + ":" + extendedListeningPoint.getTransport().toLowerCase());
            }
            if (extendedListeningPoint.getSipConnector().getHostNames() != null) {
                StringTokenizer tokenizer = new StringTokenizer(extendedListeningPoint.getSipConnector().getHostNames(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String localHostName = tokenizer.nextToken();
                    this.extendedListeningPointsCacheMap.remove(localHostName + "/" + extendedListeningPoint.getPort() + ":" + extendedListeningPoint.getTransport().toLowerCase());
                    if (this.sipApplicationDispatcher.getDNSServerLocator() == null) continue;
                    this.sipApplicationDispatcher.getDNSServerLocator().unmapLocalHostNameToIP(localHostName);
                }
            }
        }
    }

    public MobicentsExtendedListeningPoint findMatchingListeningPoint(String transport, boolean strict) {
        Set<MobicentsExtendedListeningPoint> extendedListeningPoints;
        String tmpTransport = transport;
        if (tmpTransport == null) {
            tmpTransport = "UDP";
        }
        if ((extendedListeningPoints = this.transportMappingCacheMap.get(tmpTransport.toLowerCase())).size() > 0) {
            MobicentsExtendedListeningPoint extendedListeningPoint = extendedListeningPoints.iterator().next();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Found first listening point " + extendedListeningPoint + " with transport " + transport));
            }
            return extendedListeningPoint;
        }
        if (strict) {
            return null;
        }
        if (this.extendedListeningPointList.size() > 0) {
            MobicentsExtendedListeningPoint extendedListeningPoint = this.extendedListeningPointList.iterator().next();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Found first listening point " + extendedListeningPoint + " with transport " + transport));
            }
            return extendedListeningPoint;
        }
        throw new RuntimeException("no valid sip connectors could be found to create the sip application session !!!");
    }

    public MobicentsExtendedListeningPoint findMatchingListeningPoint(SipURI outboundInterface, boolean strict) {
        Set<MobicentsExtendedListeningPoint> extendedListeningPoints;
        String tmpTransport;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Trying to find listening point corresponding to outbound interface " + outboundInterface + " in strict manner " + strict));
        }
        if ((tmpTransport = outboundInterface.getTransportParam()) == null) {
            tmpTransport = outboundInterface.isSecure() ? "TCP" : "UDP";
        }
        if ((extendedListeningPoints = this.transportMappingCacheMap.get(tmpTransport.toLowerCase())).size() > 0) {
            for (MobicentsExtendedListeningPoint extendedListeningPoint : extendedListeningPoints) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Comparing listening point " + extendedListeningPoint + " with outbound ipaddress " + outboundInterface.getHost() + " and port " + outboundInterface.getPort()));
                }
                if (!extendedListeningPoint.getIpAddresses().contains(outboundInterface.getHost()) || extendedListeningPoint.getPort() != outboundInterface.getPort()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found listening point " + extendedListeningPoint));
                }
                return extendedListeningPoint;
            }
        }
        if (strict) {
            return null;
        }
        if (this.extendedListeningPointList.size() > 0) {
            for (MobicentsExtendedListeningPoint extendedListeningPoint : extendedListeningPoints) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Comparing listening point " + extendedListeningPoint + " with outbound ipaddress " + outboundInterface.getHost() + " and port " + outboundInterface.getPort()));
                }
                if (!extendedListeningPoint.getIpAddresses().contains(outboundInterface.getHost()) || extendedListeningPoint.getPort() != outboundInterface.getPort()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found listening point " + extendedListeningPoint));
                }
                return extendedListeningPoint;
            }
            throw new RuntimeException("no valid sip connectors could be found to create the sip application session !!!");
        }
        throw new RuntimeException("no valid sip connectors could be found to create the sip application session !!!");
    }

    public MobicentsExtendedListeningPoint findMatchingListeningPoint(String ipAddress, int port, String transport) {
        String tmpTransport = transport;
        int portChecked = SipNetworkInterfaceManagerImpl.checkPortRange(port, tmpTransport);
        if (tmpTransport == null) {
            tmpTransport = "UDP";
        }
        MobicentsExtendedListeningPoint listeningPoint = this.extendedListeningPointsCacheMap.get(ipAddress + "/" + portChecked + ":" + tmpTransport.toLowerCase());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checked Listening Point " + ipAddress + "/" + portChecked + ":" + tmpTransport.toLowerCase() + " against existing listening points, found " + listeningPoint));
        }
        if (listeningPoint == null && !Inet6Util.isValidIP6Address(ipAddress) && !Inet6Util.isValidIPV4Address(ipAddress)) {
            Collection hops = null;
            try {
                hops = this.sipApplicationDispatcher.getDNSServerLocator().getDnsLookupPerformer().locateHopsForNonNumericAddressWithPort(ipAddress, portChecked, tmpTransport.toLowerCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (hops != null) {
                for (Hop hop : hops) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Checking Hop " + hop.getHost() + "/" + portChecked + ":" + tmpTransport.toLowerCase() + " against existing listening points"));
                    }
                    if ((listeningPoint = this.extendedListeningPointsCacheMap.get(hop.getHost() + "/" + portChecked + ":" + tmpTransport.toLowerCase())) == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found listening point " + listeningPoint));
                    }
                    return listeningPoint;
                }
            }
        }
        return listeningPoint;
    }

    public static int checkPortRange(int port, String transport) {
        if (port < 1024 || port > 65535) {
            if ("TLS".equalsIgnoreCase(transport)) {
                return 5061;
            }
            return 5060;
        }
        return port;
    }

    public List<javax.servlet.sip.SipURI> getOutboundInterfaces() {
        return Collections.unmodifiableList(this.outboundInterfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeOutboundInterfaces() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Outbound Interface List : ");
        }
        CopyOnWriteArrayList<javax.servlet.sip.SipURI> newlyComputedOutboundInterfaces = new CopyOnWriteArrayList<javax.servlet.sip.SipURI>();
        CopyOnWriteArraySet<String> newlyComputedOutboundInterfacesIpAddresses = new CopyOnWriteArraySet<String>();
        Iterator<MobicentsExtendedListeningPoint> it = this.getExtendedListeningPoints();
        while (it.hasNext()) {
            MobicentsExtendedListeningPoint extendedListeningPoint = it.next();
            for (String ipAddress : extendedListeningPoint.getIpAddresses()) {
                try {
                    newlyComputedOutboundInterfacesIpAddresses.add(ipAddress);
                    SipURI jainSipURI = SipFactoryImpl.addressFactory.createSipURI(null, ipAddress);
                    jainSipURI.setPort(extendedListeningPoint.getPort());
                    jainSipURI.setTransportParam(extendedListeningPoint.getTransport());
                    SipURIImpl sipURI = new SipURIImpl(jainSipURI, AddressImpl.ModifiableRule.NotModifiable);
                    newlyComputedOutboundInterfaces.add(sipURI);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Outbound Interface : " + jainSipURI));
                }
                catch (ParseException e) {
                    logger.error((Object)("cannot add the following listening point " + ipAddress + ":" + extendedListeningPoint.getPort() + ";transport=" + extendedListeningPoint.getTransport() + " to the outbound interfaces"), (Throwable)e);
                }
            }
        }
        this.lock.lock();
        try {
            this.outboundInterfaces = newlyComputedOutboundInterfaces;
            this.outboundInterfacesIpAddresses = newlyComputedOutboundInterfacesIpAddresses;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean findUsePublicAddress(Message message) {
        boolean usePublicAddress = true;
        String host = null;
        int port = -1;
        String transport = JainSipUtils.findTransport(message);
        if (message instanceof Request) {
            Request request = (Request)message;
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            URI uri = null;
            uri = routeHeader != null ? routeHeader.getAddress().getURI() : request.getRequestURI();
            if (uri instanceof SipURI) {
                SipURI sipUri = (SipURI)uri;
                host = sipUri.getHost();
                port = sipUri.getPort();
            }
        } else {
            ViaHeader topmostViaHeader = (ViaHeader)message.getHeader("Via");
            if (topmostViaHeader != null) {
                host = topmostViaHeader.getHost();
                port = topmostViaHeader.getPort();
            }
        }
        if (host != null) {
            if (Inet6Util.isValidIP6Address(host)) {
                usePublicAddress = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("host " + host + " is a numeric IPV6 address, " + "no DNS SRV lookup to be done and no need for STUN"));
                }
            } else if (Inet6Util.isValidIPV4Address(host)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("host " + host + " is a numeric IPV4 address, " + "no DNS SRV lookup to be done"));
                }
                usePublicAddress = !SipNetworkInterfaceManagerImpl.isIPAddressPartOfPrivateNetwork(host);
            } else {
                Hop lookedupHop;
                logger.debug((Object)("host " + host + " is a hostname, " + "doing DNS A + AAAA lookup"));
                HopImpl hop = new HopImpl(host, port, transport);
                Collection hops = null;
                try {
                    hops = this.sipApplicationDispatcher.getDNSServerLocator().getDnsLookupPerformer().locateHopsForNonNumericAddressWithPort(host, port, transport);
                }
                catch (Exception uri) {
                    // empty catch block
                }
                if (hops != null && hops.size() > 0 && !hop.equals(lookedupHop = (Hop)hops.peek())) {
                    boolean bl = usePublicAddress = !SipNetworkInterfaceManagerImpl.isIPAddressPartOfPrivateNetwork(lookedupHop.getHost());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("STUN enabled : use public adress " + usePublicAddress + " for following host " + host));
        }
        return usePublicAddress;
    }

    public static boolean isIPAddressPartOfPrivateNetwork(String ipAddress) {
        int addressOutboundness = JainSipUtils.getAddressOutboundness(ipAddress);
        if (addressOutboundness < 4) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("host " + ipAddress + " is part of a private network we will not use the public address resolved by STUN"));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("host " + ipAddress + " is not part of a private network we will use the public address resolved by STUN"));
        }
        return false;
    }
}

