/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import gov.nist.javax.sip.ServerTransactionExt;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.message.MessageExt;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionActivationListener;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.header.AuthenticationInfoHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.javax.servlet.sip.SipSessionAsynchronousWork;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsSipServlet;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipListeners;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.b2bua.MobicentsB2BUAHelper;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.security.MobicentsSipSessionSecurity;
import org.mobicents.servlet.sip.core.security.SipPrincipal;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipSessionAsyncTask;
import org.mobicents.servlet.sip.core.session.SipSessionEventType;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionSecurity;
import org.mobicents.servlet.sip.message.B2buaHelperImpl;
import org.mobicents.servlet.sip.message.MobicentsSipSessionFacade;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.notification.SessionActivationNotificationCause;
import org.mobicents.servlet.sip.notification.SipSessionActivationEvent;
import org.mobicents.servlet.sip.proxy.ProxyImpl;

public class SipSessionImpl
implements MobicentsSipSession {
    private static final Logger logger = Logger.getLogger(SipSessionImpl.class);
    protected transient MobicentsSipApplicationSessionKey sipApplicationSessionKey;
    protected transient MobicentsSipApplicationSession sipApplicationSession;
    protected ProxyImpl proxy;
    protected B2buaHelperImpl b2buaHelper;
    protected transient int requestsPending;
    protected volatile Map<String, Object> sipSessionAttributeMap;
    protected transient SipSessionKey key;
    protected transient SipPrincipal userPrincipal;
    protected long cseq = -1L;
    protected String transport;
    protected long creationTime;
    protected long lastAccessedTime;
    protected transient SipApplicationRoutingRegion routingRegion;
    protected transient Serializable stateInfo;
    protected transient SipApplicationRouterInfo nextSipApplicationRouterInfo;
    protected SipSession.State state;
    protected AtomicBoolean isValidInternal;
    protected transient boolean isValid;
    protected String handlerServlet;
    protected transient String subscriberURI;
    protected transient String outboundInterface;
    protected transient Dialog sessionCreatingDialog;
    protected transient SipServletRequestImpl sessionCreatingTransactionRequest;
    protected transient boolean isSessionCreatingTransactionServer;
    protected transient Set<Transaction> ongoingTransactions;
    protected volatile transient ConcurrentHashMap<String, MobicentsSipSession> derivedSipSessions;
    protected transient SipFactoryImpl sipFactory;
    protected boolean invalidateWhenReady = true;
    protected boolean readyToInvalidate = false;
    protected transient MobicentsSipSession parentSession = null;
    protected transient Address localParty = null;
    protected transient Address remoteParty = null;
    protected volatile transient Set<String> subscriptions = null;
    protected transient String originalMethod = null;
    protected transient boolean okToByeSentOrReceived = false;
    protected transient boolean copyRecordRouteHeadersOnSubsequentResponses = false;
    protected transient Semaphore semaphore;
    protected transient MobicentsSipSessionFacade facade = null;
    protected transient ConcurrentHashMap<Long, Boolean> acksReceived = new ConcurrentHashMap(2);
    protected transient MobicentsSipSessionSecurity sipSessionSecurity;
    private javax.sip.address.SipURI flow;
    private boolean bypassLoadBalancer = false;
    private boolean bypassProxy = false;
    protected boolean orphan = false;

    protected SipSessionImpl(SipSessionKey key, SipFactoryImpl sipFactoryImpl, MobicentsSipApplicationSession mobicentsSipApplicationSession) {
        this.key = key;
        this.setSipApplicationSession(mobicentsSipApplicationSession);
        this.sipFactory = sipFactoryImpl;
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
        this.state = SipSession.State.INITIAL;
        this.isValidInternal = new AtomicBoolean(true);
        this.isValid = true;
        this.ongoingTransactions = new CopyOnWriteArraySet<Transaction>();
        if (mobicentsSipApplicationSession.getSipContext() != null && ConcurrencyControlMode.SipSession.equals((Object)mobicentsSipApplicationSession.getSipContext().getConcurrencyControlMode())) {
            this.semaphore = new Semaphore(1);
        }
    }

    public void notifySipSessionListeners(SipSessionEventType sipSessionEventType) {
        SipContext sipContext;
        List sipSessionListeners;
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession();
        if (sipApplicationSession != null && (sipSessionListeners = (sipContext = sipApplicationSession.getSipContext()).getListeners().getSipSessionListeners()).size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notifying sip session listeners of context " + sipContext.getApplicationName() + " of following event " + (Object)((Object)sipSessionEventType)));
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            sipContext.enterSipContext();
            SipSessionEvent sipSessionEvent = new SipSessionEvent((SipSession)this.getFacade());
            for (SipSessionListener sipSessionListener : sipSessionListeners) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying sip session listener " + sipSessionListener.getClass().getName() + " of context " + this.key.getApplicationName() + " of following event " + (Object)((Object)sipSessionEventType)));
                    }
                    if (SipSessionEventType.CREATION.equals((Object)sipSessionEventType)) {
                        sipSessionListener.sessionCreated(sipSessionEvent);
                        continue;
                    }
                    if (SipSessionEventType.DELETION.equals((Object)sipSessionEventType)) {
                        sipSessionListener.sessionDestroyed(sipSessionEvent);
                        continue;
                    }
                    if (!SipSessionEventType.READYTOINVALIDATE.equals((Object)sipSessionEventType)) continue;
                    sipSessionListener.sessionReadyToInvalidate(sipSessionEvent);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionListener threw exception", t);
                }
            }
            sipContext.exitSipContext(oldClassLoader);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SipServletRequest createRequest(String method) {
        if (method.equalsIgnoreCase("ACK") || method.equalsIgnoreCase("PRACK") || method.equalsIgnoreCase("CANCEL")) {
            throw new IllegalArgumentException("Can not create ACK, PRACK or CANCEL requests with this method");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("cannot create a subsequent request " + method + " because the session " + this.key + " is invalid");
        }
        if (SipSession.State.TERMINATED.equals((Object)this.state)) {
            throw new IllegalStateException("cannot create a subsequent request " + method + " because the session " + this.key + " is in TERMINATED state");
        }
        if (this.proxy != null) {
            throw new IllegalStateException("cannot create a subsequent request " + method + " because the session " + this.key + " has been used for proxying. See JSR289 Section 6.2.2.1.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dialog associated with this session to create the new request " + method + " within that dialog " + this.sessionCreatingDialog));
            if (this.sessionCreatingDialog != null) {
                logger.debug((Object)("dialog state " + this.sessionCreatingDialog.getState() + " for that dialog " + this.sessionCreatingDialog));
            }
        }
        SipServletRequestImpl sipServletRequest = null;
        if (this.sessionCreatingDialog != null && DialogState.TERMINATED.equals((Object)this.sessionCreatingDialog.getState()) && !method.equalsIgnoreCase("BYE") && (this.sessionCreatingTransactionRequest == null || this.sessionCreatingTransactionRequest.getLastFinalResponse() == null || this.sessionCreatingTransactionRequest.getLastFinalResponse().getStatus() != 401 && this.sessionCreatingTransactionRequest.getLastFinalResponse().getStatus() != 407 && this.sessionCreatingTransactionRequest.getLastFinalResponse().getStatus() != 422)) {
            throw new IllegalStateException("cannot create a subsequent request " + method + " because the dialog " + this.sessionCreatingDialog + " for session " + this.key + " is in TERMINATED state");
        }
        if (this.sessionCreatingDialog != null && (!DialogState.TERMINATED.equals((Object)this.sessionCreatingDialog.getState()) || DialogState.TERMINATED.equals((Object)this.sessionCreatingDialog.getState()) && method.equalsIgnoreCase("BYE"))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dialog " + this.sessionCreatingDialog + " used to create the new request " + method));
            }
            try {
                ListIterator viaHeaders;
                Request methodRequest = this.sessionCreatingDialog.createRequest(method);
                if (methodRequest.getHeader("Contact") != null) {
                    try {
                        ContactHeader contactHeader = null;
                        FromHeader from = (FromHeader)methodRequest.getHeader("From");
                        String displayName = from.getAddress().getDisplayName();
                        String userName = null;
                        javax.sip.address.URI uri = from.getAddress().getURI();
                        if (uri.isSipURI()) {
                            userName = ((javax.sip.address.SipURI)uri).getUser();
                        }
                        if (this.sipFactory.isUseLoadBalancer()) {
                            MobicentsExtendedListeningPoint listeningPoint = JainSipUtils.findListeningPoint(this.sipFactory.getSipNetworkInterfaceManager(), methodRequest, this.outboundInterface);
                            if (listeningPoint != null && listeningPoint.isUseLoadBalancer()) {
                                SipLoadBalancer loadBalancerToUse = null;
                                if (listeningPoint.getLoadBalancer() == null) {
                                    loadBalancerToUse = this.sipFactory.getLoadBalancerToUse();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Using listeningPoint " + listeningPoint + " for global load balancer " + this.sipFactory.getLoadBalancerToUse()));
                                    }
                                } else {
                                    loadBalancerToUse = listeningPoint.getLoadBalancer();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Using listeningPoint " + listeningPoint + " for connector specific load balancer " + listeningPoint.getLoadBalancer()));
                                    }
                                }
                                javax.sip.address.SipURI sipURI = SipFactoryImpl.addressFactory.createSipURI(userName, loadBalancerToUse.getAddress().getHostAddress());
                                sipURI.setHost(loadBalancerToUse.getAddress().getHostAddress());
                                sipURI.setPort(loadBalancerToUse.getSipPort());
                                sipURI.setTransportParam("UDP");
                                javax.sip.address.Address contactAddress = SipFactoryImpl.addressFactory.createAddress((javax.sip.address.URI)sipURI);
                                contactHeader = SipFactoryImpl.headerFactory.createContactHeader(contactAddress);
                            } else {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Not Using load balancer as it is not enabled for listeningPoint " + listeningPoint));
                                }
                                contactHeader = JainSipUtils.createContactHeader(this.sipFactory.getSipNetworkInterfaceManager(), methodRequest, displayName, userName, this.outboundInterface);
                            }
                        } else {
                            contactHeader = JainSipUtils.createContactHeader(this.sipFactory.getSipNetworkInterfaceManager(), methodRequest, displayName, userName, this.outboundInterface);
                        }
                        methodRequest.setHeader((Header)contactHeader);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Can not create contact header for subsequent request " + method + " for session " + this.key), (Throwable)e);
                    }
                }
                if ((viaHeaders = methodRequest.getHeaders("Via")) != null && viaHeaders.hasNext()) {
                    ViaHeader viaHeader = (ViaHeader)viaHeaders.next();
                    ((MessageExt)methodRequest).setApplicationData((Object)viaHeader.getTransport());
                }
                methodRequest.removeHeader("Via");
                SipApplicationDispatcher sipApplicationDispatcher = this.sipFactory.getSipApplicationDispatcher();
                String branch = JainSipUtils.createBranch(this.getSipApplicationSession().getKey().getId(), sipApplicationDispatcher.getHashFromApplicationName(this.getKey().getApplicationName()));
                ViaHeader viaHeader = JainSipUtils.createViaHeader(this.sipFactory.getSipNetworkInterfaceManager(), methodRequest, branch, this.outboundInterface);
                methodRequest.addHeader((Header)viaHeader);
                sipServletRequest = (SipServletRequestImpl)this.sipFactory.getMobicentsSipServletMessageFactory().createSipServletRequest(methodRequest, (MobicentsSipSession)this, null, this.sessionCreatingDialog, false);
            }
            catch (SipException e) {
                logger.error((Object)("Cannot create the " + method + " request from the dialog " + this.sessionCreatingDialog), (Throwable)e);
                throw new IllegalArgumentException("Cannot create the " + method + " request from the dialog " + this.sessionCreatingDialog + " for sip session " + this.key, e);
            }
        }
        boolean treatAsInitialRequest = false;
        if (this.sessionCreatingTransactionRequest != null && this.sessionCreatingTransactionRequest.getLastFinalResponse() != null && this.sessionCreatingTransactionRequest.getLastFinalResponse().getStatus() >= 400 && this.sessionCreatingTransactionRequest.getLastFinalResponse().getStatus() < 500) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Treating as Initial Request");
            }
            treatAsInitialRequest = true;
        }
        if (this.sessionCreatingTransactionRequest != null) {
            if (!this.isSessionCreatingTransactionServer) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("orignal tx for creating susbequent request " + method + " on session " + this.key + " was a Client Tx"));
                }
                Request request = (Request)this.sessionCreatingTransactionRequest.getMessage().clone();
                javax.sip.address.URI requestUri = (javax.sip.address.URI)request.getRequestURI().clone();
                try {
                    request.setMethod(method);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Unexpected exception happened on setting method " + method, e);
                }
                request.setRequestURI(requestUri);
                ((MessageExt)request).setApplicationData(null);
                CSeqHeader cSeqHeader = (CSeqHeader)request.getHeader("CSeq");
                try {
                    cSeqHeader.setSeqNumber(cSeqHeader.getSeqNumber() + 1L);
                    cSeqHeader.setMethod(method);
                }
                catch (InvalidArgumentException e) {
                    logger.error((Object)("Cannot increment the Cseq header to the new " + method + " on the susbequent request to create on session " + this.key), (Throwable)e);
                    throw new IllegalArgumentException("Cannot create the " + method + " on the susbequent request to create on session " + this.key, e);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot set the " + method + " on the susbequent request to create on session " + this.key, e);
                }
                ListIterator viaHeaders = request.getHeaders("Via");
                if (viaHeaders != null && viaHeaders.hasNext()) {
                    ViaHeader viaHeader = (ViaHeader)viaHeaders.next();
                    ((MessageExt)request).setApplicationData((Object)viaHeader.getTransport());
                }
                request.removeHeader("Via");
                SipNetworkInterfaceManager sipNetworkInterfaceManager = this.sipFactory.getSipNetworkInterfaceManager();
                SipProvider sipProvider = sipNetworkInterfaceManager.findMatchingListeningPoint(JainSipUtils.findTransport((Message)request), false).getSipProvider();
                SipApplicationDispatcher sipApplicationDispatcher = this.sipFactory.getSipApplicationDispatcher();
                String branch = JainSipUtils.createBranch(this.getSipApplicationSession().getKey().getId(), sipApplicationDispatcher.getHashFromApplicationName(this.getKey().getApplicationName()));
                ViaHeader viaHeader = JainSipUtils.createViaHeader(sipNetworkInterfaceManager, request, branch, this.outboundInterface);
                request.addHeader((Header)viaHeader);
                request.removeContent();
                Dialog dialogToUse = this.sessionCreatingDialog;
                if (treatAsInitialRequest) {
                    dialogToUse = null;
                }
                sipServletRequest = (SipServletRequestImpl)this.sipFactory.getMobicentsSipServletMessageFactory().createSipServletRequest(request, (MobicentsSipSession)this, null, dialogToUse, true);
                if (this.sessionCreatingDialog != null && this.sessionCreatingDialog.getRemoteTarget() != null) {
                    SipUri sipUri = (SipUri)this.sessionCreatingDialog.getRemoteTarget().getURI().clone();
                    sipUri.clearUriParms();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("setting request uri to " + sipUri));
                    }
                    request.setRequestURI((javax.sip.address.URI)sipUri);
                }
                request.removeHeader("Route");
                request.removeHeader("Path");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("orignal tx for creating susbequent request " + method + " on session " + this.key + " was a Server Tx"));
                }
                try {
                    Request originalRequest = (Request)this.sessionCreatingTransactionRequest.getMessage();
                    FromHeader fromHeader = (FromHeader)originalRequest.getHeader("From");
                    ToHeader toHeader = (ToHeader)originalRequest.getHeader("To");
                    AddressImpl currentLocalParty = (AddressImpl)this.getLocalParty().clone();
                    AddressImpl currentRemoteParty = (AddressImpl)this.getRemoteParty().clone();
                    ((Parameters)currentRemoteParty.getAddress().getURI()).removeParameter("tag");
                    ((Parameters)currentLocalParty.getAddress().getURI()).removeParameter("tag");
                    String originalCallId = ((CallIdHeader)originalRequest.getHeader("Call-ID")).getCallId();
                    sipServletRequest = (SipServletRequestImpl)this.sipFactory.createRequest((SipApplicationSession)this.getSipApplicationSession(), method, currentLocalParty, currentRemoteParty, this.handlerServlet, originalCallId, fromHeader.getTag());
                    Request request = (Request)sipServletRequest.getMessage();
                    sipServletRequest.getSipSession().setCseq(((CSeqHeader)request.getHeader("CSeq")).getSeqNumber());
                    HashMap<String, String> fromParameters = new HashMap<String, String>();
                    Iterator fromParameterNames = fromHeader.getParameterNames();
                    while (fromParameterNames.hasNext()) {
                        String parameterName = (String)fromParameterNames.next();
                        if (this.sessionCreatingDialog == null && SipFactoryImpl.FORBIDDEN_PARAMS.contains(parameterName)) continue;
                        fromParameters.put(parameterName, fromHeader.getParameter(parameterName));
                    }
                    HashMap<String, String> toParameters = new HashMap<String, String>();
                    Iterator toParameterNames = toHeader.getParameterNames();
                    while (toParameterNames.hasNext()) {
                        String parameterName = (String)toParameterNames.next();
                        if (this.sessionCreatingDialog == null && SipFactoryImpl.FORBIDDEN_PARAMS.contains(parameterName)) continue;
                        toParameters.put(parameterName, toHeader.getParameter(parameterName));
                    }
                    ToHeader newTo = (ToHeader)request.getHeader("To");
                    for (Map.Entry fromParameter : fromParameters.entrySet()) {
                        void var18_46;
                        String string = (String)fromParameter.getValue();
                        if (string == null) {
                            String string2 = "";
                        }
                        newTo.setParameter((String)fromParameter.getKey(), (String)var18_46);
                    }
                    FromHeader newFrom = (FromHeader)request.getHeader("From");
                    for (Map.Entry entry : toParameters.entrySet()) {
                        String value = (String)entry.getValue();
                        if (value == null) {
                            value = "";
                        }
                        newFrom.setParameter((String)entry.getKey(), value);
                    }
                    if (this.sessionCreatingDialog != null && this.sessionCreatingDialog.getRemoteTarget() != null) {
                        SipUri sipUri = (SipUri)this.sessionCreatingDialog.getRemoteTarget().getURI().clone();
                        sipUri.clearUriParms();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("setting request uri to " + sipUri));
                        }
                        request.setRequestURI((javax.sip.address.URI)sipUri);
                    }
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Problem setting param on the newly created susbequent request " + sipServletRequest, e);
                }
            }
            if (this.sipSessionSecurity != null && this.sipSessionSecurity.getNextNonce() != null) {
                sipServletRequest.updateAuthorizationHeaders(true);
            } else if (this.sipSessionSecurity != null) {
                sipServletRequest.updateAuthorizationHeaders(false);
            }
            if (treatAsInitialRequest) {
                sipServletRequest.setRoutingState(RoutingState.INITIAL);
            }
            return sipServletRequest;
        }
        String errorMessage = "Couldn't create the subsequent request " + method + " for this session " + this.key + ", isValid " + this.isValid() + ", session state " + this.state + " , sessionCreatingDialog = " + this.sessionCreatingDialog;
        if (this.sessionCreatingDialog != null) {
            errorMessage = errorMessage + " , dialog state " + this.sessionCreatingDialog.getState();
        }
        errorMessage = errorMessage + " , sessionCreatingTransactionRequest = " + this.sessionCreatingTransactionRequest;
        throw new IllegalStateException(errorMessage);
        Request request = (Request)sipServletRequest.getMessage();
        ListIterator routeHeaders = request.getHeaders("Route");
        request.removeHeader("Route");
        while (routeHeaders.hasNext()) {
            RouteHeader routeHeader = (RouteHeader)routeHeaders.next();
            String routeServerId = ((javax.sip.address.SipURI)routeHeader.getAddress().getURI()).getParameter("as");
            String routeAppNameHashed = ((javax.sip.address.SipURI)routeHeader.getAddress().getURI()).getParameter("appname");
            String routeAppName = null;
            if (routeAppNameHashed != null) {
                routeAppName = this.sipFactory.getSipApplicationDispatcher().getApplicationNameFromHash(routeAppNameHashed);
            }
            if (routeAppName != null && this.sipFactory.getSipApplicationDispatcher().getApplicationServerId().equals(routeServerId) && routeAppName.equals(this.getKey().getApplicationName())) continue;
            request.addHeader((Header)routeHeader);
        }
        if (this.sipSessionSecurity != null && this.sipSessionSecurity.getNextNonce() != null) {
            sipServletRequest.updateAuthorizationHeaders(true);
        } else if (this.sipSessionSecurity != null) {
            sipServletRequest.updateAuthorizationHeaders(false);
        }
        return sipServletRequest;
    }

    public SipApplicationSession getApplicationSession() {
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession();
        if (sipApplicationSession == null) {
            return null;
        }
        return sipApplicationSession.getFacade();
    }

    protected Map<String, Object> getAttributeMap() {
        if (this.sipSessionAttributeMap == null) {
            this.sipSessionAttributeMap = new ConcurrentHashMap<String, Object>();
        }
        return this.sipSessionAttributeMap;
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        return this.getAttributeMap().get(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException("SipApplicationSession already invalidated !");
        }
        Vector<String> names = new Vector<String>(this.getAttributeMap().keySet());
        return names.elements();
    }

    public String getCallId() {
        if (this.sessionCreatingDialog != null) {
            return this.sessionCreatingDialog.getCallId().getCallId();
        }
        if (this.sessionCreatingTransactionRequest != null) {
            return ((CallIdHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("Call-ID")).getCallId();
        }
        if (this.key != null) {
            return this.key.getCallId();
        }
        return null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.key.toString();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    private void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public void access() {
        this.setLastAccessedTime(System.currentTimeMillis());
    }

    public Address getLocalParty() {
        if (this.sessionCreatingDialog != null) {
            return new AddressImpl(this.sessionCreatingDialog.getLocalParty(), null, AddressImpl.ModifiableRule.NotModifiable);
        }
        if (this.sessionCreatingTransactionRequest != null) {
            if (this.isSessionCreatingTransactionServer) {
                ToHeader toHeader = (ToHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("To");
                return new AddressImpl(toHeader.getAddress(), AddressImpl.getParameters((Parameters)toHeader), AddressImpl.ModifiableRule.NotModifiable);
            }
            FromHeader fromHeader = (FromHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("From");
            return new AddressImpl(fromHeader.getAddress(), AddressImpl.getParameters((Parameters)fromHeader), AddressImpl.ModifiableRule.NotModifiable);
        }
        return this.localParty;
    }

    public SipApplicationRoutingRegion getRegion() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (this.routingRegion == null) {
            throw new IllegalStateException("This methos can be called only on initial requests");
        }
        return this.routingRegion;
    }

    public SipApplicationRoutingRegion getRegionInternal() {
        return this.routingRegion;
    }

    public void setRoutingRegion(SipApplicationRoutingRegion routingRegion) {
        this.routingRegion = routingRegion;
    }

    public Serializable getStateInfo() {
        return this.stateInfo;
    }

    public void setStateInfo(Serializable stateInfo) {
        this.stateInfo = stateInfo;
    }

    public Address getRemoteParty() {
        if (this.sessionCreatingDialog != null) {
            return new AddressImpl(this.sessionCreatingDialog.getRemoteParty(), null, AddressImpl.ModifiableRule.NotModifiable);
        }
        if (this.sessionCreatingTransactionRequest != null) {
            try {
                if (!this.isSessionCreatingTransactionServer) {
                    ToHeader toHeader = (ToHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("To");
                    return new AddressImpl(toHeader.getAddress(), AddressImpl.getParameters((Parameters)toHeader), AddressImpl.ModifiableRule.NotModifiable);
                }
                FromHeader fromHeader = (FromHeader)this.sessionCreatingTransactionRequest.getMessage().getHeader("From");
                return new AddressImpl(fromHeader.getAddress(), AddressImpl.getParameters((Parameters)fromHeader), AddressImpl.ModifiableRule.NotModifiable);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error creating Address", e);
            }
        }
        return this.remoteParty;
    }

    public SipSession.State getState() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        return this.state;
    }

    public SipSession.State getStateInternal() {
        return this.state;
    }

    public URI getSubscriberURI() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (this.subscriberURI == null) {
            throw new IllegalStateException("Subscriber URI is only available for outbound sessions.");
        }
        try {
            return this.sipFactory.createURI(this.subscriberURI);
        }
        catch (ServletParseException e) {
            throw new IllegalArgumentException("couldn't parse the outbound interface " + this.subscriberURI, e);
        }
    }

    public void invalidate() {
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean bypassCheck) {
        boolean wasValid = this.isValidInternal.compareAndSet(true, false);
        if (!wasValid) {
            if (!bypassCheck) {
                throw new IllegalStateException("SipSession " + this.key + " already invalidated !");
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SipSession " + this.key + " already invalidated, doing nothing"));
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Invalidating the sip session " + this.key));
        }
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession();
        SipManager manager = sipApplicationSession.getSipContext().getSipManager();
        MobicentsSipSession parentSipSession = this.getParentSession();
        if (parentSipSession == null) {
            if (this.derivedSipSessions == null || this.derivedSipSessions.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sip session " + this.key + " has no derived sessions removing it from the manager"));
                }
                if (this.sipSessionAttributeMap != null) {
                    for (String key : this.sipSessionAttributeMap.keySet()) {
                        this.removeAttribute(key, true);
                    }
                }
                manager.removeSipSession((MobicentsSipSessionKey)this.key);
                sipApplicationSession.getSipContext().getSipSessionsUtil().removeCorrespondingSipSession((MobicentsSipSessionKey)this.key);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sip session " + this.key + " is the parent session, checking derived sessions"));
                }
                if (this.derivedSipSessions != null) {
                    for (MobicentsSipSession session : this.derivedSipSessions.values()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("derived session " + session + " " + this.isValidInternal + " " + this.readyToInvalidate + " " + this.state));
                        }
                        if (!session.isReadyToInvalidateInternal() || this.state != SipSession.State.TERMINATED) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Invalidating derived sipsession " + session));
                        }
                        session.invalidate(true);
                    }
                }
                if (this.sipSessionAttributeMap != null) {
                    for (String key : this.sipSessionAttributeMap.keySet()) {
                        this.removeAttribute(key, true);
                    }
                }
                manager.removeSipSession((MobicentsSipSessionKey)this.key);
                sipApplicationSession.getSipContext().getSipSessionsUtil().removeCorrespondingSipSession((MobicentsSipSessionKey)this.key);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sip session " + this.key + " is a derived session, so not removing it from the manager, only from the parent session " + parentSipSession.getKey()));
            }
            MobicentsSipSession removedSession = null;
            try {
                removedSession = parentSipSession.removeDerivedSipSession(SessionManagerUtil.parseSipSessionKey(this.key.toString()).getToTag());
            }
            catch (ParseException e) {
                logger.error((Object)("couldn't parse " + this.key));
            }
            if (logger.isDebugEnabled() && removedSession != null) {
                logger.debug((Object)("removed derived sip session " + this.key + " from the list of derived sessions from the parent session " + parentSipSession.getKey()));
            }
        }
        long timeNow = System.currentTimeMillis();
        int timeAlive = (int)((timeNow - this.creationTime) / 1000L);
        SipManager sipManager = manager;
        synchronized (sipManager) {
            if (timeAlive > manager.getSipSessionMaxAliveTime()) {
                manager.setSipSessionMaxAliveTime(timeAlive);
            }
            int numExpired = manager.getExpiredSipSessions();
            manager.setExpiredSipSessions(++numExpired);
            int average = manager.getSipSessionAverageAliveTime();
            average = (average * (numExpired - 1) + timeAlive) / numExpired;
            manager.setSipSessionAverageAliveTime(average);
        }
        this.notifySipSessionListeners(SipSessionEventType.DELETION);
        this.isValid = false;
        if (this.derivedSipSessions != null && !bypassCheck) {
            for (MobicentsSipSession derivedMobicentsSipSession : this.derivedSipSessions.values()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Invalidating Derived Sip Session " + derivedMobicentsSipSession.getKey()));
                }
                derivedMobicentsSipSession.invalidate(bypassCheck);
            }
            this.derivedSipSessions.clear();
        }
        sipApplicationSession.onSipSessionReadyToInvalidate((MobicentsSipSession)this);
        if (this.ongoingTransactions != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.ongoingTransactions.size() + " ongoing transactions still present in the following sip session " + this.key + " on invalidation"));
            }
            for (Transaction transaction : this.ongoingTransactions) {
                if (TransactionState.TERMINATED.equals((Object)transaction.getState())) continue;
                if (transaction.getApplicationData() != null) {
                    ((TransactionApplicationData)transaction.getApplicationData()).cleanUp();
                }
                try {
                    transaction.terminate();
                }
                catch (ObjectInUseException objectInUseException) {}
            }
            this.ongoingTransactions.clear();
        }
        if (this.subscriptions != null) {
            this.subscriptions.clear();
        }
        if (this.acksReceived != null) {
            this.acksReceived.clear();
        }
        if (this.sipSessionSecurity != null) {
            this.sipSessionSecurity.getCachedAuthInfos().clear();
        }
        this.parentSession = null;
        this.userPrincipal = null;
        manager = null;
        if (this.b2buaHelper != null) {
            this.b2buaHelper.unlinkSipSessionsInternal((SipSession)this, false);
            this.b2buaHelper = null;
        }
        this.derivedSipSessions = null;
        this.localParty = null;
        this.ongoingTransactions = null;
        this.originalMethod = null;
        this.outboundInterface = null;
        this.sipSessionAttributeMap = null;
        if (this.sessionCreatingDialog != null) {
            this.cleanDialogInformation(true);
            if (!DialogState.TERMINATED.equals((Object)this.sessionCreatingDialog.getState())) {
                this.sessionCreatingDialog.delete();
            }
            this.sessionCreatingDialog = null;
        }
        if (this.sessionCreatingTransactionRequest != null) {
            Transaction sessionCreatingTransaction = this.sessionCreatingTransactionRequest.getTransaction();
            if (sessionCreatingTransaction != null && !TransactionState.TERMINATED.equals((Object)sessionCreatingTransaction.getState())) {
                try {
                    sessionCreatingTransaction.terminate();
                }
                catch (ObjectInUseException objectInUseException) {
                    // empty catch block
                }
            }
            this.sessionCreatingTransactionRequest.cleanUp();
            this.sessionCreatingTransactionRequest = null;
        }
        if (this.proxy != null && !this.proxy.getAckReceived()) {
            try {
                this.proxy.cancelAllExcept(null, null, null, null, false);
            }
            catch (Exception e) {
                logger.debug((Object)"Problem cancelling proxy. We just try our best. This is not a critical error.", (Throwable)e);
            }
            this.proxy.getTransactionMap().clear();
            this.proxy.getProxyBranchesMap().clear();
            this.proxy = null;
        }
        this.remoteParty = null;
        this.routingRegion = null;
        this.sipFactory = null;
        this.state = null;
        this.stateInfo = null;
        this.subscriberURI = null;
        this.subscriptions = null;
        this.acksReceived = null;
        this.sipSessionSecurity = null;
        this.facade = null;
    }

    protected boolean hasOngoingTransaction() {
        if (!this.isSupervisedMode()) {
            return false;
        }
        if (this.ongoingTransactions != null) {
            for (Transaction transaction : this.ongoingTransactions) {
                if (!TransactionState.CALLING.equals((Object)transaction.getState()) && !TransactionState.TRYING.equals((Object)transaction.getState()) && !TransactionState.PROCEEDING.equals((Object)transaction.getState()) && !TransactionState.COMPLETED.equals((Object)transaction.getState()) && !TransactionState.CONFIRMED.equals((Object)transaction.getState())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValidInternal() {
        return this.isValidInternal.get();
    }

    public void setValid(boolean isValid) {
        this.isValidInternal.set(isValid);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, false);
    }

    public void removeAttribute(String name, boolean byPassValidCheck) {
        if (!byPassValidCheck && !this.isValid()) {
            throw new IllegalStateException("Can not bind object to session that has been invalidated!!");
        }
        if (name == null) {
            return;
        }
        SipSessionBindingEvent event = null;
        Object value = this.getAttributeMap().get(name);
        if (value != null && value instanceof SipSessionBindingListener) {
            event = new SipSessionBindingEvent((SipSession)this, name);
            ((SipSessionBindingListener)value).valueUnbound(event);
        }
        this.getAttributeMap().remove(name);
        SipListeners sipListenersHolder = this.getSipApplicationSession().getSipContext().getListeners();
        List listenersList = sipListenersHolder.getSipSessionAttributeListeners();
        if (listenersList.size() > 0) {
            if (event == null) {
                event = new SipSessionBindingEvent((SipSession)this, name);
            }
            for (SipSessionAttributeListener listener : listenersList) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("notifying SipSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute removed on key " + this.key));
                }
                try {
                    listener.attributeRemoved(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionAttributeListener threw exception", t);
                }
            }
        }
    }

    public void setAttribute(String key, Object attribute) {
        block20: {
            SipListeners sipListenersHolder;
            List listenersList;
            Object previousValue;
            Object oldValue;
            if (!this.isValid()) {
                throw new IllegalStateException("Can not bind object to session that has been invalidated!!");
            }
            if (key == null) {
                throw new NullPointerException("Name of attribute to bind cant be null!!!");
            }
            if (attribute == null) {
                throw new NullPointerException("Attribute that is to be bound cant be null!!!");
            }
            SipSessionBindingEvent event = null;
            if (attribute instanceof SipSessionBindingListener && attribute != (oldValue = this.getAttributeMap().get(key))) {
                event = new SipSessionBindingEvent((SipSession)this, key);
                try {
                    ((SipSessionBindingListener)attribute).valueBound(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionBindingListener threw exception", t);
                }
            }
            if ((previousValue = this.getAttributeMap().put(key, attribute)) != null && previousValue != attribute && previousValue instanceof SipSessionBindingListener) {
                try {
                    ((SipSessionBindingListener)previousValue).valueUnbound(new SipSessionBindingEvent((SipSession)this, key));
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionBindingListener threw exception", t);
                }
            }
            if ((listenersList = (sipListenersHolder = this.getSipApplicationSession().getSipContext().getListeners()).getSipSessionAttributeListeners()).size() <= 0) break block20;
            if (event == null) {
                event = new SipSessionBindingEvent((SipSession)this, key);
            }
            if (previousValue == null) {
                for (SipSessionAttributeListener listener : listenersList) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying SipSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute added on key " + key));
                    }
                    try {
                        listener.attributeAdded(event);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipSessionAttributeListener threw exception", t);
                    }
                }
            } else {
                for (SipSessionAttributeListener listener : listenersList) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("notifying SipSessionAttributeListener " + listener.getClass().getCanonicalName() + " of attribute replaced on key " + key));
                    }
                    try {
                        listener.attributeReplaced(event);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipSessionAttributeListener threw exception", t);
                    }
                }
            }
        }
    }

    public void setHandler(String name) throws ServletException {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has already been invalidated, no handler can be set on it anymore !");
        }
        if (name != null && name.equals(this.handlerServlet)) {
            return;
        }
        SipContext sipContext = this.getSipApplicationSession().getSipContext();
        MobicentsSipServlet container = sipContext.findSipServletByName(name);
        if (container == null && sipContext.getSipRubyController() == null) {
            throw new ServletException("the sip servlet with the name " + name + " doesn't exist in the sip application " + sipContext.getApplicationName());
        }
        this.handlerServlet = name;
        this.getSipApplicationSession().setCurrentRequestHandler(this.handlerServlet);
        if (logger.isDebugEnabled()) {
            if (name != null) {
                logger.debug((Object)("Session Handler for application " + this.getKey().getApplicationName() + " set to " + this.handlerServlet + " on sip session " + this.key));
            } else {
                logger.debug((Object)("Session Handler for application " + this.getKey().getApplicationName() + " set to " + sipContext.getSipRubyController() + " on sip session " + this.key));
            }
        }
    }

    public String getHandler() {
        return this.handlerServlet;
    }

    public void setSessionCreatingDialog(Dialog dialog) {
        if (this.proxy == null) {
            this.sessionCreatingDialog = dialog;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setting session creating dialog for this session to " + dialog));
                if (dialog != null) {
                    logger.debug((Object)("session creating dialog dialogId " + dialog.getDialogId()));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("not setting session creating dialog for this session to " + dialog + " since this is a proxy application"));
            if (dialog != null) {
                logger.debug((Object)("not setting session creating dialog with dialogId " + dialog.getDialogId() + " since this is a proxy application"));
            }
        }
    }

    public Dialog getSessionCreatingDialog() {
        return this.sessionCreatingDialog;
    }

    public MobicentsSipApplicationSession getSipApplicationSession() {
        if (this.sipApplicationSession == null) {
            String applicationName = this.key.getApplicationName();
            SipContext sipContext = this.sipFactory.getSipApplicationDispatcher().findSipApplication(applicationName);
            if (sipContext != null) {
                this.sipApplicationSession = sipContext.getSipManager().getSipApplicationSession(this.sipApplicationSessionKey, false);
            }
        }
        return this.sipApplicationSession;
    }

    protected void setSipApplicationSession(MobicentsSipApplicationSession sipApplicationSession) {
        if (sipApplicationSession != null) {
            this.sipApplicationSessionKey = sipApplicationSession.getKey();
            sipApplicationSession.addSipSession((MobicentsSipSession)this);
        }
    }

    public SipServletRequestImpl getSessionCreatingTransactionRequest() {
        return this.sessionCreatingTransactionRequest;
    }

    public void setSessionCreatingTransactionRequest(MobicentsSipServletMessage message) {
        if (message != null) {
            SipServletMessageImpl sipServletMessageImpl;
            if (message instanceof SipServletRequestImpl) {
                this.sessionCreatingTransactionRequest = (SipServletRequestImpl)message;
                this.isSessionCreatingTransactionServer = message.getTransaction() instanceof ServerTransaction;
            } else if (message.getTransaction() != null && message.getTransaction().getApplicationData() != null && (sipServletMessageImpl = ((TransactionApplicationData)message.getTransaction().getApplicationData()).getSipServletMessage()) != null && sipServletMessageImpl instanceof SipServletRequestImpl) {
                this.sessionCreatingTransactionRequest = (SipServletRequestImpl)sipServletMessageImpl;
                this.isSessionCreatingTransactionServer = message.getTransaction() instanceof ServerTransaction;
            }
        }
        if (this.sessionCreatingTransactionRequest != null) {
            if (this.originalMethod == null) {
                this.originalMethod = this.sessionCreatingTransactionRequest.getMethod();
            }
            this.addOngoingTransaction(this.sessionCreatingTransactionRequest.getTransaction());
            if (this.parentSession != null && "REGISTER".equals(this.originalMethod) && !this.parentSession.equals(this)) {
                this.parentSession.setSessionCreatingTransactionRequest(message);
            }
        }
    }

    public boolean isSupervisedMode() {
        if (this.proxy == null) {
            return true;
        }
        return this.proxy.getSupervised();
    }

    public void setSipSubscriberURI(String subscriberURI) {
        this.subscriberURI = subscriberURI;
    }

    public String getSipSubscriberURI() {
        return this.subscriberURI;
    }

    public String getOutboundInterface() {
        return this.outboundInterface;
    }

    public void onDialogTimeout(Dialog dialog) {
        if (this.hasOngoingTransaction()) {
            throw new IllegalStateException("Dialog timed out, but there are active transactions.");
        }
        this.state = SipSession.State.TERMINATED;
    }

    public void setState(SipSession.State state) {
        this.state = state;
        if (state == SipSession.State.TERMINATED) {
            this.setReadyToInvalidate(true);
        }
    }

    public void onTerminatedState() {
        if (this.isValidInternal()) {
            this.onReadyToInvalidate();
            if (this.parentSession != null) {
                Iterator derivedSessionsIterator = this.parentSession.getDerivedSipSessions();
                while (derivedSessionsIterator.hasNext()) {
                    MobicentsSipSession mobicentsSipSession = (MobicentsSipSession)derivedSessionsIterator.next();
                    if (!mobicentsSipSession.isValidInternal() || mobicentsSipSession.isReadyToInvalidate()) continue;
                    return;
                }
                this.parentSession.onReadyToInvalidate();
            }
        }
    }

    public void addOngoingTransaction(Transaction transaction) {
        boolean added;
        if (transaction != null && this.ongoingTransactions != null && !this.isReadyToInvalidate() && (added = this.ongoingTransactions.add(transaction))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transaction " + transaction + " has been added to sip session's ongoingTransactions"));
            }
            this.setReadyToInvalidate(false);
        }
    }

    public void removeOngoingTransaction(Transaction transaction) {
        boolean removed = false;
        if (this.ongoingTransactions != null) {
            removed = this.ongoingTransactions.remove(transaction);
        }
        if (this.proxy != null) {
            this.proxy.removeTransaction(transaction.getBranchId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transaction " + transaction + " has been removed from sip session's ongoingTransactions ? " + removed));
        }
        this.updateReadyToInvalidate(transaction);
        String branchId = transaction.getBranchId();
        if (this.sessionCreatingTransactionRequest != null && branchId != null) {
            Transaction sessionCreatingTransactionRequestTransaction = this.sessionCreatingTransactionRequest.getTransaction();
            String sessionCreatingTransactionRequestTransactionBranchId = null;
            if (sessionCreatingTransactionRequestTransaction != null) {
                sessionCreatingTransactionRequestTransactionBranchId = sessionCreatingTransactionRequestTransaction.getBranchId();
            }
            String sessionCreatingTransactionRequestMethod = this.sessionCreatingTransactionRequest.getMethod();
            if (sessionCreatingTransactionRequestTransaction != null && branchId.equals(sessionCreatingTransactionRequestTransactionBranchId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Session " + this.key + ": cleaning up " + this.sessionCreatingTransactionRequest + " since transaction " + transaction + " with branch id " + branchId + " is the same as sessionCreatingRequestTransaction " + sessionCreatingTransactionRequestTransaction + " with branch id " + sessionCreatingTransactionRequestTransactionBranchId + " and method " + sessionCreatingTransactionRequestMethod));
                }
                this.sessionCreatingTransactionRequest.cleanUp();
                if (this.sessionCreatingDialog != null || this.proxy != null || JainSipUtils.DIALOG_CREATING_METHODS.contains(sessionCreatingTransactionRequestMethod)) {
                    if (logger.isDebugEnabled() && this.sessionCreatingTransactionRequest != null) {
                        logger.debug((Object)("nullifying  sessionCreatingTransactionRequest" + this.sessionCreatingTransactionRequest + " from Session " + this.key));
                    }
                    this.sessionCreatingTransactionRequest = null;
                }
            }
        }
    }

    public void cleanDialogInformation(boolean terminate) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cleanDialogInformation " + this.sessionCreatingDialog));
            logger.debug((Object)("cleanDialogInformation terminate " + terminate));
        }
        if (this.sessionCreatingDialog != null && this.sessionCreatingDialog.getApplicationData() != null && ((TransactionApplicationData)this.sessionCreatingDialog.getApplicationData()).getSipServletMessage() != null) {
            TransactionApplicationData dialogAppData = (TransactionApplicationData)this.sessionCreatingDialog.getApplicationData();
            SipServletMessageImpl sipServletMessage = dialogAppData.getSipServletMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("trying to cleanup message " + sipServletMessage + " and related dialog app data " + dialogAppData));
                logger.debug((Object)("is dialog established " + ("INVITE".equalsIgnoreCase(sipServletMessage.getMethod()) && this.isAckReceived(((MessageExt)sipServletMessage.getMessage()).getCSeqHeader().getSeqNumber()))));
                logger.debug((Object)("is dialog creating method " + JainSipUtils.DIALOG_CREATING_METHODS.contains(sipServletMessage.getMethod())));
                logger.debug((Object)("is dialog terminating method " + JainSipUtils.DIALOG_TERMINATING_METHODS.contains(sipServletMessage.getMethod())));
            }
            boolean cleanDialog = false;
            if ("INVITE".equalsIgnoreCase(sipServletMessage.getMethod()) && this.isAckReceived(((MessageExt)sipServletMessage.getMessage()).getCSeqHeader().getSeqNumber())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("cleaning INVITE and ack received for it for dialog " + this.sessionCreatingDialog));
                }
                cleanDialog = true;
            }
            if (!"INVITE".equalsIgnoreCase(sipServletMessage.getMethod()) && JainSipUtils.DIALOG_CREATING_METHODS.contains(sipServletMessage.getMethod())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("cleaning non INVITE Dialog creating method " + sipServletMessage.getMethod()));
                }
                cleanDialog = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cleanDialog " + cleanDialog));
                logger.debug((Object)("cleanDialog terminate " + terminate));
            }
            if (cleanDialog || terminate) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("cleanDialogInformation app data and message" + this.sessionCreatingDialog));
                }
                dialogAppData.cleanUpMessage();
                dialogAppData.cleanUp();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("cleaned DialogInformation " + this.sessionCreatingDialog));
                }
            }
        }
    }

    public Set<Transaction> getOngoingTransactions() {
        return this.ongoingTransactions;
    }

    public void updateStateOnResponse(MobicentsSipServletResponse response, boolean receive) {
        block33: {
            AuthenticationInfoHeader authenticationInfoHeader;
            String method = response.getMethod();
            if (this.sipSessionSecurity != null && response.getStatus() >= 200 && response.getStatus() < 300 && (authenticationInfoHeader = (AuthenticationInfoHeader)response.getMessage().getHeader("Authentication-Info")) != null) {
                String nextNonce = authenticationInfoHeader.getNextNonce();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Storing nextNonce " + nextNonce + " for session " + this.key));
                }
                this.sipSessionSecurity.setNextNonce(nextNonce);
            }
            if (!JainSipUtils.DIALOG_CREATING_METHODS.contains(method) && !JainSipUtils.DIALOG_TERMINATING_METHODS.contains(method)) {
                if (this.getSessionCreatingDialog() == null && this.proxy == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("resetting the to tag since a response to a non dialog creating and terminating method has been received for non proxy session with no dialog in state " + this.state));
                    }
                    this.key.setToTag(null, false);
                    if (this.state != null && SipSession.State.INITIAL.equals((Object)this.state) && response.getStatus() >= 200 && response.getStatus() != 407 && response.getStatus() != 401) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Setting SipSession " + this.getKey() + " for response " + response.getStatus() + " to a non dialog creating or terminating request " + method + " in state " + this.state + " to ReadyToInvalidate=true"));
                        }
                        this.setReadyToInvalidate(true);
                    }
                }
                return;
            }
            if ((SipSession.State.INITIAL.equals((Object)this.state) || SipSession.State.EARLY.equals((Object)this.state)) && response.getStatus() >= 200 && response.getStatus() < 300 && !JainSipUtils.DIALOG_TERMINATING_METHODS.contains(method)) {
                this.setState(SipSession.State.CONFIRMED);
                if (this.proxy != null && response.getProxyBranch() != null && !response.getProxyBranch().getRecordRoute()) {
                    this.setReadyToInvalidate(true);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
            }
            if (SipSession.State.INITIAL.equals((Object)this.state) && response.getStatus() >= 100 && response.getStatus() < 200) {
                this.setState(SipSession.State.EARLY);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
            }
            if ((SipSession.State.INITIAL.equals((Object)this.state) || SipSession.State.EARLY.equals((Object)this.state)) && response.getStatus() >= 300 && response.getStatus() < 700 && JainSipUtils.DIALOG_CREATING_METHODS.contains(method) && !JainSipUtils.DIALOG_TERMINATING_METHODS.contains(method)) {
                if (receive) {
                    if (this.proxy == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("resetting the to tag since a non 2xx response has been received for non proxy session in state " + this.state));
                        }
                        this.key.setToTag(null, false);
                    }
                    this.setState(SipSession.State.INITIAL);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                    }
                } else {
                    this.setState(SipSession.State.TERMINATED);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                    }
                }
            }
            if ((SipSession.State.CONFIRMED.equals((Object)this.state) || SipSession.State.TERMINATED.equals((Object)this.state)) && response.getStatus() >= 200 && "BYE".equals(method) && response.getStatus() != 407 && response.getStatus() != 401 || !SipSession.State.CONFIRMED.equals((Object)this.state) && response.getStatus() == 487) {
                boolean hasOngoingSubscriptions = false;
                if (this.subscriptions != null) {
                    if (this.subscriptions.size() > 0) {
                        hasOngoingSubscriptions = true;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has " + this.subscriptions.size() + " subscriptions"));
                    }
                    if (!hasOngoingSubscriptions && this.sessionCreatingDialog != null) {
                        this.sessionCreatingDialog.delete();
                    }
                }
                if (!(hasOngoingSubscriptions || this.getProxy() != null && response.getStatus() == 487)) {
                    this.setState(SipSession.State.TERMINATED);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                        logger.debug((Object)("the following sip session " + this.getKey() + " is ready to be invalidated "));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
                this.okToByeSentOrReceived = true;
            }
            if (response.getTransactionApplicationData().isCanceled() && response.getStatus() < 200 && !response.getMethod().equals("CANCEL")) {
                SipServletRequestImpl request = (SipServletRequestImpl)response.getTransactionApplicationData().getSipServletMessage();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("request to cancel " + request + " routingstate " + (Object)((Object)request.getRoutingState()) + " requestCseq " + ((MessageExt)request.getMessage()).getCSeqHeader().getSeqNumber() + " responseCseq " + ((MessageExt)response.getMessage()).getCSeqHeader().getSeqNumber()));
                }
                if (!request.getRoutingState().equals((Object)RoutingState.CANCELLED) && ((MessageExt)request.getMessage()).getCSeqHeader().getSeqNumber() == ((MessageExt)response.getMessage()).getCSeqHeader().getSeqNumber()) {
                    if (response.getStatus() > 100) {
                        request.setRoutingState(RoutingState.CANCELLED);
                    }
                    try {
                        request.createCancel().send();
                    }
                    catch (IOException e) {
                        if (!logger.isEnabledFor(Priority.WARN)) break block33;
                        logger.warn((Object)("Couldn't send CANCEL for a transaction that has been CANCELLED but CANCEL was not sent because there was no response from the other side. We just stopped the retransmissions." + response + "\nThe transaction" + response.getTransaction()), (Throwable)e);
                    }
                }
            }
        }
    }

    public void updateStateOnSubsequentRequest(MobicentsSipServletRequest request, boolean receive) {
        if ("CANCEL".equalsIgnoreCase(request.getMethod())) {
            if (!(request.getTransaction() instanceof ServerTransactionExt)) {
                return;
            }
            ServerTransaction inviteTransaction = ((ServerTransactionExt)request.getTransaction()).getCanceledInviteTransaction();
            TransactionApplicationData inviteAppData = (TransactionApplicationData)inviteTransaction.getApplicationData();
            SipServletRequestImpl inviteRequest = (SipServletRequestImpl)inviteAppData.getSipServletMessage();
            if (inviteRequest != null && inviteRequest.isInitial() && inviteRequest.getLastFinalResponse() == null || this.proxy != null && this.proxy.getBestResponse() == null) {
                this.setState(SipSession.State.TERMINATED);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the following sip session " + this.getKey() + " has its state updated to " + this.state));
                }
            }
        }
        if ("ACK".equalsIgnoreCase(request.getMethod()) && this.sessionCreatingTransactionRequest != null) {
            this.sessionCreatingTransactionRequest.cleanUpLastResponses();
        }
    }

    private void updateReadyToInvalidate(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            if (this.ongoingTransactions != null) {
                logger.debug((Object)("ongoingTransactions " + this.ongoingTransactions.isEmpty() + " for sipsession " + this.key));
            } else {
                logger.debug((Object)("ongoingTransactions " + null + " for sipsession " + this.key));
            }
        }
        if (!this.readyToInvalidate && (this.ongoingTransactions == null || this.ongoingTransactions.isEmpty()) && transaction instanceof ClientTransaction && this.getProxy() == null && this.state != null && this.state.equals((Object)SipSession.State.INITIAL) && this.sessionCreatingTransactionRequest != null && this.sessionCreatingTransactionRequest.getLastFinalResponse() != null && this.sessionCreatingTransactionRequest.getLastFinalResponse().getStatus() >= 300) {
            this.setReadyToInvalidate(true);
        }
    }

    public void onReadyToInvalidate() {
        this.setReadyToInvalidate(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("invalidateWhenReady flag is set to " + this.invalidateWhenReady));
        }
        if (this.isValid() && this.invalidateWhenReady) {
            this.notifySipSessionListeners(SipSessionEventType.READYTOINVALIDATE);
            if (this.isValid()) {
                this.invalidate(true);
            }
        }
    }

    public SipSessionKey getKey() {
        return this.key;
    }

    public void setKey(SipSessionKey key) {
        this.key = key;
    }

    public ProxyImpl getProxy() {
        return this.proxy;
    }

    public void setProxy(MobicentsProxy proxy) {
        this.proxy = (ProxyImpl)proxy;
    }

    public void setB2buaHelper(MobicentsB2BUAHelper helperImpl) {
        this.b2buaHelper = (B2buaHelperImpl)helperImpl;
    }

    public B2buaHelperImpl getB2buaHelper() {
        return this.b2buaHelper;
    }

    public void passivate() {
        SipSessionActivationEvent event = null;
        if (this.sipSessionAttributeMap != null) {
            Set<String> keySet = this.getAttributeMap().keySet();
            for (String key : keySet) {
                Object attribute = this.getAttributeMap().get(key);
                if (!(attribute instanceof SipSessionActivationListener)) continue;
                if (event == null) {
                    event = new SipSessionActivationEvent((SipSession)this, SessionActivationNotificationCause.PASSIVATION);
                }
                try {
                    ((SipSessionActivationListener)attribute).sessionWillPassivate(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionActivationListener threw exception", t);
                }
            }
        }
    }

    public void activate() {
        SipSessionActivationEvent event = null;
        if (this.sipSessionAttributeMap != null) {
            Set<String> keySet = this.getAttributeMap().keySet();
            for (String key : keySet) {
                Object attribute = this.getAttributeMap().get(key);
                if (!(attribute instanceof SipSessionActivationListener)) continue;
                if (event == null) {
                    event = new SipSessionActivationEvent((SipSession)this, SessionActivationNotificationCause.ACTIVATION);
                }
                try {
                    ((SipSessionActivationListener)attribute).sessionDidActivate(event);
                }
                catch (Throwable t) {
                    logger.error((Object)"SipSessionActivationListener threw exception", t);
                }
            }
        }
    }

    public SipPrincipal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(SipPrincipal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public boolean getInvalidateWhenReady() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        return this.invalidateWhenReady;
    }

    public boolean isReadyToInvalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        return this.readyToInvalidate;
    }

    public void setReadyToInvalidate(boolean readyToInvalidate) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("readyToInvalidate flag is set to " + readyToInvalidate));
        }
        this.readyToInvalidate = readyToInvalidate;
    }

    public boolean isReadyToInvalidateInternal() {
        return this.readyToInvalidate;
    }

    public void setInvalidateWhenReady(boolean arg0) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        this.invalidateWhenReady = arg0;
    }

    public void setOutboundInterface(InetAddress inetAddress) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (inetAddress == null) {
            throw new NullPointerException("parameter is null");
        }
        String address = inetAddress.getHostAddress();
        List list = this.sipFactory.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + address + " not found");
        }
        try {
            this.outboundInterface = new SipURIImpl(SipFactoryImpl.addressFactory.createSipURI(null, address), AddressImpl.ModifiableRule.NotModifiable).toString();
        }
        catch (ParseException e) {
            logger.error((Object)("couldn't parse the SipURI from USER[" + null + "] HOST[" + address + "]"), (Throwable)e);
            throw new IllegalArgumentException("Could not create SIP URI user = " + null + " host = " + address);
        }
    }

    public void setOutboundInterface(InetSocketAddress inetSocketAddress) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (inetSocketAddress == null) {
            throw new NullPointerException("parameter is null");
        }
        String address = inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
        List list = this.sipFactory.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.toString().contains(address)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + address + " not found");
        }
        try {
            this.outboundInterface = new SipURIImpl(SipFactoryImpl.addressFactory.createSipURI(null, address), AddressImpl.ModifiableRule.NotModifiable).toString();
        }
        catch (ParseException e) {
            logger.error((Object)("couldn't parse the SipURI from USER[" + null + "] HOST[" + address + "]"), (Throwable)e);
            throw new IllegalArgumentException("Could not create SIP URI user = " + null + " host = " + address);
        }
    }

    public void setOutboundInterface(SipURI outboundInterface) {
        if (!this.isValid()) {
            throw new IllegalStateException("the session has been invalidated");
        }
        if (outboundInterface == null) {
            throw new NullPointerException("parameter is null");
        }
        List list = this.sipFactory.getSipNetworkInterfaceManager().getOutboundInterfaces();
        SipURI networkInterface = null;
        for (SipURI networkInterfaceURI : list) {
            if (!networkInterfaceURI.equals((Object)outboundInterface)) continue;
            networkInterface = networkInterfaceURI;
            break;
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface for " + outboundInterface + " not found");
        }
        this.outboundInterface = outboundInterface.toString();
        if (outboundInterface.getTransportParam() != null) {
            this.transport = outboundInterface.getTransportParam();
        }
    }

    public ServletContext getServletContext() {
        return this.getSipApplicationSession().getSipContext().getServletContext();
    }

    public MobicentsSipSession removeDerivedSipSession(String toTag) {
        return this.derivedSipSessions.remove(toTag);
    }

    public MobicentsSipSession findDerivedSipSession(String toTag) {
        this.dumpDerivedSipSessions();
        if (this.derivedSipSessions != null) {
            return this.derivedSipSessions.get(toTag);
        }
        return null;
    }

    private void dumpDerivedSipSessions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("derived sessions contained in the following sip session " + this.key));
            if (this.derivedSipSessions != null) {
                for (MobicentsSipSession session : this.derivedSipSessions.values()) {
                    logger.debug((Object)("derived session " + session + " " + this.isValidInternal + " " + this.readyToInvalidate + " " + this.state));
                }
            }
        }
    }

    public Iterator<MobicentsSipSession> getDerivedSipSessions() {
        if (this.derivedSipSessions != null) {
            return this.derivedSipSessions.values().iterator();
        }
        return new HashMap().values().iterator();
    }

    public void setParentSession(MobicentsSipSession mobicentsSipSession) {
        this.parentSession = mobicentsSipSession;
    }

    public MobicentsSipSession getParentSession() {
        return this.parentSession;
    }

    public void setSipSessionAttributeMap(Map<String, Object> sipSessionAttributeMap) {
        this.sipSessionAttributeMap = sipSessionAttributeMap;
    }

    public void addDerivedSipSessions(MobicentsSipSession derivedSession) {
        if (this.derivedSipSessions == null) {
            this.derivedSipSessions = new ConcurrentHashMap();
        }
        this.derivedSipSessions.putIfAbsent(derivedSession.getKey().getToTag(), derivedSession);
    }

    public Map<String, Object> getSipSessionAttributeMap() {
        return this.getAttributeMap();
    }

    public void setLocalParty(Address localParty) {
        this.localParty = localParty;
    }

    public void setRemoteParty(Address remoteParty) {
        this.remoteParty = remoteParty;
    }

    public void addSubscription(MobicentsSipServletMessage sipServletMessageImpl) throws SipException {
        EventHeader eventHeader = null;
        eventHeader = sipServletMessageImpl instanceof SipServletResponseImpl ? (EventHeader)((SipServletRequestImpl)((SipServletResponseImpl)sipServletMessageImpl).getRequest()).getMessage().getHeader("Event") : (EventHeader)sipServletMessageImpl.getMessage().getHeader("Event");
        if (eventHeader != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("adding subscription " + eventHeader + " to sip session " + this.getId()));
            }
            if (this.subscriptions == null) {
                this.subscriptions = new CopyOnWriteArraySet<String>();
            }
            this.subscriptions.add(eventHeader.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request from Original Transaction is " + this.originalMethod));
                logger.debug((Object)("Dialog is " + this.sessionCreatingDialog));
            }
            if (this.subscriptions.size() < 2 && "INVITE".equals(this.originalMethod)) {
                this.sessionCreatingDialog.terminateOnBye(false);
            }
        }
    }

    public void removeSubscription(MobicentsSipServletMessage sipServletMessageImpl) {
        EventHeader eventHeader = (EventHeader)sipServletMessageImpl.getMessage().getHeader("Event");
        if (eventHeader != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removing subscription " + eventHeader + " to sip session " + this.getId()));
            }
            boolean hasOngoingSubscriptions = false;
            if (this.subscriptions != null) {
                this.subscriptions.remove(eventHeader.toString());
                if (this.subscriptions.size() > 0) {
                    hasOngoingSubscriptions = true;
                }
                if (!hasOngoingSubscriptions && this.subscriptions.size() < 1 && (this.originalMethod != null && this.okToByeSentOrReceived || !"INVITE".equals(this.originalMethod))) {
                    this.setState(SipSession.State.TERMINATED);
                }
            }
        }
        if (this.isReadyToInvalidateInternal()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("no more subscriptions in session " + this.getId()));
            }
            if (this.sessionCreatingDialog != null) {
                this.sessionCreatingDialog.delete();
            }
        }
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public MobicentsSipSessionFacade getFacade() {
        MobicentsSipApplicationSession sipApplicationSession = this.getSipApplicationSession();
        if (this.facade == null && sipApplicationSession != null) {
            SipContext sipContext = sipApplicationSession.getSipContext();
            if (sipContext.isPackageProtectionEnabled()) {
                final SipSessionImpl fsession = this;
                this.facade = (MobicentsSipSessionFacade)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new MobicentsSipSessionFacade(fsession);
                    }
                });
            } else {
                this.facade = new MobicentsSipSessionFacade(this);
            }
        }
        return this.facade;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MobicentsSipSession) {
            MobicentsSipSession sipSession = (MobicentsSipSession)obj;
            if (sipSession.getKey().equals(this.getKey())) {
                if (sipSession.getKey().getToTag() == null && this.getKey().getToTag() == null) {
                    return true;
                }
                return sipSession.getKey().getToTag() != null && this.getKey().getToTag() != null && sipSession.getKey().getToTag().equals(this.getKey().getToTag());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public SipApplicationRouterInfo getNextSipApplicationRouterInfo() {
        return this.nextSipApplicationRouterInfo;
    }

    public void setNextSipApplicationRouterInfo(SipApplicationRouterInfo routerInfo) {
        this.nextSipApplicationRouterInfo = routerInfo;
    }

    public void setAckReceived(long cSeq, boolean ackReceived) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting AckReceived to : " + ackReceived + " for CSeq " + cSeq));
        }
        this.acksReceived.put(cSeq, ackReceived);
        if (ackReceived) {
            this.cleanupAcksReceived(cSeq);
        }
    }

    protected boolean isAckReceived(long cSeq) {
        if (this.acksReceived == null) {
            return true;
        }
        Boolean ackReceived = this.acksReceived.get(cSeq);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("isAckReceived for CSeq " + cSeq + " : " + ackReceived));
        }
        if (ackReceived == null) {
            return true;
        }
        return ackReceived;
    }

    protected void cleanupAcksReceived(long remoteCSeq) {
        ArrayList<Long> toBeRemoved = new ArrayList<Long>();
        for (Map.Entry<Long, Boolean> entry : this.acksReceived.entrySet()) {
            long cSeq = entry.getKey();
            boolean ackReceived = entry.getValue();
            if (!ackReceived || cSeq >= remoteCSeq) continue;
            toBeRemoved.add(cSeq);
        }
        for (Long cSeq : toBeRemoved) {
            this.acksReceived.remove(cSeq);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("removed ackReceived for CSeq " + cSeq));
        }
    }

    public long getCseq() {
        return this.cseq;
    }

    public void setCseq(long cseq) {
        this.cseq = cseq;
    }

    public boolean validateCSeq(MobicentsSipServletRequest sipServletRequest) {
        Request request = (Request)sipServletRequest.getMessage();
        long localCseq = this.cseq;
        long remoteCSeq = ((CSeqHeader)request.getHeader("CSeq")).getSeqNumber();
        String method = request.getMethod();
        boolean isAck = "ACK".equalsIgnoreCase(method);
        boolean isPrackCancel = "PRACK".equalsIgnoreCase(method) || "CANCEL".equalsIgnoreCase(method);
        boolean resetLocalCSeq = true;
        if (isAck && this.isAckReceived(remoteCSeq)) {
            logger.debug((Object)"ACK filtered out as a retransmission. This Sip Session already has been ACKed.");
            return false;
        }
        if (isAck) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("localCSeq : " + localCseq + ", remoteCSeq : " + remoteCSeq));
            }
            this.setAckReceived(remoteCSeq, true);
        }
        if (localCseq == remoteCSeq && !isAck) {
            logger.debug((Object)("dropping retransmission " + request + " since it matches the current sip session cseq " + localCseq));
            return false;
        }
        if (localCseq > remoteCSeq) {
            if (!isAck && !isPrackCancel) {
                logger.error((Object)("CSeq out of order for the following request " + sipServletRequest));
                if ("INVITE".equalsIgnoreCase(method)) {
                    this.setAckReceived(remoteCSeq, false);
                }
                SipServletResponse response = sipServletRequest.createResponse(500, "CSeq out of order");
                try {
                    response.send();
                }
                catch (IOException e) {
                    logger.error((Object)"Can not send error response", (Throwable)e);
                }
                return false;
            }
            resetLocalCSeq = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resetLocalCSeq : " + resetLocalCSeq));
        }
        if (resetLocalCSeq) {
            this.setCseq(remoteCSeq);
            if ("INVITE".equalsIgnoreCase(method)) {
                this.setAckReceived(remoteCSeq, false);
            }
        }
        return true;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public void scheduleAsynchronousWork(SipSessionAsynchronousWork work) {
        this.sipFactory.getSipApplicationDispatcher().getAsynchronousExecutor().execute(new SipSessionAsyncTask(this.key, work, this.sipFactory));
    }

    public int getRequestsPending() {
        return this.requestsPending;
    }

    public void setRequestsPending(int requests) {
        if (requests < 0) {
            requests = 0;
        }
        this.requestsPending = requests;
    }

    public void setCopyRecordRouteHeadersOnSubsequentResponses(boolean copyRecordRouteHeadersOnSubsequentResponses) {
        this.copyRecordRouteHeadersOnSubsequentResponses = copyRecordRouteHeadersOnSubsequentResponses;
    }

    public boolean getCopyRecordRouteHeadersOnSubsequentResponses() {
        return this.copyRecordRouteHeadersOnSubsequentResponses;
    }

    public void setSipSessionSecurity(MobicentsSipSessionSecurity sipSessionSecurity) {
        this.sipSessionSecurity = sipSessionSecurity;
    }

    public MobicentsSipSessionSecurity getSipSessionSecurity() {
        if (this.sipSessionSecurity == null) {
            this.sipSessionSecurity = new SipSessionSecurity();
        }
        return this.sipSessionSecurity;
    }

    public void acquire() {
        if (this.semaphore != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before semaphore acquire for sipSession=" + this + " semaphore=" + this.semaphore));
            }
            try {
                while (!this.semaphore.tryAcquire(30000L, TimeUnit.MILLISECONDS)) {
                    logger.warn((Object)("Failed to acquire session semaphore " + this.semaphore + " for 30 secs. We will unlock the " + "semaphore no matter what because the " + "transaction is about to timeout. THIS " + "MIGHT ALSO BE CONCURRENCY CONTROL RISK." + " sip Session is" + this));
                    this.semaphore.release();
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)("Problem acquiring semaphore on sip session " + this), (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("After semaphore acquire for sipSession=" + this + " semaphore=" + this.semaphore));
            }
        }
    }

    public void release() {
        if (this.semaphore != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before Semaphore released for sipSession=" + this + " semaphore=" + this.semaphore));
            }
            if (this.semaphore.availablePermits() > 0) {
                logger.warn((Object)("About to release semaphore but we expected permits = 0. We will adjust to normal " + this.semaphore + " sip session=" + this));
                while (this.semaphore.availablePermits() > 0) {
                    try {
                        this.semaphore.acquire();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.semaphore.availablePermits() < 0) {
                logger.warn((Object)("About to release semaphore but we expected permits = 0. We will adjust to normal " + this.semaphore + " sip session=" + this));
                while (this.semaphore.availablePermits() < 0) {
                    try {
                        this.semaphore.release();
                    }
                    catch (Exception exception) {}
                }
            }
            this.semaphore.release();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("After Semaphore released for sipSession=" + this + " semaphore=" + this.semaphore));
            }
        }
    }

    public void setFlow(javax.sip.address.SipURI flow) {
        this.flow = flow;
    }

    public javax.sip.address.SipURI getFlow() {
        return this.flow;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public void setOrphan(boolean orphan) {
        this.orphan = orphan;
    }

    public void setBypassLoadBalancer(boolean bypassLoadBalancer) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting bypassLoadBalancer: " + bypassLoadBalancer + " on the sip session " + this.key));
        }
        this.bypassLoadBalancer = bypassLoadBalancer;
    }

    public boolean getBypassLoadBalancer() {
        return this.bypassLoadBalancer;
    }

    public void setBypassProxy(boolean bypassProxy) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting bypassProxy: " + bypassProxy + " on the sip session " + this.key));
        }
        this.bypassProxy = bypassProxy;
    }

    public boolean getBypassProxy() {
        return this.bypassProxy;
    }
}

