/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.timers;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.TimerListener;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.timers.MobicentsServletTimer;

public class ServletTimerImpl
implements MobicentsServletTimer,
Runnable {
    private static final Logger logger = Logger.getLogger(ServletTimerImpl.class);
    private MobicentsSipApplicationSessionKey appSessionKey;
    private SipManager sipManager;
    private ScheduledFuture<?> future;
    private Serializable info;
    private long scheduledExecutionTime = 0L;
    private long delay = 0L;
    private long period = 0L;
    private long numInvocations = 0L;
    private long firstExecution = 0L;
    private boolean fixedDelay = false;
    private boolean persistent = false;
    private boolean isCanceled = false;
    String id = null;
    private TimerListener listener;
    private boolean isRepeatingTimer = true;
    private final Object TIMER_LOCK = new Object();

    public ServletTimerImpl(Serializable info, long delay, TimerListener listener, MobicentsSipApplicationSession appSession) {
        this(info, delay, false, 0L, listener, appSession);
        this.isRepeatingTimer = false;
    }

    public ServletTimerImpl(Serializable info, long delay, boolean fixedDelay, long period, TimerListener listener, MobicentsSipApplicationSession appSession) {
        this.id = UUID.randomUUID().toString();
        this.info = info;
        this.delay = delay;
        this.scheduledExecutionTime = delay + System.currentTimeMillis();
        this.fixedDelay = fixedDelay;
        this.period = period;
        this.listener = listener;
        this.appSessionKey = appSession.getKey();
        this.sipManager = appSession.getSipContext().getSipManager();
    }

    public void cancel() {
        this.cancel(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean mayInterruptIfRunning, boolean updateAppSessionReadyToInvalidateState) {
        MobicentsSipApplicationSession appSessionToCancelThisTimersFrom = null;
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(mayInterruptIfRunning);
                this.isCanceled = true;
                appSessionToCancelThisTimersFrom = this.getApplicationSession();
                this.future = null;
                this.info = null;
            }
        }
        if (appSessionToCancelThisTimersFrom != null && updateAppSessionReadyToInvalidateState) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removing servlet timer " + this.id + " from sip application session " + appSessionToCancelThisTimersFrom + " and updating its ready to invalidate state " + updateAppSessionReadyToInvalidateState));
            }
            appSessionToCancelThisTimersFrom.removeServletTimer((ServletTimer)this, updateAppSessionReadyToInvalidateState);
        }
    }

    public long getDelay() {
        return this.delay;
    }

    public long getPeriod() {
        return this.period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobicentsSipApplicationSession getApplicationSession() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            return this.sipManager.getSipApplicationSession(this.appSessionKey, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationSession(MobicentsSipApplicationSession sipApplicationSession) {
        if (sipApplicationSession != null) {
            Object object = this.TIMER_LOCK;
            synchronized (object) {
                this.appSessionKey = sipApplicationSession.getKey();
            }
        }
    }

    public Serializable getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scheduledExecutionTime() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            return this.scheduledExecutionTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFuture(ScheduledFuture<?> f) {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            this.future = f;
        }
    }

    public boolean canRun() {
        return this.future != null && !this.future.isCancelled() && !this.future.isDone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Info = ").append(this.info).append('\n');
        sb.append("Scheduled execution time = ").append(this.scheduledExecutionTime).append('\n');
        sb.append("Time now = ").append(System.currentTimeMillis()).append('\n');
        sb.append("SipApplicationSession = ").append(this.appSessionKey).append('\n');
        sb.append("ScheduledFuture = ").append(this.future).append('\n');
        sb.append("Delay = ").append(this.delay).append('\n');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MobicentsSipApplicationSession sipApplicationSession = this.getApplicationSession();
        SipContext sipContext = sipApplicationSession.getSipContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("running Servlet Timer " + this.id + " for sip application session " + sipApplicationSession));
        }
        boolean batchStarted = false;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            sipContext.enterSipContext();
            sipContext.enterSipApp(sipApplicationSession, null, false, true);
            batchStarted = sipContext.enterSipAppHa(true);
            if (!this.isCanceled) {
                this.listener.timeout((ServletTimer)this);
            } else {
                logger.debug((Object)("running Servlet Timer " + this.id + " for sip application session " + sipApplicationSession + " is cancelled, so we skip its timerListener's timeout() method call!"));
            }
        }
        catch (Throwable t) {
            logger.error((Object)"An unexpected exception happened in the timer callback!", t);
        }
        finally {
            try {
                sipContext.exitSipContext(oldClassLoader);
                if (this.isRepeatingTimer) {
                    this.estimateNextExecution();
                } else {
                    this.cancel();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Servlet Timer " + this.id + " for sip application session " + sipApplicationSession + " ended"));
                }
            }
            finally {
                sipContext.exitSipAppHa(null, null, batchStarted);
                sipContext.exitSipApp(sipApplicationSession, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estimateNextExecution() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            if (this.fixedDelay) {
                this.scheduledExecutionTime = this.period + System.currentTimeMillis();
            } else {
                if (this.firstExecution == 0L) {
                    this.firstExecution = this.scheduledExecutionTime;
                }
                long now = System.currentTimeMillis();
                long executedTime = this.numInvocations++ * this.period;
                this.scheduledExecutionTime = this.firstExecution + executedTime;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("next execution estimated to run at " + this.scheduledExecutionTime));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("current time is " + now));
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeRemaining() {
        Object object = this.TIMER_LOCK;
        synchronized (object) {
            return this.scheduledExecutionTime - System.currentTimeMillis();
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

