/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.IllegalTransactionStateException;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.address.TelURL;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.Parameters;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.ext.javax.sip.dns.DNSServerLocator;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.GenericURIImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.MobicentsSipServlet;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.b2bua.MobicentsB2BUAHelper;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.security.MobicentsAuthInfoEntry;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SipRequestDispatcher;
import org.mobicents.servlet.sip.message.B2buaHelperImpl;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.security.AuthInfoEntry;
import org.mobicents.servlet.sip.security.AuthInfoImpl;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public abstract class SipServletRequestImpl
extends SipServletMessageImpl
implements MobicentsSipServletRequest {
    public static final String STALE = "stale";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SipServletRequestImpl.class);
    private static final String EXCEPTION_MESSAGE = "The context does not allow you to modify this request !";
    public static final Set<String> NON_INITIAL_SIP_REQUEST_METHODS = new HashSet<String>();
    private SipServletRequestImpl linkedRequest;
    private boolean createDialog;
    private AddressImpl poppedRoute;
    private RouteHeader poppedRouteHeader;
    private SipApplicationRoutingDirective routingDirective = SipApplicationRoutingDirective.NEW;
    private RoutingState routingState;
    private transient SipServletResponse lastFinalResponse;
    private transient SipServletResponse lastInformationalResponse;
    private SipApplicationRoutingRegion routingRegion;
    private transient URI subscriberURI;
    private boolean isInitial;
    private boolean isFinalResponseGenerated;
    private boolean is1xxResponseGenerated;
    private transient boolean isReadOnly;
    private transient Transaction inviteTransactionToCancel;

    public SipServletRequestImpl() {
    }

    protected SipServletRequestImpl(Request request, SipFactoryImpl sipFactoryImpl, MobicentsSipSession sipSession, Transaction transaction, Dialog dialog, boolean createDialog) {
        super((Message)request, sipFactoryImpl, transaction, sipSession, dialog);
        this.createDialog = createDialog;
        this.routingState = SipServletRequestImpl.checkRoutingState(this, dialog);
        if (RoutingState.INITIAL.equals((Object)this.routingState)) {
            this.isInitial = true;
        }
        this.isFinalResponseGenerated = false;
    }

    @Override
    public AddressImpl.ModifiableRule getModifiableRule(String headerName) {
        AddressImpl.ModifiableRule overriden = this.retrieveModifiableOverriden();
        if (overriden != null) {
            return overriden;
        }
        String hName = SipServletRequestImpl.getFullHeaderName(headerName);
        boolean isSystemHeader = JainSipUtils.SYSTEM_HEADERS.contains(hName);
        if (isSystemHeader) {
            return AddressImpl.ModifiableRule.NotModifiable;
        }
        if (headerName.equalsIgnoreCase("From")) {
            if (!this.isCommitted()) {
                return AddressImpl.ModifiableRule.From;
            }
            return AddressImpl.ModifiableRule.NotModifiable;
        }
        if (headerName.equalsIgnoreCase("To")) {
            if (!this.isCommitted()) {
                return AddressImpl.ModifiableRule.To;
            }
            return AddressImpl.ModifiableRule.NotModifiable;
        }
        if (hName.equals("Contact")) {
            Request request = (Request)this.message;
            String method = request.getMethod();
            if (method.equals("REGISTER")) {
                return AddressImpl.ModifiableRule.ContactNotSystem;
            }
            return AddressImpl.ModifiableRule.ContactSystem;
        }
        return AddressImpl.ModifiableRule.Modifiable;
    }

    public SipServletRequest createCancel() {
        this.checkReadOnly();
        if (!((Request)this.message).getMethod().equals("INVITE")) {
            throw new IllegalStateException("Cannot create CANCEL for non invite " + this.message);
        }
        if (super.getTransaction() == null || super.getTransaction() instanceof ServerTransaction) {
            throw new IllegalStateException("No client transaction found! " + super.getTransaction());
        }
        if (RoutingState.FINAL_RESPONSE_SENT.equals((Object)this.routingState) || this.lastFinalResponse != null) {
            if (this.lastFinalResponse != null) {
                throw new IllegalStateException("final response already sent : " + this.lastFinalResponse);
            }
            throw new IllegalStateException("final response already sent!");
        }
        try {
            Request cancelRequest = ((ClientTransaction)this.getTransaction()).createCancel();
            SipServletRequestImpl newRequest = (SipServletRequestImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(cancelRequest, this.getSipSession(), null, this.getTransaction().getDialog(), false);
            newRequest.inviteTransactionToCancel = super.getTransaction();
            return newRequest;
        }
        catch (SipException ex) {
            throw new IllegalStateException("Could not create cancel", ex);
        }
    }

    public SipServletResponse createResponse(int statusCode) {
        return this.createResponse(statusCode, null, true, false);
    }

    public SipServletResponse createResponse(int statusCode, String reasonPhrase) {
        return this.createResponse(statusCode, reasonPhrase, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipServletResponse createResponse(int statusCode, String reasonPhrase, boolean validate, boolean hasBeenReceived) {
        this.checkReadOnly();
        Transaction transaction = this.getTransaction();
        if (RoutingState.CANCELLED.equals((Object)this.routingState)) {
            throw new IllegalStateException("Cannot create a response for the invite, a CANCEL has been received and the INVITE was replied with a 487!");
        }
        if (validate) {
            if (transaction == null) {
                throw new IllegalStateException("Cannot create a response for request " + this.message + " transaction is null, a final error response has probably already been sent");
            }
            if (transaction instanceof ClientTransaction) {
                throw new IllegalStateException("Cannot create a response for request " + this.message + " not a server transaction " + transaction);
            }
        }
        try {
            Request request = (Request)this.getMessage();
            Response response = SipFactoryImpl.messageFactory.createResponse(statusCode, request);
            if (reasonPhrase != null) {
                response.setReasonPhrase(reasonPhrase);
            }
            MobicentsSipSession session = this.getSipSession();
            String requestMethod = this.getMethod();
            if (!(statusCode <= 100 && this.isInitial() || statusCode > 606)) {
                ToHeader toHeader = (ToHeader)response.getHeader("To");
                if (toHeader.getTag() == null) {
                    Dialog dialog = transaction.getDialog();
                    if (session != null && dialog != null && dialog.getLocalTag() != null && dialog.getLocalTag().length() > 0 && session.getKey().getToTag() != null && session.getKey().getToTag().length() > 0) {
                        if (!dialog.getLocalTag().equals(session.getKey().getToTag())) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("setting session ToTag: " + session.getKey().getToTag()));
                            }
                            toHeader.setTag(session.getKey().getToTag());
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("setting dialog LocalTag: " + dialog.getLocalTag()));
                            }
                            toHeader.setTag(dialog.getLocalTag());
                        }
                    } else if (session != null && session.getSipApplicationSession() != null) {
                        MobicentsSipApplicationSessionKey sipAppSessionKey = session.getSipApplicationSession().getKey();
                        MobicentsSipSessionKey sipSessionKey = session.getKey();
                        SipServletRequestImpl sipServletRequestImpl = this;
                        synchronized (sipServletRequestImpl) {
                            String toTag = sipSessionKey.getToTag();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("sipSessionKey ToTag : " + toTag));
                            }
                            if (toTag == null) {
                                toTag = ApplicationRoutingHeaderComposer.getHash(this.sipFactoryImpl.getSipApplicationDispatcher(), sipSessionKey.getApplicationName(), sipAppSessionKey.getId());
                                session.getKey().setToTag(toTag, false);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("setting ToTag: " + toTag));
                            }
                            toHeader.setTag(toTag);
                        }
                    } else {
                        toHeader.setTag(Integer.toString(new Random().nextInt(10000000)));
                    }
                }
                boolean setContactHeader = true;
                if (statusCode >= 300 && statusCode < 400 || statusCode == 485 || "REGISTER".equals(requestMethod) || "OPTIONS".equals(requestMethod) || "BYE".equals(requestMethod) || "CANCEL".equals(requestMethod) || "PRACK".equals(requestMethod) || "MESSAGE".equals(requestMethod) || "PUBLISH".equals(requestMethod)) {
                    setContactHeader = false;
                }
                if (setContactHeader) {
                    boolean sipURI;
                    SipConnector sipConnector;
                    String outboundInterface = null;
                    if (session != null) {
                        outboundInterface = session.getOutboundInterface();
                    }
                    ContactHeader contactHeader = JainSipUtils.createContactHeader(this.sipFactoryImpl.getSipNetworkInterfaceManager(), request, null, null, outboundInterface);
                    String transport = "udp";
                    if (session != null && session.getTransport() != null) {
                        transport = session.getTransport();
                    }
                    if ((sipConnector = StaticServiceHolder.sipStandardService.findSipConnector(transport)) != null && sipConnector.isUseStaticAddress() && session != null && session.getProxy() == null && (sipURI = contactHeader.getAddress().getURI().isSipURI())) {
                        javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)contactHeader.getAddress().getURI();
                        sipUri.setHost(sipConnector.getStaticServerAddress());
                        sipUri.setPort(sipConnector.getStaticServerPort());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("We're adding this contact header to our new response: '" + contactHeader + ", transport=" + JainSipUtils.findTransport((Message)request)));
                    }
                    response.setHeader((Header)contactHeader);
                }
            }
            if (session != null && session.getCopyRecordRouteHeadersOnSubsequentResponses() && !this.isInitial() && "INVITE".equals(requestMethod)) {
                ListIterator recordRouteHeaders = request.getHeaders("Record-Route");
                while (recordRouteHeaders.hasNext()) {
                    RecordRouteHeader recordRouteHeader = (RecordRouteHeader)recordRouteHeaders.next();
                    response.addHeader((Header)recordRouteHeader);
                }
            }
            SipServletResponseImpl newSipServletResponse = (SipServletResponseImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletResponse(response, (Transaction)(validate ? (ServerTransaction)transaction : transaction), session, this.getDialog(), hasBeenReceived, false);
            newSipServletResponse.setOriginalRequest(this);
            if (!"PRACK".equals(requestMethod) && statusCode >= 200 && statusCode <= 606) {
                this.isFinalResponseGenerated = true;
            }
            if (statusCode >= 100 && statusCode < 200) {
                this.is1xxResponseGenerated = true;
            }
            return newSipServletResponse;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad status code " + statusCode, ex);
        }
    }

    public B2buaHelper getB2buaHelper() {
        this.checkReadOnly();
        MobicentsSipSession session = this.getSipSession();
        if (session.getProxy() != null) {
            throw new IllegalStateException("Proxy already present");
        }
        MobicentsB2BUAHelper b2buaHelper = session.getB2buaHelper();
        if (b2buaHelper != null) {
            return b2buaHelper;
        }
        b2buaHelper = new B2buaHelperImpl();
        b2buaHelper.setMobicentsSipFactory((MobicentsSipFactory)this.sipFactoryImpl);
        b2buaHelper.setSipManager(session.getSipApplicationSession().getSipContext().getSipManager());
        if (JainSipUtils.DIALOG_CREATING_METHODS.contains(this.getMethod())) {
            this.createDialog = true;
        }
        session.setB2buaHelper(b2buaHelper);
        return b2buaHelper;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public int getMaxForwards() {
        return ((MaxForwardsHeader)((Request)this.message).getHeader("Max-Forwards")).getMaxForwards();
    }

    public Address getPoppedRoute() {
        if (this.poppedRoute == null && this.poppedRouteHeader != null || this.poppedRoute != null && this.poppedRouteHeader != null && !this.poppedRoute.getAddress().equals((Object)this.poppedRouteHeader.getAddress())) {
            this.poppedRoute = new AddressImpl(this.poppedRouteHeader.getAddress(), null, this.getTransaction() == null ? AddressImpl.ModifiableRule.Modifiable : AddressImpl.ModifiableRule.NotModifiable);
        }
        return this.poppedRoute;
    }

    public RouteHeader getPoppedRouteHeader() {
        return this.poppedRouteHeader;
    }

    public void setPoppedRoute(RouteHeader routeHeader) {
        this.poppedRouteHeader = routeHeader;
    }

    public Proxy getProxy() throws TooManyHopsException {
        this.checkReadOnly();
        MobicentsSipSession session = this.getSipSession();
        if (session.getB2buaHelper() != null) {
            throw new IllegalStateException("Cannot proxy request");
        }
        return this.getProxy(true);
    }

    public Proxy getProxy(boolean create) throws TooManyHopsException {
        this.checkReadOnly();
        MobicentsSipSession session = this.getSipSession();
        if (session.getB2buaHelper() != null) {
            throw new IllegalStateException("Cannot proxy request");
        }
        MaxForwardsHeader mfHeader = (MaxForwardsHeader)this.message.getHeader("Max-Forwards");
        if (mfHeader.getMaxForwards() <= 0) {
            try {
                this.createResponse(483, "Too many hops").send();
            }
            catch (IOException e) {
                throw new RuntimeException("could not send the Too many hops response out !", e);
            }
            throw new TooManyHopsException();
        }
        if (create) {
            MobicentsProxy proxy = session.getProxy();
            boolean createNewProxy = false;
            if (this.isInitial() && proxy != null && proxy.getOriginalRequest() == null) {
                createNewProxy = true;
            }
            if (proxy == null || createNewProxy) {
                session.setProxy((MobicentsProxy)new ProxyImpl(this, this.sipFactoryImpl));
            }
        }
        return session.getProxy();
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public URI getRequestURI() {
        Request request = (Request)this.message;
        if (request.getRequestURI() instanceof javax.sip.address.SipURI) {
            return new SipURIImpl((javax.sip.address.SipURI)request.getRequestURI(), AddressImpl.ModifiableRule.Modifiable);
        }
        if (request.getRequestURI() instanceof TelURL) {
            return new TelURLImpl((TelURL)request.getRequestURI());
        }
        return new GenericURIImpl(request.getRequestURI());
    }

    public boolean isInitial() {
        return this.isInitial && !this.isOrphan();
    }

    public boolean isCommitted() {
        if (this.getTransaction() instanceof ServerTransaction && (RoutingState.FINAL_RESPONSE_SENT.equals((Object)this.routingState) || this.isFinalResponseGenerated)) {
            return true;
        }
        return this.getTransaction() instanceof ClientTransaction && this.isMessageSent;
    }

    @Override
    protected void checkMessageState() {
        if (this.isMessageSent || this.getTransaction() instanceof ServerTransaction) {
            throw new IllegalStateException("Message already sent or incoming message");
        }
    }

    public void pushPath(Address uri) {
        this.checkReadOnly();
        if (!"REGISTER".equalsIgnoreCase(((Request)this.message).getMethod())) {
            throw new IllegalStateException("Cannot push a Path on a non REGISTER request !");
        }
        if (uri.getURI() instanceof TelURL) {
            throw new IllegalArgumentException("Cannot push a TelUrl as a path !");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pushing path into message of value [" + uri + "]"));
        }
        try {
            Header p = SipFactoryImpl.headerFactory.createHeader("Path", uri.toString());
            this.message.addFirst(p);
        }
        catch (Exception e) {
            logger.error((Object)("Error while pushing path [" + uri + "]"));
            throw new IllegalArgumentException("Error pushing path ", e);
        }
    }

    public void pushRoute(Address address) {
        this.checkReadOnly();
        if (address.getURI() instanceof TelURL) {
            throw new IllegalArgumentException("Cannot push a TelUrl as a route !");
        }
        javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)((AddressImpl)address).getAddress().getURI();
        this.pushRoute(sipUri);
    }

    public void pushRoute(SipURI uri) {
        this.checkReadOnly();
        javax.sip.address.SipURI sipUri = ((SipURIImpl)uri).getSipURI();
        sipUri.setLrParam();
        this.pushRoute(sipUri);
    }

    private void pushRoute(javax.sip.address.SipURI sipUri) {
        if (!this.isInitial() && this.getSipSession().getProxy() == null) {
            throw new IllegalStateException("Cannot push route on subsequent requests, only intial ones");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pushing route into message of value [" + sipUri + "]"));
        }
        sipUri.setLrParam();
        try {
            RouteHeader p = SipFactoryImpl.headerFactory.createRouteHeader(SipFactoryImpl.addressFactory.createAddress((javax.sip.address.URI)sipUri));
            this.message.addFirst((Header)p);
        }
        catch (SipException e) {
            logger.error((Object)("Error while pushing route [" + sipUri + "]"));
            throw new IllegalArgumentException("Error pushing route ", e);
        }
    }

    public void setMaxForwards(int n) {
        this.checkReadOnly();
        MaxForwardsHeader mfh = (MaxForwardsHeader)this.message.getHeader("Max-Forwards");
        try {
            if (mfh != null) {
                mfh.setMaxForwards(n);
            }
        }
        catch (Exception ex) {
            String s = "Error while setting max forwards";
            logger.error((Object)s, (Throwable)ex);
            throw new IllegalArgumentException(s, ex);
        }
    }

    public void setRequestURI(URI uri) {
        this.checkReadOnly();
        Request request = (Request)this.message;
        URIImpl uriImpl = (URIImpl)uri;
        javax.sip.address.URI wrappedUri = uriImpl.getURI();
        request.setRequestURI(wrappedUri);
    }

    public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) throws IllegalStateException {
        this.checkReadOnly();
        SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
        MobicentsSipSession session = this.getSipSession();
        if (directive == SipApplicationRoutingDirective.REVERSE || directive == SipApplicationRoutingDirective.CONTINUE) {
            if (origRequestImpl == null || !origRequestImpl.isInitial()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("directive to set : " + directive));
                    logger.debug((Object)("Original Request Routing State : " + (Object)((Object)origRequestImpl.getRoutingState())));
                }
                throw new IllegalStateException("Bad state -- cannot set routing directive");
            }
            session.setStateInfo(origRequestImpl.getSipSession().getStateInfo());
            this.currentApplicationName = origRequestImpl.getCurrentApplicationName();
            origRequestImpl.setLinkedRequest(this);
            this.setLinkedRequest(origRequestImpl);
        } else {
            Set ongoingTransactions = session.getOngoingTransactions();
            if (!SipSession.State.INITIAL.equals((Object)session.getState()) && ongoingTransactions != null && ongoingTransactions.size() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("session state : " + session.getState()));
                    logger.debug((Object)("numbers of ongoing transactions : " + ongoingTransactions.size()));
                }
                throw new IllegalStateException("Bad state -- cannot set routing directive");
            }
        }
        this.routingDirective = directive;
        this.linkedRequest = origRequestImpl;
    }

    public String getLocalName() {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public String getParameter(String name) {
        if (this.getPoppedRoute() != null) {
            return this.getPoppedRoute().getURI().getParameter(name);
        }
        return this.getRequestURI().getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> retval = new Vector<String>();
        if (this.getPoppedRoute() != null) {
            Iterator parameterNamesIt = this.getPoppedRoute().getURI().getParameterNames();
            while (parameterNamesIt.hasNext()) {
                String parameterName = (String)parameterNamesIt.next();
                retval.add(parameterName);
            }
        } else {
            Iterator parameterNamesIt = this.getRequestURI().getParameterNames();
            while (parameterNamesIt.hasNext()) {
                String parameterName = (String)parameterNamesIt.next();
                retval.add(parameterName);
            }
        }
        return retval.elements();
    }

    public String[] getParameterValues(String name) {
        return new String[]{this.getParameter(name)};
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteHost() {
        if (this.getTransaction() != null) {
            if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null && ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress().getHostAddress() != null) {
                return ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress().getHostAddress();
            }
            return ((SIPTransaction)this.getTransaction()).getPeerAddress();
        }
        ViaHeader via = (ViaHeader)this.message.getHeader("Via");
        if (via == null) {
            return null;
        }
        return via.getHost();
    }

    public RequestDispatcher getRequestDispatcher(String handler) {
        MobicentsSipServlet sipServletImpl = this.getSipSession().getSipApplicationSession().getSipContext().findSipServletByName(handler);
        if (sipServletImpl == null) {
            throw new IllegalArgumentException(handler + " is not a valid servlet name");
        }
        return new SipRequestDispatcher(sipServletImpl);
    }

    public String getScheme() {
        return ((Request)this.message).getRequestURI().getScheme();
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public SipApplicationRoutingDirective getRoutingDirective() {
        if (!this.isInitial()) {
            throw new IllegalStateException("the request is not initial");
        }
        return this.routingDirective;
    }

    @Override
    public void send() throws IOException {
        this.checkReadOnly();
        this.checkMessageState();
        Request request = (Request)this.message;
        String requestMethod = this.getMethod();
        SipApplicationDispatcher sipApplicationDispatcher = this.sipFactoryImpl.getSipApplicationDispatcher();
        MobicentsSipSession session = this.getSipSession();
        DNSServerLocator dnsServerLocator = sipApplicationDispatcher.getDNSServerLocator();
        Hop hop = null;
        if (dnsServerLocator != null) {
            if ("CANCEL".equals(requestMethod)) {
                TransactionApplicationData inviteTxAppData = (TransactionApplicationData)this.inviteTransactionToCancel.getApplicationData();
                if (inviteTxAppData != null && inviteTxAppData.getHops() != null) {
                    hop = inviteTxAppData.getHops().peek();
                }
            } else {
                javax.sip.address.URI uriToResolve = request.getRequestURI();
                RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
                uriToResolve = routeHeader != null ? routeHeader.getAddress().getURI() : this.resolveSipOutbound(uriToResolve);
                String uriToResolveTransport = ((javax.sip.address.SipURI)uriToResolve).getTransportParam();
                boolean transportParamModified = false;
                if (session.getProxy() == null && session.getTransport() != null && uriToResolve.isSipURI() && uriToResolveTransport == null && !session.getTransport().equalsIgnoreCase("UDP")) {
                    try {
                        ((javax.sip.address.SipURI)uriToResolve).setTransportParam(session.getTransport());
                        transportParamModified = true;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                Queue hops = dnsServerLocator.locateHops(uriToResolve);
                if (transportParamModified) {
                    if (uriToResolveTransport == null) {
                        ((javax.sip.address.SipURI)uriToResolve).removeParameter("transport");
                    } else {
                        try {
                            ((javax.sip.address.SipURI)uriToResolve).setTransportParam(uriToResolveTransport);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
                if (hops != null && hops.size() > 0) {
                    hop = (Hop)hops.peek();
                    this.transactionApplicationData.setHops(hops);
                }
            }
        }
        this.send(hop);
    }

    private javax.sip.address.URI resolveSipOutbound(javax.sip.address.URI uriToResolve) {
        if (!uriToResolve.isSipURI()) {
            return uriToResolve;
        }
        javax.sip.address.SipURI sipURI = (javax.sip.address.SipURI)uriToResolve;
        if (sipURI.getParameter("ob") == null) {
            return uriToResolve;
        }
        MobicentsSipSession session = this.getSipSession();
        javax.sip.address.SipURI flow = session.getFlow();
        if (flow != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found a flow \"" + flow + "\" for the original uri \"" + uriToResolve + "\""));
            }
            return flow;
        }
        return uriToResolve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Hop hop) throws IOException {
        Request request = (Request)this.message;
        String requestMethod = this.getMethod();
        MobicentsSipSession session = this.getSipSession();
        String sessionTransport = session.getTransport();
        SipNetworkInterfaceManager sipNetworkInterfaceManager = this.sipFactoryImpl.getSipNetworkInterfaceManager();
        MobicentsSipApplicationSession sipApplicationSession = session.getSipApplicationSession();
        try {
            ClientTransaction ctx;
            SipApplicationRouterInfo routerInfo;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("session transport is " + sessionTransport));
            }
            if (session != null && session.getProxy() == null) {
                ((MessageExt)this.message).setApplicationData((Object)session.getTransport());
            }
            if ("CANCEL".equals(requestMethod)) {
                this.getSipSession().setRequestsPending(0);
                Transaction tx = this.inviteTransactionToCancel;
                if (tx != null) {
                    if (tx.getState() == null || tx.getState().equals((Object)TransactionState.CALLING) || tx.getState().equals((Object)TransactionState.TRYING)) {
                        logger.debug((Object)("Can not send CANCEL. Will try to STOP retransmissions " + tx + " tx state " + tx.getState()));
                        StaticServiceHolder.disableRetransmissionTimer.invoke((Object)tx, new Object[0]);
                        if (tx.getApplicationData() instanceof TransactionApplicationData) {
                            TransactionApplicationData tad = (TransactionApplicationData)tx.getApplicationData();
                            tad.setCanceled(true);
                        }
                        return;
                    }
                } else {
                    logger.debug((Object)"Can not send CANCEL because no responses arrived. Can not stop retransmissions. The transaction is null");
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("hop " + hop));
            }
            if (hop != null) {
                ((MessageExt)this.message).setApplicationData((Object)hop.getTransport());
            }
            this.checkViaHeaderAddition(hop);
            String transport = JainSipUtils.findTransport((Message)request);
            if (sessionTransport == null) {
                session.setTransport(transport);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The found transport for sending request is '" + transport + "'"));
            }
            MobicentsExtendedListeningPoint matchingListeningPoint = null;
            String outboundInterface = session.getOutboundInterface();
            if (outboundInterface != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to find listening point with outbound interface " + outboundInterface));
                }
                javax.sip.address.SipURI outboundInterfaceURI = null;
                try {
                    outboundInterfaceURI = (javax.sip.address.SipURI)SipFactoryImpl.addressFactory.createURI(outboundInterface);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("couldn't parse the outbound interface " + outboundInterface, e);
                }
                matchingListeningPoint = sipNetworkInterfaceManager.findMatchingListeningPoint(outboundInterfaceURI, false);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Matching listening point " + matchingListeningPoint));
                }
            }
            if (matchingListeningPoint == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to find listening point with transport " + transport));
                }
                matchingListeningPoint = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Matching listening point " + matchingListeningPoint));
                }
            }
            SipProvider sipProvider = matchingListeningPoint.getSipProvider();
            SipConnector sipConnector = matchingListeningPoint.getSipConnector();
            this.checkViaHeaderUpdateOrForStaticExternalAddressUsage(matchingListeningPoint, hop);
            if ("ACK".equals(requestMethod)) {
                this.addDnsRoute(hop, request);
                this.sendAck(transport, sipConnector, matchingListeningPoint);
                return;
            }
            boolean addDNSRoute = true;
            if (this.isInitial() && (routerInfo = this.sipFactoryImpl.getNextInterestedApplication(this)).getNextApplicationName() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("routing back to the container since the following app is interested " + routerInfo.getNextApplicationName()));
                }
                this.addInfoForRoutingBackToContainer(routerInfo, session.getSipApplicationSession().getKey().getId(), session.getKey().getApplicationName());
                addDNSRoute = false;
            }
            if (addDNSRoute) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"routing outside the container since no more apps are interested.");
                }
                if (this.isInitial() || this.dialog == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("bypassLoadBalancer: " + session.getBypassLoadBalancer() + ", sipFactoryImpl UseLoadBalancer: " + this.sipFactoryImpl.isUseLoadBalancer() + ", matchingListeningPoint: " + matchingListeningPoint));
                    }
                    if (!session.getBypassLoadBalancer() && this.sipFactoryImpl.isUseLoadBalancer()) {
                        if (matchingListeningPoint != null && matchingListeningPoint.isUseLoadBalancer()) {
                            this.sipFactoryImpl.addLoadBalancerRouteHeader(request, matchingListeningPoint);
                            addDNSRoute = false;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"adding route to Load Balancer since we are in a HA configuration  and no more apps are interested.");
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Not Using load balancer as it is not enabled for listeningPoint " + matchingListeningPoint));
                        }
                    } else if (!session.getBypassProxy() && StaticServiceHolder.sipStandardService.getOutboundProxy() != null) {
                        this.sipFactoryImpl.addLoadBalancerRouteHeader(request, null);
                        addDNSRoute = false;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"adding route to outbound proxy (no load balancer set) since we have outboundProxy configured  and no more apps are interested.");
                        }
                    }
                }
            }
            if (addDNSRoute) {
                this.addDnsRoute(hop, request);
            }
            if (logger.isDebugEnabled()) {
                this.getSipSession().getSipApplicationSession().getSipContext().getSipManager().dumpSipSessions();
            }
            if (super.getTransaction() == null) {
                this.setSystemContactHeader(sipConnector, matchingListeningPoint, transport);
                if (!this.isInitial() && sipConnector != null && sipConnector.isUseStaticAddress()) {
                    JainSipUtils.optimizeRouteHeaderAddressForInternalRoutingrequest(sipConnector, request, session, this.sipFactoryImpl, transport);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Getting new Client Tx for request " + request));
                }
                ctx = sipProvider.getNewClientTransaction(request);
                JainSipUtils.setTransactionTimers((TransactionExt)ctx, this.sipFactoryImpl.getSipApplicationDispatcher());
                Dialog dialog = null;
                if (session.getProxy() != null) {
                    if (this.isInitial() && session.getProxy().getRecordRoute()) {
                        ListIterator li = request.getHeaders("Record-Route");
                        while (li.hasNext()) {
                            RecordRouteHeader rrh = (RecordRouteHeader)li.next();
                            if (rrh == null) {
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("Unexpected RRH = null for this request" + request));
                                continue;
                            }
                            javax.sip.address.URI uri = rrh.getAddress().getURI();
                            if (!uri.isSipURI()) continue;
                            javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)uri;
                            String serverId = sipUri.getParameter("as");
                            String nextApp = sipUri.getParameter("appname");
                            MobicentsSipApplicationSessionKey sipAppKey = this.getSipSession().getSipApplicationSession().getKey();
                            String thisApp = this.sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(sipAppKey.getApplicationName());
                            if (!this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationServerId().equalsIgnoreCase(serverId) || !thisApp.equals(nextApp)) continue;
                            if (sipConnector != null && sipConnector.isUseStaticAddress()) {
                                sipUri.setHost(sipConnector.getStaticServerAddress());
                                sipUri.setPort(sipConnector.getStaticServerPort());
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Updated the RRH with static server address " + sipUri));
                        }
                    }
                } else {
                    dialog = ctx.getDialog();
                }
                if (dialog == null && this.createDialog && JainSipUtils.DIALOG_CREATING_METHODS.contains(this.getMethod())) {
                    dialog = sipProvider.getNewDialog((Transaction)ctx);
                    ((DialogExt)dialog).disableSequenceNumberValidation();
                    session.setSessionCreatingDialog(dialog);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("new Dialog for request " + request + ", ref = " + dialog));
                    }
                }
                if (this.linkedRequest != null) {
                    this.updateLinkedRequestAppDataMapping(ctx, dialog);
                }
                if (dialog != null) {
                    dialog.setApplicationData((Object)this.transactionApplicationData);
                }
                ctx.setApplicationData((Object)this.transactionApplicationData);
                super.setTransaction((Transaction)ctx);
                session.setSessionCreatingTransactionRequest((MobicentsSipServletMessage)this);
            } else if ("PRACK".equals(request.getMethod())) {
                ctx = sipProvider.getNewClientTransaction(request);
                JainSipUtils.setTransactionTimers((TransactionExt)ctx, this.sipFactoryImpl.getSipApplicationDispatcher());
                if (this.linkedRequest != null) {
                    this.updateLinkedRequestAppDataMapping(ctx, this.dialog);
                }
                ctx.setApplicationData((Object)this.transactionApplicationData);
                this.setTransaction((Transaction)ctx);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transaction is not null, where was it created? " + this.getTransaction()));
            }
            if (this.linkedRequest != null && !SipApplicationRoutingDirective.NEW.equals((Object)this.routingDirective) && !RoutingState.PROXIED.equals((Object)this.linkedRequest.getRoutingState())) {
                this.linkedRequest.setRoutingState(RoutingState.RELAYED);
            }
            session.addOngoingTransaction(this.getTransaction());
            session.updateStateOnSubsequentRequest((MobicentsSipServletRequest)this, false);
            this.checkSubscriptionStateHeaders(session);
            session.access();
            sipApplicationSession.access();
            Dialog dialog = this.getDialog();
            if (session.getProxy() != null) {
                dialog = null;
            }
            if (request.getMethod().equals("CANCEL")) {
                dialog = null;
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = sipApplicationSession.getSipContext().getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                if (dialog == null || dialog.getState() == null || dialog.getState() == DialogState.EARLY && !"PRACK".equals(requestMethod) && !"UPDATE".equals(requestMethod) || "CANCEL".equals(requestMethod)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sending the request " + request));
                    }
                    ((ClientTransaction)super.getTransaction()).sendRequest();
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sending the in dialog request " + request));
                    }
                    dialog.sendRequest((ClientTransaction)this.getTransaction());
                }
                this.sipFactoryImpl.getSipApplicationDispatcher().updateRequestsStatistics(request, false);
                this.isMessageSent = true;
                if (this.method.equals("INVITE")) {
                    session.setRequestsPending(session.getRequestsPending() + 1);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (Exception ex) {
            boolean skipTxTermination = false;
            Transaction tx = this.getTransaction();
            if (ex instanceof IllegalTransactionStateException && ((IllegalTransactionStateException)ex).getReason().equals((Object)IllegalTransactionStateException.Reason.RequestAlreadySent) || tx != null && !(tx instanceof ClientTransaction)) {
                skipTxTermination = true;
            }
            if (!skipTxTermination) {
                JainSipUtils.terminateTransaction(tx);
                if (this.transactionApplicationData.getHops() != null && this.transactionApplicationData.getHops().size() > 0) {
                    request.removeFirst("Route");
                    boolean nextHopVisited = this.visitNextHop();
                    if (nextHopVisited) {
                        return;
                    }
                }
                this.message = (Request)request.clone();
                this.message.removeFirst("Via");
                this.message.removeFirst("Contact");
                this.setTransaction(null);
                if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
            }
            throw new IllegalStateException("Error sending request " + request, ex);
        }
    }

    private void addDnsRoute(Hop hop, Request request) throws ParseException, SipException {
        if (hop != null && this.sipFactoryImpl.getSipApplicationDispatcher().isExternal(hop.getHost(), hop.getPort(), hop.getTransport())) {
            javax.sip.address.SipURI nextHopUri = SipFactoryImpl.addressFactory.createSipURI(null, hop.getHost());
            nextHopUri.setLrParam();
            nextHopUri.setPort(hop.getPort());
            if (hop.getTransport() != null) {
                nextHopUri.setTransportParam(hop.getTransport());
            }
            nextHopUri.setParameter("dns_route", Boolean.TRUE.toString());
            javax.sip.address.Address nextHopRouteAddress = SipFactoryImpl.addressFactory.createAddress((javax.sip.address.URI)nextHopUri);
            RouteHeader nextHopRouteHeader = SipFactoryImpl.headerFactory.createRouteHeader(nextHopRouteAddress);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding next hop found by RFC 3263 lookups as route header" + nextHopRouteHeader));
            }
            request.addFirst((Header)nextHopRouteHeader);
        }
    }

    private void checkViaHeaderAddition(Hop hop) throws ParseException {
        SipNetworkInterfaceManager sipNetworkInterfaceManager = this.sipFactoryImpl.getSipNetworkInterfaceManager();
        Request request = (Request)this.message;
        MobicentsSipSession session = this.getSipSession();
        MobicentsSipApplicationSession sipApplicationSession = session.getSipApplicationSession();
        MobicentsProxy proxy = session.getProxy();
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        if (!request.getMethod().equals("CANCEL") && viaHeader == null) {
            boolean addViaHeader = false;
            if (proxy == null) {
                addViaHeader = true;
            } else if (this.isInitial) {
                if (proxy.getRecordRoute()) {
                    addViaHeader = true;
                }
            } else if (proxy.getFinalBranchForSubsequentRequests() != null && proxy.getFinalBranchForSubsequentRequests().getRecordRoute()) {
                addViaHeader = true;
            }
            if (addViaHeader) {
                viaHeader = JainSipUtils.createViaHeader(sipNetworkInterfaceManager, request, null, session.getOutboundInterface());
                this.message.addHeader((Header)viaHeader);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added via Header" + viaHeader));
                }
            }
        }
        if (viaHeader.getBranch() == null) {
            String branch = JainSipUtils.createBranch(sipApplicationSession.getKey().getId(), this.sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(session.getKey().getApplicationName()));
            viaHeader.setBranch(branch);
        }
        String transportFromRouteOrRequestUri = JainSipUtils.findRouteOrRequestUriTransport((Request)this.message);
        String hopTransport = null;
        if (hop != null) {
            hopTransport = hop.getTransport();
        }
        String viaTransport = viaHeader.getTransport();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("viaHeader transport " + viaTransport + ", hopTransport " + hopTransport + ", transportFromRouteOrRequestUri " + transportFromRouteOrRequestUri));
        }
        if (hopTransport != null && !viaTransport.equalsIgnoreCase(hopTransport)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updating via transport to hopTransport " + hopTransport));
            }
            viaHeader.setTransport(hopTransport);
        } else if (transportFromRouteOrRequestUri != null && !viaTransport.equalsIgnoreCase(transportFromRouteOrRequestUri)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updating via transport to transportFromRouteOrRequestUri " + transportFromRouteOrRequestUri));
            }
            viaHeader.setTransport(transportFromRouteOrRequestUri);
        }
    }

    private void checkViaHeaderUpdateOrForStaticExternalAddressUsage(MobicentsExtendedListeningPoint mobicentsExtendedListeningPoint, Hop hop) throws ParseException, InvalidArgumentException {
        SipConnector sipConnector = mobicentsExtendedListeningPoint.getSipConnector();
        Request request = (Request)this.message;
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        if (sipConnector != null) {
            if (sipConnector.isUseStaticAddress() && !((MobicentsSipSession)this.getSession()).getBypassLoadBalancer()) {
                javax.sip.address.URI uri = request.getRequestURI();
                RouteHeader route = (RouteHeader)request.getHeader("Route");
                if (route != null) {
                    uri = route.getAddress().getURI();
                }
                if (uri.isSipURI()) {
                    javax.sip.address.SipURI sipUri = (javax.sip.address.SipURI)uri;
                    String host = sipUri.getHost();
                    int port = sipUri.getPort();
                    if (this.sipFactoryImpl.getSipApplicationDispatcher().isExternal(host, port, this.transport)) {
                        viaHeader.setHost(sipConnector.getStaticServerAddress());
                        viaHeader.setPort(sipConnector.getStaticServerPort());
                    }
                }
            } else {
                String outboundInterface;
                String ipAddressToCheckAgainst = sipConnector.getIpAddress();
                if (mobicentsExtendedListeningPoint.isAnyLocalAddress()) {
                    for (String lpIpAddress : mobicentsExtendedListeningPoint.getIpAddresses()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("AnyLocalAddress so checking the list of ip addresses " + lpIpAddress + " to see if one matches the destination hop" + hop.getHost()));
                        }
                        if (!lpIpAddress.equalsIgnoreCase(hop.getHost())) continue;
                        ipAddressToCheckAgainst = lpIpAddress;
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)("AnyLocalAddress using ip address " + lpIpAddress + " matching the destination hop" + hop.getHost()));
                    }
                }
                if ((outboundInterface = this.getSipSession().getOutboundInterface()) != null) {
                    javax.sip.address.SipURI outboundInterfaceURI = (javax.sip.address.SipURI)SipFactoryImpl.addressFactory.createURI(outboundInterface);
                    ipAddressToCheckAgainst = ((SipUri)outboundInterfaceURI).getHost();
                }
                if (!viaHeader.getHost().equalsIgnoreCase(ipAddressToCheckAgainst) || !viaHeader.getTransport().equalsIgnoreCase(sipConnector.getTransport()) || viaHeader.getPort() != sipConnector.getPort()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Via " + viaHeader + " different than outbound SIP Connector picked by the container " + sipConnector + " , updating it"));
                    }
                    viaHeader.setHost(ipAddressToCheckAgainst);
                    viaHeader.setPort(sipConnector.getPort());
                    viaHeader.setTransport(sipConnector.getTransport());
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Via updated to outbound SIP Connector picked by the container " + viaHeader));
                    }
                }
            }
        }
    }

    private void updateLinkedRequestAppDataMapping(ClientTransaction ctx, Dialog dialog) {
        Transaction linkedTransaction = this.linkedRequest.getTransaction();
        Dialog linkedDialog = this.linkedRequest.getDialog();
        if (linkedTransaction != null && linkedTransaction.getApplicationData() != null) {
            ((TransactionApplicationData)linkedTransaction.getApplicationData()).setTransaction((Transaction)ctx);
        }
        if (linkedDialog != null && linkedDialog.getApplicationData() != null) {
            ((TransactionApplicationData)linkedDialog.getApplicationData()).setTransaction((Transaction)ctx);
        }
        this.transactionApplicationData.setTransaction(linkedTransaction);
        if (dialog != null && dialog.getApplicationData() != null) {
            ((TransactionApplicationData)dialog.getApplicationData()).setTransaction(linkedTransaction);
        }
    }

    private void checkSubscriptionStateHeaders(MobicentsSipSession session) throws SipException {
        if ("NOTIFY".equals(this.getMethod()) && session.getProxy() == null) {
            SubscriptionStateHeader subscriptionStateHeader = (SubscriptionStateHeader)this.getMessage().getHeader("Subscription-State");
            if (subscriptionStateHeader != null && ("active".equalsIgnoreCase(subscriptionStateHeader.getState()) || "pending".equalsIgnoreCase(subscriptionStateHeader.getState()))) {
                session.addSubscription((MobicentsSipServletMessage)this);
            }
            if (subscriptionStateHeader != null && "terminated".equalsIgnoreCase(subscriptionStateHeader.getState())) {
                session.removeSubscription((MobicentsSipServletMessage)this);
            }
        }
    }

    private void setSystemContactHeader(SipConnector sipConnector, MobicentsExtendedListeningPoint matchingListeningPoint, String transportForRequest) throws ParseException {
        boolean sipURI;
        SipNetworkInterfaceManager sipNetworkInterfaceManager = this.sipFactoryImpl.getSipNetworkInterfaceManager();
        Request request = (Request)this.message;
        String requestMethod = this.getMethod();
        MobicentsSipSession session = this.getSipSession();
        MobicentsProxy proxy = session.getProxy();
        ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
        if (contactHeader != null && (((Parameters)contactHeader.getAddress().getURI()).getParameter("gruu") != null || ((Parameters)contactHeader.getAddress().getURI()).getParameter("gr") != null)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("not changing existing contact header " + contactHeader + " as it contains gruu"));
            }
            return;
        }
        if (contactHeader == null && !"REGISTER".equalsIgnoreCase(requestMethod) && JainSipUtils.CONTACT_HEADER_METHODS.contains(requestMethod) && proxy == null) {
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            javax.sip.address.URI fromUri = fromHeader.getAddress().getURI();
            String fromName = null;
            String displayName = fromHeader.getAddress().getDisplayName();
            if (fromUri instanceof javax.sip.address.SipURI) {
                fromName = ((javax.sip.address.SipURI)fromUri).getUser();
            }
            contactHeader = JainSipUtils.createContactHeader(sipNetworkInterfaceManager, request, displayName, fromName, session.getOutboundInterface());
            request.addHeader((Header)contactHeader);
        }
        if (proxy == null && contactHeader != null && (sipURI = contactHeader.getAddress().getURI().isSipURI())) {
            javax.sip.address.SipURI contactSipUri = (javax.sip.address.SipURI)contactHeader.getAddress().getURI();
            if (sipConnector != null && sipConnector.isUseStaticAddress() && !session.getBypassLoadBalancer()) {
                contactSipUri.setHost(sipConnector.getStaticServerAddress());
                contactSipUri.setPort(sipConnector.getStaticServerPort());
            } else if (JainSipUtils.CONTACT_HEADER_METHODS.contains(requestMethod)) {
                String outboundInterface = this.getSipSession().getOutboundInterface();
                if (outboundInterface != null) {
                    javax.sip.address.SipURI outboundInterfaceURI = (javax.sip.address.SipURI)SipFactoryImpl.addressFactory.createURI(outboundInterface);
                    String outboundHost = ((SipUri)outboundInterfaceURI).getHost();
                    contactSipUri.setHost(outboundHost);
                } else {
                    boolean usePublicAddress = JainSipUtils.findUsePublicAddress(sipNetworkInterfaceManager, (Message)request, matchingListeningPoint);
                    contactSipUri.setHost(matchingListeningPoint.getIpAddress(usePublicAddress));
                }
                contactSipUri.setPort(matchingListeningPoint.getPort());
            }
            if (transportForRequest != null) {
                String transportParam;
                if (!"UDP".equalsIgnoreCase(transportForRequest)) {
                    contactSipUri.setTransportParam(transportForRequest);
                }
                if ((transportParam = contactSipUri.getTransportParam()) != null && !transportParam.equalsIgnoreCase(transportForRequest)) {
                    contactSipUri.setTransportParam(transportForRequest);
                }
                if ("TLS".equalsIgnoreCase(transportForRequest)) {
                    javax.sip.address.URI requestURI = request.getRequestURI();
                    if (requestURI.isSipURI() && ((javax.sip.address.SipURI)requestURI).isSecure()) {
                        contactSipUri.setSecure(true);
                    } else if (requestURI.isSipURI() && !((javax.sip.address.SipURI)requestURI).isSecure() && contactSipUri.isSecure()) {
                        contactSipUri.setSecure(false);
                    }
                }
            }
        }
    }

    public boolean visitNextHop() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visitNextHop txAppData " + this.transactionApplicationData));
        }
        if (this.transactionApplicationData != null) {
            Queue<Hop> nextHops = this.transactionApplicationData.getHops();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("visitNextHop nextHops " + nextHops));
                if (nextHops != null) {
                    logger.debug((Object)("visitNextHop nextHops size " + nextHops.size()));
                }
            }
            if (this.sipFactoryImpl.getSipApplicationDispatcher().getDNSServerLocator() != null && nextHops != null && nextHops.size() > 1) {
                nextHops.remove();
                Hop nextHop = nextHops.peek();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("visitNextHop nextHop " + nextHop));
                }
                if (nextHop != null) {
                    this.getMessage().removeFirst("Route");
                    ViaHeader viaHeader = (ViaHeader)this.getMessage().getHeader("Via");
                    viaHeader.removeParameter("branch");
                    this.message = (Message)this.message.clone();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("sending request " + this.getMessage() + " to next hop " + nextHop + " discovered through RFC3263 mechanisms."));
                    }
                    this.setTransaction(null);
                    try {
                        this.send(nextHop);
                    }
                    catch (IOException e) {
                        logger.error((Object)("unexpected IOException on sending " + this.getMessage() + " to next hop " + nextHop + "discovered through RFC3263 mechanisms."));
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck(String transport, SipConnector sipConnector, MobicentsExtendedListeningPoint matchingListeningPoint) throws ParseException, SipException {
        Request request = (Request)this.message;
        MobicentsSipSession session = this.getSipSession();
        MobicentsSipApplicationSession sipApplicationSession = session.getSipApplicationSession();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SipProvider sipProvider;
            ClassLoader cl = sipApplicationSession.getSipContext().getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            if (sipConnector != null && sipConnector.isUseStaticAddress()) {
                JainSipUtils.optimizeRouteHeaderAddressForInternalRoutingrequest(sipConnector, request, session, this.sipFactoryImpl, transport);
            }
            session.access();
            sipApplicationSession.access();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending the ACK request " + request));
            }
            session.getSessionCreatingDialog().sendAck(request);
            session.setRequestsPending(session.getRequestsPending() - 1);
            this.sipFactoryImpl.getSipApplicationDispatcher().updateRequestsStatistics(request, false);
            Transaction transaction = this.getTransaction();
            if (transaction != null) {
                TransactionApplicationData tad = (TransactionApplicationData)transaction.getApplicationData();
                MobicentsB2BUAHelper b2buaHelperImpl = this.sipSession.getB2buaHelper();
                if (b2buaHelperImpl == null) {
                    session.removeOngoingTransaction(transaction);
                }
                if (tad != null) {
                    boolean nullifyAppData = true;
                    if (((SipStackImpl)this.sipFactoryImpl.getSipApplicationDispatcher().getSipStack()).getMaxForkTime() > 0) {
                        nullifyAppData = false;
                    }
                    if (nullifyAppData) {
                        tad.cleanUp();
                        transaction.setApplicationData(null);
                        if (b2buaHelperImpl == null && this.sipSession.getProxy() == null) {
                            tad.cleanUpMessage();
                        }
                    }
                }
            }
            if (((SipStackImpl)(sipProvider = matchingListeningPoint.getSipProvider()).getSipStack()).getMaxForkTime() == 0 && transaction != null) {
                transaction.setApplicationData(null);
            }
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void addInfoForRoutingBackToContainer(SipApplicationRouterInfo routerInfo, String applicationSessionId, String applicationName) throws ParseException, SipException {
        Request request = (Request)this.message;
        javax.sip.address.SipURI sipURI = JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)request);
        sipURI.setLrParam();
        sipURI.setParameter("directive", this.routingDirective.toString());
        if (this.getSipSession().getRegionInternal() != null) {
            sipURI.setParameter("region_label", this.getSipSession().getRegionInternal().getLabel());
            sipURI.setParameter("region_type", this.getSipSession().getRegionInternal().getType().toString());
        }
        sipURI.setParameter("previousappname", applicationName);
        sipURI.setParameter("previousappid", applicationSessionId);
        javax.sip.address.Address routeAddress = SipFactoryImpl.addressFactory.createAddress((javax.sip.address.URI)sipURI);
        RouteHeader routeHeader = SipFactoryImpl.headerFactory.createRouteHeader(routeAddress);
        request.addFirst((Header)routeHeader);
        MobicentsSipSession session = this.getSipSession();
        session.setNextSipApplicationRouterInfo(routerInfo);
    }

    public void setLinkedRequest(SipServletRequestImpl linkedRequest) {
        this.linkedRequest = linkedRequest;
    }

    public SipServletRequestImpl getLinkedRequest() {
        return this.linkedRequest;
    }

    public RoutingState getRoutingState() {
        return this.routingState;
    }

    public void setRoutingState(RoutingState routingState) throws IllegalStateException {
        if (routingState.equals((Object)RoutingState.CANCELLED) && (this.routingState.equals((Object)RoutingState.FINAL_RESPONSE_SENT) || this.routingState.equals((Object)RoutingState.PROXIED))) {
            throw new IllegalStateException("Cannot cancel final response already sent!");
        }
        if ((routingState.equals((Object)RoutingState.FINAL_RESPONSE_SENT) || routingState.equals((Object)RoutingState.PROXIED)) && this.routingState.equals((Object)RoutingState.CANCELLED)) {
            throw new IllegalStateException("Cancel received and already replied with a 487!");
        }
        if (routingState.equals((Object)RoutingState.SUBSEQUENT)) {
            this.isInitial = false;
        }
        if (routingState.equals((Object)RoutingState.INITIAL)) {
            this.isInitial = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setting routing state to " + (Object)((Object)routingState)));
        }
        this.routingState = routingState;
    }

    public void addAuthHeader(SipServletResponse challengeResponse, AuthInfo authInfo) {
        this.addAuthHeader(challengeResponse, authInfo, false);
    }

    public void addAuthHeader(SipServletResponse challengeResponse, String username, String password) {
        this.addAuthHeader(challengeResponse, username, password, false);
    }

    public void addAuthHeader(SipServletResponse challengeResponse, AuthInfo authInfo, boolean cacheCredentials) {
        AuthInfoEntry authInfoEntry;
        this.checkReadOnly();
        AuthInfoImpl authInfoImpl = (AuthInfoImpl)authInfo;
        SipServletResponseImpl challengeResponseImpl = (SipServletResponseImpl)challengeResponse;
        Response response = (Response)challengeResponseImpl.getMessage();
        ListIterator authHeaderIterator = response.getHeaders("WWW-Authenticate");
        while (authHeaderIterator.hasNext()) {
            WWWAuthenticateHeader wwwAuthHeader = (WWWAuthenticateHeader)authHeaderIterator.next();
            this.removeStaleAuthHeaders(wwwAuthHeader);
            authInfoEntry = authInfoImpl.getAuthInfo(wwwAuthHeader.getRealm());
            if (authInfoEntry == null) {
                throw new SecurityException("Cannot add authorization header. No credentials for the following realm: " + wwwAuthHeader.getRealm());
            }
            this.addChallengeResponse(wwwAuthHeader, authInfoEntry.getUserName(), authInfoEntry.getPassword(), this.getRequestURI().toString());
            if (!cacheCredentials) continue;
            this.getSipSession().getSipSessionSecurity().addCachedAuthInfo(wwwAuthHeader.getRealm(), (MobicentsAuthInfoEntry)authInfoEntry);
        }
        authHeaderIterator = response.getHeaders("Proxy-Authenticate");
        while (authHeaderIterator.hasNext()) {
            ProxyAuthenticateHeader proxyAuthHeader = (ProxyAuthenticateHeader)authHeaderIterator.next();
            this.removeStaleAuthHeaders((WWWAuthenticateHeader)proxyAuthHeader);
            authInfoEntry = authInfoImpl.getAuthInfo(proxyAuthHeader.getRealm());
            if (authInfoEntry == null) {
                throw new SecurityException("No credentials for the following realm: " + proxyAuthHeader.getRealm());
            }
            this.addChallengeResponse((WWWAuthenticateHeader)proxyAuthHeader, authInfoEntry.getUserName(), authInfoEntry.getPassword(), this.getRequestURI().toString());
            if (!cacheCredentials) continue;
            this.getSipSession().getSipSessionSecurity().addCachedAuthInfo(proxyAuthHeader.getRealm(), (MobicentsAuthInfoEntry)authInfoEntry);
        }
    }

    public void addAuthHeader(SipServletResponse challengeResponse, String username, String password, boolean cacheCredentials) {
        this.checkReadOnly();
        SipServletResponseImpl challengeResponseImpl = (SipServletResponseImpl)challengeResponse;
        Response response = (Response)challengeResponseImpl.getMessage();
        ListIterator authHeaderIterator = response.getHeaders("WWW-Authenticate");
        while (authHeaderIterator.hasNext()) {
            WWWAuthenticateHeader wwwAuthHeader = (WWWAuthenticateHeader)authHeaderIterator.next();
            this.removeStaleAuthHeaders(wwwAuthHeader);
            this.addChallengeResponse(wwwAuthHeader, username, password, this.getRequestURI().toString());
            if (!cacheCredentials) continue;
            this.getSipSession().getSipSessionSecurity().addCachedAuthInfo(wwwAuthHeader.getRealm(), (MobicentsAuthInfoEntry)new AuthInfoEntry(response.getStatusCode(), username, password));
        }
        authHeaderIterator = response.getHeaders("Proxy-Authenticate");
        while (authHeaderIterator.hasNext()) {
            ProxyAuthenticateHeader proxyAuthHeader = (ProxyAuthenticateHeader)authHeaderIterator.next();
            this.removeStaleAuthHeaders((WWWAuthenticateHeader)proxyAuthHeader);
            String uri = proxyAuthHeader.getParameter("uri");
            if (uri == null) {
                uri = this.getRequestURI().toString();
            }
            this.addChallengeResponse((WWWAuthenticateHeader)proxyAuthHeader, username, password, uri);
            if (!cacheCredentials) continue;
            this.getSipSession().getSipSessionSecurity().addCachedAuthInfo(proxyAuthHeader.getRealm(), (MobicentsAuthInfoEntry)new AuthInfoEntry(response.getStatusCode(), username, password));
        }
    }

    protected void removeStaleAuthHeaders(WWWAuthenticateHeader responseAuthHeader) {
        String realm = responseAuthHeader.getRealm();
        ListIterator authHeaderIterator = this.message.getHeaders("Authorization");
        if (authHeaderIterator.hasNext()) {
            this.message.removeHeader("Authorization");
            while (authHeaderIterator.hasNext()) {
                AuthorizationHeader wwwAuthHeader = (AuthorizationHeader)authHeaderIterator.next();
                if (realm == null || realm.equalsIgnoreCase(wwwAuthHeader.getRealm())) continue;
                this.message.addHeader((Header)wwwAuthHeader);
            }
        }
        if ((authHeaderIterator = this.message.getHeaders("Proxy-Authorization")).hasNext()) {
            this.message.removeHeader("Proxy-Authorization");
            while (authHeaderIterator.hasNext()) {
                ProxyAuthorizationHeader proxyAuthHeader = (ProxyAuthorizationHeader)authHeaderIterator.next();
                if (realm == null || realm.equalsIgnoreCase(proxyAuthHeader.getRealm())) continue;
                this.message.addHeader((Header)proxyAuthHeader);
            }
        }
    }

    private void addChallengeResponse(WWWAuthenticateHeader wwwAuthHeader, String username, String password, String uri) {
        int nc = SipServletRequestImpl.generateNcFromMessage(this.message);
        AuthorizationHeader authorization = this.getSipSession().getSipApplicationSession().getSipContext().getDigestAuthenticator().getAuthorizationHeader(this.getMethod(), uri, "", (Header)wwwAuthHeader, username, password, wwwAuthHeader.getNonce(), nc);
        this.message.addHeader((Header)authorization);
    }

    public SipServletResponse getLastFinalResponse() {
        return this.lastFinalResponse;
    }

    public void setResponse(SipServletResponseImpl response) {
        if (response.getStatus() >= 200 && (this.lastFinalResponse == null || this.lastFinalResponse.getStatus() < response.getStatus())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("last final response " + response + " set on " + this));
            }
            this.lastFinalResponse = response;
        }
        if (this.containsRel100(response.getMessage()) && response.getStatus() > 100 && response.getStatus() < 200 && (this.lastInformationalResponse == null || this.lastInformationalResponse.getStatus() < response.getStatus())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("last informational response " + this.lastInformationalResponse + " set on " + this));
            }
            this.lastInformationalResponse = response;
        }
    }

    public Address getInitialPoppedRoute() {
        return this.transactionApplicationData.getInitialPoppedRoute();
    }

    public SipApplicationRoutingRegion getRegion() {
        return this.routingRegion;
    }

    public void setRoutingRegion(SipApplicationRoutingRegion routingRegion) {
        this.routingRegion = routingRegion;
    }

    public URI getSubscriberURI() {
        return this.subscriberURI;
    }

    public void setSubscriberURI(URI uri) {
        this.subscriberURI = uri;
    }

    private static RoutingState checkRoutingState(SipServletRequestImpl sipServletRequest, Dialog dialog) {
        if (dialog != null && DialogState.CONFIRMED.equals((Object)dialog.getState())) {
            return RoutingState.SUBSEQUENT;
        }
        if (NON_INITIAL_SIP_REQUEST_METHODS.contains(sipServletRequest.getMethod())) {
            return RoutingState.SUBSEQUENT;
        }
        if (dialog != null && !DialogState.EARLY.equals((Object)dialog.getState())) {
            return RoutingState.SUBSEQUENT;
        }
        return RoutingState.INITIAL;
    }

    public boolean is1xxResponseGenerated() {
        return this.is1xxResponseGenerated;
    }

    public boolean isFinalResponseGenerated() {
        return this.isFinalResponseGenerated;
    }

    public SipServletResponse getLastInformationalResponse() {
        return this.lastInformationalResponse;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    protected void checkReadOnly() {
        if (this.isReadOnly) {
            throw new IllegalStateException(EXCEPTION_MESSAGE);
        }
    }

    @Override
    public void addAcceptLanguage(Locale locale) {
        this.checkReadOnly();
        super.addAcceptLanguage(locale);
    }

    @Override
    public void addAddressHeader(String name, Address addr, boolean first) throws IllegalArgumentException {
        this.checkReadOnly();
        super.addAddressHeader(name, addr, first);
    }

    @Override
    public void addHeader(String name, String value) {
        this.checkReadOnly();
        super.addHeader(name, value);
    }

    @Override
    public void addParameterableHeader(String name, Parameterable param, boolean first) {
        this.checkReadOnly();
        super.addParameterableHeader(name, param, first);
    }

    @Override
    public void removeAttribute(String name) {
        this.checkReadOnly();
        super.removeAttribute(name);
    }

    @Override
    public void removeHeader(String name) {
        this.checkReadOnly();
        super.removeHeader(name);
    }

    @Override
    public void setAcceptLanguage(Locale locale) {
        this.checkReadOnly();
        super.setAcceptLanguage(locale);
    }

    @Override
    public void setAddressHeader(String name, Address addr) {
        this.checkReadOnly();
        super.setAddressHeader(name, addr);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.checkReadOnly();
        super.setAttribute(name, o);
    }

    @Override
    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.checkReadOnly();
        super.setCharacterEncoding(enc);
    }

    @Override
    public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
        this.checkReadOnly();
        super.setContent(content, contentType);
    }

    @Override
    public void setContentLanguage(Locale locale) {
        this.checkReadOnly();
        super.setContentLanguage(locale);
    }

    @Override
    public void setContentType(String type) {
        this.checkReadOnly();
        super.setContentType(type);
    }

    @Override
    public void setExpires(int seconds) {
        this.checkReadOnly();
        super.setExpires(seconds);
    }

    @Override
    public void setHeader(String name, String value) {
        this.checkReadOnly();
        super.setHeader(name, value);
    }

    @Override
    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        this.checkReadOnly();
        super.setHeaderForm(form);
    }

    @Override
    public void setParameterableHeader(String name, Parameterable param) {
        this.checkReadOnly();
        super.setParameterableHeader(name, param);
    }

    @Override
    public String getInitialRemoteAddr() {
        ViaHeader via;
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"ACK request trying to return the Via address as we don't have a transaction");
            }
            if (this.message == null || ((SIPRequest)this.message).getPeerPacketSourceAddress() == null) {
                return null;
            }
            return ((SIPRequest)this.message).getPeerPacketSourceAddress().getHostAddress();
        }
        if (this.message != null && this.message instanceof SIPRequest && ((SIPRequest)this.message).getPeerPacketSourceAddress() != null) {
            return ((SIPRequest)this.message).getPeerPacketSourceAddress().getHostAddress();
        }
        if (this.getTransaction() != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"transaction not null, returning packet source ip address");
            }
            if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null) {
                return ((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress().getHostAddress();
            }
            return ((SIPTransaction)this.getTransaction()).getPeerAddress();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"transaction null, returning top via ip address");
        }
        if ((via = (ViaHeader)this.message.getHeader("Via")) == null || !this.sipFactoryImpl.getSipApplicationDispatcher().isViaHeaderExternal(via)) {
            return null;
        }
        return via.getHost();
    }

    @Override
    public int getInitialRemotePort() {
        ViaHeader via;
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"ACK request trying to return the Via port as we don't have a transaction");
            }
            if (this.message == null) {
                return -1;
            }
            return ((SIPRequest)this.message).getPeerPacketSourcePort();
        }
        if (this.message != null && this.message instanceof SIPRequest) {
            return ((SIPRequest)this.message).getPeerPacketSourcePort();
        }
        if (this.getTransaction() != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"transaction not null, returning packet source port");
            }
            if (((SIPTransaction)this.getTransaction()).getPeerPacketSourceAddress() != null) {
                return ((SIPTransaction)this.getTransaction()).getPeerPacketSourcePort();
            }
            return ((SIPTransaction)this.getTransaction()).getPeerPort();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"transaction null, returning top via port");
        }
        if ((via = (ViaHeader)this.message.getHeader("Via")) == null || !this.sipFactoryImpl.getSipApplicationDispatcher().isViaHeaderExternal(via)) {
            return -1;
        }
        return via.getPort() <= 0 ? 5060 : via.getPort();
    }

    @Override
    public String getInitialTransport() {
        if (this.getTransaction() != null) {
            return ((SIPTransaction)this.getTransaction()).getTransport();
        }
        ViaHeader via = (ViaHeader)this.message.getHeader("Via");
        if (via == null || !this.sipFactoryImpl.getSipApplicationDispatcher().isViaHeaderExternal(via)) {
            return null;
        }
        return via.getTransport();
    }

    @Override
    public void cleanUp() {
        if (this.transactionApplicationData != null) {
            this.transactionApplicationData.cleanUp();
            this.transactionApplicationData = null;
        }
        this.setTransaction(null);
        this.poppedRoute = null;
        this.poppedRouteHeader = null;
        this.routingDirective = null;
        this.routingRegion = null;
        this.routingState = null;
        this.subscriberURI = null;
        this.linkedRequest = null;
    }

    public void cleanUpLastResponses() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cleaning up last responses on " + this));
        }
        this.lastFinalResponse = null;
        this.lastInformationalResponse = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isRoutingRegionSet;
        String routingStateString;
        super.readExternal(in);
        String messageString = in.readUTF();
        try {
            this.message = SipFactoryImpl.messageFactory.createRequest(messageString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Message " + messageString + " previously serialized could not be reparsed", e);
        }
        boolean isLinkedRequestSerialized = in.readBoolean();
        if (isLinkedRequestSerialized) {
            this.linkedRequest = (SipServletRequestImpl)in.readObject();
        }
        this.createDialog = in.readBoolean();
        String routingDirectiveString = in.readUTF();
        if (!routingDirectiveString.equals("")) {
            this.routingDirective = SipApplicationRoutingDirective.valueOf((String)routingDirectiveString);
        }
        if (!(routingStateString = in.readUTF()).equals("")) {
            this.routingState = RoutingState.valueOf(routingStateString);
        }
        if (isRoutingRegionSet = in.readBoolean()) {
            this.routingRegion = (SipApplicationRoutingRegion)in.readObject();
        }
        this.isInitial = in.readBoolean();
        this.isFinalResponseGenerated = in.readBoolean();
        this.is1xxResponseGenerated = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.linkedRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.linkedRequest);
        }
        out.writeBoolean(this.createDialog);
        if (this.routingDirective != null) {
            out.writeUTF(this.routingDirective.toString());
        } else {
            out.writeUTF("");
        }
        if (this.routingState != null) {
            out.writeUTF(this.routingState.toString());
        } else {
            out.writeUTF("");
        }
        if (this.routingRegion != null) {
            out.writeBoolean(true);
            out.writeObject(this.routingRegion);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.isInitial);
        out.writeBoolean(this.isFinalResponseGenerated);
        out.writeBoolean(this.is1xxResponseGenerated);
    }

    private static int generateNcFromMessage(Message message) {
        int nc = 1;
        CSeqHeader cseq = (CSeqHeader)message.getHeader("CSeq");
        if (cseq != null) {
            nc = (int)(cseq.getSeqNumber() % Integer.MAX_VALUE);
        }
        return nc;
    }

    public void updateAuthorizationHeaders(boolean useNextNonce) {
        AuthorizationHeader authorization;
        String nextNonce;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating authorization headers with nextnonce " + this.getSipSession().getSipSessionSecurity().getNextNonce()));
        }
        int nc = -1;
        ArrayList<Object> authorizationHeaders = new ArrayList<Object>();
        ListIterator authHeaderIterator = this.message.getHeaders("Authorization");
        while (authHeaderIterator.hasNext()) {
            AuthorizationHeader wwwAuthHeader = (AuthorizationHeader)authHeaderIterator.next();
            MobicentsAuthInfoEntry mobicentsAuthInfoEntry = (MobicentsAuthInfoEntry)this.getSipSession().getSipSessionSecurity().getCachedAuthInfos().get(wwwAuthHeader.getRealm());
            if (mobicentsAuthInfoEntry != null) {
                if (nc < 0) {
                    nc = SipServletRequestImpl.generateNcFromMessage(this.message);
                }
                nextNonce = null;
                nextNonce = useNextNonce ? this.getSipSession().getSipSessionSecurity().getNextNonce() : wwwAuthHeader.getNonce();
                authorization = this.getSipSession().getSipApplicationSession().getSipContext().getDigestAuthenticator().getAuthorizationHeader(this.getMethod(), this.getRequestURI().toString(), "", (Header)wwwAuthHeader, mobicentsAuthInfoEntry.getUserName(), mobicentsAuthInfoEntry.getPassword(), nextNonce, nc);
                authorizationHeaders.add(authorization);
                continue;
            }
            authorizationHeaders.add(wwwAuthHeader);
        }
        authHeaderIterator = this.message.getHeaders("Proxy-Authorization");
        while (authHeaderIterator.hasNext()) {
            ProxyAuthorizationHeader proxyAuthHeader = (ProxyAuthorizationHeader)authHeaderIterator.next();
            MobicentsAuthInfoEntry mobicentsAuthInfoEntry = (MobicentsAuthInfoEntry)this.getSipSession().getSipSessionSecurity().getCachedAuthInfos().get(proxyAuthHeader.getRealm());
            if (mobicentsAuthInfoEntry != null) {
                if (nc < 0) {
                    nc = SipServletRequestImpl.generateNcFromMessage(this.message);
                }
                nextNonce = null;
                nextNonce = useNextNonce ? this.getSipSession().getSipSessionSecurity().getNextNonce() : proxyAuthHeader.getNonce();
                authorization = this.getSipSession().getSipApplicationSession().getSipContext().getDigestAuthenticator().getAuthorizationHeader(this.getMethod(), this.getRequestURI().toString(), "", (Header)proxyAuthHeader, mobicentsAuthInfoEntry.getUserName(), mobicentsAuthInfoEntry.getPassword(), nextNonce, nc);
                authorizationHeaders.add(authorization);
                continue;
            }
            authorizationHeaders.add(proxyAuthHeader);
        }
        this.message.removeHeader("Authorization");
        this.message.removeHeader("Proxy-Authorization");
        for (Header header : authorizationHeaders) {
            this.message.addHeader(header);
        }
    }

    public Object clone() {
        SipServletRequestImpl sipServletRequestImpl = (SipServletRequestImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest((Request)this.message, this.sipSession, this.getTransaction(), null, this.createDialog);
        sipServletRequestImpl.setLinkedRequest(this.linkedRequest);
        sipServletRequestImpl.setPoppedRoute(this.poppedRouteHeader);
        sipServletRequestImpl.setSubscriberURI(this.subscriberURI);
        sipServletRequestImpl.setAttributeMap(this.getAttributeMap());
        return sipServletRequestImpl;
    }

    static {
        NON_INITIAL_SIP_REQUEST_METHODS.add("CANCEL");
        NON_INITIAL_SIP_REQUEST_METHODS.add("BYE");
        NON_INITIAL_SIP_REQUEST_METHODS.add("PRACK");
        NON_INITIAL_SIP_REQUEST_METHODS.add("ACK");
        NON_INITIAL_SIP_REQUEST_METHODS.add("UPDATE");
        NON_INITIAL_SIP_REQUEST_METHODS.add("INFO");
    }
}

