/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import gov.nist.javax.sip.ClientTransactionExt;
import gov.nist.javax.sip.DialogTimeoutEvent;
import gov.nist.javax.sip.IOExceptionEventExt;
import gov.nist.javax.sip.ResponseEventExt;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.message.MessageExt;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.spi.ServiceRegistry;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.spi.SipApplicationRouterProvider;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.ext.javax.sip.dns.DNSServerLocator;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingListener;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.javax.servlet.CongestionControlEvent;
import org.mobicents.javax.servlet.CongestionControlPolicy;
import org.mobicents.javax.servlet.ContainerListener;
import org.mobicents.javax.servlet.sip.dns.DNSResolver;
import org.mobicents.servlet.sip.GenericUtils;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipApplicationDispatcherImplMBean;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipContextEvent;
import org.mobicents.servlet.sip.core.SipContextEventImpl;
import org.mobicents.servlet.sip.core.SipContextEventType;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManagerImpl;
import org.mobicents.servlet.sip.core.SipService;
import org.mobicents.servlet.sip.core.Version;
import org.mobicents.servlet.sip.core.b2bua.MobicentsB2BUAHelper;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcherFactory;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.session.DistributableSipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.dns.MobicentsDNSResolver;
import org.mobicents.servlet.sip.listener.SipConnectorListener;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.router.ManageableApplicationRouter;
import org.mobicents.servlet.sip.utils.NamingThreadFactory;
import org.restcomm.commons.statistics.reporter.RestcommStatsReporter;

public class SipApplicationDispatcherImpl
implements SipApplicationDispatcher,
SipApplicationDispatcherImplMBean,
MBeanRegistration,
LoadBalancerHeartBeatingListener {
    private static final String[] METHODS_SUPPORTED = new String[]{"REGISTER", "INVITE", "ACK", "BYE", "CANCEL", "MESSAGE", "INFO", "SUBSCRIBE", "NOTIFY", "UPDATE", "PUBLISH", "REFER", "PRACK", "OPTIONS"};
    private static final String[] EXTENSIONS_SUPPORTED = new String[]{"MESSAGE", "INFO", "SUBSCRIBE", "NOTIFY", "UPDATE", "PUBLISH", "REFER", "PRACK", "100rel", "STUN", "path", "join", "outbound", "from-change", "gruu"};
    private static final String[] RFC_SUPPORTED = new String[]{"3261", "3428", "2976", "3265", "3311", "3903", "3515", "3262", "3489", "3327", "3911", "5626", "4916", "5627"};
    private static final String[] RESPONSES_PER_CLASS_OF_SC = new String[]{"1XX", "2XX", "3XX", "4XX", "5XX", "6XX", "7XX", "8XX", "9XX"};
    private static final Logger logger = Logger.getLogger(SipApplicationDispatcherImpl.class);
    private String applicationServerId;
    private String applicationServerIdHash;
    private SipService sipService = null;
    private SipFactoryImpl sipFactoryImpl = null;
    private SipApplicationRouter sipApplicationRouter = null;
    private Map<String, SipContext> applicationDeployed = null;
    private Map<String, String> mdToApplicationName = null;
    private Map<String, String> applicationNameToMd = null;
    private Set<String> hostNames = null;
    private Boolean started = Boolean.FALSE;
    private Lock statusLock = new ReentrantLock();
    protected SipStack sipStack;
    private SipNetworkInterfaceManager sipNetworkInterfaceManager;
    private DNSServerLocator dnsServerLocator;
    private int dnsTimeout;
    private DNSResolver dnsResolver;
    RestcommStatsReporter statsReporter = RestcommStatsReporter.getRestcommStatsReporter();
    MetricRegistry metrics = RestcommStatsReporter.getMetricRegistry();
    Counter counterCalls = this.metrics.counter("calls");
    Counter counterSeconds = this.metrics.counter("seconds");
    Counter counterMessages = this.metrics.counter("messages");
    private boolean gatherStatistics = true;
    private final AtomicLong requestsProcessed = new AtomicLong(0L);
    private final AtomicLong responsesProcessed = new AtomicLong(0L);
    final Map<String, AtomicLong> requestsProcessedByMethod = new ConcurrentHashMap<String, AtomicLong>();
    final Map<String, AtomicLong> responsesProcessedByStatusCode = new ConcurrentHashMap<String, AtomicLong>();
    private final AtomicLong requestsSent = new AtomicLong(0L);
    private final AtomicLong responsesSent = new AtomicLong(0L);
    final Map<String, AtomicLong> requestsSentByMethod = new ConcurrentHashMap<String, AtomicLong>();
    final Map<String, AtomicLong> responsesSentByStatusCode = new ConcurrentHashMap<String, AtomicLong>();
    private boolean memoryToHigh = false;
    private double maxMemory;
    private int memoryThreshold;
    private int backToNormalMemoryThreshold;
    private boolean rejectSipMessages = false;
    private long congestionControlCheckingInterval;
    @Deprecated
    protected transient CongestionControlTimerTask congestionControlTimerTask;
    @Deprecated
    protected transient ScheduledFuture congestionControlTimerFuture;
    private CongestionControlPolicy congestionControlPolicy;
    @Deprecated
    private int numberOfMessagesInQueue;
    @Deprecated
    private double percentageOfMemoryUsed;
    @Deprecated
    private int queueSize;
    @Deprecated
    private int backToNormalQueueSize;
    private ScheduledThreadPoolExecutor asynchronousScheduledThreadPoolExecutor = null;
    private boolean bypassResponseExecutor = true;
    private boolean bypassRequestExecutor = true;
    private int baseTimerInterval = 500;
    private int t2Interval = 4000;
    private int t4Interval = 5000;
    private int timerDInterval = 32000;
    private ConcurrencyControlMode concurrencyControlMode;
    public static int APP_ID_HASHING_MAX_LENGTH = 8;
    private static final int NUMBER_OF_TAG_SEPARATORS = 3;
    private int tagHashMaxLength = 8;
    private int callIdMaxLength = -1;
    private ThreadPoolExecutor asynchronousExecutor = null;
    private MessageDispatcherFactory messageDispatcherFactory;
    private Set<SipLoadBalancer> sipLoadBalancers = new CopyOnWriteArraySet<SipLoadBalancer>();
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public SipApplicationDispatcherImpl() {
        this.resetStatsCounters();
        this.applicationDeployed = new ConcurrentHashMap<String, SipContext>();
        this.mdToApplicationName = new ConcurrentHashMap<String, String>();
        this.applicationNameToMd = new ConcurrentHashMap<String, String>();
        this.sipFactoryImpl = new SipFactoryImpl(this);
        this.hostNames = new CopyOnWriteArraySet<String>();
        this.sipNetworkInterfaceManager = new SipNetworkInterfaceManagerImpl(this);
        this.maxMemory = (double)Runtime.getRuntime().maxMemory() / 1024.0;
        this.congestionControlPolicy = CongestionControlPolicy.ErrorResponse;
    }

    public final void resetStatsCounters() {
        this.requestsProcessed.set(0L);
        this.responsesProcessed.set(0L);
        this.requestsSent.set(0L);
        this.responsesSent.set(0L);
        for (String method : METHODS_SUPPORTED) {
            this.requestsProcessedByMethod.put(method, new AtomicLong(0L));
        }
        for (String classOfSc : RESPONSES_PER_CLASS_OF_SC) {
            this.responsesProcessedByStatusCode.put(classOfSc, new AtomicLong(0L));
        }
        for (String classOfSc : RESPONSES_PER_CLASS_OF_SC) {
            this.responsesSentByStatusCode.put(classOfSc, new AtomicLong(0L));
        }
        for (String method : METHODS_SUPPORTED) {
            this.requestsSentByMethod.put(method, new AtomicLong(0L));
        }
    }

    public void init() throws IllegalArgumentException {
        int tagHashMaxTotalLength;
        String sipApplicationRouterProviderClassName = System.getProperty("javax.servlet.sip.ar.spi.SipApplicationRouterProvider");
        if (sipApplicationRouterProviderClassName != null && sipApplicationRouterProviderClassName.length() > 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Using the javax.servlet.sip.ar.spi.SipApplicationRouterProvider system property to load the application router provider");
            }
            try {
                this.sipApplicationRouter = ((SipApplicationRouterProvider)Class.forName(sipApplicationRouterProviderClassName).newInstance()).getSipApplicationRouter();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Impossible to load the Sip Application Router", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Impossible to load the Sip Application Router", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Impossible to load the Sip Application Router", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Sip Application Router defined does not implement " + SipApplicationRouterProvider.class.getName(), e);
            }
        } else {
            Iterator<SipApplicationRouterProvider> providers;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Using the Service Provider Framework to load the application router provider");
            }
            if ((providers = ServiceRegistry.lookupProviders(SipApplicationRouterProvider.class)).hasNext()) {
                this.sipApplicationRouter = providers.next().getSipApplicationRouter();
            }
        }
        if (this.sipApplicationRouter == null) {
            throw new IllegalArgumentException("No Sip Application Router Provider could be loaded. No jar compliant with JSR 289 Section Section 15.4.2 could be found on the classpath and no javax.servlet.sip.ar.spi.SipApplicationRouterProvider system property set");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this + " Using the following Application Router instance: " + this.sipApplicationRouter));
        }
        this.sipApplicationRouter.init();
        this.sipApplicationRouter.applicationDeployed(new ArrayList<String>(this.applicationDeployed.keySet()));
        if (this.sipService.getDnsResolverClass() != null && this.sipService.getDnsResolverClass().trim().length() > 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SipApplicationDispatcher will be using " + this.sipService.getDnsResolverClass() + " as DNSResolver"));
            }
            try {
                Class[] paramTypes = new Class[]{DNSServerLocator.class};
                Constructor<?> dnsResolverConstructor = Class.forName(this.sipService.getDnsResolverClass()).getConstructor(paramTypes);
                Object[] conArgs = new Object[]{this.dnsServerLocator};
                this.dnsResolver = (DNSResolver)dnsResolverConstructor.newInstance(conArgs);
            }
            catch (Exception e) {
                logger.error((Object)("Couldn't set the DNSResolver " + this.sipService.getDnsResolverClass()), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Using default MobicentsDNSResolver since none has been specified.");
            }
            this.dnsResolver = new MobicentsDNSResolver(this.dnsServerLocator);
        }
        if (this.oname == null) {
            try {
                this.oname = new ObjectName(this.domain + ":type=SipApplicationDispatcher");
                MBeanServerFactory.findMBeanServer(null).get(0).registerMBean(this, this.oname);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Sip Application dispatcher registered under following name " + this.oname));
                }
            }
            catch (Exception e) {
                logger.error((Object)("Impossible to register the Sip Application dispatcher in domain" + this.domain), (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("bypassRequestExecutor ? " + this.bypassRequestExecutor));
            logger.info((Object)("bypassResponseExecutor ? " + this.bypassResponseExecutor));
        }
        if (this.sipService.getCallIdMaxLength() > 0) {
            this.callIdMaxLength = this.sipService.getCallIdMaxLength();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("callIdMaxLength ? " + this.callIdMaxLength));
            }
        }
        if ((tagHashMaxTotalLength = this.sipService.getTagHashMaxLength()) > 0) {
            this.tagHashMaxLength = (tagHashMaxTotalLength - 3) / 4;
            APP_ID_HASHING_MAX_LENGTH = tagHashMaxTotalLength - 3 - this.tagHashMaxLength * 3;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("tagHashMaxLength ? " + this.tagHashMaxLength));
                logger.info((Object)("DEFAULT_TAG_HASHING_MAX_LENGTH ? " + APP_ID_HASHING_MAX_LENGTH));
            }
        }
        this.applicationServerId = "" + UUID.randomUUID();
        this.applicationServerIdHash = GenericUtils.hashString(this.applicationServerId, this.tagHashMaxLength);
        this.messageDispatcherFactory = new MessageDispatcherFactory(this);
        this.asynchronousScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(2, new NamingThreadFactory("sip_servlets_congestion_control"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.asynchronousScheduledThreadPoolExecutor.prestartAllCoreThreads();
        logger.info((Object)("AsynchronousThreadPoolExecutor size is " + this.sipService.getDispatcherThreadPoolSize()));
        this.asynchronousExecutor = new ThreadPoolExecutor(this.sipService.getDispatcherThreadPoolSize(), 64, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private int threadCount = 0;

            @Override
            public Thread newThread(Runnable pRunnable) {
                Thread thread = new Thread(pRunnable, String.format("%s-%d", "MSS-Executor-Thread", this.threadCount++));
                thread.setPriority(((SipStackImpl)SipApplicationDispatcherImpl.this.sipStack).getThreadPriority());
                return thread;
            }
        });
        this.asynchronousExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                logger.warn((Object)("Executor job was rejected " + r.toString()));
            }
        });
        String statisticsServer = Version.getVersionProperty("statistics.server");
        if (statisticsServer == null || !statisticsServer.contains("http")) {
            statisticsServer = "https://statistics.restcomm.com/rest/";
        }
        this.statsReporter.setRemoteServer(statisticsServer);
        this.statsReporter.setProjectName("sipservlets");
        this.statsReporter.setProjectType("community");
        this.statsReporter.setVersion(Version.getVersionProperty("release.version"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.statusLock.lock();
        try {
            if (this.started.booleanValue()) {
                return;
            }
            this.started = Boolean.TRUE;
        }
        finally {
            this.statusLock.unlock();
        }
        this.congestionControlTimerTask = new CongestionControlTimerTask();
        if (this.congestionControlTimerFuture == null && this.congestionControlCheckingInterval > 0L) {
            this.congestionControlTimerFuture = this.asynchronousScheduledThreadPoolExecutor.scheduleWithFixedDelay(this.congestionControlTimerTask, this.congestionControlCheckingInterval, this.congestionControlCheckingInterval, TimeUnit.MILLISECONDS);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Congestion control background task started and checking every " + this.congestionControlCheckingInterval + " milliseconds."));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("No Congestion control background task started since the checking interval is equals to " + this.congestionControlCheckingInterval + " milliseconds."));
        }
        this.statsReporter.start(86400L, TimeUnit.SECONDS);
        Version.printVersion();
        this.resetOutboundInterfaces();
        try {
            this.startSipStack();
        }
        catch (Exception e) {
            throw new IllegalStateException("The SIP Stack couldn't be started ", e);
        }
        for (SipContext sipContext : this.applicationDeployed.values()) {
            sipContext.notifySipContextListeners((SipContextEvent)new SipContextEventImpl(SipContextEventType.SERVLET_INITIALIZED, null));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SipApplicationDispatcher Started");
        }
    }

    public void stopGracefully(long timeToWait) {
        this.sipService.stopGracefully(timeToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.statusLock.lock();
        try {
            if (!this.started.booleanValue()) {
                return;
            }
            this.started = Boolean.FALSE;
        }
        finally {
            this.statusLock.unlock();
        }
        this.asynchronousScheduledThreadPoolExecutor.shutdownNow();
        this.asynchronousExecutor.shutdownNow();
        this.sipApplicationRouter.destroy();
        this.stopSipStack();
        this.statsReporter.stop();
        if (this.oname != null) {
            try {
                MBeanServerFactory.findMBeanServer(null).get(0).unregisterMBean(this.oname);
            }
            catch (Exception e) {
                logger.error((Object)("Impossible to register the Sip Application dispatcher in domain" + this.domain), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SipApplicationDispatcher Stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSipApplication(String sipApplicationName, SipContext sipApplication) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding the following sip servlet application " + sipApplicationName + ", SipContext=" + sipApplication));
        }
        if (sipApplicationName == null) {
            throw new IllegalArgumentException("Something when wrong while initializing a sip servlets or converged application ");
        }
        if (sipApplication == null) {
            throw new IllegalArgumentException("Something when wrong while initializing the following application " + sipApplicationName);
        }
        SipContext app = this.applicationDeployed.get(sipApplicationName);
        if (app != null) {
            logger.error((Object)("An application with the app name " + sipApplicationName + " is already deployed under the following context " + app.getPath()));
            throw new IllegalStateException("An application with the app name " + sipApplicationName + " is already deployed under the following context " + app.getPath());
        }
        if (sipApplication.getConcurrencyControlMode() == null) {
            sipApplication.setConcurrencyControlMode(this.concurrencyControlMode);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("No concurrency control mode for application " + sipApplicationName + " , defaulting to the container wide one : " + this.concurrencyControlMode));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("Concurrency control mode for application " + sipApplicationName + " is " + sipApplication.getConcurrencyControlMode()));
        }
        sipApplication.getServletContext().setAttribute(ConcurrencyControlMode.class.getCanonicalName(), (Object)sipApplication.getConcurrencyControlMode());
        this.applicationDeployed.put(sipApplicationName, sipApplication);
        String hash = GenericUtils.hashString(sipApplicationName, this.tagHashMaxLength);
        this.mdToApplicationName.put(hash, sipApplicationName);
        this.applicationNameToMd.put(sipApplicationName, hash);
        ArrayList<String> newlyApplicationsDeployed = new ArrayList<String>();
        newlyApplicationsDeployed.add(sipApplicationName);
        if (this.sipApplicationRouter != null) {
            this.sipApplicationRouter.applicationDeployed(newlyApplicationsDeployed);
        }
        this.statusLock.lock();
        try {
            if (this.started.booleanValue()) {
                sipApplication.notifySipContextListeners((SipContextEvent)new SipContextEventImpl(SipContextEventType.SERVLET_INITIALIZED, null));
            }
        }
        finally {
            this.statusLock.unlock();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this + " the following sip servlet application has been added : " + sipApplicationName));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"It contains the following Sip Servlets : ");
            for (String servletName : sipApplication.getChildrenMap().keySet()) {
                logger.info((Object)("SipApplicationName : " + sipApplicationName + "/ServletName : " + servletName));
            }
            if (sipApplication.getSipRubyController() != null) {
                logger.info((Object)("It contains the following Sip Ruby Controller : " + sipApplication.getSipRubyController()));
            }
        }
    }

    public SipContext removeSipApplication(String sipApplicationName) {
        SipContext sipContext = this.applicationDeployed.remove(sipApplicationName);
        ArrayList<String> applicationsUndeployed = new ArrayList<String>();
        applicationsUndeployed.add(sipApplicationName);
        this.sipApplicationRouter.applicationUndeployed(applicationsUndeployed);
        if (sipContext != null) {
            sipContext.getSipManager().removeAllSessions();
        }
        String hash = GenericUtils.hashString(sipApplicationName, this.tagHashMaxLength);
        this.mdToApplicationName.remove(hash);
        this.applicationNameToMd.remove(sipApplicationName);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("the following sip servlet application has been removed : " + sipApplicationName));
        }
        return sipContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIOException(IOExceptionEvent event) {
        SipServletMessageImpl sipServletMessageImpl;
        ClientTransaction ioExceptionTx;
        IOExceptionEventExt keepAliveTimeout;
        SipConnector connector;
        if (event instanceof IOExceptionEventExt && ((IOExceptionEventExt)event).getReason() == IOExceptionEventExt.Reason.KeepAliveTimeout && (connector = this.findSipConnector((keepAliveTimeout = (IOExceptionEventExt)event).getLocalHost(), keepAliveTimeout.getLocalPort(), keepAliveTimeout.getTransport())) != null) {
            for (SipContext sipContext : this.applicationDeployed.values()) {
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                sipContext.enterSipContext();
                try {
                    for (SipConnectorListener connectorListener : sipContext.getListeners().getSipConnectorListeners()) {
                        try {
                            connectorListener.onKeepAliveTimeout(connector, keepAliveTimeout.getPeerHost(), keepAliveTimeout.getPeerPort());
                        }
                        catch (Throwable t) {
                            logger.error((Object)"SipErrorListener threw exception", t);
                        }
                    }
                }
                finally {
                    sipContext.exitSipContext(oldClassLoader);
                }
            }
        }
        if (this.dnsServerLocator != null && event.getSource() instanceof ClientTransaction && (ioExceptionTx = (ClientTransaction)event.getSource()).getApplicationData() != null && (sipServletMessageImpl = ((TransactionApplicationData)ioExceptionTx.getApplicationData()).getSipServletMessage()) != null && sipServletMessageImpl instanceof SipServletRequestImpl) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("An IOException occured on " + event.getHost() + ":" + event.getPort() + "/" + event.getTransport() + " for source " + event.getSource() + ", trying to visit next hop as per RFC3263"));
            }
            if (((SipServletRequestImpl)sipServletMessageImpl).visitNextHop()) {
                return;
            }
        }
        logger.error((Object)("An IOException occured on " + event.getHost() + ":" + event.getPort() + "/" + event.getTransport() + " for source " + event.getSource()));
    }

    public int getNumberOfPendingMessages() {
        return this.asynchronousExecutor.getQueue().size();
    }

    private void analyzeQueueCongestionState() {
        this.numberOfMessagesInQueue = this.getNumberOfPendingMessages();
        if (this.rejectSipMessages) {
            if (this.numberOfMessagesInQueue < this.backToNormalQueueSize) {
                String message = "Number of pending messages in the queues : " + this.numberOfMessagesInQueue + " < to the back to normal queue Size : " + this.backToNormalQueueSize;
                logger.warn((Object)(message + " => stopping to reject requests"));
                this.rejectSipMessages = false;
                CongestionControlEvent congestionControlEvent = new CongestionControlEvent(CongestionControlEvent.Reason.Queue, message);
                this.callbackCongestionControlListener(this.rejectSipMessages, congestionControlEvent);
            }
        } else if (this.numberOfMessagesInQueue > this.queueSize) {
            String message = "Number of pending messages in the queues : " + this.numberOfMessagesInQueue + " > to the queue Size : " + this.queueSize;
            logger.warn((Object)(message + " => starting to reject requests"));
            this.rejectSipMessages = true;
            CongestionControlEvent congestionControlEvent = new CongestionControlEvent(CongestionControlEvent.Reason.Queue, message);
            this.callbackCongestionControlListener(this.rejectSipMessages, congestionControlEvent);
        }
    }

    private void analyzeMemory() {
        Runtime runtime = Runtime.getRuntime();
        double allocatedMemory = (double)runtime.totalMemory() / 1024.0;
        double freeMemory = (double)runtime.freeMemory() / 1024.0;
        double totalFreeMemory = freeMemory + (this.maxMemory - allocatedMemory);
        this.percentageOfMemoryUsed = 100.0 - totalFreeMemory / this.maxMemory * 100.0;
        if (this.memoryToHigh) {
            if (this.percentageOfMemoryUsed < (double)this.backToNormalMemoryThreshold) {
                String message = "Memory used: " + this.percentageOfMemoryUsed + "% < to the back to normal memory threshold : " + this.backToNormalMemoryThreshold + "%";
                logger.warn((Object)(message + " => stopping to reject requests"));
                this.memoryToHigh = false;
                CongestionControlEvent congestionControlEvent = new CongestionControlEvent(CongestionControlEvent.Reason.Memory, message);
                this.callbackCongestionControlListener(this.memoryToHigh, congestionControlEvent);
            }
        } else if (this.percentageOfMemoryUsed > (double)this.memoryThreshold) {
            String message = "Memory used: " + this.percentageOfMemoryUsed + "% > to the memory threshold : " + this.memoryThreshold + "%";
            logger.warn((Object)(message + " => starting to reject requests"));
            this.memoryToHigh = true;
            CongestionControlEvent congestionControlEvent = new CongestionControlEvent(CongestionControlEvent.Reason.Memory, message);
            this.callbackCongestionControlListener(this.memoryToHigh, congestionControlEvent);
        }
    }

    public void processRequest(RequestEvent requestEvent) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        ServerTransaction requestTransaction = requestEvent.getServerTransaction();
        Dialog dialog = requestEvent.getDialog();
        Request request = requestEvent.getRequest();
        ((MessageExt)request).setApplicationData(null);
        String requestMethod = request.getMethod();
        RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
        if (CongestionControlPolicy.DropMessage.equals((Object)this.congestionControlPolicy) && this.controlCongestion(request, null, dialog, routeHeader, sipProvider)) {
            return;
        }
        if ((this.rejectSipMessages || this.memoryToHigh) && CongestionControlPolicy.DropMessage.equals((Object)this.congestionControlPolicy)) {
            boolean goodMethod;
            String method = requestEvent.getRequest().getMethod();
            boolean bl = goodMethod = method.equals("ACK") || method.equals("PRACK") || method.equals("BYE") || method.equals("CANCEL") || method.equals("UPDATE") || method.equals("INFO");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("congestion control good method " + goodMethod + ", dialog " + dialog + " routeHeader " + routeHeader));
            }
            if (!(goodMethod || dialog != null || routeHeader != null && ((Parameters)routeHeader.getAddress().getURI()).getParameter("proxy") != null)) {
                logger.error((Object)"dropping request, memory is too high or too many messages present in queues");
                return;
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sipApplicationDispatcher " + this + ", Got a request event " + request.toString()));
            }
            if (!"ACK".equals(requestMethod) && requestTransaction == null) {
                try {
                    if (request.getHeader("Max-Forwards") == null) {
                        request.setHeader((Header)SipFactoryImpl.headerFactory.createMaxForwardsHeader(70));
                    }
                    requestTransaction = sipProvider.getNewServerTransaction(request);
                    JainSipUtils.setTransactionTimers((TransactionExt)requestTransaction, this);
                }
                catch (TransactionUnavailableException tae) {
                    logger.error((Object)("cannot get a new Server transaction for this request " + request), (Throwable)tae);
                    MessageDispatcher.sendErrorResponse(this, 500, requestTransaction, request, sipProvider);
                    return;
                }
                catch (TransactionAlreadyExistsException taex) {
                    return;
                }
            }
            ServerTransaction transaction = requestTransaction;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ServerTx ref " + transaction));
                logger.debug((Object)("Dialog ref " + dialog));
            }
            SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(request, null, (Transaction)transaction, dialog, JainSipUtils.DIALOG_CREATING_METHODS.contains(requestMethod));
            this.updateRequestsStatistics(request, true);
            if (!this.isRouteExternal(routeHeader)) {
                TransactionApplicationData transactionApplicationData;
                request.removeFirst("Route");
                sipServletRequest.setPoppedRoute(routeHeader);
                Parameters poppedAddress = (Parameters)routeHeader.getAddress().getURI();
                if (poppedAddress.getParameter("proxy") != null || request.getRequestURI() instanceof javax.sip.address.SipURI && ((Parameters)request.getRequestURI()).getParameter("proxy") != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"the request is for a proxy application, thus it is a subsequent request ");
                    }
                    sipServletRequest.setRoutingState(RoutingState.SUBSEQUENT);
                }
                if (transaction != null && (transactionApplicationData = (TransactionApplicationData)transaction.getApplicationData()) != null && transactionApplicationData.getInitialPoppedRoute() == null) {
                    transactionApplicationData.setInitialPoppedRoute(new AddressImpl(routeHeader.getAddress(), null, AddressImpl.ModifiableRule.NotModifiable));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Routing State " + (Object)((Object)sipServletRequest.getRoutingState())));
            }
            try {
                if (this.controlCongestion(request, sipServletRequest, dialog, routeHeader, sipProvider)) {
                    return;
                }
                this.messageDispatcherFactory.getRequestDispatcher(sipServletRequest, this).dispatchMessage(sipProvider, sipServletRequest);
            }
            catch (DispatcherException e) {
                logger.error((Object)("Unexpected exception while processing request " + request), (Throwable)e);
                if (!"ACK".equalsIgnoreCase(requestMethod)) {
                    MessageDispatcher.sendErrorResponse(this, e.getErrorCode(), sipServletRequest, sipProvider);
                }
                return;
            }
            catch (Throwable e) {
                logger.error((Object)("Unexpected exception while processing request " + request), e);
                if (!"ACK".equalsIgnoreCase(requestMethod)) {
                    MessageDispatcher.sendErrorResponse(this, 500, sipServletRequest, sipProvider);
                }
                return;
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Unexpected exception while processing request " + request), e);
            if (!"ACK".equalsIgnoreCase(request.getMethod())) {
                MessageDispatcher.sendErrorResponse(this, 500, requestTransaction, request, sipProvider);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackCongestionControlListener(boolean triggered, CongestionControlEvent congestionControlEvent) {
        for (SipContext sipContext : this.applicationDeployed.values()) {
            ContainerListener containerListener = sipContext.getListeners().getContainerListener();
            if (containerListener == null) continue;
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipContext();
                try {
                    if (triggered) {
                        containerListener.onCongestionControlStarted(congestionControlEvent);
                        continue;
                    }
                    containerListener.onCongestionControlStopped(congestionControlEvent);
                }
                catch (Throwable t) {
                    logger.error((Object)"ContainerListener threw exception", t);
                }
            }
            finally {
                sipContext.exitSipContext(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean controlCongestion(Request request, SipServletRequestImpl sipServletRequest, Dialog dialog, RouteHeader routeHeader, SipProvider sipProvider) {
        if (this.rejectSipMessages || this.memoryToHigh) {
            boolean goodMethod;
            String method = request.getMethod();
            boolean bl = goodMethod = method.equals("ACK") || method.equals("PRACK") || method.equals("BYE") || method.equals("CANCEL") || method.equals("UPDATE") || method.equals("INFO");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("congestion control good method " + goodMethod + ", dialog " + dialog + " routeHeader " + routeHeader));
            }
            if (!(goodMethod || dialog != null || routeHeader != null && ((Parameters)routeHeader.getAddress().getURI()).getParameter("proxy") != null)) {
                if (CongestionControlPolicy.DropMessage.equals((Object)this.congestionControlPolicy)) {
                    logger.error((Object)"dropping request, memory is too high or too many messages present in queues");
                    return true;
                }
                SipServletResponse sipServletResponse = null;
                String message = null;
                if (this.rejectSipMessages) {
                    message = "Number of pending messages in the queues : " + this.numberOfMessagesInQueue + " > to the queue Size : " + this.queueSize;
                } else if (this.memoryToHigh) {
                    message = "Memory used: " + this.percentageOfMemoryUsed + "% > to the memory threshold : " + this.memoryThreshold + "%";
                }
                CongestionControlEvent congestionControlEvent = new CongestionControlEvent(CongestionControlEvent.Reason.Memory, message);
                for (SipContext sipContext : this.applicationDeployed.values()) {
                    ContainerListener containerListener = sipContext.getListeners().getContainerListener();
                    if (containerListener == null) continue;
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        sipContext.enterSipContext();
                        try {
                            sipServletResponse = containerListener.onRequestThrottled((SipServletRequest)sipServletRequest, congestionControlEvent);
                        }
                        catch (Throwable t) {
                            logger.error((Object)"ContainerListener threw exception", t);
                        }
                    }
                    finally {
                        sipContext.exitSipContext(oldClassLoader);
                    }
                    if (sipServletResponse == null) continue;
                    try {
                        ((ServerTransaction)sipServletRequest.getTransaction()).sendResponse(((SipServletResponseImpl)sipServletResponse).getResponse());
                        this.sipFactoryImpl.getSipApplicationDispatcher().updateResponseStatistics(((SipServletResponseImpl)sipServletResponse).getResponse(), false);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Problem while sending the error response " + sipServletResponse + " to the following request " + request.toString()), (Throwable)e);
                    }
                    return true;
                }
                if (sipServletResponse == null) {
                    MessageDispatcher.sendErrorResponse(this, 503, (ServerTransaction)sipServletRequest.getTransaction(), request, sipProvider);
                    return true;
                }
            }
        }
        return false;
    }

    public void updateRequestsStatistics(Request request, boolean processed) {
        if (this.gatherStatistics) {
            AtomicLong requestsStats = null;
            requestsStats = processed ? this.requestsProcessed : this.requestsSent;
            requestsStats.incrementAndGet();
            String method = request.getMethod();
            AtomicLong requestsStatsMethod = null;
            requestsStatsMethod = processed ? this.requestsProcessedByMethod.get(method) : this.requestsSentByMethod.get(method);
            if (requestsStatsMethod == null) {
                if (processed) {
                    this.requestsProcessedByMethod.put(method, new AtomicLong());
                } else {
                    this.requestsSentByMethod.put(method, new AtomicLong());
                }
            } else {
                requestsStatsMethod.incrementAndGet();
            }
        }
    }

    public void updateResponseStatistics(Response response, boolean processed) {
        if (this.gatherStatistics) {
            AtomicLong responsesStats = null;
            Map<String, AtomicLong> responsesStatsStatusCode = null;
            if (processed) {
                responsesStats = this.responsesProcessed;
                responsesStatsStatusCode = this.responsesProcessedByStatusCode;
            } else {
                responsesStats = this.responsesSent;
                responsesStatsStatusCode = this.responsesSentByStatusCode;
            }
            responsesStats.incrementAndGet();
            int statusCode = response.getStatusCode();
            int statusCodeDiv = statusCode / 100;
            switch (statusCodeDiv) {
                case 1: {
                    responsesStatsStatusCode.get("1XX").incrementAndGet();
                    break;
                }
                case 2: {
                    responsesStatsStatusCode.get("2XX").incrementAndGet();
                    break;
                }
                case 3: {
                    responsesStatsStatusCode.get("3XX").incrementAndGet();
                    break;
                }
                case 4: {
                    responsesStatsStatusCode.get("4XX").incrementAndGet();
                    break;
                }
                case 5: {
                    responsesStatsStatusCode.get("5XX").incrementAndGet();
                    break;
                }
                case 6: {
                    responsesStatsStatusCode.get("6XX").incrementAndGet();
                    break;
                }
                case 7: {
                    responsesStatsStatusCode.get("7XX").incrementAndGet();
                    break;
                }
                case 8: {
                    responsesStatsStatusCode.get("8XX").incrementAndGet();
                    break;
                }
                case 9: {
                    responsesStatsStatusCode.get("9XX").incrementAndGet();
                }
            }
        }
    }

    public void incCalls() {
        this.counterCalls.inc();
    }

    public void incMessages() {
        this.counterMessages.inc();
    }

    public void incSeconds(long seconds) {
        this.counterSeconds.inc(seconds);
    }

    public void processResponse(ResponseEvent responseEvent) {
        CSeqHeader cSeqHeader;
        ResponseEventExt responseEventExt = (ResponseEventExt)responseEvent;
        Response response = responseEventExt.getResponse();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Response " + response.toString()));
        }
        if ("CANCEL".equalsIgnoreCase((cSeqHeader = (CSeqHeader)response.getHeader("CSeq")).getMethod())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"the response is dropped accordingly to JSR 289 since this a response to a CANCEL");
            }
            return;
        }
        ((MessageExt)response).setApplicationData(null);
        this.updateResponseStatistics(response, true);
        ClientTransaction clientTransaction = responseEventExt.getClientTransaction();
        Dialog dialog = responseEventExt.getDialog();
        boolean isForkedResponse = responseEventExt.isForkedResponse();
        boolean isRetransmission = responseEventExt.isRetransmission();
        ClientTransactionExt originalTransaction = responseEventExt.getOriginalTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("is Forked Response " + isForkedResponse));
            logger.debug((Object)("is Retransmission " + isRetransmission));
            logger.debug((Object)("Client Transaction " + clientTransaction));
            logger.debug((Object)("Original Transaction " + originalTransaction));
            logger.debug((Object)("Dialog " + dialog));
            if (dialog != null) {
                logger.debug((Object)("Dialog State " + dialog.getState()));
            }
        }
        if (isForkedResponse && originalTransaction != null && !responseEventExt.isRetransmission()) {
            Dialog defaultDialog = originalTransaction.getDefaultDialog();
            Dialog orginalTransactionDialog = originalTransaction.getDialog();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Original Transaction Dialog " + orginalTransactionDialog));
                logger.debug((Object)("Original Transaction Default Dialog " + defaultDialog));
            }
            clientTransaction = originalTransaction;
        }
        SipServletResponseImpl sipServletResponse = (SipServletResponseImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletResponse(response, (Transaction)clientTransaction, null, dialog, true, isRetransmission);
        try {
            this.messageDispatcherFactory.getResponseDispatcher(sipServletResponse, this).dispatchMessage((SipProvider)responseEvent.getSource(), sipServletResponse);
        }
        catch (Throwable e) {
            logger.error((Object)("An unexpected exception happened while routing the response " + sipServletResponse), e);
            return;
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        final Dialog dialog = dialogTerminatedEvent.getDialog();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dialog Terminated => dialog Id : " + dialogTerminatedEvent.getDialog().getDialogId()));
        }
        this.getAsynchronousExecutor().execute(new Runnable(){
            final TransactionApplicationData dialogAppData;
            {
                this.dialogAppData = (TransactionApplicationData)dialog.getApplicationData();
            }

            @Override
            public void run() {
                try {
                    boolean appDataFound = false;
                    TransactionApplicationData txAppData = null;
                    if (this.dialogAppData != null) {
                        if (this.dialogAppData.getSipServletMessage() == null) {
                            Transaction transaction = this.dialogAppData.getTransaction();
                            if (transaction != null && transaction.getApplicationData() != null) {
                                txAppData = (TransactionApplicationData)transaction.getApplicationData();
                                txAppData.cleanUp();
                            }
                        } else {
                            MobicentsSipSessionKey sipSessionKey = this.dialogAppData.getSipSessionKey();
                            SipApplicationDispatcherImpl.this.tryToInvalidateSession(sipSessionKey, false);
                        }
                        this.dialogAppData.cleanUp();
                        dialog.setApplicationData(null);
                    }
                    if (!appDataFound && logger.isDebugEnabled()) {
                        logger.debug((Object)("no application data for this dialog " + dialog.getDialogId()));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Problem handling dialog termination", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void tryToInvalidateSession(MobicentsSipSessionKey sipSessionKey, boolean invalidateProxySession) {
        block27: {
            if (sipSessionKey != null && (sipContext = this.findSipApplication(sipSessionKey.getApplicationName())) != null) {
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    sipContext.enterSipContext();
                    sipManager = sipContext.getSipManager();
                    sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(sipSessionKey.getApplicationName(), sipSessionKey.getApplicationSessionId(), null);
                    sipSessionImpl = null;
                    sipApplicationSession = null;
                    if (sipManager instanceof DistributableSipManager) {
                        distributableSipManager = (DistributableSipManager)sipManager;
                        sipApplicationSession = distributableSipManager.getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, false, true);
                        sipSessionImpl = distributableSipManager.getSipSession(sipSessionKey, false, (MobicentsSipFactory)this.sipFactoryImpl, sipApplicationSession, true);
                    } else {
                        sipApplicationSession = sipManager.getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, false);
                        sipSessionImpl = sipManager.getSipSession(sipSessionKey, false, (MobicentsSipFactory)this.sipFactoryImpl, sipApplicationSession);
                    }
                    if (sipSessionImpl != null) {
                        proxy = sipSessionImpl.getProxy();
                        if (!invalidateProxySession && (proxy == null || proxy != null && (proxy.getFinalBranchForSubsequentRequests() != null && !proxy.getFinalBranchForSubsequentRequests().getRecordRoute() || proxy.isTerminationSent()))) {
                            if (SipApplicationDispatcherImpl.logger.isDebugEnabled()) {
                                if (proxy != null) {
                                    SipApplicationDispatcherImpl.logger.debug((Object)("try to Invalidate Proxy session if it is non record routing " + proxy.getFinalBranchForSubsequentRequests().getRecordRoute() + " or termination " + proxy.isTerminationSent() + " has been sent " + sipSessionKey));
                                } else {
                                    SipApplicationDispatcherImpl.logger.debug((Object)"Non Proxy session : invalidating");
                                }
                            }
                            invalidateProxySession = true;
                        }
                        if (!invalidateProxySession) {
                            if (SipApplicationDispatcherImpl.logger.isDebugEnabled()) {
                                SipApplicationDispatcherImpl.logger.debug((Object)"don't Invalidate Proxy session");
                            }
                            return;
                        }
                        batchStarted = false;
                        try {
                            sipContext.enterSipApp(sipApplicationSession, sipSessionImpl, false, true);
                            batchStarted = sipContext.enterSipAppHa(true);
                            if (SipApplicationDispatcherImpl.logger.isDebugEnabled()) {
                                SipApplicationDispatcherImpl.logger.debug((Object)("sip session " + sipSessionKey + " is valid ? :" + sipSessionImpl.isValidInternal()));
                                if (sipSessionImpl.isValidInternal()) {
                                    SipApplicationDispatcherImpl.logger.debug((Object)("Sip session " + sipSessionKey + " is ready to be invalidated ? :" + sipSessionImpl.isReadyToInvalidateInternal()));
                                }
                            }
                            if (!sipSessionImpl.isValidInternal() || !sipSessionImpl.isReadyToInvalidateInternal()) ** GOTO lbl46
                            sipSessionImpl.onTerminatedState();
                        }
                        finally {
                            sipContext.exitSipAppHa(null, null, batchStarted);
                            sipContext.exitSipApp(sipApplicationSession, sipSessionImpl);
                        }
                    } else if (SipApplicationDispatcherImpl.logger.isDebugEnabled()) {
                        SipApplicationDispatcherImpl.logger.debug((Object)("sip session already invalidated" + sipSessionKey));
                    }
lbl46:
                    // 5 sources

                    if (sipApplicationSession == null) break block27;
                    try {
                        sipContext.enterSipApp(sipApplicationSession, null, false, true);
                        if (SipApplicationDispatcherImpl.logger.isDebugEnabled()) {
                            SipApplicationDispatcherImpl.logger.debug((Object)("sip app session " + sipApplicationSession.getKey() + " is valid ? :" + sipApplicationSession.isValidInternal()));
                            if (sipApplicationSession.isValidInternal()) {
                                SipApplicationDispatcherImpl.logger.debug((Object)("Sip app session " + sipApplicationSession.getKey() + " is ready to be invalidated ? :" + sipApplicationSession.isReadyToInvalidate()));
                            }
                        }
                        if (sipApplicationSession.isValidInternal() && sipApplicationSession.isReadyToInvalidate()) {
                            sipApplicationSession.tryToInvalidate();
                        }
                    }
                    finally {
                        sipContext.exitSipApp(sipApplicationSession, null);
                    }
                }
                finally {
                    sipContext.exitSipContext(oldClassLoader);
                }
            }
        }
    }

    public void processDialogTimeout(final DialogTimeoutEvent timeoutEvent) {
        final Dialog dialog = timeoutEvent.getDialog();
        if (logger.isDebugEnabled()) {
            logger.info((Object)("dialog timeout " + dialog + " reason => " + timeoutEvent.getReason()));
        }
        if (timeoutEvent.getReason() == DialogTimeoutEvent.Reason.AckNotReceived) {
            final TransactionApplicationData tad = (TransactionApplicationData)dialog.getApplicationData();
            if (tad != null && tad.getSipServletMessage() != null) {
                final SipServletMessageImpl sipServletMessage = tad.getSipServletMessage();
                final MobicentsSipSessionKey sipSessionKey = sipServletMessage.getSipSessionKey();
                final MobicentsSipSession sipSession = sipServletMessage.getSipSession();
                this.getAsynchronousExecutor().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (logger.isDebugEnabled()) {
                            logger.info((Object)("Running process dialog timeout " + dialog + " reason => " + timeoutEvent.getReason()));
                        }
                        try {
                            SipContext sipContext;
                            if (sipSession != null && (sipContext = SipApplicationDispatcherImpl.this.findSipApplication(sipSessionKey.getApplicationName())) != null) {
                                MobicentsSipApplicationSession sipApplicationSession = sipSession.getSipApplicationSession();
                                try {
                                    sipContext.enterSipApp(sipApplicationSession, sipSession, false, true);
                                    SipApplicationDispatcherImpl.this.checkForAckNotReceived(sipServletMessage);
                                    SipApplicationDispatcherImpl.this.checkForPrackNotReceived(sipServletMessage);
                                }
                                finally {
                                    sipContext.exitSipApp(sipApplicationSession, sipSession);
                                }
                                SipApplicationDispatcherImpl.this.tryToInvalidateSession(sipSessionKey, false);
                            }
                            tad.cleanUp();
                            tad.cleanUpMessage();
                            dialog.setApplicationData(null);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Problem handling dialog timeout", (Throwable)e);
                        }
                    }
                });
            } else {
                dialog.setApplicationData(null);
            }
        } else {
            dialog.setApplicationData(null);
        }
    }

    public SipConnector findSipConnector(String ipAddress, int port, String transport) {
        MobicentsExtendedListeningPoint extendedListeningPoint = this.sipNetworkInterfaceManager.findMatchingListeningPoint(ipAddress, port, transport);
        if (extendedListeningPoint != null) {
            return extendedListeningPoint.getSipConnector();
        }
        return null;
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        TransactionApplicationData tad;
        Object eventTransaction = null;
        eventTransaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        ServerTransaction transaction = eventTransaction;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transaction " + transaction + " timed out => " + transaction.getRequest().toString()));
        }
        if ((tad = (TransactionApplicationData)transaction.getApplicationData()) != null && tad.getSipServletMessage() != null) {
            SipServletMessageImpl sipServletMessage = tad.getSipServletMessage();
            MobicentsSipSessionKey sipSessionKey = sipServletMessage.getSipSessionKey();
            MobicentsSipSession sipSession = sipServletMessage.getSipSession();
            this.getAsynchronousExecutor().execute(new Runnable((Transaction)transaction, sipSession, sipSessionKey, tad, timeoutEvent, sipServletMessage){
                final /* synthetic */ Transaction val$transaction;
                final /* synthetic */ MobicentsSipSession val$sipSession;
                final /* synthetic */ MobicentsSipSessionKey val$sipSessionKey;
                final /* synthetic */ TransactionApplicationData val$tad;
                final /* synthetic */ TimeoutEvent val$timeoutEvent;
                final /* synthetic */ SipServletMessageImpl val$sipServletMessage;
                {
                    this.val$transaction = transaction;
                    this.val$sipSession = mobicentsSipSession;
                    this.val$sipSessionKey = mobicentsSipSessionKey;
                    this.val$tad = transactionApplicationData;
                    this.val$timeoutEvent = timeoutEvent;
                    this.val$sipServletMessage = sipServletMessageImpl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        block20: {
                            block18: {
                                block17: {
                                    if (SipApplicationDispatcherImpl.access$000().isDebugEnabled()) {
                                        SipApplicationDispatcherImpl.access$000().debug((Object)("transaction " + this.val$transaction + " timed out => " + this.val$transaction.getRequest().toString()));
                                    }
                                    appNotifiedOfPrackNotReceived = false;
                                    if (SipApplicationDispatcherImpl.access$000().isDebugEnabled()) {
                                        SipApplicationDispatcherImpl.access$000().debug((Object)("time out happened on sipSession " + this.val$sipSession));
                                    }
                                    if (this.val$sipSession == null || (sipContext = SipApplicationDispatcherImpl.this.findSipApplication(this.val$sipSessionKey.getApplicationName())) == null) break block20;
                                    sipApplicationSession = this.val$sipSession.getSipApplicationSession();
                                    sipContext.enterSipApp(sipApplicationSession, this.val$sipSession, false, true);
                                    b2buaHelperImpl = this.val$sipSession.getB2buaHelper();
                                    if (b2buaHelperImpl != null && this.val$tad.getSipServletMessage() instanceof SipServletRequestImpl) {
                                        b2buaHelperImpl.unlinkOriginalRequestInternal((MobicentsSipServletRequest)((SipServletRequestImpl)this.val$tad.getSipServletMessage()), false);
                                    }
                                    if (SipApplicationDispatcherImpl.access$000().isDebugEnabled()) {
                                        SipApplicationDispatcherImpl.access$000().debug((Object)("time out happened on server tx ? " + this.val$timeoutEvent.isServerTransaction() + " and message " + this.val$sipServletMessage));
                                    }
                                    if (!(this.val$sipServletMessage instanceof SipServletRequestImpl) || this.val$timeoutEvent.isServerTransaction()) ** GOTO lbl48
                                    proxyBranchImpl = this.val$tad.getProxyBranch();
                                    if (proxyBranchImpl == null || (proxy = (ProxyImpl)proxyBranchImpl.getProxy()).getFinalBranchForSubsequentRequests() == null) break block17;
                                    this.val$tad.cleanUp();
                                    this.val$transaction.setApplicationData(null);
                                    this.val$sipSession.removeOngoingTransaction(this.val$transaction);
                                    this.val$sipSession.setRequestsPending(0);
                                    sipContext.exitSipApp(sipApplicationSession, this.val$sipSession);
                                    return;
                                }
                                sipServletRequestImpl = (SipServletRequestImpl)this.val$sipServletMessage;
                                if (!sipServletRequestImpl.visitNextHop()) break block18;
                                this.val$sipSession.removeOngoingTransaction(this.val$transaction);
                                this.val$sipSession.setRequestsPending(0);
                                sipContext.exitSipApp(sipApplicationSession, this.val$sipSession);
                                return;
                            }
                            try {
                                this.val$sipServletMessage.setTransaction(this.val$transaction);
                                response = (SipServletResponseImpl)sipServletRequestImpl.createResponse(408, null, false, true);
                                sipServletRequestImpl.setResponse(response);
                                MessageDispatcher.callServlet(response);
                                if (this.val$tad.getProxyBranch() != null) {
                                    this.val$tad.getProxyBranch().setResponse(response);
                                    this.val$tad.getProxyBranch().onResponse(response, response.getStatus());
                                }
                                this.val$sipSession.updateStateOnResponse((MobicentsSipServletResponse)response, true);
                                {
                                    catch (Throwable t) {
                                        SipApplicationDispatcherImpl.access$000().error((Object)("Failed to deliver 408 response on transaction timeout" + this.val$transaction), t);
                                    }
                                }
lbl48:
                                // 3 sources

                                if ("INVITE".equals(this.val$sipServletMessage.getMethod()) && this.val$timeoutEvent.isServerTransaction()) {
                                    SipApplicationDispatcherImpl.access$600(SipApplicationDispatcherImpl.this, this.val$sipServletMessage);
                                    appNotifiedOfPrackNotReceived = SipApplicationDispatcherImpl.access$700(SipApplicationDispatcherImpl.this, this.val$sipServletMessage);
                                }
                            }
                            catch (Throwable var8_10) {
                                throw var8_10;
                            }
                            finally {
                                this.val$sipSession.removeOngoingTransaction(this.val$transaction);
                                this.val$sipSession.setRequestsPending(0);
                                sipContext.exitSipApp(sipApplicationSession, this.val$sipSession);
                            }
                            if (!appNotifiedOfPrackNotReceived) {
                                SipApplicationDispatcherImpl.access$500(SipApplicationDispatcherImpl.this, this.val$sipSessionKey, false);
                            }
                        }
                        this.val$tad.cleanUp();
                        this.val$transaction.setApplicationData(null);
                    }
                    catch (Exception e) {
                        SipApplicationDispatcherImpl.access$000().error((Object)"Problem handling timeout", (Throwable)e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForAckNotReceived(SipServletMessageImpl sipServletMessage) {
        MobicentsSipSession sipSession = sipServletMessage.getSipSession();
        SipServletResponseImpl lastFinalResponse = (SipServletResponseImpl)((SipServletRequestImpl)sipServletMessage).getLastFinalResponse();
        MobicentsProxy proxy = sipSession.getProxy();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checkForAckNotReceived : request " + sipServletMessage + " last Final Response " + lastFinalResponse));
        }
        boolean notifiedApplication = false;
        if (sipServletMessage instanceof SipServletRequestImpl && "INVITE".equals(sipServletMessage.getMethod()) && proxy == null && lastFinalResponse != null) {
            SipContext sipContext = sipSession.getSipApplicationSession().getSipContext();
            List sipErrorListeners = sipContext.getListeners().getSipErrorListeners();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipContext();
                SipErrorEvent sipErrorEvent = new SipErrorEvent((SipServletRequest)sipServletMessage, (SipServletResponse)lastFinalResponse);
                for (SipErrorListener sipErrorListener : sipErrorListeners) {
                    try {
                        notifiedApplication = true;
                        sipErrorListener.noAckReceived(sipErrorEvent);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipErrorListener threw exception", t);
                    }
                }
            }
            finally {
                sipContext.exitSipContext(oldClassLoader);
            }
            Dialog dialog = sipSession.getSessionCreatingDialog();
            if (!notifiedApplication && sipSession.getProxy() == null && dialog != null && dialog.getState() != null && !dialog.getState().equals((Object)DialogState.TERMINATED)) {
                SipServletRequest bye = sipSession.createRequest("BYE");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("no applications called for ACK not received, sending BYE " + bye));
                }
                try {
                    bye.send();
                }
                catch (IOException e) {
                    logger.error((Object)("Couldn't send the BYE " + bye), (Throwable)e);
                }
            }
        }
        return notifiedApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForPrackNotReceived(SipServletMessageImpl sipServletMessage) {
        MobicentsSipSession sipSession = sipServletMessage.getSipSession();
        SipServletResponseImpl lastInfoResponse = (SipServletResponseImpl)((SipServletRequestImpl)sipServletMessage).getLastInformationalResponse();
        MobicentsProxy proxy = sipSession.getProxy();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checkForPrackNotReceived : last Informational Response " + lastInfoResponse));
        }
        boolean notifiedApplication = false;
        if (sipServletMessage instanceof SipServletRequestImpl && "INVITE".equals(sipServletMessage.getMethod()) && proxy == null && lastInfoResponse != null) {
            SipContext sipContext = sipSession.getSipApplicationSession().getSipContext();
            List sipErrorListeners = sipContext.getListeners().getSipErrorListeners();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                sipContext.enterSipContext();
                SipErrorEvent sipErrorEvent = new SipErrorEvent((SipServletRequest)sipServletMessage, (SipServletResponse)lastInfoResponse);
                for (SipErrorListener sipErrorListener : sipErrorListeners) {
                    try {
                        notifiedApplication = true;
                        sipErrorListener.noPrackReceived(sipErrorEvent);
                    }
                    catch (Throwable t) {
                        logger.error((Object)"SipErrorListener threw exception", t);
                    }
                }
            }
            finally {
                sipContext.exitSipContext(oldClassLoader);
            }
        }
        return notifiedApplication;
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        Object eventTransaction = null;
        eventTransaction = transactionTerminatedEvent.isServerTransaction() ? transactionTerminatedEvent.getServerTransaction() : transactionTerminatedEvent.getClientTransaction();
        ServerTransaction transaction = eventTransaction;
        if (logger.isDebugEnabled()) {
            logger.info((Object)("transaction " + transaction + " terminated => " + transaction.getRequest()));
        }
        TransactionApplicationData tad = (TransactionApplicationData)transaction.getApplicationData();
        String branchId = transaction.getBranchId();
        if (tad != null && tad.getSipServletMessage() != null) {
            SipServletMessageImpl sipServletMessageImpl = tad.getSipServletMessage();
            MobicentsSipSessionKey sipSessionKey = sipServletMessageImpl.getSipSessionKey();
            MobicentsSipSession sipSession = sipServletMessageImpl.getSipSession();
            this.getAsynchronousExecutor().execute(new Runnable((Transaction)transaction, sipServletMessageImpl, sipSession, sipSessionKey, tad, branchId, transactionTerminatedEvent){
                final /* synthetic */ Transaction val$transaction;
                final /* synthetic */ SipServletMessageImpl val$sipServletMessageImpl;
                final /* synthetic */ MobicentsSipSession val$sipSession;
                final /* synthetic */ MobicentsSipSessionKey val$sipSessionKey;
                final /* synthetic */ TransactionApplicationData val$tad;
                final /* synthetic */ String val$branchId;
                final /* synthetic */ TransactionTerminatedEvent val$transactionTerminatedEvent;
                {
                    this.val$transaction = transaction;
                    this.val$sipServletMessageImpl = sipServletMessageImpl;
                    this.val$sipSession = mobicentsSipSession;
                    this.val$sipSessionKey = mobicentsSipSessionKey;
                    this.val$tad = transactionApplicationData;
                    this.val$branchId = string;
                    this.val$transactionTerminatedEvent = transactionTerminatedEvent;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block19: {
                        try {
                            SipContext sipContext;
                            if (logger.isDebugEnabled()) {
                                logger.info((Object)("transaction " + this.val$transaction + " terminated => " + this.val$sipServletMessageImpl));
                            }
                            MobicentsB2BUAHelper b2buaHelperImpl = null;
                            if (this.val$sipSession != null) {
                                b2buaHelperImpl = this.val$sipSession.getB2buaHelper();
                            }
                            if (this.val$sipSessionKey == null && logger.isDebugEnabled()) {
                                logger.debug((Object)("no sip session were returned for this key " + this.val$sipServletMessageImpl.getSipSessionKey() + " and message " + this.val$sipServletMessageImpl));
                            }
                            if (this.val$tad.getProxyBranch() != null) {
                                this.val$tad.getProxyBranch().removeTransaction(this.val$branchId);
                            }
                            if (this.val$sipSession == null) break block19;
                            boolean removeTx = true;
                            if (b2buaHelperImpl != null && (this.val$transaction == null || this.val$transaction instanceof ClientTransaction) && "INVITE".equals(this.val$sipServletMessageImpl.getMethod())) {
                                removeTx = false;
                            }
                            if ((sipContext = SipApplicationDispatcherImpl.this.findSipApplication(this.val$sipSessionKey.getApplicationName())) != null) {
                                MobicentsSipApplicationSession sipApplicationSession = this.val$sipSession.getSipApplicationSession();
                                try {
                                    sipContext.enterSipApp(sipApplicationSession, this.val$sipSession, false, true);
                                    if (b2buaHelperImpl != null && this.val$tad.getSipServletMessage() instanceof SipServletRequestImpl) {
                                        b2buaHelperImpl.unlinkOriginalRequestInternal((MobicentsSipServletRequest)((SipServletRequestImpl)this.val$tad.getSipServletMessage()), false);
                                    }
                                    if (removeTx) {
                                        if (b2buaHelperImpl != null && this.val$tad.getSipServletMessage() instanceof SipServletRequestImpl) {
                                            b2buaHelperImpl.unlinkOriginalRequestInternal((MobicentsSipServletRequest)((SipServletRequestImpl)this.val$tad.getSipServletMessage()), false);
                                        }
                                        this.val$sipSession.removeOngoingTransaction(this.val$transaction);
                                        boolean nullifyAppData = true;
                                        if (((SipStackImpl)((SipProvider)this.val$transactionTerminatedEvent.getSource()).getSipStack()).getMaxForkTime() > 0 && "INVITE".equals(this.val$sipServletMessageImpl.getMethod())) {
                                            nullifyAppData = false;
                                        }
                                        if (nullifyAppData) {
                                            this.val$tad.cleanUp();
                                            if (b2buaHelperImpl == null && this.val$tad.getSipServletMessage() instanceof SipServletRequestImpl) {
                                                this.val$sipSession.cleanDialogInformation(false);
                                            }
                                            this.val$transaction.setApplicationData(null);
                                        }
                                    } else if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Transaction " + this.val$transaction + " not removed from session " + this.val$sipSessionKey + " because the B2BUA might still need it to create the ACK"));
                                    }
                                }
                                finally {
                                    sipContext.exitSipApp(sipApplicationSession, this.val$sipSession);
                                }
                            }
                            SipApplicationDispatcherImpl.this.tryToInvalidateSession(this.val$sipSessionKey, this.val$transactionTerminatedEvent.isServerTransaction());
                        }
                        catch (Exception e) {
                            logger.error((Object)"Problem handling transaction termination", (Throwable)e);
                        }
                    }
                }
            });
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TransactionApplicationData not available on the following request " + transaction.getRequest().toString()));
            }
            if (tad != null) {
                tad.cleanUp();
            }
            transaction.setApplicationData(null);
        }
    }

    public String getApplicationNameFromHash(String hash) {
        return this.mdToApplicationName.get(hash);
    }

    public String getHashFromApplicationName(String appName) {
        return this.applicationNameToMd.get(appName);
    }

    public String getApplicationServerId() {
        return this.applicationServerId;
    }

    public String getApplicationServerIdHash() {
        return this.applicationServerIdHash;
    }

    public int getTagHashMaxLength() {
        return this.tagHashMaxLength;
    }

    public CallIdHeader getCallId(MobicentsExtendedListeningPoint extendedListeningPoint, String callId) throws ParseException {
        String callIdString = callId;
        if (callIdString == null) {
            callIdString = extendedListeningPoint.getSipProvider().getNewCallId().getCallId();
        }
        if (this.callIdMaxLength > 0 && callIdString.length() > this.callIdMaxLength) {
            callIdString = callIdString.substring(0, this.callIdMaxLength);
        }
        return SipFactoryImpl.headerFactory.createCallIdHeader(callIdString);
    }

    public final boolean isRouteExternal(RouteHeader routeHeader) {
        if (routeHeader != null) {
            javax.sip.address.SipURI routeUri = (javax.sip.address.SipURI)routeHeader.getAddress().getURI();
            String routeTransport = routeUri.getTransportParam();
            if (routeTransport == null) {
                routeTransport = "UDP";
            }
            return this.isExternal(routeUri.getHost(), routeUri.getPort(), routeTransport);
        }
        return true;
    }

    public final boolean isViaHeaderExternal(ViaHeader viaHeader) {
        if (viaHeader != null) {
            return this.isExternal(viaHeader.getHost(), viaHeader.getPort(), viaHeader.getTransport());
        }
        return true;
    }

    public final boolean isExternal(String host, int port, String transport) {
        boolean isExternal = true;
        MobicentsExtendedListeningPoint listeningPoint = this.sipNetworkInterfaceManager.findMatchingListeningPoint(host, port, transport);
        if (this.hostNames.contains(host) || this.hostNames.contains(host + ":" + port) || listeningPoint != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("hostNames.contains(" + host + ")=" + this.hostNames.contains(host) + "hostNames.contains(" + host + ":" + port + ")=" + this.hostNames.contains(host + ":" + port) + " | listeningPoint found = " + listeningPoint));
            }
            isExternal = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("the triplet host/port/transport : " + host + "/" + port + "/" + transport + " is external : " + isExternal));
        }
        return isExternal;
    }

    public SipApplicationRouter getSipApplicationRouter() {
        return this.sipApplicationRouter;
    }

    public void setSipApplicationRouter(SipApplicationRouter sipApplicationRouter) {
        this.sipApplicationRouter = sipApplicationRouter;
    }

    public SipNetworkInterfaceManager getSipNetworkInterfaceManager() {
        return this.sipNetworkInterfaceManager;
    }

    public MobicentsSipFactory getSipFactory() {
        return this.sipFactoryImpl;
    }

    public List<SipURI> getOutboundInterfaces() {
        return this.sipNetworkInterfaceManager.getOutboundInterfaces();
    }

    private void resetOutboundInterfaces() {
        List outboundInterfaces = this.sipNetworkInterfaceManager.getOutboundInterfaces();
        for (SipContext sipContext : this.applicationDeployed.values()) {
            sipContext.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", (Object)outboundInterfaces);
        }
    }

    public void addHostName(String hostName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this);
            logger.debug((Object)("Adding hostname " + hostName));
        }
        this.hostNames.add(hostName);
        if (this.dnsServerLocator != null) {
            this.dnsServerLocator.addLocalHostName(hostName);
        }
    }

    public Set<String> findHostNames() {
        return this.hostNames;
    }

    public void removeHostName(String hostName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing hostname " + hostName));
        }
        this.hostNames.remove(hostName);
        if (this.dnsServerLocator != null) {
            this.dnsServerLocator.removeLocalHostName(hostName);
        }
    }

    public SipApplicationRouterInfo getNextInterestedApplication(MobicentsSipServletRequest sipServletRequest) {
        SipApplicationRoutingRegion routingRegion = null;
        Serializable stateInfo = null;
        if (sipServletRequest.getSipSession() != null) {
            routingRegion = sipServletRequest.getSipSession().getRegionInternal();
            stateInfo = sipServletRequest.getSipSession().getStateInfo();
        }
        Request request = (Request)sipServletRequest.getMessage();
        sipServletRequest.setReadOnly(true);
        SipApplicationRouterInfo applicationRouterInfo = this.sipApplicationRouter.getNextApplication((SipServletRequest)sipServletRequest, routingRegion, sipServletRequest.getRoutingDirective(), null, stateInfo);
        sipServletRequest.setReadOnly(false);
        SipRouteModifier sipRouteModifier = applicationRouterInfo.getRouteModifier();
        String[] routes = applicationRouterInfo.getRoutes();
        try {
            if (SipRouteModifier.ROUTE.equals((Object)sipRouteModifier)) {
                Address routeAddress = SipFactoryImpl.addressFactory.createAddress(routes[0]);
                RouteHeader applicationRouterInfoRouteHeader = SipFactoryImpl.headerFactory.createRouteHeader(routeAddress);
                if (this.isRouteExternal(applicationRouterInfoRouteHeader)) {
                    for (int i = routes.length - 1; i >= 0; --i) {
                        RouteHeader routeHeader = (RouteHeader)SipFactoryImpl.headerFactory.createHeader("Route", routes[i]);
                        URI routeURI = routeHeader.getAddress().getURI();
                        if (routeURI.isSipURI()) {
                            ((javax.sip.address.SipURI)routeURI).setLrParam();
                        }
                        request.addHeader((Header)routeHeader);
                    }
                }
            } else if (SipRouteModifier.ROUTE_BACK.equals((Object)sipRouteModifier)) {
                SipURI sipURI = this.getOutboundInterfaces().get(0);
                sipURI.setParameter("modifier", "route_back");
                Header routeHeader = SipFactoryImpl.headerFactory.createHeader("Route", sipURI.toString());
                request.addHeader(routeHeader);
                for (int i = routes.length - 1; i >= 0; --i) {
                    routeHeader = SipFactoryImpl.headerFactory.createHeader("Route", routes[i]);
                    request.addHeader(routeHeader);
                }
            }
        }
        catch (ParseException e) {
            logger.error((Object)"Impossible to parse the route returned by the application router into a compliant address", (Throwable)e);
        }
        return applicationRouterInfo;
    }

    public ThreadPoolExecutor getAsynchronousExecutor() {
        return this.asynchronousExecutor;
    }

    public ScheduledThreadPoolExecutor getAsynchronousScheduledExecutor() {
        return this.asynchronousScheduledThreadPoolExecutor;
    }

    public Iterator<SipContext> findSipApplications() {
        return this.applicationDeployed.values().iterator();
    }

    public SipContext findSipApplication(String applicationName) {
        return this.applicationDeployed.get(applicationName);
    }

    public DNSResolver getDNSResolver() {
        return this.dnsResolver;
    }

    public DNSServerLocator getDNSServerLocator() {
        return this.dnsServerLocator;
    }

    public void setDNSServerLocator(DNSServerLocator dnsServerLocator) {
        this.dnsServerLocator = dnsServerLocator;
    }

    public int getDNSTimeout() {
        return this.dnsTimeout;
    }

    public void setDNSTimeout(int dnsTimeout) {
        this.dnsTimeout = dnsTimeout;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("DNSServerLocator will be using timeout of " + dnsTimeout + " seconds "));
        }
        this.dnsServerLocator.getDnsLookupPerformer().setDNSTimeout(dnsTimeout);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public String[] findInstalledSipApplications() {
        Iterator<SipContext> apps = this.findSipApplications();
        ArrayList<String> appList = new ArrayList<String>();
        while (apps.hasNext()) {
            SipContext ctx = apps.next();
            appList.add(ctx.getApplicationName());
        }
        String[] ret = new String[appList.size()];
        for (int q = 0; q < appList.size(); ++q) {
            ret[q] = (String)appList.get(q);
        }
        return ret;
    }

    public Object retrieveApplicationRouterConfiguration() {
        if (this.sipApplicationRouter instanceof ManageableApplicationRouter) {
            ManageableApplicationRouter router = (ManageableApplicationRouter)this.sipApplicationRouter;
            return router.getCurrentConfiguration();
        }
        throw new RuntimeException("This application router is not manageable");
    }

    public Map<String, List<? extends SipApplicationRouterInfo>> getApplicationRouterConfiguration() {
        if (this.sipApplicationRouter instanceof ManageableApplicationRouter) {
            ManageableApplicationRouter router = (ManageableApplicationRouter)this.sipApplicationRouter;
            return router.getConfiguration();
        }
        throw new RuntimeException("This application router is not manageable");
    }

    public void updateApplicationRouterConfiguration(Object configuration) {
        if (!(this.sipApplicationRouter instanceof ManageableApplicationRouter)) {
            throw new RuntimeException("This application router is not manageable");
        }
        ManageableApplicationRouter router = (ManageableApplicationRouter)this.sipApplicationRouter;
        router.configure(configuration);
    }

    public Serializable retrieveApplicationRouterConfigurationString() {
        if (this.sipApplicationRouter instanceof ManageableApplicationRouter) {
            ManageableApplicationRouter router = (ManageableApplicationRouter)this.sipApplicationRouter;
            return (Serializable)router.getCurrentConfiguration();
        }
        throw new RuntimeException("This application router is not manageable");
    }

    public void updateApplicationRouterConfiguration(Serializable configuration) {
        if (!(this.sipApplicationRouter instanceof ManageableApplicationRouter)) {
            throw new RuntimeException("This application router is not manageable");
        }
        ManageableApplicationRouter router = (ManageableApplicationRouter)this.sipApplicationRouter;
        router.configure((Object)configuration);
    }

    public ConcurrencyControlMode getConcurrencyControlMode() {
        return this.concurrencyControlMode;
    }

    public void setConcurrencyControlMode(ConcurrencyControlMode concurrencyControlMode) {
        this.concurrencyControlMode = concurrencyControlMode;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Container wide Concurrency Control set to " + concurrencyControlMode));
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Queue Size set to " + queueSize));
        }
    }

    public void setConcurrencyControlModeByName(String concurrencyControlMode) {
        this.concurrencyControlMode = ConcurrencyControlMode.valueOf((String)concurrencyControlMode);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Container wide Concurrency Control set to " + concurrencyControlMode));
        }
    }

    public String getConcurrencyControlModeByName() {
        return this.concurrencyControlMode.toString();
    }

    public long getRequestsProcessed() {
        return this.requestsProcessed.get();
    }

    public Map<String, AtomicLong> getRequestsProcessedByMethod() {
        return this.requestsProcessedByMethod;
    }

    public Map<String, AtomicLong> getResponsesProcessedByStatusCode() {
        return this.responsesProcessedByStatusCode;
    }

    public long getRequestsProcessedByMethod(String method) {
        AtomicLong requestsProcessed = this.requestsProcessedByMethod.get(method);
        if (requestsProcessed != null) {
            return requestsProcessed.get();
        }
        return 0L;
    }

    public long getResponsesProcessedByStatusCode(String statusCode) {
        AtomicLong responsesProcessed = this.responsesProcessedByStatusCode.get(statusCode);
        if (responsesProcessed != null) {
            return responsesProcessed.get();
        }
        return 0L;
    }

    public long getResponsesProcessed() {
        return this.responsesProcessed.get();
    }

    public long getRequestsSent() {
        return this.requestsSent.get();
    }

    public Map<String, AtomicLong> getRequestsSentByMethod() {
        return this.requestsSentByMethod;
    }

    public Map<String, AtomicLong> getResponsesSentByStatusCode() {
        return this.responsesSentByStatusCode;
    }

    public long getRequestsSentByMethod(String method) {
        AtomicLong requestsSent = this.requestsSentByMethod.get(method);
        if (requestsSent != null) {
            return requestsSent.get();
        }
        return 0L;
    }

    public long getResponsesSentByStatusCode(String statusCode) {
        AtomicLong responsesSent = this.responsesSentByStatusCode.get(statusCode);
        if (responsesSent != null) {
            return responsesSent.get();
        }
        return 0L;
    }

    public long getResponsesSent() {
        return this.responsesSent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCongestionControlCheckingInterval(long congestionControlCheckingInterval) {
        if (congestionControlCheckingInterval != this.congestionControlCheckingInterval) {
            this.congestionControlCheckingInterval = congestionControlCheckingInterval;
            this.statusLock.lock();
            try {
                if (this.started.booleanValue()) {
                    if (this.congestionControlTimerFuture != null) {
                        this.congestionControlTimerFuture.cancel(false);
                    }
                    if (congestionControlCheckingInterval > 0L) {
                        this.congestionControlTimerFuture = this.asynchronousScheduledThreadPoolExecutor.scheduleWithFixedDelay(this.congestionControlTimerTask, congestionControlCheckingInterval, congestionControlCheckingInterval, TimeUnit.MILLISECONDS);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Congestion control background task modified to check every " + congestionControlCheckingInterval + " milliseconds."));
                        }
                    } else if (logger.isInfoEnabled()) {
                        logger.info((Object)("No Congestion control background task started since the checking interval is equals to " + congestionControlCheckingInterval + " milliseconds."));
                    }
                }
            }
            finally {
                this.statusLock.unlock();
            }
        }
    }

    public long getCongestionControlCheckingInterval() {
        return this.congestionControlCheckingInterval;
    }

    public void setCongestionControlPolicy(CongestionControlPolicy congestionControlPolicy) {
        this.congestionControlPolicy = congestionControlPolicy;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Congestion Control policy set to " + this.congestionControlPolicy.toString()));
        }
    }

    public void setCongestionControlPolicyByName(String congestionControlPolicy) {
        this.congestionControlPolicy = CongestionControlPolicy.valueOf((String)congestionControlPolicy);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Congestion Control policy set to " + this.congestionControlPolicy.toString()));
        }
    }

    public String getCongestionControlPolicyByName() {
        return this.congestionControlPolicy.toString();
    }

    public CongestionControlPolicy getCongestionControlPolicy() {
        return this.congestionControlPolicy;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Memory threshold set to " + this.memoryThreshold + "%"));
        }
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public int getNumberOfMessagesInQueue() {
        return this.numberOfMessagesInQueue;
    }

    public double getPercentageOfMemoryUsed() {
        return this.percentageOfMemoryUsed;
    }

    public void setBypassRequestExecutor(boolean bypassRequestExecutor) {
        this.bypassRequestExecutor = bypassRequestExecutor;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bypass Request Executor enabled ?" + this.bypassRequestExecutor));
        }
    }

    public boolean isBypassRequestExecutor() {
        return this.bypassRequestExecutor;
    }

    public void setBypassResponseExecutor(boolean bypassResponseExecutor) {
        this.bypassResponseExecutor = bypassResponseExecutor;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bypass Response Executor enabled ?" + this.bypassResponseExecutor));
        }
    }

    public boolean isBypassResponseExecutor() {
        return this.bypassResponseExecutor;
    }

    public void setBaseTimerInterval(int baseTimerInterval) {
        if (baseTimerInterval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the Base Timer Interval to a non positive value");
        }
        this.baseTimerInterval = baseTimerInterval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Base Timer Interval set to " + this.baseTimerInterval + "ms"));
        }
    }

    public int getBaseTimerInterval() {
        return this.baseTimerInterval;
    }

    public void setT2Interval(int t2Interval) {
        if (t2Interval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer T2 Interval to a non positive value");
        }
        this.t2Interval = t2Interval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Timer T2 Interval set to " + this.t2Interval + "ms"));
        }
    }

    public int getT2Interval() {
        return this.t2Interval;
    }

    public void setT4Interval(int t4Interval) {
        if (t4Interval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer T4 Interval to a non positive value");
        }
        this.t4Interval = t4Interval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Timer T4 Interval set to " + this.t4Interval + "ms"));
        }
    }

    public int getT4Interval() {
        return this.t4Interval;
    }

    public void setTimerDInterval(int timerDInterval) {
        if (timerDInterval < 1) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer TD Interval to a non positive value");
        }
        if (timerDInterval < 32000) {
            throw new IllegalArgumentException("It's forbidden to set the SIP Timer TD Interval to a value lower than 32s");
        }
        this.timerDInterval = timerDInterval;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("SIP Timer D Interval set to " + this.timerDInterval + "ms"));
        }
    }

    public int getTimerDInterval() {
        return this.timerDInterval;
    }

    public String[] getExtensionsSupported() {
        return EXTENSIONS_SUPPORTED;
    }

    public String[] getRfcSupported() {
        return RFC_SUPPORTED;
    }

    public void loadBalancerAdded(SipLoadBalancer sipLoadBalancer) {
        this.sipLoadBalancers.add(sipLoadBalancer);
        if (this.sipFactoryImpl.getLoadBalancerToUse() == null) {
            this.sipFactoryImpl.setLoadBalancerToUse(sipLoadBalancer);
        }
    }

    public void loadBalancerRemoved(SipLoadBalancer sipLoadBalancer) {
        this.sipLoadBalancers.remove(sipLoadBalancer);
        if (this.sipFactoryImpl.getLoadBalancerToUse() != null && this.sipFactoryImpl.getLoadBalancerToUse().equals((Object)sipLoadBalancer)) {
            if (this.sipLoadBalancers.size() > 0) {
                this.sipFactoryImpl.setLoadBalancerToUse(this.sipLoadBalancers.iterator().next());
            } else {
                this.sipFactoryImpl.setLoadBalancerToUse(null);
            }
        }
    }

    public void pingingloadBalancer(SipLoadBalancer balancerDescription) {
        SipConnector[] sipConnectors;
        for (SipConnector sipConnector : sipConnectors = this.sipService.findSipConnectors()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Comparing Balancer Address " + balancerDescription.getAddress().getHostAddress() + " to sipconnector balancer address " + sipConnector.getLoadBalancerAddress()));
            }
            if (!balancerDescription.getAddress().getHostAddress().equals(sipConnector.getLoadBalancerAddress()) || sipConnector.getLoadBalancerCustomInformation() == null || sipConnector.getLoadBalancerCustomInformation().isEmpty()) continue;
            balancerDescription.setCustomInfo(sipConnector.getLoadBalancerCustomInformation());
        }
    }

    public void pingedloadBalancer(SipLoadBalancer balancerDescription) {
    }

    public void sendSwitchoverInstruction(String fromJvmRoute, String toJvmRoute) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("switching over from " + fromJvmRoute + " to " + toJvmRoute));
        }
        if (fromJvmRoute == null || toJvmRoute == null) {
            return;
        }
        for (SipLoadBalancer sipLoadBalancer : this.sipLoadBalancers) {
            sipLoadBalancer.switchover(fromJvmRoute, toJvmRoute);
        }
    }

    public void setGracefulShutdown(boolean shuttingDownGracefully) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sending graceful shutdown to Load Balancers");
        }
    }

    public void setGatherStatistics(boolean gatherStatistics) {
        this.gatherStatistics = gatherStatistics;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Gathering Statistics set to " + gatherStatistics));
        }
    }

    public boolean isGatherStatistics() {
        return this.gatherStatistics;
    }

    public boolean getGatherStatistics() {
        return this.gatherStatistics;
    }

    public void setBackToNormalMemoryThreshold(int backToNormalMemoryThreshold) {
        this.backToNormalMemoryThreshold = backToNormalMemoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Back To Normal Memory threshold set to " + backToNormalMemoryThreshold + "%"));
        }
    }

    public int getBackToNormalMemoryThreshold() {
        return this.backToNormalMemoryThreshold;
    }

    public void setBackToNormalQueueSize(int backToNormalQueueSize) {
        this.backToNormalQueueSize = backToNormalQueueSize;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Back To Normal Queue Size set to " + backToNormalQueueSize));
        }
    }

    public int getBackToNormalQueueSize() {
        return this.backToNormalQueueSize;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    protected void startSipStack() throws SipException {
        if (this.sipStack != null) {
            this.sipStack.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SIP stack started");
            }
        }
    }

    protected void stopSipStack() {
        if (this.sipStack != null) {
            this.sipStack.stop();
            this.sipStack = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SIP stack stopped");
            }
        }
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public SipService getSipService() {
        return this.sipService;
    }

    public void setSipService(SipService sipService) {
        this.sipService = sipService;
    }

    @Deprecated
    public class CongestionControlTimerTask
    implements Runnable {
        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"CongestionControlTimerTask now running ");
            }
            SipApplicationDispatcherImpl.this.analyzeQueueCongestionState();
            SipApplicationDispatcherImpl.this.analyzeMemory();
            if (SipApplicationDispatcherImpl.this.gatherStatistics) {
                for (SipContext sipContext : SipApplicationDispatcherImpl.this.applicationDeployed.values()) {
                    sipContext.getSipManager().updateStats();
                }
            }
        }
    }
}

