/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.security.MobicentsAuthInfoEntry;
import org.mobicents.servlet.sip.core.security.MobicentsSipSessionSecurity;

public class SipSessionSecurity
implements MobicentsSipSessionSecurity {
    private static final Logger logger = Logger.getLogger(SipSessionSecurity.class);
    private ConcurrentHashMap<String, MobicentsAuthInfoEntry> cachedAuthInfos = new ConcurrentHashMap(2);
    private String nextNonce;

    public void removeCachedAuthInfo(String realm) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing authInfo for realm " + realm));
        }
        ((ConcurrentHashMap)this.getCachedAuthInfos()).remove(realm);
    }

    public void addCachedAuthInfo(String realm, MobicentsAuthInfoEntry authInfoEntry) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Caching authInfo " + authInfoEntry + " for realm " + realm));
        }
        ((ConcurrentHashMap)this.getCachedAuthInfos()).put(realm, authInfoEntry);
    }

    public ConcurrentHashMap<String, MobicentsAuthInfoEntry> getCachedAuthInfos() {
        return this.cachedAuthInfos;
    }

    public void setNextNonce(String nextNonce) {
        this.nextNonce = nextNonce;
    }

    public String getNextNonce() {
        return this.nextNonce;
    }
}

