/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.dns;

import java.text.ParseException;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.sip.SipFactory;
import javax.sip.address.AddressFactory;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import org.apache.log4j.Logger;
import org.mobicents.ext.javax.sip.dns.DNSServerLocator;
import org.mobicents.javax.servlet.sip.dns.DNSResolver;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.URIImpl;

public class MobicentsDNSResolver
implements DNSResolver {
    private static final Logger logger = Logger.getLogger((String)MobicentsDNSResolver.class.getName());
    private DNSServerLocator dnsServerLocator;
    private AddressFactory createAddressFactory;

    public MobicentsDNSResolver(DNSServerLocator dnsServerLocator) {
        this.dnsServerLocator = dnsServerLocator;
        try {
            this.createAddressFactory = SipFactory.getInstance().createAddressFactory();
        }
        catch (Exception e) {
            logger.warn((Object)"Error getting address factory", (Throwable)e);
        }
    }

    public javax.servlet.sip.SipURI getSipURI(javax.servlet.sip.URI uri) {
        SipURI jainSipURI = this.dnsServerLocator.getSipURI(((URIImpl)uri).getURI());
        SipURIImpl sipURI = new SipURIImpl(jainSipURI, AddressImpl.ModifiableRule.NotModifiable);
        return sipURI;
    }

    public void setDnsTimeout(int timeout) {
        this.dnsServerLocator.getDnsLookupPerformer().setDNSTimeout(timeout);
    }

    public int getDnsTimeout() {
        return this.dnsServerLocator.getDnsLookupPerformer().getDNSTimeout();
    }

    public Set<String> resolveHost(String host) {
        CopyOnWriteArraySet<String> ipAddresses = new CopyOnWriteArraySet<String>();
        Queue hops = this.dnsServerLocator.resolveHostByAandAAAALookup(host, -1, null);
        if (hops != null) {
            for (Hop hop : hops) {
                ipAddresses.add(hop.getHost());
            }
        }
        return ipAddresses;
    }

    public List<javax.servlet.sip.SipURI> locateURIs(javax.servlet.sip.SipURI uri) {
        SipURIImpl uriImpl;
        Queue hops;
        CopyOnWriteArrayList<javax.servlet.sip.SipURI> uris = new CopyOnWriteArrayList<javax.servlet.sip.SipURI>();
        if (uri instanceof SipURIImpl && this.createAddressFactory != null && (hops = this.dnsServerLocator.locateHops((URI)(uriImpl = (SipURIImpl)uri).getSipURI())) != null) {
            for (Hop hop : hops) {
                try {
                    SipURI createSipURI = this.createAddressFactory.createSipURI(null, hop.getHost());
                    createSipURI.setPort(hop.getPort());
                    createSipURI.setTransportParam(hop.getTransport());
                    SipURIImpl sipURI = new SipURIImpl(createSipURI, AddressImpl.ModifiableRule.NotModifiable);
                    uris.add(sipURI);
                }
                catch (ParseException ex) {
                    logger.debug((Object)"Error creating SipURI.", (Throwable)ex);
                }
            }
        }
        return uris;
    }
}

