/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.header.HeaderFactoryExt;
import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.header.ims.PathHeader;
import gov.nist.javax.sip.message.MessageExt;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.sip.PeerUnavailableException;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.address.AddressFactory;
import javax.sip.address.TelURL;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.address.GenericURIImpl;
import org.mobicents.servlet.sip.address.SipURIImpl;
import org.mobicents.servlet.sip.address.TelURLImpl;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.MobicentsSipServletMessageFactory;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.OutboundProxy;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.security.AuthInfoImpl;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class SipFactoryImpl
implements MobicentsSipFactory,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)SipFactoryImpl.class.getCanonicalName());
    private static final String TAG_PARAM = "tag";
    private static final String METHOD_PARAM = "method";
    private static final String MADDR_PARAM = "maddr";
    private static final String TTL_PARAM = "ttl";
    private static final String TRANSPORT_PARAM = "transport";
    private static final String LR_PARAM = "lr";
    private boolean useLoadBalancer = false;
    private boolean useLoadBalancerForAllRequests = true;
    private boolean routeOrphanRequests = false;
    private SipLoadBalancer loadBalancerToUse = null;
    private static boolean initialized;
    public static AddressFactory addressFactory;
    public static HeaderFactory headerFactory;
    public static SipFactory sipFactory;
    public static MessageFactory messageFactory;
    private MobicentsSipServletMessageFactory mobicentsSipServletMessageFactory;
    public static final Set<String> FORBIDDEN_PARAMS;
    private transient SipApplicationDispatcher sipApplicationDispatcher = null;

    public void initialize(String pathName, boolean prettyEncoding) {
        if (!initialized) {
            try {
                System.setProperty("gov.nist.core.STRIP_ADDR_SCOPES", "true");
                sipFactory = SipFactory.getInstance();
                sipFactory.setPathName(pathName);
                addressFactory = sipFactory.createAddressFactory();
                headerFactory = sipFactory.createHeaderFactory();
                if (prettyEncoding) {
                    ((HeaderFactoryImpl)headerFactory).setPrettyEncoding(prettyEncoding);
                }
                messageFactory = sipFactory.createMessageFactory();
                initialized = true;
            }
            catch (PeerUnavailableException ex) {
                logger.error((Object)"Could not instantiate factories -- exitting", (Throwable)ex);
                throw new IllegalArgumentException("Cannot instantiate factories ", ex);
            }
        }
    }

    public SipFactoryImpl() {
    }

    public SipFactoryImpl(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
        this.mobicentsSipServletMessageFactory = this.initMobicentsSipServletMessageFactory();
    }

    public Address createAddress(String sipAddress) throws ServletParseException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating Address from [" + sipAddress + "]"));
            }
            AddressImpl retval = new AddressImpl();
            retval.setValue(sipAddress);
            return retval;
        }
        catch (IllegalArgumentException e) {
            throw new ServletParseException((Throwable)e);
        }
    }

    public Address createAddress(URI uri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Address fromm URI[" + uri.toString() + "]"));
        }
        URIImpl uriImpl = (URIImpl)uri;
        return new AddressImpl(addressFactory.createAddress(uriImpl.getURI()), null, AddressImpl.ModifiableRule.Modifiable);
    }

    public Address createAddress(URI uri, String displayName) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating Address from URI[" + uri.toString() + "] with display name[" + displayName + "]"));
            }
            javax.sip.address.Address address = addressFactory.createAddress(((URIImpl)uri).getURI());
            address.setDisplayName(displayName);
            return new AddressImpl(address, null, AddressImpl.ModifiableRule.Modifiable);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SipApplicationSession createApplicationSession() {
        throw new UnsupportedOperationException("use createApplicationSession(SipContext sipContext) instead !");
    }

    public MobicentsSipApplicationSession createApplicationSession(SipContext sipContext) {
        String jvmRoute;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new application session for sip context " + sipContext.getApplicationName()));
        }
        SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(sipContext.getApplicationName(), null, null);
        MobicentsSipApplicationSession sipApplicationSession = sipContext.getSipManager().getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, true);
        if (StaticServiceHolder.sipStandardService.isHttpFollowsSip() && (jvmRoute = StaticServiceHolder.sipStandardService.getJvmRoute()) != null) {
            sipApplicationSession.setJvmRoute(jvmRoute);
        }
        return sipApplicationSession.getFacade();
    }

    public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, Address from, Address to, String handler, String originalCallId, String fromTagToUse) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new SipServletRequest for SipApplicationSession[" + sipAppSession + "] METHOD[" + method + "] FROM_A[" + from + "] TO_A[" + to + "]"));
        }
        SipFactoryImpl.validateCreation(method, sipAppSession);
        try {
            return this.createSipServletRequest(sipAppSession, method, (Address)from.clone(), (Address)to.clone(), handler, originalCallId, fromTagToUse);
        }
        catch (ServletParseException e) {
            logger.error((Object)"Error creating sipServletRequest", (Throwable)e);
            return null;
        }
    }

    public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, URI from, URI to, String handler) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new SipServletRequest for SipApplicationSession[" + sipAppSession + "] METHOD[" + method + "] FROM_URI[" + from + "] TO_URI[" + to + "]"));
        }
        SipFactoryImpl.validateCreation(method, sipAppSession);
        Address toA = this.createAddress(to.clone());
        Address fromA = this.createAddress(from.clone());
        try {
            return this.createSipServletRequest(sipAppSession, method, fromA, toA, handler, null, null);
        }
        catch (ServletParseException e) {
            logger.error((Object)"Error creating sipServletRequest", (Throwable)e);
            return null;
        }
    }

    public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, String from, String to, String handler) throws ServletParseException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new SipServletRequest for SipApplicationSession[" + sipAppSession + "] METHOD[" + method + "] FROM[" + from + "] TO[" + to + "]"));
        }
        SipFactoryImpl.validateCreation(method, sipAppSession);
        Address toA = this.createAddress(to);
        Address fromA = this.createAddress(from);
        return this.createSipServletRequest(sipAppSession, method, fromA, toA, handler, null, null);
    }

    public SipServletRequest createRequest(SipServletRequest origRequest, boolean sameCallId) {
        SipServletRequestImpl origRequestImpl;
        MobicentsSipApplicationSession originalAppSession;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating SipServletRequest from original request[" + origRequest + "] with same call id[" + sameCallId + "]"));
        }
        if ((originalAppSession = (origRequestImpl = (SipServletRequestImpl)origRequest).getSipApplicationSession(false)) == null) {
            throw new IllegalStateException("original request's app session does not exists");
        }
        MobicentsSipSession originalSession = origRequestImpl.getSipSession();
        Request newRequest = (Request)origRequestImpl.message.clone();
        ((MessageExt)newRequest).setApplicationData(null);
        newRequest.removeHeader("Via");
        SipApplicationDispatcher sipApplicationDispatcher = this.getSipApplicationDispatcher();
        String branch = JainSipUtils.createBranch(originalAppSession.getKey().getId(), sipApplicationDispatcher.getHashFromApplicationName(originalAppSession.getKey().getApplicationName()));
        ViaHeader viaHeader = JainSipUtils.createViaHeader(this.getSipNetworkInterfaceManager(), newRequest, branch, null);
        newRequest.addHeader((Header)viaHeader);
        FromHeader newFromHeader = (FromHeader)newRequest.getHeader("From");
        newFromHeader.removeParameter(TAG_PARAM);
        ((ToHeader)newRequest.getHeader("To")).removeParameter(TAG_PARAM);
        newRequest.removeHeader("Record-Route");
        if (!"REGISTER".equalsIgnoreCase(newRequest.getMethod())) {
            try {
                if (!"REGISTER".equalsIgnoreCase(newRequest.getMethod())) {
                    if (JainSipUtils.CONTACT_HEADER_METHODS.contains(newRequest.getMethod())) {
                        String fromName = null;
                        String displayName = ((MessageExt)newRequest).getFromHeader().getAddress().getDisplayName();
                        if (newRequest.getHeader("Contact") != null && ((ContactHeader)newRequest.getHeader("Contact")).getAddress().getURI() instanceof javax.sip.address.SipURI) {
                            fromName = ((javax.sip.address.SipURI)((MessageExt)newRequest).getFromHeader().getAddress().getURI()).getUser();
                        }
                        ContactHeader contactHeader = null;
                        if (fromName != null) {
                            if (this.useLoadBalancer) {
                                javax.sip.address.SipURI sipURI = addressFactory.createSipURI(fromName, this.loadBalancerToUse.getAddress().getHostAddress());
                                sipURI.setHost(this.loadBalancerToUse.getAddress().getHostAddress());
                                sipURI.setPort(this.loadBalancerToUse.getSipPort());
                                sipURI.setTransportParam(JainSipUtils.findTransport((Message)newRequest));
                                javax.sip.address.Address contactAddress = addressFactory.createAddress((javax.sip.address.URI)sipURI);
                                if (displayName != null && displayName.length() > 0) {
                                    contactAddress.setDisplayName(displayName);
                                }
                                contactHeader = headerFactory.createContactHeader(contactAddress);
                            } else {
                                contactHeader = JainSipUtils.createContactHeader(this.getSipNetworkInterfaceManager(), newRequest, displayName, fromName, null);
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Unable to create Contact Header. It will be added later on send.");
                        }
                        newRequest.removeHeader("Contact");
                        if (contactHeader != null) {
                            newRequest.addHeader((Header)contactHeader);
                        }
                    } else {
                        newRequest.removeHeader("Contact");
                    }
                }
            }
            catch (Exception ex) {
                logger.warn((Object)"Unable to create Contact Header. It will be added later on send.", (Throwable)ex);
            }
        }
        try {
            if (!sameCallId) {
                Iterator listeningPointsIterator = this.getSipNetworkInterfaceManager().getExtendedListeningPoints();
                if (!listeningPointsIterator.hasNext()) {
                    throw new IllegalStateException("There is no SIP connectors available to create the request");
                }
                MobicentsExtendedListeningPoint extendedListeningPoint = (MobicentsExtendedListeningPoint)listeningPointsIterator.next();
                CallIdHeader callIdHeader = sipApplicationDispatcher.getCallId(extendedListeningPoint, null);
                newRequest.setHeader((Header)callIdHeader);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("not reusing same call id, new call id is " + callIdHeader));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("reusing same call id = " + ((MessageExt)newRequest).getCallIdHeader().getCallId()));
            }
            newFromHeader.setTag(ApplicationRoutingHeaderComposer.getHash(this.getSipApplicationDispatcher(), originalAppSession.getKey().getApplicationName(), originalAppSession.getKey().getId()));
            SipSessionKey key = SessionManagerUtil.getSipSessionKey(originalAppSession.getKey().getId(), originalAppSession.getKey().getApplicationName(), (Message)newRequest, false);
            MobicentsSipSession session = originalAppSession.getSipContext().getSipManager().getSipSession((MobicentsSipSessionKey)key, true, (MobicentsSipFactory)this, originalAppSession);
            if (originalSession != null) {
                session.setHandler(originalSession.getHandler());
            } else if (originalAppSession.getCurrentRequestHandler() != null) {
                session.setHandler(originalAppSession.getCurrentRequestHandler());
            }
            SipServletRequestImpl newSipServletRequest = (SipServletRequestImpl)this.mobicentsSipServletMessageFactory.createSipServletRequest(newRequest, session, null, null, JainSipUtils.DIALOG_CREATING_METHODS.contains(newRequest.getMethod()));
            newSipServletRequest.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, origRequest);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("newSipServletRequest = " + newSipServletRequest));
            }
            return newSipServletRequest;
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception ", (Throwable)ex);
            throw new IllegalArgumentException("Illegal arg ecnountered while creatigng b2bua", ex);
        }
    }

    public SipURI createSipURI(String user, String host) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating SipURI from USER[" + user + "] HOST[" + host + "]"));
        }
        if (user != null && user.trim().isEmpty()) {
            user = null;
        }
        try {
            return new SipURIImpl(addressFactory.createSipURI(user, host), AddressImpl.ModifiableRule.Modifiable);
        }
        catch (ParseException e) {
            logger.error((Object)("couldn't parse the SipURI from USER[" + user + "] HOST[" + host + "]"), (Throwable)e);
            throw new IllegalArgumentException("Could not create SIP URI user = " + user + " host = " + host);
        }
    }

    public URI createURI(String uri) throws ServletParseException {
        try {
            javax.sip.address.URI jainUri = addressFactory.createURI(uri);
            if (jainUri instanceof javax.sip.address.SipURI) {
                return new SipURIImpl((javax.sip.address.SipURI)jainUri, AddressImpl.ModifiableRule.Modifiable);
            }
            if (jainUri instanceof TelURL) {
                return new TelURLImpl((TelURL)jainUri);
            }
            return new GenericURIImpl(jainUri);
        }
        catch (ParseException ex) {
            throw new ServletParseException("Bad param " + uri, (Throwable)ex);
        }
    }

    private static void validateCreation(String method, SipApplicationSession app) {
        if (method.equals("ACK")) {
            throw new IllegalArgumentException("Wrong method to create request with[ACK]!");
        }
        if (method.equals("PRACK")) {
            throw new IllegalArgumentException("Wrong method to create request with[PRACK]!");
        }
        if (method.equals("CANCEL")) {
            throw new IllegalArgumentException("Wrong method to create request with[CANCEL]!");
        }
        if (!((MobicentsSipApplicationSession)app).isValidInternal()) {
            throw new IllegalArgumentException("Cant associate request with invalidaded sip session application!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SipServletRequest createSipServletRequest(SipApplicationSession sipAppSession, String method, Address from, Address to, String handler, String originalCallId, String fromTagToUse) throws ServletParseException {
        MobicentsSipApplicationSession mobicentsSipApplicationSession = (MobicentsSipApplicationSession)sipAppSession;
        Request requestToWrap = null;
        ContactHeader contactHeader = null;
        ToHeader toHeader = null;
        FromHeader fromHeader = null;
        CSeqHeader cseqHeader = null;
        CallIdHeader callIdHeader = null;
        MaxForwardsHeader maxForwardsHeader = null;
        String transport = "UDP";
        javax.sip.address.Address fromAddress = null;
        try {
            for (String param : FORBIDDEN_PARAMS) {
                from.getURI().removeParameter(param);
            }
            from.removeParameter(TAG_PARAM);
            fromAddress = addressFactory.createAddress(((URIImpl)from.getURI()).getURI());
            fromAddress.setDisplayName(from.getDisplayName());
            fromHeader = headerFactory.createFromHeader(fromAddress, null);
        }
        catch (Exception pe) {
            throw new ServletParseException("Impossoible to parse the given From " + from.toString(), (Throwable)pe);
        }
        javax.sip.address.Address toAddress = null;
        try {
            for (String param : FORBIDDEN_PARAMS) {
                to.getURI().removeParameter(param);
            }
            to.removeParameter(TAG_PARAM);
            toAddress = addressFactory.createAddress(((URIImpl)to.getURI()).getURI());
            toAddress.setDisplayName(to.getDisplayName());
            toHeader = headerFactory.createToHeader(toAddress, null);
        }
        catch (Exception pe) {
            throw new ServletParseException("Impossoible to parse the given To " + to.toString(), (Throwable)pe);
        }
        try {
            cseqHeader = headerFactory.createCSeqHeader(1L, method);
            MobicentsSipApplicationSessionKey sipApplicationSessionKey = mobicentsSipApplicationSession.getKey();
            if (originalCallId == null) {
                Iterator listeningPointsIterator = this.getSipNetworkInterfaceManager().getExtendedListeningPoints();
                if (!listeningPointsIterator.hasNext()) throw new IllegalStateException("There is no SIP connectors available to create the request");
                callIdHeader = this.getSipApplicationDispatcher().getCallId((MobicentsExtendedListeningPoint)listeningPointsIterator.next(), null);
            } else {
                callIdHeader = this.getSipApplicationDispatcher().getCallId(null, originalCallId);
            }
            maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
            URIImpl requestURI = (URIImpl)to.getURI().clone();
            ArrayList viaHeaders = new ArrayList();
            requestToWrap = messageFactory.createRequest(requestURI.getURI(), method, callIdHeader, cseqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
            if (JainSipUtils.CONTACT_HEADER_METHODS.contains(method)) {
                String fromName = null;
                String displayName = fromHeader.getAddress().getDisplayName();
                if (fromHeader.getAddress().getURI() instanceof javax.sip.address.SipURI) {
                    fromName = ((javax.sip.address.SipURI)fromHeader.getAddress().getURI()).getUser();
                }
                contactHeader = null;
                if (this.useLoadBalancer) {
                    javax.sip.address.SipURI sipURI = addressFactory.createSipURI(fromName, this.loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setHost(this.loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setPort(this.loadBalancerToUse.getSipPort());
                    sipURI.setTransportParam(transport);
                    javax.sip.address.Address contactAddress = addressFactory.createAddress((javax.sip.address.URI)sipURI);
                    if (displayName != null && displayName.length() > 0) {
                        contactAddress.setDisplayName(displayName);
                    }
                    contactHeader = headerFactory.createContactHeader(contactAddress);
                } else {
                    contactHeader = JainSipUtils.createContactHeader(this.getSipNetworkInterfaceManager(), requestToWrap, displayName, fromName, null);
                }
            }
            if (contactHeader != null) {
                requestToWrap.addHeader(contactHeader);
            }
            if (fromTagToUse == null) {
                fromHeader.setTag(ApplicationRoutingHeaderComposer.getHash(this.sipApplicationDispatcher, sipAppSession.getApplicationName(), sipApplicationSessionKey.getId()));
            } else {
                fromHeader.setTag(fromTagToUse);
            }
            SipSessionKey key = SessionManagerUtil.getSipSessionKey(mobicentsSipApplicationSession.getKey().getId(), mobicentsSipApplicationSession.getKey().getApplicationName(), (Message)requestToWrap, false);
            MobicentsSipSession session = mobicentsSipApplicationSession.getSipContext().getSipManager().getSipSession((MobicentsSipSessionKey)key, true, (MobicentsSipFactory)this, mobicentsSipApplicationSession);
            session.setHandler(handler);
            session.setLocalParty((Address)new AddressImpl(fromAddress, null, AddressImpl.ModifiableRule.NotModifiable));
            session.setRemoteParty((Address)new AddressImpl(toAddress, null, AddressImpl.ModifiableRule.NotModifiable));
            SipApplicationDispatcher sipApplicationDispatcher = this.getSipApplicationDispatcher();
            String branch = JainSipUtils.createBranch(sipApplicationSessionKey.getId(), sipApplicationDispatcher.getHashFromApplicationName(sipApplicationSessionKey.getApplicationName()));
            ViaHeader viaHeader = JainSipUtils.createViaHeader(this.getSipNetworkInterfaceManager(), requestToWrap, branch, session.getOutboundInterface());
            requestToWrap.addHeader((Header)viaHeader);
            return (SipServletRequestImpl)this.mobicentsSipServletMessageFactory.createSipServletRequest(requestToWrap, session, null, null, JainSipUtils.DIALOG_CREATING_METHODS.contains(method));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating sipServletRequest", e);
        }
    }

    public Parameterable createParameterable(String value) throws ServletParseException {
        try {
            Header header = headerFactory.createHeader("Contact", value);
            return SipServletMessageImpl.createParameterable(header, SipServletMessageImpl.getFullHeaderName(header.getName()), true);
        }
        catch (ParseException e) {
            try {
                Header header = headerFactory.createHeader("Content-Type", value);
                return SipServletMessageImpl.createParameterable(header, SipServletMessageImpl.getFullHeaderName(header.getName()), true);
            }
            catch (ParseException pe) {
                try {
                    Header header = headerFactory.createHeader("Content-Disposition", value);
                    return SipServletMessageImpl.createParameterable(header, SipServletMessageImpl.getFullHeaderName(header.getName()), true);
                }
                catch (ParseException pe2) {
                    throw new ServletParseException("Impossible to parse the following parameterable " + value, (Throwable)pe2);
                }
            }
        }
    }

    public SipApplicationRouterInfo getNextInterestedApplication(SipServletRequestImpl sipServletRequestImpl) {
        return this.sipApplicationDispatcher.getNextInterestedApplication((MobicentsSipServletRequest)sipServletRequestImpl);
    }

    public SipApplicationSession createApplicationSessionByAppName(String sipAppName, boolean isContainerManaged) {
        SipContext sipContext;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new application session for application name " + sipAppName));
        }
        if ((sipContext = this.sipApplicationDispatcher.findSipApplication(sipAppName)) == null) {
            throw new IllegalArgumentException("The specified application " + sipAppName + " is not currently deployed");
        }
        MobicentsSipApplicationSession sipApplicationSession = this.createApplicationSession(sipContext);
        sipContext.enterSipApp(sipApplicationSession, null, true, isContainerManaged);
        return sipApplicationSession;
    }

    public SipApplicationSession createApplicationSessionByKey(String sipApplicationKey) {
        return null;
    }

    public AuthInfo createAuthInfo() {
        return new AuthInfoImpl();
    }

    public SipApplicationDispatcher getSipApplicationDispatcher() {
        if (this.sipApplicationDispatcher == null) {
            this.sipApplicationDispatcher = StaticServiceHolder.sipStandardService.getSipApplicationDispatcher();
        }
        return this.sipApplicationDispatcher;
    }

    public void setSipApplicationDispatcher(SipApplicationDispatcher sipApplicationDispatcher) {
        this.sipApplicationDispatcher = sipApplicationDispatcher;
    }

    public SipNetworkInterfaceManager getSipNetworkInterfaceManager() {
        return this.sipApplicationDispatcher.getSipNetworkInterfaceManager();
    }

    public SipLoadBalancer getLoadBalancerToUse() {
        return this.loadBalancerToUse;
    }

    public void setLoadBalancerToUse(SipLoadBalancer loadBalancerToUse) {
        this.useLoadBalancer = loadBalancerToUse != null;
        this.loadBalancerToUse = loadBalancerToUse;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Load Balancer to Use " + loadBalancerToUse));
        }
    }

    public boolean isUseLoadBalancer() {
        return this.useLoadBalancer;
    }

    public void addLoadBalancerRouteHeader(Request request, MobicentsExtendedListeningPoint mobicentsExtendedListeningPoint) {
        try {
            String transport = JainSipUtils.findTransport((Message)request);
            String host = null;
            int port = -1;
            OutboundProxy proxy = StaticServiceHolder.sipStandardService.getOutboundProxy();
            if (proxy == null) {
                if (mobicentsExtendedListeningPoint.getLoadBalancer() == null) {
                    host = this.loadBalancerToUse.getAddress().getHostAddress();
                    port = this.loadBalancerToUse.getSipPort();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using global load balancer " + host + ":" + port));
                    }
                } else {
                    host = mobicentsExtendedListeningPoint.getLoadBalancer().getAddress().getHostAddress();
                    port = mobicentsExtendedListeningPoint.getLoadBalancer().getSipPort();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using specifc load balancer " + host + ":" + port + " from listening Point " + mobicentsExtendedListeningPoint));
                    }
                }
            } else {
                host = proxy.getHost();
                port = proxy.getPort();
            }
            javax.sip.address.SipURI sipUri = addressFactory.createSipURI(null, host);
            sipUri.setPort(port);
            sipUri.setLrParam();
            sipUri.setTransportParam(transport);
            MobicentsExtendedListeningPoint listeningPoint = mobicentsExtendedListeningPoint;
            if (mobicentsExtendedListeningPoint == null) {
                listeningPoint = this.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("mobicentsExtendedListeningPoint was null, found a listening point to use " + listeningPoint));
                }
            }
            boolean usePublicAddress = JainSipUtils.findUsePublicAddress(this.getSipNetworkInterfaceManager(), (Message)request, listeningPoint);
            String nodeHost = listeningPoint.getHost(usePublicAddress);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("usePublicAddress" + usePublicAddress + ", nodeHost=" + nodeHost + " nodePort" + listeningPoint.getPort()));
            }
            sipUri.setParameter("node_host", nodeHost);
            sipUri.setParameter("node_port", "" + listeningPoint.getPort());
            javax.sip.address.Address routeAddress = addressFactory.createAddress((javax.sip.address.URI)sipUri);
            RouteHeader routeHeader = headerFactory.createRouteHeader(routeAddress);
            request.addFirst((Header)routeHeader);
            if ("REGISTER".equalsIgnoreCase(request.getMethod())) {
                PathHeader pathHeader = ((HeaderFactoryExt)headerFactory).createPathHeader(routeAddress);
                request.addFirst((Header)pathHeader);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
        catch (SipException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
    }

    public void addIpLoadBalancerRouteHeader(Request request, String lbhost, int lbport) {
        try {
            String host = null;
            int port = -1;
            OutboundProxy proxy = StaticServiceHolder.sipStandardService.getOutboundProxy();
            if (proxy == null) {
                host = lbhost;
                port = lbport;
            } else {
                host = proxy.getHost();
                port = proxy.getPort();
            }
            javax.sip.address.SipURI sipUri = addressFactory.createSipURI(null, host);
            sipUri.setPort(port);
            sipUri.setLrParam();
            String transport = JainSipUtils.findTransport((Message)request);
            sipUri.setTransportParam(transport);
            MobicentsExtendedListeningPoint listeningPoint = this.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false);
            sipUri.setParameter("node_host", listeningPoint.getHost(JainSipUtils.findUsePublicAddress(this.getSipNetworkInterfaceManager(), (Message)request, listeningPoint)));
            sipUri.setParameter("node_port", "" + listeningPoint.getPort());
            javax.sip.address.Address routeAddress = addressFactory.createAddress((javax.sip.address.URI)sipUri);
            RouteHeader routeHeader = headerFactory.createRouteHeader(routeAddress);
            request.addFirst((Header)routeHeader);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
        catch (SipException e) {
            throw new IllegalArgumentException("Impossible to set the Load Balancer Route Header !", e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.useLoadBalancer = in.readBoolean();
        if (this.useLoadBalancer) {
            this.loadBalancerToUse = (SipLoadBalancer)in.readObject();
        }
        if (this.mobicentsSipServletMessageFactory == null) {
            this.mobicentsSipServletMessageFactory = this.initMobicentsSipServletMessageFactory();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.useLoadBalancer);
        if (this.useLoadBalancer) {
            out.writeObject(this.loadBalancerToUse);
        }
    }

    public boolean isRouteOrphanRequests() {
        return this.routeOrphanRequests;
    }

    public void setRouteOrphanRequests(boolean routeOrphanRequets) {
        this.routeOrphanRequests = routeOrphanRequets;
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, Address from, Address to) {
        throw new UnsupportedOperationException("Use the one createRequest(SipApplicationSession appSession, String method, Address from, Address to, String handler) method instead");
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, String from, String to) throws ServletParseException {
        throw new UnsupportedOperationException("Use the one createRequest(SipApplicationSession appSession, String method, String from, String to, String handler) method instead");
    }

    public SipServletRequest createRequest(SipApplicationSession appSession, String method, URI from, URI to) {
        throw new UnsupportedOperationException("Use the one createRequest(SipApplicationSession appSession, String method, URI from, URI to, String handler) method instead");
    }

    public AddressFactory getAddressFactory() {
        return addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return headerFactory;
    }

    public MessageFactory getMessageFactory() {
        return messageFactory;
    }

    public SipFactory getJainSipFactory() {
        return sipFactory;
    }

    public MobicentsSipServletMessageFactory getMobicentsSipServletMessageFactory() {
        return this.mobicentsSipServletMessageFactory;
    }

    protected MobicentsSipServletMessageFactory initMobicentsSipServletMessageFactory() {
        MobicentsSipServletMessageFactory factory = null;
        try {
            factory = (MobicentsSipServletMessageFactory)Class.forName(StaticServiceHolder.sipStandardService.getMobicentsSipServletMessageFactoryClassName()).newInstance();
            factory.setMobicentsSipFactory((MobicentsSipFactory)this);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Impossible to load the MobicentsSipServletMessageFactory ", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Impossible to load the MobicentsSipServletMessageFactory ", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Impossible to load the MobicentsSipServletMessageFactory ", e);
        }
        return factory;
    }

    public SipApplicationSession createApplicationSession(boolean managed) {
        throw new UnsupportedOperationException("use createApplicationSession(SipContext sipContext) instead !");
    }

    public SipApplicationSession createApplicationSessionByKey(String sipApplicationKey, boolean managed) {
        throw new UnsupportedOperationException("use createApplicationSession(SipContext sipContext) instead !");
    }

    static {
        FORBIDDEN_PARAMS = new HashSet<String>();
        FORBIDDEN_PARAMS.add(TAG_PARAM);
        FORBIDDEN_PARAMS.add(METHOD_PARAM);
        FORBIDDEN_PARAMS.add(MADDR_PARAM);
        FORBIDDEN_PARAMS.add(TTL_PARAM);
        FORBIDDEN_PARAMS.add(TRANSPORT_PARAM);
        FORBIDDEN_PARAMS.add(LR_PARAM);
    }

    public static class NamesComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

