/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import java.io.Serializable;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.GenericUtils;
import org.mobicents.servlet.sip.core.SipApplicationDispatcherImpl;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;

public final class SipApplicationSessionKey
implements Serializable,
MobicentsSipApplicationSessionKey {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)SipApplicationSessionKey.class.getCanonicalName());
    private final String uuid;
    private final String appGeneratedKey;
    private final String applicationName;
    private String toString;

    public SipApplicationSessionKey(String id, String applicationName, String appGeneratedKey) {
        this.appGeneratedKey = appGeneratedKey;
        this.applicationName = applicationName;
        if (appGeneratedKey != null) {
            this.uuid = GenericUtils.hashString(appGeneratedKey, SipApplicationDispatcherImpl.APP_ID_HASHING_MAX_LENGTH);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("uuid for appGeneratedKey " + appGeneratedKey + " set to " + this.uuid));
            }
            this.toString = appGeneratedKey + ";" + this.uuid + ";" + applicationName;
        } else {
            if (id == null) {
                String tempUuid = "" + UUID.randomUUID();
                this.uuid = SipApplicationDispatcherImpl.APP_ID_HASHING_MAX_LENGTH > 0 ? tempUuid.substring(0, SipApplicationDispatcherImpl.APP_ID_HASHING_MAX_LENGTH) : tempUuid;
            } else {
                this.uuid = id;
            }
            this.toString = this.uuid + ";" + applicationName;
        }
    }

    public String getId() {
        return this.uuid;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getAppGeneratedKey() {
        return this.appGeneratedKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicationName == null ? 0 : this.applicationName.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipApplicationSessionKey other = (SipApplicationSessionKey)obj;
        if (this.applicationName == null ? other.applicationName != null : !this.applicationName.equals(other.applicationName)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return this.toString;
    }
}

