/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.header.HeaderExt;
import gov.nist.javax.sip.message.MessageExt;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.b2bua.MobicentsB2BUAHelper;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;

public class B2buaHelperImpl
implements MobicentsB2BUAHelper,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(B2buaHelperImpl.class);
    protected static final Set<String> B2BUA_SYSTEM_HEADERS = new HashSet<String>();
    protected static final Set<String> CONTACT_FORBIDDEN_PARAMETER;
    private Map<MobicentsSipSessionKey, MobicentsSipSessionKey> sessionMap = new ConcurrentHashMap<MobicentsSipSessionKey, MobicentsSipSessionKey>();
    private Map<String, String> derivedSessionMap = new ConcurrentHashMap<String, String>();
    private transient Map<SipServletRequestImpl, SipServletRequestImpl> originalRequestMap = new ConcurrentHashMap<SipServletRequestImpl, SipServletRequestImpl>();
    private transient SipFactoryImpl sipFactoryImpl;
    private transient SipManager sipManager;

    public SipServletRequest createRequest(SipServletRequest origRequest, boolean linked, Map<String, List<String>> headerMap) throws TooManyHopsException {
        if (origRequest == null) {
            throw new NullPointerException("original request cannot be null");
        }
        if (origRequest.getMaxForwards() == 0) {
            throw new TooManyHopsException();
        }
        try {
            SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
            Request newRequest = (Request)origRequestImpl.message.clone();
            ((MessageExt)newRequest).setApplicationData(null);
            newRequest.removeHeader("Via");
            newRequest.removeHeader("Record-Route");
            MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)newRequest.getHeader("Max-Forwards");
            try {
                maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalArgumentException(e);
            }
            Iterator listeningPointsIterator = this.sipFactoryImpl.getSipNetworkInterfaceManager().getExtendedListeningPoints();
            if (!listeningPointsIterator.hasNext()) {
                throw new IllegalStateException("There is no SIP connectors available to create the request");
            }
            MobicentsExtendedListeningPoint extendedListeningPoint = (MobicentsExtendedListeningPoint)listeningPointsIterator.next();
            CallIdHeader callIdHeader = this.sipFactoryImpl.getSipApplicationDispatcher().getCallId(extendedListeningPoint, null);
            newRequest.setHeader((Header)callIdHeader);
            List<String> contactHeaderSet = this.retrieveContactHeaders(headerMap, newRequest);
            FromHeader newFromHeader = (FromHeader)newRequest.getHeader("From");
            newFromHeader.removeParameter("tag");
            ((ToHeader)newRequest.getHeader("To")).removeParameter("tag");
            MobicentsSipSession originalSession = origRequestImpl.getSipSession();
            MobicentsSipApplicationSession appSession = originalSession.getSipApplicationSession();
            newFromHeader.setTag(ApplicationRoutingHeaderComposer.getHash(this.sipFactoryImpl.getSipApplicationDispatcher(), originalSession.getKey().getApplicationName(), appSession.getKey().getId()));
            SipSessionKey key = SessionManagerUtil.getSipSessionKey(appSession.getKey().getId(), originalSession.getKey().getApplicationName(), (Message)newRequest, false);
            MobicentsSipSession session = appSession.getSipContext().getSipManager().getSipSession((MobicentsSipSessionKey)key, true, (MobicentsSipFactory)this.sipFactoryImpl, appSession);
            session.setHandler(originalSession.getHandler());
            SipApplicationDispatcher sipApplicationDispatcher = this.sipFactoryImpl.getSipApplicationDispatcher();
            String branch = JainSipUtils.createBranch(appSession.getKey().getId(), sipApplicationDispatcher.getHashFromApplicationName(appSession.getKey().getApplicationName()));
            ViaHeader viaHeader = JainSipUtils.createViaHeader(this.sipFactoryImpl.getSipNetworkInterfaceManager(), newRequest, branch, session.getOutboundInterface());
            newRequest.addHeader((Header)viaHeader);
            SipServletRequestImpl newSipServletRequest = (SipServletRequestImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(newRequest, session, null, null, JainSipUtils.DIALOG_CREATING_METHODS.contains(newRequest.getMethod()));
            newSipServletRequest.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, origRequest);
            String method = origRequest.getMethod();
            if ("REGISTER".equalsIgnoreCase(method)) {
                if (contactHeaderSet.size() > 0) {
                    for (String contactHeaderValue : contactHeaderSet) {
                        newSipServletRequest.addHeaderInternal("Contact", contactHeaderValue, true);
                    }
                    ListIterator contactHeaders = newSipServletRequest.getMessage().getHeaders("Contact");
                    while (contactHeaders.hasNext()) {
                        URI contactURI = ((ContactHeader)contactHeaders.next()).getAddress().getURI();
                        if (!(contactURI instanceof SipURI)) continue;
                        this.stripForbiddenContactURIParams((SipURI)contactURI);
                    }
                }
            } else {
                newRequest.removeHeader("Contact");
                ContactHeader contactHeader = null;
                String fromName = null;
                String diaplayName = newFromHeader.getAddress().getDisplayName();
                if (newFromHeader.getAddress().getURI() instanceof SipURI) {
                    fromName = ((SipURI)newFromHeader.getAddress().getURI()).getUser();
                }
                if (this.sipFactoryImpl.isUseLoadBalancer()) {
                    SipLoadBalancer loadBalancerToUse = this.sipFactoryImpl.getLoadBalancerToUse();
                    SipURI sipURI = this.sipFactoryImpl.getAddressFactory().createSipURI(fromName, loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setHost(loadBalancerToUse.getAddress().getHostAddress());
                    sipURI.setPort(loadBalancerToUse.getSipPort());
                    sipURI.setTransportParam("UDP");
                    Address contactAddress = this.sipFactoryImpl.getAddressFactory().createAddress((URI)sipURI);
                    if (diaplayName != null && diaplayName.length() > 0) {
                        contactAddress.setDisplayName(diaplayName);
                    }
                    contactHeader = this.sipFactoryImpl.getHeaderFactory().createContactHeader(contactAddress);
                } else {
                    contactHeader = JainSipUtils.createContactHeader(this.sipFactoryImpl.getSipNetworkInterfaceManager(), newRequest, diaplayName, fromName, session.getOutboundInterface());
                }
                if (contactHeaderSet.size() > 0) {
                    this.setContactHeaders(contactHeaderSet, newSipServletRequest, contactHeader);
                } else if (JainSipUtils.CONTACT_HEADER_METHODS.contains(method)) {
                    newRequest.setHeader((Header)contactHeader);
                }
            }
            this.originalRequestMap.put(newSipServletRequest, origRequestImpl);
            this.originalRequestMap.put(origRequestImpl, newSipServletRequest);
            if (linked) {
                this.sessionMap.put(originalSession.getKey(), session.getKey());
                this.sessionMap.put(session.getKey(), originalSession.getKey());
                this.dumpLinkedSessions();
            }
            session.setB2buaHelper((MobicentsB2BUAHelper)this);
            originalSession.setB2buaHelper((MobicentsB2BUAHelper)this);
            session.setSessionCreatingTransactionRequest((MobicentsSipServletMessage)newSipServletRequest);
            return newSipServletRequest;
        }
        catch (ParseException ex) {
            logger.error((Object)"Unexpected parse exception ", (Throwable)ex);
            throw new IllegalArgumentException("Illegal arg encountered while creating b2bua", ex);
        }
        catch (ServletException ex) {
            logger.error((Object)"Unexpected exception ", (Throwable)ex);
            throw new IllegalArgumentException("Unexpected problem while creating b2bua", ex);
        }
    }

    public SipServletRequest createRequest(SipSession session, SipServletRequest origRequest, Map<String, List<String>> headerMap) {
        if (origRequest == null) {
            throw new NullPointerException("original request cannot be null");
        }
        try {
            SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
            MobicentsSipSession originalSession = origRequestImpl.getSipSession();
            MobicentsSipSession sessionImpl = (MobicentsSipSession)session;
            SipServletRequestImpl newSubsequentServletRequest = (SipServletRequestImpl)session.createRequest(origRequest.getMethod());
            List<String> contactHeaderSet = this.retrieveContactHeaders(headerMap, (Request)newSubsequentServletRequest.getMessage());
            Request subsequentRequest = (Request)newSubsequentServletRequest.getMessage();
            MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)subsequentRequest.getHeader("Max-Forwards");
            try {
                maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalArgumentException(e);
            }
            ContactHeader contactHeader = (ContactHeader)subsequentRequest.getHeader("Contact");
            if (contactHeader != null && contactHeaderSet.size() > 0) {
                subsequentRequest.removeHeader("Contact");
                this.setContactHeaders(contactHeaderSet, newSubsequentServletRequest, contactHeader);
            }
            if (origRequest.getContent() != null && origRequest.getContentType() != null) {
                newSubsequentServletRequest.setContentLength(origRequest.getContentLength());
                newSubsequentServletRequest.setContent(origRequest.getContent(), origRequest.getContentType());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("newSubsequentServletRequest = " + newSubsequentServletRequest));
            }
            this.copyNonSystemHeaders(origRequestImpl, newSubsequentServletRequest);
            this.originalRequestMap.put(newSubsequentServletRequest, origRequestImpl);
            this.originalRequestMap.put(origRequestImpl, newSubsequentServletRequest);
            this.sessionMap.put(originalSession.getKey(), sessionImpl.getKey());
            this.sessionMap.put(sessionImpl.getKey(), originalSession.getKey());
            this.dumpLinkedSessions();
            sessionImpl.setB2buaHelper((MobicentsB2BUAHelper)this);
            originalSession.setB2buaHelper((MobicentsB2BUAHelper)this);
            return newSubsequentServletRequest;
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception ", (Throwable)ex);
            throw new IllegalArgumentException("Illegal arg encountered while creating b2bua", ex);
        }
    }

    private void copyNonSystemHeaders(SipServletRequestImpl origRequestImpl, SipServletRequestImpl newSubsequentServletRequest) {
        Message origMessage = origRequestImpl.getMessage();
        Message subsequentMessage = newSubsequentServletRequest.getMessage();
        ListIterator headerNames = origMessage.getHeaderNames();
        while (headerNames.hasNext()) {
            String headerName = (String)headerNames.next();
            if (JainSipUtils.SYSTEM_HEADERS.contains(headerName) || headerName.equalsIgnoreCase("Contact") || headerName.equalsIgnoreCase("From") || headerName.equalsIgnoreCase("To")) continue;
            ListIterator origHeaderIt = origMessage.getHeaders(headerName);
            ListIterator subsHeaderIt = subsequentMessage.getHeaders(headerName);
            while (origHeaderIt.hasNext()) {
                HeaderExt origHeader = (HeaderExt)origHeaderIt.next();
                boolean headerNameValueAlreadyPresent = false;
                while (subsHeaderIt.hasNext() && !headerNameValueAlreadyPresent) {
                    HeaderExt subsHeader = (HeaderExt)subsHeaderIt.next();
                    if (!origHeader.getValue().equals(subsHeader.getValue())) continue;
                    headerNameValueAlreadyPresent = true;
                }
                if (headerNameValueAlreadyPresent) continue;
                if (origHeader != null) {
                    subsequentMessage.addHeader((Header)origHeader.clone());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("original header " + origHeader + " copied in the new subsequent request"));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("trying to copy original header name " + headerName + " into the new subsequent request with an empty value"));
                }
                try {
                    subsequentMessage.addHeader(this.sipFactoryImpl.getHeaderFactory().createHeader(headerName, ""));
                }
                catch (ParseException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("couldn't copy original header name " + headerName + " into the new subsequent request with an empty value"));
                }
            }
        }
    }

    private void setContactHeaders(List<String> contactHeaderSet, SipServletRequestImpl newSipServletRequest, ContactHeader contactHeader) throws ParseException {
        Request newRequest = (Request)newSipServletRequest.getMessage();
        for (String contactHeaderValue : contactHeaderSet) {
            newSipServletRequest.addHeaderInternal("Contact", contactHeaderValue, true);
        }
        ArrayList<ContactHeader> newContactHeaders = new ArrayList<ContactHeader>();
        ListIterator contactHeaders = newRequest.getHeaders("Contact");
        while (contactHeaders.hasNext()) {
            ContactHeader newContactHeader = (ContactHeader)contactHeader.clone();
            ContactHeader newRequestContactHeader = (ContactHeader)contactHeaders.next();
            URI newURI = newRequestContactHeader.getAddress().getURI();
            newContactHeader.getAddress().setDisplayName(newRequestContactHeader.getAddress().getDisplayName());
            if (newURI instanceof SipURI) {
                SipURI newSipURI = (SipURI)newURI;
                SipURI newContactSipURI = (SipURI)newContactHeader.getAddress().getURI();
                ((SipURI)newContactHeader.getAddress().getURI()).setUser(newSipURI.getUser());
                Iterator uriParameters = newSipURI.getParameterNames();
                while (uriParameters.hasNext()) {
                    String parameter = (String)uriParameters.next();
                    if (CONTACT_FORBIDDEN_PARAMETER.contains(parameter)) continue;
                    String value = newSipURI.getParameter(parameter);
                    newContactSipURI.setParameter(parameter, "".equals(value) ? null : value);
                }
            }
            Iterator headerParameters = newRequestContactHeader.getParameterNames();
            while (headerParameters.hasNext()) {
                String parameter;
                String value = newRequestContactHeader.getParameter(parameter = (String)headerParameters.next());
                newContactHeader.setParameter(parameter, "".equals(value) ? null : value);
            }
            newContactHeaders.add(newContactHeader);
        }
        newRequest.removeHeader("Contact");
        for (ContactHeader newContactHeader : newContactHeaders) {
            newRequest.addHeader((Header)newContactHeader);
        }
    }

    private void stripForbiddenContactURIParams(SipURI contactURI) {
        Iterator uriParameters = contactURI.getParameterNames();
        while (uriParameters.hasNext()) {
            String parameter = (String)uriParameters.next();
            if (!CONTACT_FORBIDDEN_PARAMETER.contains(parameter)) continue;
            contactURI.removeParameter(parameter);
            uriParameters = contactURI.getParameterNames();
        }
    }

    private final List<String> retrieveContactHeaders(Map<String, List<String>> headerMap, Request newRequest) throws ParseException {
        List<String> contactHeaderList = new ArrayList<String>();
        if (headerMap != null) {
            for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
                String headerName = entry.getKey();
                if (!headerName.equalsIgnoreCase("Contact")) {
                    if (B2BUA_SYSTEM_HEADERS.contains(headerName)) {
                        throw new IllegalArgumentException(headerName + " in the provided map is a system header");
                    }
                    if (entry.getValue().size() > 0) {
                        newRequest.removeHeader(headerName);
                    }
                    for (String value : entry.getValue()) {
                        Header header = this.sipFactoryImpl.getHeaderFactory().createHeader(headerName, value);
                        if (!JainSipUtils.SINGLETON_HEADER_NAMES.contains(header.getName())) {
                            newRequest.addHeader(header);
                            continue;
                        }
                        newRequest.setHeader(header);
                    }
                    continue;
                }
                contactHeaderList = headerMap.get(headerName);
            }
        }
        return contactHeaderList;
    }

    public SipServletResponse createResponseToOriginalRequest(SipSession session, int status, String reasonPhrase) {
        if (session == null) {
            throw new NullPointerException("Null arg");
        }
        MobicentsSipSession sipSession = (MobicentsSipSession)session;
        if (!sipSession.isValidInternal()) {
            throw new IllegalArgumentException("sip session " + sipSession.getId() + " is invalid !");
        }
        MobicentsSipServletMessage sipServletMessageImpl = sipSession.getSessionCreatingTransactionRequest();
        if (!(sipServletMessageImpl instanceof SipServletRequestImpl)) {
            throw new IllegalStateException("session creating transaction message is not a request !");
        }
        SipServletRequestImpl sipServletRequestImpl = (SipServletRequestImpl)sipServletMessageImpl;
        if (RoutingState.FINAL_RESPONSE_SENT.equals((Object)sipServletRequestImpl.getRoutingState())) {
            throw new IllegalStateException("subsequent response is inconsistent with an already sent response. a Final response has already been sent for this request " + sipServletRequestImpl);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating response to original request " + sipServletRequestImpl + " on session " + session));
        }
        return sipServletRequestImpl.createResponse(status, reasonPhrase);
    }

    public SipSession getLinkedSession(SipSession session) {
        return this.getLinkedSession(session, true);
    }

    public SipSession getLinkedSession(SipSession session, boolean checkSession) {
        if (session == null) {
            throw new NullPointerException("the argument is null");
        }
        MobicentsSipSession mobicentsSipSession = (MobicentsSipSession)session;
        if (checkSession && !mobicentsSipSession.isValidInternal()) {
            throw new IllegalArgumentException("the session " + mobicentsSipSession + " is invalid");
        }
        MobicentsSipSessionKey sipSessionKey = this.sessionMap.get(mobicentsSipSession.getKey());
        if (sipSessionKey == null) {
            this.dumpLinkedSessions();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No Linked Session found for this session " + session));
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" trying to find linked session with key " + sipSessionKey + " for session " + mobicentsSipSession));
        }
        MobicentsSipSession linkedSession = this.sipManager.getSipSession(sipSessionKey, false, null, mobicentsSipSession.getSipApplicationSession());
        if (logger.isDebugEnabled()) {
            if (linkedSession != null) {
                logger.debug((Object)("Linked Session found : " + linkedSession + " for this session " + session));
            } else {
                logger.debug((Object)("No Linked Session found for this session " + session));
            }
        }
        if (mobicentsSipSession.getParentSession() != null) {
            String linkedDerivedSessionId;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(mobicentsSipSession + " has a parent session, it means we need to handle a forked case"));
            }
            if ((linkedDerivedSessionId = this.derivedSessionMap.get(mobicentsSipSession.getId())) == null) {
                SipServletRequestImpl originalSipServletRequestImpl = (SipServletRequestImpl)linkedSession.getSessionCreatingTransactionRequest();
                String newToTag = ApplicationRoutingHeaderComposer.getHash(this.sipFactoryImpl.getSipApplicationDispatcher(), sipSessionKey.getApplicationName(), sipSessionKey.getApplicationSessionId());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("derived session " + mobicentsSipSession + " has no linked forked session yet, lazily creating one with new ToTag " + newToTag));
                }
                sipSessionKey = new SipSessionKey(sipSessionKey.getFromTag(), newToTag, sipSessionKey.getCallId(), sipSessionKey.getApplicationSessionId(), sipSessionKey.getApplicationName());
                linkedSession = this.sipManager.getSipSession(sipSessionKey, false, null, mobicentsSipSession.getSipApplicationSession());
                SipServletRequestImpl clonedOriginalRequest = (SipServletRequestImpl)originalSipServletRequestImpl.clone();
                clonedOriginalRequest.setSipSession(linkedSession);
                linkedSession.setSessionCreatingDialog(null);
                linkedSession.setSessionCreatingTransactionRequest((MobicentsSipServletMessage)clonedOriginalRequest);
                this.derivedSessionMap.put(mobicentsSipSession.getId(), linkedSession.getId());
                this.derivedSessionMap.put(linkedSession.getId(), mobicentsSipSession.getId());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("derived session " + mobicentsSipSession + " has already a linked forked session " + linkedDerivedSessionId + " reusing it"));
                }
                try {
                    sipSessionKey = SessionManagerUtil.parseSipSessionKey(linkedDerivedSessionId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" trying to find derived linked session with key " + sipSessionKey + " for session " + mobicentsSipSession));
                    }
                    linkedSession = this.sipManager.getSipSession(sipSessionKey, false, null, mobicentsSipSession.getSipApplicationSession());
                }
                catch (ParseException e) {
                    logger.error((Object)("Couldn't parse linkedDerivedSessionId " + linkedDerivedSessionId + " linked to derived session " + mobicentsSipSession), (Throwable)e);
                }
            }
        }
        if (linkedSession != null) {
            return linkedSession.getFacade();
        }
        return null;
    }

    public SipServletRequest getLinkedSipServletRequest(SipServletRequest req) {
        if (req == null) {
            throw new NullPointerException("the argument is null");
        }
        return (SipServletRequest)this.originalRequestMap.get(req);
    }

    public List<SipServletMessage> getPendingMessages(SipSession session, UAMode mode) {
        ArrayList<SipServletMessage> retval;
        block7: {
            MobicentsSipSession sipSessionImpl;
            block6: {
                sipSessionImpl = (MobicentsSipSession)session;
                if (!sipSessionImpl.isValidInternal()) {
                    throw new IllegalArgumentException("the session " + sipSessionImpl.getId() + " is invalid");
                }
                retval = new ArrayList<SipServletMessage>();
                if (!mode.equals((Object)UAMode.UAC)) break block6;
                Set ongoingTransactions = sipSessionImpl.getOngoingTransactions();
                if (ongoingTransactions == null) break block7;
                for (Transaction transaction : ongoingTransactions) {
                    Set<SipServletResponseImpl> sipServletsResponses;
                    SipServletMessageImpl sipServletMessage;
                    TransactionApplicationData tad;
                    if (!(transaction instanceof ClientTransaction) || (tad = (TransactionApplicationData)transaction.getApplicationData()) == null || (sipServletMessage = tad.getSipServletMessage()) == null) continue;
                    if (!(sipServletMessage.isCommitted() || "ACK".equals(sipServletMessage.getMethod()) || "PRACK".equals(sipServletMessage.getMethod()))) {
                        retval.add((SipServletMessage)sipServletMessage);
                    }
                    if ((sipServletsResponses = tad.getSipServletResponses()) == null) continue;
                    for (SipServletResponseImpl sipServletResponseImpl : sipServletsResponses) {
                        if (sipServletResponseImpl.isCommitted()) continue;
                        retval.add((SipServletMessage)sipServletResponseImpl);
                    }
                }
                break block7;
            }
            Set ongoingTransactions = sipSessionImpl.getOngoingTransactions();
            if (ongoingTransactions != null) {
                for (Transaction transaction : ongoingTransactions) {
                    TransactionApplicationData tad;
                    SipServletMessageImpl sipServletMessage;
                    if (!(transaction instanceof ServerTransaction) || (sipServletMessage = (tad = (TransactionApplicationData)transaction.getApplicationData()).getSipServletMessage()).isCommitted() || "ACK".equals(sipServletMessage.getMethod())) continue;
                    retval.add((SipServletMessage)sipServletMessage);
                }
            }
        }
        return retval;
    }

    public void linkSipSessions(SipSession session1, SipSession session2) {
        Map forkedSessionMap;
        if (session1 == null) {
            throw new NullPointerException("First argument is null");
        }
        if (session2 == null) {
            throw new NullPointerException("Second argument is null");
        }
        if (!((MobicentsSipSession)session1).isValidInternal() || !((MobicentsSipSession)session2).isValidInternal() || SipSession.State.TERMINATED.equals((Object)((MobicentsSipSession)session1).getState()) || SipSession.State.TERMINATED.equals((Object)((MobicentsSipSession)session2).getState()) || !session1.getApplicationSession().equals(session2.getApplicationSession()) || this.sessionMap.get(((MobicentsSipSession)session1).getKey()) != null && this.sessionMap.get(((MobicentsSipSession)session1).getKey()) != ((MobicentsSipSession)session2).getKey() || this.sessionMap.get(((MobicentsSipSession)session2).getKey()) != null && this.sessionMap.get(((MobicentsSipSession)session2).getKey()) != ((MobicentsSipSession)session1).getKey()) {
            throw new IllegalArgumentException("either of the specified sessions has been terminated or the sessions do not belong to the same application session or one or both the sessions are already linked with some other session(s)");
        }
        this.sessionMap.put(((MobicentsSipSession)session1).getKey(), ((MobicentsSipSession)session2).getKey());
        this.sessionMap.put(((MobicentsSipSession)session2).getKey(), ((MobicentsSipSession)session1).getKey());
        if (!this.equals(((MobicentsSipSession)session1).getB2buaHelper())) {
            if (((MobicentsSipSession)session1).getB2buaHelper() == null) {
                ((MobicentsSipSession)session1).setB2buaHelper((MobicentsB2BUAHelper)this);
            } else {
                forkedSessionMap = ((MobicentsSipSession)session1).getB2buaHelper().getSessionMap();
                forkedSessionMap.put(((MobicentsSipSession)session1).getKey(), ((MobicentsSipSession)session2).getKey());
                forkedSessionMap.put(((MobicentsSipSession)session2).getKey(), ((MobicentsSipSession)session1).getKey());
            }
        }
        if (!this.equals(((MobicentsSipSession)session2).getB2buaHelper())) {
            if (((MobicentsSipSession)session2).getB2buaHelper() == null) {
                ((MobicentsSipSession)session2).setB2buaHelper((MobicentsB2BUAHelper)this);
            } else {
                forkedSessionMap = ((MobicentsSipSession)session2).getB2buaHelper().getSessionMap();
                forkedSessionMap.put(((MobicentsSipSession)session1).getKey(), ((MobicentsSipSession)session2).getKey());
                forkedSessionMap.put(((MobicentsSipSession)session2).getKey(), ((MobicentsSipSession)session1).getKey());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sipsession " + ((MobicentsSipSession)session1).getKey() + " linked to sip session " + ((MobicentsSipSession)session2).getKey()));
        }
        this.dumpLinkedSessions();
    }

    public void unlinkSipSessions(SipSession session) {
        this.unlinkSipSessionsInternal(session, true);
    }

    public void unlinkSipSessionsInternal(SipSession session, boolean checkSession) {
        if (session == null) {
            throw new NullPointerException("the argument is null");
        }
        MobicentsSipSession key = (MobicentsSipSession)session;
        MobicentsSipSessionKey sipSessionKey = key.getKey();
        if (checkSession && (!((MobicentsSipSession)session).isValidInternal() || SipSession.State.TERMINATED.equals((Object)key.getState()) || this.sessionMap.get(sipSessionKey) == null)) {
            throw new IllegalArgumentException("the session is not currently linked to another session or it has been terminated");
        }
        MobicentsSipSessionKey value = this.sessionMap.get(sipSessionKey);
        if (value != null) {
            SipSession linkedSipSession = this.getLinkedSession(session, checkSession);
            this.sessionMap.remove(sipSessionKey);
            this.sessionMap.remove(value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sipsession " + sipSessionKey + " unlinked from sip session " + value));
            }
            if (linkedSipSession != null) {
                MobicentsB2BUAHelper linkedB2buaHelper = ((MobicentsSipSession)linkedSipSession).getB2buaHelper();
                if (!linkedB2buaHelper.equals(this)) {
                    linkedB2buaHelper.unlinkSipSessionsInternal(linkedSipSession, false);
                } else {
                    linkedB2buaHelper = ((MobicentsSipSession)session).getB2buaHelper();
                    linkedB2buaHelper.unlinkSipSessionsInternal(linkedSipSession, false);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("no sipsession for " + sipSessionKey + " to unlink"));
        }
        String linkedDerivedSessionId = this.derivedSessionMap.get(sipSessionKey.toString());
        if (linkedDerivedSessionId != null) {
            SipSession linkedSipSession = this.getLinkedSession(session, checkSession);
            this.derivedSessionMap.remove(sipSessionKey.toString());
            this.derivedSessionMap.remove(linkedDerivedSessionId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("derived sipsession " + sipSessionKey.toString() + " unlinked from derived sip session " + linkedDerivedSessionId));
            }
            if (linkedSipSession != null) {
                MobicentsB2BUAHelper linkedB2buaHelper = ((MobicentsSipSession)linkedSipSession).getB2buaHelper();
                if (!linkedB2buaHelper.equals(this)) {
                    linkedB2buaHelper.unlinkSipSessions(linkedSipSession);
                } else {
                    linkedB2buaHelper = ((MobicentsSipSession)session).getB2buaHelper();
                    linkedB2buaHelper.unlinkSipSessions(linkedSipSession);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("no derived sipsession for " + sipSessionKey.toString() + " to unlink"));
        }
        this.unlinkOriginalRequestInternal(sipSessionKey, !checkSession);
        this.dumpLinkedSessions();
    }

    public void unlinkOriginalRequestInternal(MobicentsSipSessionKey sipSessionKey, boolean force) {
        for (Map.Entry<SipServletRequestImpl, SipServletRequestImpl> linkedRequests : this.originalRequestMap.entrySet()) {
            SipServletRequestImpl request1 = linkedRequests.getKey();
            SipServletRequestImpl request2 = linkedRequests.getValue();
            if (request1 == null || request2 == null) continue;
            MobicentsSipSessionKey key1 = request1.getSipSessionKey();
            MobicentsSipSessionKey key2 = request2.getSipSessionKey();
            if ((key1 == null || !key1.equals(sipSessionKey)) && (key2 == null || !key2.equals(sipSessionKey))) continue;
            this.unlinkOriginalRequestInternal(linkedRequests.getKey(), force);
            this.unlinkOriginalRequestInternal(linkedRequests.getValue(), force);
        }
    }

    public void unlinkOriginalRequestInternal(MobicentsSipServletRequest sipServletRequestImpl, boolean force) {
        if (sipServletRequestImpl != null) {
            SipServletRequestImpl linkedRequest = this.originalRequestMap.get(sipServletRequestImpl);
            if (sipServletRequestImpl != null && linkedRequest != null) {
                Transaction transaction = sipServletRequestImpl.getTransaction();
                Transaction linkedTransaction = linkedRequest.getTransaction();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("force " + force));
                    logger.debug((Object)("transaction " + transaction));
                    logger.debug((Object)("Linkedtransaction " + linkedTransaction));
                    if (transaction != null) {
                        logger.debug((Object)("transaction state " + transaction.getState()));
                    }
                    if (linkedTransaction != null) {
                        logger.debug((Object)("linked transaction state " + linkedTransaction.getState()));
                    }
                }
                if (force || (transaction == null || TransactionState.TERMINATED.equals((Object)transaction.getState())) && (linkedTransaction == null || TransactionState.TERMINATED.equals((Object)linkedTransaction.getState()))) {
                    this.originalRequestMap.remove(sipServletRequestImpl);
                    this.originalRequestMap.remove(linkedRequest);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("following linked request " + linkedRequest + " unlinked from " + sipServletRequestImpl));
                    }
                }
            }
        }
    }

    public SipServletRequest createRequest(SipServletRequest origRequest) {
        SipServletRequestImpl newSipServletRequest = (SipServletRequestImpl)this.sipFactoryImpl.createRequest(origRequest, false);
        SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
        MobicentsSipSession originalSession = origRequestImpl.getSipSession();
        MobicentsSipSession session = newSipServletRequest.getSipSession();
        session.setB2buaHelper((MobicentsB2BUAHelper)this);
        originalSession.setB2buaHelper((MobicentsB2BUAHelper)this);
        return newSipServletRequest;
    }

    public SipServletRequest createCancel(SipSession session) {
        if (session == null) {
            throw new NullPointerException("The session for createCancel cannot be null");
        }
        for (SipServletRequestImpl linkedRequest : this.originalRequestMap.keySet()) {
            if (!linkedRequest.getSipSessionKey().equals(((MobicentsSipSession)session).getKey()) || !linkedRequest.getMethod().equalsIgnoreCase("INVITE") || linkedRequest.isFinalResponseGenerated() || linkedRequest.getLastFinalResponse() != null) continue;
            SipServletRequestImpl sipServletRequestImpl = (SipServletRequestImpl)linkedRequest.createCancel();
            ((MobicentsSipSession)sipServletRequestImpl.getSession()).setB2buaHelper((MobicentsB2BUAHelper)this);
            return sipServletRequestImpl;
        }
        return null;
    }

    public SipFactoryImpl getSipFactoryImpl() {
        return this.sipFactoryImpl;
    }

    public void setMobicentsSipFactory(MobicentsSipFactory sipFactoryImpl) {
        this.sipFactoryImpl = (SipFactoryImpl)sipFactoryImpl;
    }

    public SipManager getSipManager() {
        return this.sipManager;
    }

    public void setSipManager(SipManager sipManager) {
        this.sipManager = sipManager;
    }

    private void dumpLinkedSessions() {
        if (logger.isDebugEnabled()) {
            for (MobicentsSipSessionKey mobicentsSipSessionKey : this.sessionMap.keySet()) {
                logger.debug((Object)(mobicentsSipSessionKey + " tied to session " + this.sessionMap.get(mobicentsSipSessionKey)));
            }
            for (String string : this.derivedSessionMap.keySet()) {
                logger.debug((Object)("forked " + string + " tied to forked session " + this.derivedSessionMap.get(string)));
            }
        }
    }

    public void setSessionMap(Map<MobicentsSipSessionKey, MobicentsSipSessionKey> sessionMap) {
        this.sessionMap = sessionMap;
    }

    public Map<MobicentsSipSessionKey, MobicentsSipSessionKey> getSessionMap() {
        return this.sessionMap;
    }

    public Map<SipServletRequestImpl, SipServletRequestImpl> getOriginalRequestMap() {
        return this.originalRequestMap;
    }

    public void setOriginalRequestMap(Map<SipServletRequestImpl, SipServletRequestImpl> originalRequestsMap) {
        this.originalRequestMap = originalRequestsMap;
    }

    static {
        B2BUA_SYSTEM_HEADERS.add("Call-ID");
        B2BUA_SYSTEM_HEADERS.add("CSeq");
        B2BUA_SYSTEM_HEADERS.add("Via");
        B2BUA_SYSTEM_HEADERS.add("Record-Route");
        B2BUA_SYSTEM_HEADERS.add("Path");
        CONTACT_FORBIDDEN_PARAMETER = new HashSet<String>();
        CONTACT_FORBIDDEN_PARAMETER.add("method");
        CONTACT_FORBIDDEN_PARAMETER.add("ttl");
        CONTACT_FORBIDDEN_PARAMETER.add("maddr");
        CONTACT_FORBIDDEN_PARAMETER.add("lr");
    }
}

