/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.session;

import javax.servlet.sip.SipApplicationSession;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipApplicationSessionAsynchronousWork;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;

public class SipApplicationSessionAsyncTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(SipApplicationSessionAsyncTask.class);
    private SipApplicationSessionKey key;
    private SipApplicationSessionAsynchronousWork work;
    private MobicentsSipFactory sipFactoryImpl;

    public SipApplicationSessionAsyncTask(SipApplicationSessionKey key, SipApplicationSessionAsynchronousWork work, MobicentsSipFactory sipFactory) {
        this.key = key;
        this.work = work;
        this.sipFactoryImpl = sipFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        SipContext sipContext = this.sipFactoryImpl.getSipApplicationDispatcher().findSipApplication(this.key.getApplicationName());
        if (sipContext == null) return;
        SipManager sipManager = sipContext.getSipManager();
        MobicentsSipApplicationSession sipApplicationSession = sipManager.getSipApplicationSession((MobicentsSipApplicationSessionKey)this.key, false);
        if (sipApplicationSession != null) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            boolean batchStarted = false;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Asynchronous work for sip app session " + this.key + " scheduled to run once the sipappsession lock is available."));
                }
                sipContext.enterSipContext();
                sipContext.enterSipApp(sipApplicationSession, null, false, true);
                batchStarted = sipContext.enterSipAppHa(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Starting Asynchronous work for sip app session " + this.key));
                }
                this.work.doAsynchronousWork((SipApplicationSession)sipApplicationSession);
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)("Done with Asynchronous work for sip app session " + this.key));
                return;
            }
            catch (Throwable t) {
                logger.error((Object)("An unexpected exception happened in the SipApplicationSessionAsynchronousWork callback on sip application session " + this.key), t);
                return;
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Exiting Asynchronous work for sip app session " + this.key));
                }
                sipContext.exitSipAppHa(null, null, batchStarted);
                sipContext.exitSipApp(sipApplicationSession, null);
                sipContext.exitSipContext(oldClassLoader);
            }
        } else {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("SipApplicationSession " + this.key + " couldn't be found, it may have been already invalidated."));
        }
    }
}

