/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import gov.nist.javax.sip.ListeningPointExt;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.sip.InvalidArgumentException;
import javax.sip.SipProvider;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.ViaHeader;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.message.SipFactoryImpl;

public class ExtendedListeningPoint
implements MobicentsExtendedListeningPoint {
    private static final Logger logger = Logger.getLogger(ExtendedListeningPoint.class);
    private ListeningPointExt listeningPoint;
    private SipProvider sipProvider;
    private SipConnector sipConnector;
    private String globalIpAddress;
    String mostOutboundAddress = null;
    private int globalPort;
    private List<String> ipAddresses;
    private boolean isAnyLocalAddress;
    private boolean useStaticAddress;
    private boolean useLoadBalancer;
    int port = -1;
    String transport;

    public ExtendedListeningPoint(SipProvider sipProvider, ListeningPointExt listeningPoint, SipConnector sipConnector) {
        this.sipProvider = sipProvider;
        this.listeningPoint = listeningPoint;
        this.sipConnector = sipConnector;
        this.globalIpAddress = null;
        this.globalPort = -1;
        this.ipAddresses = new ArrayList<String>();
        try {
            this.isAnyLocalAddress = InetAddress.getByName(listeningPoint.getIPAddress()).isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            logger.warn((Object)"Unable to enumerate mapped interfaces. Binding to 0.0.0.0 may not work.");
            this.isAnyLocalAddress = false;
        }
        if (this.isAnyLocalAddress) {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    Enumeration<InetAddress> bindings = networkInterface.getInetAddresses();
                    while (bindings.hasMoreElements()) {
                        InetAddress addr = bindings.nextElement();
                        String networkInterfaceIpAddress = addr.getHostAddress();
                        this.ipAddresses.add(networkInterfaceIpAddress);
                    }
                }
            }
            catch (SocketException e) {
                logger.warn((Object)"Unable to enumerate network interfaces. Binding to 0.0.0.0 may not work.");
            }
        } else {
            this.ipAddresses.add(listeningPoint.getIPAddress());
        }
        this.mostOutboundAddress = JainSipUtils.getMostOutboundAddress(this.ipAddresses);
        this.transport = listeningPoint.getTransport();
        this.port = listeningPoint.getPort();
    }

    public String getIpAddress(boolean usePublicAddress) {
        if (usePublicAddress && this.globalIpAddress != null) {
            return this.globalIpAddress;
        }
        return this.mostOutboundAddress;
    }

    public ContactHeader createContactHeader(String displayName, String userName, boolean usePublicAddress) {
        return this.createContactHeader(displayName, userName, usePublicAddress, null);
    }

    public ContactHeader createContactHeader(String displayName, String userName, boolean usePublicAddress, String outboundInterface) {
        try {
            String host = null;
            if (outboundInterface != null) {
                SipURI outboundInterfaceURI = (SipURI)SipFactoryImpl.addressFactory.createURI(outboundInterface);
                host = outboundInterfaceURI.getHost();
            } else {
                host = this.getIpAddress(usePublicAddress);
            }
            SipURI sipURI = SipFactoryImpl.addressFactory.createSipURI(userName, host);
            sipURI.setHost(host);
            sipURI.setPort(this.port);
            if (!sipURI.isSecure() && !"UDP".equalsIgnoreCase(this.transport) || sipURI.isSecure() && !"TCP".equalsIgnoreCase(this.transport)) {
                sipURI.setTransportParam(this.transport);
            }
            Address contactAddress = SipFactoryImpl.addressFactory.createAddress((URI)sipURI);
            ContactHeader contact = SipFactoryImpl.headerFactory.createContactHeader(contactAddress);
            if (displayName != null && displayName.length() > 0) {
                contactAddress.setDisplayName(displayName);
            }
            return contact;
        }
        catch (ParseException ex) {
            logger.error((Object)"Unexpected error while creating the contact header for the extended listening point", (Throwable)ex);
            throw new IllegalArgumentException("Unexpected exception when creating a sip URI", ex);
        }
    }

    public ViaHeader createViaHeader(String branch, boolean usePublicAddress) {
        try {
            String host = this.getIpAddress(usePublicAddress);
            ViaHeader via = SipFactoryImpl.headerFactory.createViaHeader(host, this.port, this.transport, branch);
            return via;
        }
        catch (ParseException ex) {
            logger.error((Object)"Unexpected error while creating a via header", (Throwable)ex);
            throw new IllegalArgumentException("Unexpected exception when creating via header ", ex);
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"Unexpected error while creating a via header", (Throwable)e);
            throw new IllegalArgumentException("Unexpected exception when creating via header ", e);
        }
    }

    public SipURI createRecordRouteURI(boolean usePublicAddress) {
        try {
            String host = this.getIpAddress(usePublicAddress);
            SipURI sipUri = SipFactoryImpl.addressFactory.createSipURI(null, host);
            sipUri.setPort(this.port);
            sipUri.setTransportParam(this.transport);
            return sipUri;
        }
        catch (ParseException ex) {
            logger.error((Object)"Unexpected error while creating a record route URI", (Throwable)ex);
            throw new IllegalArgumentException("Unexpected exception when creating a record route URI", ex);
        }
    }

    public ListeningPointExt getListeningPoint() {
        return this.listeningPoint;
    }

    public SipProvider getSipProvider() {
        return this.sipProvider;
    }

    public String getGlobalIpAddress() {
        return this.globalIpAddress;
    }

    public int getGlobalPort() {
        return this.globalPort;
    }

    public void setGlobalIpAddress(String globalIpAddress) {
        this.globalIpAddress = globalIpAddress;
    }

    public void setGlobalPort(int globalPort) {
        this.globalPort = globalPort;
    }

    public boolean isUseStaticAddress() {
        return this.useStaticAddress;
    }

    public void setUseStaticAddress(boolean useStaticAddress) {
        this.useStaticAddress = useStaticAddress;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = stringBuilder.append("ExtendedListeningPoint:").append("ipAddress=").append(this.listeningPoint.getIPAddress());
        if (this.isAnyLocalAddress) {
            stringBuilder = stringBuilder.append(",maps to following ipaddress:");
            for (String mappedIpAddress : this.ipAddresses) {
                stringBuilder = stringBuilder.append("\n \t mapped ipaddress:");
                stringBuilder = stringBuilder.append(mappedIpAddress);
            }
            stringBuilder = stringBuilder.append("\n");
        }
        stringBuilder = stringBuilder.append(", port=").append(this.listeningPoint.getPort()).append(", transport=").append(this.transport).append(", globalIpAddress=").append(this.globalIpAddress).append(", gloablPort=").append(this.globalPort).append(", hostNames=").append(this.sipConnector.getHostNames()).append(", useLoadBalancer=").append(this.useLoadBalancer).append(", mostOutboundAddress=").append(this.mostOutboundAddress);
        return stringBuilder.toString();
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public String getHost(boolean usePublicAddress) {
        String host = this.getIpAddress(usePublicAddress);
        return host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isAnyLocalAddress() {
        return this.isAnyLocalAddress;
    }

    public void setSipConnector(SipConnector sipConnector) {
        this.sipConnector = sipConnector;
    }

    public SipConnector getSipConnector() {
        return this.sipConnector;
    }

    public boolean isUseLoadBalancer() {
        return this.useLoadBalancer;
    }

    public void setUseLoadBalancer(boolean useLoadBalancer) {
        this.useLoadBalancer = useLoadBalancer;
    }
}

