/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import gov.nist.javax.sip.TransactionExt;
import gov.nist.javax.sip.message.MessageExt;
import java.text.ParseException;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.Parameters;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.core.MobicentsExtendedListeningPoint;
import org.mobicents.servlet.sip.core.SipNetworkInterfaceManager;
import org.mobicents.servlet.sip.core.SipSessionRoutingType;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;

public abstract class RequestDispatcher
extends MessageDispatcher {
    private static final Logger logger = Logger.getLogger(RequestDispatcher.class);

    protected final void forwardRequestStatefully(SipServletRequestImpl sipServletRequest, SipSessionRoutingType sipSessionRoutingType, SipRouteModifier sipRouteModifier) throws Exception {
        SipNetworkInterfaceManager sipNetworkInterfaceManager = this.sipApplicationDispatcher.getSipNetworkInterfaceManager();
        Request clonedRequest = (Request)sipServletRequest.getMessage().clone();
        String transport = JainSipUtils.findTransport((Message)clonedRequest);
        ((MessageExt)clonedRequest).setApplicationData(null);
        MobicentsSipSession session = sipServletRequest.getSipSession();
        String outboundInterface = null;
        if (session != null) {
            outboundInterface = session.getOutboundInterface();
        }
        ViaHeader viaHeader = JainSipUtils.createViaHeader(sipNetworkInterfaceManager, clonedRequest, null, outboundInterface);
        String appNotDeployed = null;
        boolean noAppReturned = false;
        String modifier = null;
        if (session != null) {
            if (SipSessionRoutingType.CURRENT_SESSION.equals((Object)sipSessionRoutingType)) {
                String branch;
                String handlerName = session.getHandler();
                if (handlerName != null) {
                    branch = JainSipUtils.createBranch(session.getSipApplicationSession().getKey().getId(), this.sipApplicationDispatcher.getHashFromApplicationName(session.getKey().getApplicationName()));
                    viaHeader.setBranch(branch);
                } else {
                    branch = JainSipUtils.createBranch(session.getSipApplicationSession().getKey().getId(), this.sipApplicationDispatcher.getHashFromApplicationName(session.getKey().getApplicationName()));
                    viaHeader.setBranch(branch);
                    appNotDeployed = session.getKey().getApplicationName();
                }
                clonedRequest.addHeader((Header)viaHeader);
            } else {
                if (SipRouteModifier.NO_ROUTE.equals((Object)sipRouteModifier)) {
                    noAppReturned = true;
                } else {
                    modifier = sipRouteModifier.toString();
                }
                clonedRequest.addHeader((Header)viaHeader);
            }
        } else {
            if (SipRouteModifier.NO_ROUTE.equals((Object)sipRouteModifier)) {
                noAppReturned = true;
            } else {
                modifier = sipRouteModifier.toString();
            }
            clonedRequest.addHeader((Header)viaHeader);
        }
        MobicentsExtendedListeningPoint extendedListeningPoint = sipNetworkInterfaceManager.findMatchingListeningPoint(transport, false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Matching listening point found " + extendedListeningPoint));
        }
        SipProvider sipProvider = extendedListeningPoint.getSipProvider();
        ServerTransaction serverTransaction = (ServerTransaction)sipServletRequest.getTransaction();
        Dialog dialog = sipServletRequest.getDialog();
        MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)clonedRequest.getHeader("Max-Forwards");
        if (maxForwardsHeader == null) {
            maxForwardsHeader = SipFactoryImpl.headerFactory.createMaxForwardsHeader(70);
            clonedRequest.addHeader((Header)maxForwardsHeader);
        } else if (maxForwardsHeader.getMaxForwards() - 1 > 0) {
            maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
        } else {
            RequestDispatcher.sendErrorResponse(this.sipApplicationDispatcher, 483, sipServletRequest, sipProvider);
            return;
        }
        if (logger.isDebugEnabled()) {
            if (SipRouteModifier.NO_ROUTE.equals((Object)sipRouteModifier)) {
                logger.debug((Object)("Routing Back to the container the following request " + clonedRequest));
            } else {
                logger.debug((Object)("Routing externally the following request " + clonedRequest));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dialog existing " + (dialog != null)));
        }
        if (dialog == null) {
            Transaction transaction = ((TransactionApplicationData)serverTransaction.getApplicationData()).getSipServletMessage().getTransaction();
            if (transaction == null || transaction instanceof ServerTransaction) {
                ClientTransaction ctx = sipProvider.getNewClientTransaction(clonedRequest);
                JainSipUtils.setTransactionTimers((TransactionExt)ctx, this.sipApplicationDispatcher);
                TransactionApplicationData appData = new TransactionApplicationData(sipServletRequest);
                appData.setTransaction((Transaction)serverTransaction);
                appData.setNoAppReturned(noAppReturned);
                appData.setAppNotDeployed(appNotDeployed);
                appData.setModifier(modifier);
                ctx.setApplicationData((Object)appData);
                ((TransactionApplicationData)serverTransaction.getApplicationData()).setTransaction((Transaction)ctx);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Sending the request through a new client transaction " + clonedRequest));
                }
                try {
                    ctx.sendRequest();
                }
                catch (SipException e) {
                    JainSipUtils.terminateTransaction((Transaction)ctx);
                    throw e;
                }
            } else {
                TransactionApplicationData appData = (TransactionApplicationData)transaction.getApplicationData();
                if (appData == null) {
                    appData = new TransactionApplicationData(sipServletRequest);
                    appData.setTransaction(transaction);
                }
                appData.setNoAppReturned(noAppReturned);
                appData.setAppNotDeployed(appNotDeployed);
                appData.setModifier(modifier);
                ((TransactionApplicationData)serverTransaction.getApplicationData()).setTransaction(transaction);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Sending the request through the existing transaction " + clonedRequest));
                }
                ((ClientTransaction)transaction).sendRequest();
            }
        } else if (clonedRequest.getMethod().equals("ACK")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Sending the ACK through the dialog " + clonedRequest));
            }
            dialog.sendAck(clonedRequest);
        } else {
            ContentTypeHeader contentTypeHeader;
            Request dialogRequest = dialog.createRequest(clonedRequest.getMethod());
            Object content = clonedRequest.getContent();
            if (content != null && (contentTypeHeader = (ContentTypeHeader)clonedRequest.getHeader("Content-Type")) != null) {
                dialogRequest.setContent(content, contentTypeHeader);
            }
            ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(dialogRequest);
            JainSipUtils.setTransactionTimers((TransactionExt)clientTransaction, this.sipApplicationDispatcher);
            TransactionApplicationData appData = new TransactionApplicationData(sipServletRequest);
            appData.setNoAppReturned(noAppReturned);
            appData.setAppNotDeployed(appNotDeployed);
            appData.setModifier(modifier);
            appData.setTransaction((Transaction)serverTransaction);
            clientTransaction.setApplicationData((Object)appData);
            ((TransactionApplicationData)serverTransaction.getApplicationData()).setTransaction((Transaction)clientTransaction);
            dialog.setApplicationData((Object)appData);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Sending the request through the dialog " + clonedRequest));
            }
            dialog.sendRequest(clientTransaction);
        }
    }

    protected void handleSipOutbound(SipServletRequestImpl sipServletRequest) {
        if (!JainSipUtils.DIALOG_CREATING_METHODS.contains(sipServletRequest.getMethod())) {
            return;
        }
        Request request = (Request)sipServletRequest.getMessage();
        ContactHeader contact = (ContactHeader)request.getHeader("Contact");
        URI requestUri = request.getRequestURI();
        if (contact != null && contact.getAddress().getURI() instanceof Parameters && ((Parameters)contact.getAddress().getURI()).getParameter("ob") != null) {
            String remoteHost = sipServletRequest.getRemoteAddr();
            int remotePort = sipServletRequest.getRemotePort();
            String transport = sipServletRequest.getTransport();
            MobicentsSipSession sipSessionImpl = sipServletRequest.getSipSession();
            try {
                SipURI flowURI = SipFactoryImpl.addressFactory.createSipURI(null, remoteHost);
                flowURI.setPort(remotePort);
                flowURI.setTransportParam(transport);
                sipSessionImpl.setFlow(flowURI);
            }
            catch (ParseException e) {
                logger.warn((Object)("Unable to create new flow URI from " + remoteHost + ":" + remotePort + ";transport=" + transport + " due to a parse exception"));
            }
        } else if (sipServletRequest.getPoppedRouteHeader() != null && requestUri instanceof SipURI && ((SipURI)requestUri).getParameter("ob") != null) {
            SipURI poppedURI = (SipURI)sipServletRequest.getPoppedRouteHeader().getAddress().getURI();
            String flowToken = poppedURI.getUser();
            return;
        }
    }
}

