/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core.dispatchers;

import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.message.RequestExt;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletResponse;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipFactoryExt;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.address.URIImpl;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.core.ApplicationRoutingHeaderComposer;
import org.mobicents.servlet.sip.core.DispatcherException;
import org.mobicents.servlet.sip.core.MobicentsSipFactory;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.b2bua.MobicentsB2BUAHelper;
import org.mobicents.servlet.sip.core.dispatchers.DispatchTask;
import org.mobicents.servlet.sip.core.dispatchers.MessageDispatcher;
import org.mobicents.servlet.sip.core.dispatchers.RequestDispatcher;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxyBranch;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SipSessionKey;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.SipServletResponseImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.startup.StaticServiceHolder;

public class SubsequentRequestDispatcher
extends RequestDispatcher {
    private static final Logger logger = Logger.getLogger(SubsequentRequestDispatcher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchMessage(SipProvider sipProvider, SipServletMessageImpl sipServletMessage) throws DispatcherException {
        boolean isValid;
        String jvmRoute;
        SipContext sipContext;
        Parameters poppedAddress;
        String applicationNameHashed;
        MobicentsSipFactory sipFactoryImpl = this.sipApplicationDispatcher.getSipFactory();
        SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)sipServletMessage;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Routing of Subsequent Request " + sipServletRequest));
        }
        Request request = (Request)sipServletRequest.getMessage();
        Dialog dialog = sipServletRequest.getDialog();
        RouteHeader poppedRouteHeader = sipServletRequest.getPoppedRouteHeader();
        String method = request.getMethod();
        String applicationName = null;
        String applicationId = null;
        if (poppedRouteHeader != null && (applicationNameHashed = (poppedAddress = (Parameters)poppedRouteHeader.getAddress().getURI()).getParameter("appname")) != null && applicationNameHashed.length() > 0) {
            applicationName = this.sipApplicationDispatcher.getApplicationNameFromHash(applicationNameHashed);
            applicationId = poppedAddress.getParameter("app_id");
        }
        if (applicationId == null) {
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String arText = toHeader.getTag();
            try {
                String[] tuple = ApplicationRoutingHeaderComposer.getAppNameAndSessionId(this.sipApplicationDispatcher, arText);
                applicationName = tuple[1];
                applicationId = tuple[2];
            }
            catch (IllegalArgumentException e) {
                throw new DispatcherException(500, (Throwable)e);
            }
            if (applicationId == null && applicationName == null) {
                String applicationNameHashed2;
                URI requestURI = request.getRequestURI();
                if (request.getRequestURI() instanceof SipURI && (applicationNameHashed2 = ((Parameters)requestURI).getParameter("appname")) != null && applicationNameHashed2.length() > 0) {
                    applicationName = this.sipApplicationDispatcher.getApplicationNameFromHash(applicationNameHashed2);
                    applicationId = ((Parameters)requestURI).getParameter("app_id");
                }
                if (applicationId == null && applicationName == null) {
                    boolean isAnotherDomain = false;
                    if (requestURI.isSipURI()) {
                        String host = ((SipURI)requestURI).getHost();
                        int port = ((SipURI)requestURI).getPort();
                        String transport = JainSipUtils.findTransport((Message)request);
                        isAnotherDomain = this.sipApplicationDispatcher.isExternal(host, port, transport);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("The Request URI " + requestURI + " is not a SIP URI and the Route Header was null or didn't contain information about an application to call (which would be incorrect) so we assume the request is an ACK for a container generated error response or misrouted"));
                    }
                    if (isAnotherDomain) {
                        if ("ACK".equals(method) && sipServletRequest.getTransaction() != null && ((SIPServerTransaction)sipServletRequest.getTransaction()).getLastResponseStatusCode() >= 300) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"The popped Route, application Id and name are null for an ACK or belonging to a different SIP application server, this is an ACK for an error response, so it is dropped");
                            }
                            return;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("No application found to handle this request " + request + " with the following popped route header " + poppedRouteHeader + " so forwarding statelessly to the outside since it is not targeted at the container"));
                        }
                        try {
                            sipProvider.sendRequest(request);
                            sipFactoryImpl.getSipApplicationDispatcher().updateRequestsStatistics(request, false);
                        }
                        catch (SipException e) {
                            throw new DispatcherException("cannot proxy statelessly outside of the container the following request " + request, (Throwable)e);
                        }
                        return;
                    }
                    if ("ACK".equals(method)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"The popped Route, application Id and name are null for an ACK, so this is an ACK to a container generated error response, so it is dropped");
                        }
                        return;
                    }
                    if (poppedRouteHeader != null) {
                        throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request + "in this popped routed header " + poppedRouteHeader);
                    }
                    throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request);
                }
            }
        }
        boolean inverted = false;
        if (dialog != null && !dialog.isServer()) {
            inverted = true;
        }
        if ((sipContext = this.sipApplicationDispatcher.findSipApplication(applicationName)) == null) {
            if (poppedRouteHeader != null) {
                throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request + "in this popped routed header " + poppedRouteHeader);
            }
            throw new DispatcherException(500, "cannot find the application to handle this subsequent request " + request);
        }
        SipManager sipManager = sipContext.getSipManager();
        SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.getSipApplicationSessionKey(applicationName, applicationId, null);
        MobicentsSipSession tmpSipSession = null;
        MobicentsSipApplicationSession sipApplicationSession = sipManager.getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, false);
        if (sipApplicationSession == null) {
            if (logger.isDebugEnabled()) {
                sipManager.dumpSipApplicationSessions();
            }
            MobicentsSipApplicationSessionKey joinSipApplicationSessionKey = sipContext.getSipSessionsUtil().getCorrespondingSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, "Join");
            MobicentsSipApplicationSessionKey replacesSipApplicationSessionKey = sipContext.getSipSessionsUtil().getCorrespondingSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, "Replaces");
            if (joinSipApplicationSessionKey != null) {
                sipApplicationSession = sipManager.getSipApplicationSession(joinSipApplicationSessionKey, false);
            } else if (replacesSipApplicationSessionKey != null) {
                sipApplicationSession = sipManager.getSipApplicationSession(replacesSipApplicationSessionKey, false);
            }
        }
        boolean routeOrphanRequests = ((SipFactoryExt)sipContext.getSipFactoryFacade()).isRouteOrphanRequests();
        if (sipApplicationSession == null || sipApplicationSession.isOrphan()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("routeOrphanRequests = " + routeOrphanRequests + " for context " + sipContext.getApplicationName() + " appSession=" + sipApplicationSession));
            }
            if (!routeOrphanRequests) {
                if (poppedRouteHeader != null) {
                    throw new DispatcherException(481, "Cannot find the corresponding sip application session to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute() + ", it may already have been invalidated or timed out");
                }
                throw new DispatcherException(481, "Cannot find the corresponding sip application session to this subsequent request " + request + ", it may already have been invalidated or timed out");
            }
            SubsequentRequestDispatcher.handleOrphanRequest(sipProvider, sipServletRequest, applicationId, sipContext);
            return;
        }
        if (StaticServiceHolder.sipStandardService.isHttpFollowsSip() && (jvmRoute = StaticServiceHolder.sipStandardService.getJvmRoute()) != null) {
            sipApplicationSession.setJvmRoute(jvmRoute);
        }
        SipSessionKey key = SessionManagerUtil.getSipSessionKey(sipApplicationSession.getKey().getId(), applicationName, (Message)request, inverted);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to find the corresponding sip session with key " + key + " to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute()));
        }
        if ((tmpSipSession = sipManager.getSipSession((MobicentsSipSessionKey)key, false, sipFactoryImpl, sipApplicationSession)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot find the corresponding sip session with key " + key + " to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute() + ". Trying inverted."));
            }
            key = SessionManagerUtil.getSipSessionKey(sipApplicationSession.getKey().getId(), applicationName, (Message)request, !inverted);
            tmpSipSession = sipManager.getSipSession((MobicentsSipSessionKey)key, false, sipFactoryImpl, sipApplicationSession);
        }
        if (tmpSipSession == null) {
            sipManager.dumpSipSessions();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("routeOrphanRequests = " + routeOrphanRequests + " for context " + sipContext.getApplicationName() + " appSessionId=" + applicationId));
            }
            if (!routeOrphanRequests) {
                if (poppedRouteHeader != null) {
                    throw new DispatcherException(481, "Cannot find the corresponding sip session to this subsequent request " + request + " with the following popped route header " + sipServletRequest.getPoppedRoute() + ", it may already have been invalidated or timed out");
                }
                throw new DispatcherException(481, "Cannot find the corresponding sip session to this subsequent request " + request + ", it may already have been invalidated or timed out");
            }
            SubsequentRequestDispatcher.handleOrphanRequest(sipProvider, sipServletRequest, applicationId, sipContext);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inverted try worked. sip session found : " + tmpSipSession.getId()));
        }
        MobicentsSipSession sipSession = tmpSipSession;
        sipServletRequest.setSipSession(sipSession);
        SubsequentDispatchTask dispatchTask = new SubsequentDispatchTask(sipServletRequest, sipProvider);
        sipContext.enterSipApp(sipApplicationSession, sipSession, false, true);
        boolean batchStarted = sipContext.enterSipAppHa(true);
        if (request.getMethod().equals("ACK")) {
            sipSession.setRequestsPending(sipSession.getRequestsPending() - 1);
        } else if (request.getMethod().equals("INVITE")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("INVITE requests pending " + sipSession.getRequestsPending()));
            }
            if (StaticServiceHolder.sipStandardService.isDialogPendingRequestChecking() && sipSession.getProxy() == null && sipSession.getRequestsPending() > 0) {
                try {
                    sipServletRequest.createResponse(491).send();
                    return;
                }
                catch (IOException e) {
                    logger.error((Object)("Problem sending 491 response to " + sipServletRequest), (Throwable)e);
                }
                finally {
                    sipContext.exitSipApp(sipApplicationSession, sipSession);
                }
            }
            sipSession.setRequestsPending(sipSession.getRequestsPending() + 1);
            ViaHeader via = (ViaHeader)request.getHeader("Via");
            sipSession.setTransport(via.getTransport());
            this.handleSipOutbound(sipServletRequest);
        }
        boolean orphan = sipSession.isOrphan() || sipApplicationSession.isOrphan();
        sipServletRequest.setOrphan(orphan);
        if (sipSession.getProxy() == null && !orphan && !(isValid = sipSession.validateCSeq((MobicentsSipServletRequest)sipServletRequest))) {
            sipContext.exitSipAppHa((MobicentsSipServletRequest)sipServletRequest, null, batchStarted);
            sipContext.exitSipApp(sipApplicationSession, sipSession);
            return;
        }
        if (this.sipApplicationDispatcher.isBypassRequestExecutor() || ConcurrencyControlMode.Transaction.equals((Object)sipContext.getConcurrencyControlMode())) {
            dispatchTask.setBatchStarted(batchStarted);
            dispatchTask.dispatchAndHandleExceptions();
        } else {
            sipContext.exitSipAppHa((MobicentsSipServletRequest)sipServletRequest, null, batchStarted);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("We are just before executor with sipAppSession=" + sipApplicationSession + " and sipSession=" + sipSession + " for " + sipServletMessage));
            }
            this.getConcurrencyModelExecutorService(sipContext, sipServletMessage).execute(dispatchTask);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("We are just after executor with sipAppSession=" + sipApplicationSession + " and sipSession=" + sipSession + " for " + sipServletMessage));
            }
        }
    }

    private static void handleOrphanRequest(SipProvider sipProvider, SipServletRequestImpl sipServletRequest, String applicationId, SipContext sipContext) throws DispatcherException {
        String applicationName = sipContext.getApplicationName();
        Request request = (Request)sipServletRequest.getMessage();
        sipServletRequest.setSipSession(null);
        sipServletRequest.setSipSessionKey(null);
        sipServletRequest.setOrphan(true);
        sipServletRequest.setAppSessionId(applicationId);
        sipServletRequest.setCurrentApplicationName(applicationName);
        try {
            MessageDispatcher.callServletForOrphanRequest(sipContext, sipServletRequest);
            try {
                String transport = JainSipUtils.findTransport((Message)request);
                SipConnector connector = StaticServiceHolder.sipStandardService.findSipConnector(transport);
                String branch = ((ViaHeader)sipServletRequest.getMessage().getHeader("Via")).getBranch();
                ViaHeader via = JainSipUtils.createViaHeader(sipContext.getSipApplicationDispatcher().getSipNetworkInterfaceManager(), request, JainSipUtils.createBranch("orphan", sipContext.getSipApplicationDispatcher().getHashFromApplicationName(applicationName), Integer.toString(branch.hashCode()) + branch.substring(branch.length() / 2)), null);
                if (connector.isUseStaticAddress()) {
                    try {
                        via.setHost(connector.getStaticServerAddress());
                        via.setPort(connector.getStaticServerPort());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                sipServletRequest.getMessage().addHeader((Header)via);
                sipProvider.sendRequest((Request)sipServletRequest.getMessage());
                sipContext.getSipApplicationDispatcher().updateRequestsStatistics(request, false);
            }
            catch (SipException e) {
                logger.error((Object)"Error routing orphaned request", (Throwable)e);
            }
            return;
        }
        catch (ServletException e) {
            throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, (Throwable)e);
        }
        catch (IOException e) {
            throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, (Throwable)e);
        }
    }

    public static class SubsequentDispatchTask
    extends DispatchTask {
        boolean batchStarted = false;

        SubsequentDispatchTask(SipServletRequestImpl sipServletRequest, SipProvider sipProvider) {
            super(sipServletRequest, sipProvider);
        }

        public void setBatchStarted(boolean batchStarted) {
            this.batchStarted = batchStarted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() throws DispatcherException {
            SipServletRequestImpl sipServletRequest = (SipServletRequestImpl)this.sipServletMessage;
            MobicentsSipSession sipSession = sipServletRequest.getSipSession();
            MobicentsSipApplicationSession appSession = sipSession.getSipApplicationSession();
            SipContext sipContext = appSession.getSipContext();
            Request request = (Request)sipServletRequest.getMessage();
            if (!sipContext.getSipApplicationDispatcher().isBypassRequestExecutor()) {
                this.batchStarted = sipContext.enterSipAppHa(true);
            }
            if (!appSession.isValidInternal()) {
                if (appSession.isOrphan() || ((SipFactoryExt)sipContext.getSipFactoryFacade()).isRouteOrphanRequests()) {
                    SubsequentRequestDispatcher.handleOrphanRequest(this.sipProvider, sipServletRequest, appSession.getId(), sipContext);
                } else {
                    throw new DispatcherException(481, "The corresponding sip application session to this subsequent request " + request + " has been invalidated or timed out.");
                }
            }
            String requestMethod = sipServletRequest.getMethod();
            try {
                if (!"ACK".equalsIgnoreCase(requestMethod)) {
                    if (!"PRACK".equalsIgnoreCase(requestMethod) && !"UPDATE".equalsIgnoreCase(requestMethod)) {
                        sipSession.setSessionCreatingTransactionRequest((MobicentsSipServletMessage)sipServletRequest);
                    }
                    sipSession.addOngoingTransaction(sipServletRequest.getTransaction());
                }
                try {
                    MobicentsProxy proxy;
                    Set ongoingTransactions;
                    SubscriptionStateHeader subscriptionStateHeader;
                    if ("NOTIFY".equals(requestMethod) && sipSession.getProxy() == null && (subscriptionStateHeader = (SubscriptionStateHeader)sipServletRequest.getMessage().getHeader("Subscription-State")) != null && ("active".equalsIgnoreCase(subscriptionStateHeader.getState()) || "pending".equalsIgnoreCase(subscriptionStateHeader.getState()))) {
                        sipSession.addSubscription((MobicentsSipServletMessage)sipServletRequest);
                    }
                    boolean callServlet = true;
                    if ("ACK".equalsIgnoreCase(requestMethod) && (ongoingTransactions = sipSession.getOngoingTransactions()) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"going through all Stx to check if we need to pass the ACK up to the application");
                        }
                        for (Transaction transaction : ongoingTransactions) {
                            SipServletMessageImpl sipServletMessage;
                            TransactionApplicationData tad;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(" tx to check " + transaction));
                            }
                            if (!(transaction instanceof ServerTransaction) || !((SIPTransaction)transaction).getMethod().equals("INVITE")) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Stx found " + transaction.getBranchId() + " to check if we need to pass the ACK up to the application"));
                            }
                            if ((tad = (TransactionApplicationData)transaction.getApplicationData()) == null || (sipServletMessage = tad.getSipServletMessage()) == null || !(sipServletMessage instanceof SipServletRequestImpl) || ((MessageExt)request).getCSeqHeader().getSeqNumber() != ((MessageExt)sipServletMessage.getMessage()).getCSeqHeader().getSeqNumber()) continue;
                            SipServletRequestImpl correspondingInviteRequest = (SipServletRequestImpl)sipServletMessage;
                            SipServletResponse lastFinalResponse = correspondingInviteRequest.getLastFinalResponse();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("last final response " + lastFinalResponse + " for original request " + correspondingInviteRequest));
                            }
                            if (lastFinalResponse != null && lastFinalResponse.getStatus() >= 300) {
                                callServlet = false;
                                if (!logger.isDebugEnabled()) break;
                                logger.debug((Object)"not calling the servlet since this is an ACK for a final error response");
                                break;
                            }
                            if (lastFinalResponse != null) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"not calling the servlet since this is an ACK for a null last final response, which means the ACK was for a sip stack generated error response");
                            }
                            callServlet = false;
                            break;
                        }
                    }
                    if ((proxy = sipSession.getProxy()) != null) {
                        MobicentsProxyBranch finalBranch = proxy.getFinalBranchForSubsequentRequests();
                        boolean isPrack = requestMethod.equalsIgnoreCase("PRACK");
                        boolean isUpdate = requestMethod.equalsIgnoreCase("UPDATE");
                        boolean isNotify = requestMethod.equalsIgnoreCase("NOTIFY");
                        sipSession.updateStateOnSubsequentRequest((MobicentsSipServletRequest)sipServletRequest, true);
                        if (finalBranch != null) {
                            proxy.setAckReceived(requestMethod.equalsIgnoreCase("ACK"));
                            this.checkRequestURIForNonCompliantAgents(finalBranch, request);
                            proxy.setOriginalRequest((MobicentsSipServletRequest)sipServletRequest);
                            if (callServlet) {
                                MessageDispatcher.callServlet(sipServletRequest);
                                finalBranch.proxySubsequentRequest((MobicentsSipServletRequest)sipServletRequest);
                            }
                        } else if (isPrack || isUpdate || isNotify) {
                            MessageDispatcher.callServlet(sipServletRequest);
                            List branches = proxy.getProxyBranches();
                            for (ProxyBranch pb : branches) {
                                ProxyBranchImpl proxyBranch = (ProxyBranchImpl)pb;
                                if (proxyBranch.isWaitingForPrack() && isPrack) {
                                    proxyBranch.proxyDialogStateless(sipServletRequest);
                                    proxyBranch.setWaitingForPrack(false);
                                    continue;
                                }
                                String requestToTag = ((RequestExt)request).getToHeader().getTag();
                                SipServletResponseImpl proxyResponse = (SipServletResponseImpl)proxyBranch.getResponse();
                                if (isNotify && proxyResponse == null) {
                                    SipServletRequestImpl subscribeRequest;
                                    String subscribeFromTag;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)"NOTIFY Request and response not yet received at proxy, checking request's To header tag against proxyBranch's request From tag in order to identify the proxyBranch for this request ");
                                    }
                                    if (!(subscribeFromTag = ((MessageExt)(subscribeRequest = (SipServletRequestImpl)proxyBranch.getRequest()).getMessage()).getFromHeader().getTag()).equals(requestToTag)) continue;
                                    finalBranch = proxyBranch;
                                    this.checkRequestURIForNonCompliantAgents(finalBranch, request);
                                    finalBranch.proxySubsequentRequest((MobicentsSipServletRequest)sipServletRequest);
                                    continue;
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Checking request's To header tag against proxyBranch's From tag and To tagin order to identify the proxyBranch for this request ");
                                }
                                String proxyToTag = ((MessageExt)proxyResponse.getMessage()).getToHeader().getTag();
                                String proxyFromTag = ((MessageExt)proxyResponse.getMessage()).getFromHeader().getTag();
                                if (!proxyToTag.equals(requestToTag) && !proxyFromTag.equals(requestToTag)) continue;
                                finalBranch = proxyBranch;
                                this.checkRequestURIForNonCompliantAgents(finalBranch, request);
                                finalBranch.proxySubsequentRequest((MobicentsSipServletRequest)sipServletRequest);
                            }
                            if (finalBranch == null && isUpdate) {
                                logger.warn((Object)"Final branch is null, enable debug for more information.");
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Final branch is null, this will probably result in a lost call or request. Here is the request:\n" + request), (Throwable)new RuntimeException("Final branch is null"));
                                }
                            }
                        } else if (!"ACK".equalsIgnoreCase(requestMethod)) {
                            logger.warn((Object)"Final branch is null, enable debug for more information.");
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Final branch is null, this will probably result in a lost call or request. Here is the request:\n" + request), (Throwable)new RuntimeException("Final branch is null"));
                            }
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Final branch is null, Here is the request:\n" + request));
                        }
                    } else {
                        sipSession.updateStateOnSubsequentRequest((MobicentsSipServletRequest)sipServletRequest, true);
                        if (callServlet) {
                            MessageDispatcher.callServlet(sipServletRequest);
                        }
                    }
                }
                catch (ServletException e) {
                    throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, (Throwable)e);
                }
                catch (SipException e) {
                    throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, (Throwable)e);
                }
                catch (IOException e) {
                    throw new DispatcherException(500, "An unexpected servlet exception occured while processing the following subsequent request " + request, (Throwable)e);
                }
            }
            finally {
                Transaction transaction;
                SubscriptionStateHeader subscriptionStateHeader;
                if ("NOTIFY".equals(requestMethod) && sipSession.getProxy() == null && (subscriptionStateHeader = (SubscriptionStateHeader)sipServletRequest.getMessage().getHeader("Subscription-State")) != null && "terminated".equalsIgnoreCase(subscriptionStateHeader.getState())) {
                    sipSession.removeSubscription((MobicentsSipServletMessage)sipServletRequest);
                }
                if ("ACK".equals(requestMethod) && (transaction = sipServletRequest.getTransaction()) != null) {
                    TransactionApplicationData tad = (TransactionApplicationData)transaction.getApplicationData();
                    MobicentsProxy proxy = sipSession.getProxy();
                    if (proxy == null && tad != null) {
                        tad.cleanUp();
                        transaction.setApplicationData(null);
                    }
                    MobicentsB2BUAHelper b2buaHelperImpl = sipSession.getB2buaHelper();
                    if (proxy == null && b2buaHelperImpl == null) {
                        sipSession.removeOngoingTransaction(sipServletRequest.getTransaction());
                    }
                }
                sipContext.exitSipAppHa((MobicentsSipServletRequest)sipServletRequest, null, this.batchStarted);
                sipContext.exitSipApp(sipSession.getSipApplicationSession(), sipSession);
            }
        }

        private void checkRequestURIForNonCompliantAgents(MobicentsProxyBranch finalBranch, Request request) throws ServletParseException {
            URI requestURI = request.getRequestURI();
            if (request.getRequestURI() instanceof SipURI && ((Parameters)requestURI).getParameter("proxy") != null && requestURI instanceof SipURI) {
                String host = ((SipURI)requestURI).getHost();
                int port = ((SipURI)requestURI).getPort();
                String transport = JainSipUtils.findTransport((Message)request);
                boolean isAnotherDomain = StaticServiceHolder.sipStandardService.getSipApplicationDispatcher().isExternal(host, port, transport);
                if (!isAnotherDomain) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Non Compliant Agent targeting Mobicents directly, Changing the request URI from " + requestURI + " to " + finalBranch.getTargetURI() + " to avoid going in a loop"));
                    }
                    request.setRequestURI(((URIImpl)StaticServiceHolder.sipStandardService.getSipApplicationDispatcher().getSipFactory().createURI(finalBranch.getTargetURI())).getURI());
                }
            }
        }
    }
}

