/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.core;

import java.util.ArrayList;

public class ApplicationRoutingHeaderStack {
    private ArrayList<ApplicationRouterNode> nodes = new ArrayList();

    public ApplicationRoutingHeaderStack(String text) {
        String[] txtNodes;
        if (text == null) {
            return;
        }
        for (String node : txtNodes = text.split("/")) {
            String[] params = node.split("!");
            ApplicationRouterNode arNode = new ApplicationRouterNode(params[0], params[1]);
            this.nodes.add(arNode);
        }
    }

    public void addNode(ApplicationRouterNode node) {
        this.nodes.add(node);
    }

    public void removeLast() {
        if (this.nodes.size() <= 0) {
            return;
        }
        this.nodes.remove(0);
    }

    public ApplicationRouterNode getLast() {
        return this.nodes.get(0);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int q = 0; q < this.nodes.size(); ++q) {
            text.append(this.nodes.get((int)q).application).append("!").append(this.nodes.get((int)q).handler).append("/");
        }
        if (text.length() > 0) {
            text.append(text.substring(0, text.length() - 1));
        }
        return text.toString();
    }

    public static class ApplicationRouterNode {
        public String application;
        public String handler;

        public ApplicationRouterNode(String app, String handler) {
            this.application = app;
            this.handler = handler;
        }
    }
}

