/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.message;

import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.SipServletRequest;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.RSeqHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RequireHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.address.AddressImpl;
import org.mobicents.servlet.sip.core.RoutingState;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletMessage;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxy;
import org.mobicents.servlet.sip.core.proxy.MobicentsProxyBranch;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletMessageImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.message.TransactionApplicationData;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;

public abstract class SipServletResponseImpl
extends SipServletMessageImpl
implements MobicentsSipServletResponse {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SipServletResponseImpl.class);
    SipServletRequestImpl originalRequest;
    ProxyBranch proxyBranch;
    private boolean isProxiedResponse;
    private boolean isResponseForwardedUpstream;
    private boolean isAckGenerated;
    private boolean isPrackGenerated;
    private boolean hasBeenReceived;
    private boolean isRetransmission;
    private boolean branchResponse;
    private boolean orphanRequest;

    public SipServletResponseImpl() {
    }

    protected SipServletResponseImpl(Response response, SipFactoryImpl sipFactoryImpl, Transaction transaction, MobicentsSipSession session, Dialog dialog, boolean hasBeenReceived, boolean isRetransmission) {
        super((Message)response, sipFactoryImpl, transaction, session, dialog);
        this.setProxiedResponse(false);
        this.isResponseForwardedUpstream = false;
        this.isAckGenerated = false;
        this.hasBeenReceived = hasBeenReceived;
        this.isRetransmission = isRetransmission;
    }

    public Response getResponse() {
        return (Response)this.message;
    }

    @Override
    public AddressImpl.ModifiableRule getModifiableRule(String headerName) {
        AddressImpl.ModifiableRule overriden = this.retrieveModifiableOverriden();
        if (overriden != null) {
            return overriden;
        }
        String hName = SipServletResponseImpl.getFullHeaderName(headerName);
        boolean isSystemHeader = JainSipUtils.SYSTEM_HEADERS.contains(hName);
        if (isSystemHeader) {
            return AddressImpl.ModifiableRule.NotModifiable;
        }
        if (headerName.equalsIgnoreCase("From")) {
            return AddressImpl.ModifiableRule.NotModifiable;
        }
        if (headerName.equalsIgnoreCase("To")) {
            return AddressImpl.ModifiableRule.NotModifiable;
        }
        if (hName.equals("Contact")) {
            Response sipResponse = (Response)this.message;
            String method = ((CSeqHeader)sipResponse.getHeader("CSeq")).getMethod();
            if (method.equals("REGISTER") || 300 <= sipResponse.getStatusCode() && sipResponse.getStatusCode() < 400 && !method.equals("CANCEL") || sipResponse.getStatusCode() == 485 && !method.equals("PRACK") && !method.equals("CANCEL") || sipResponse.getStatusCode() == 200 && method.equals("OPTIONS")) {
                return AddressImpl.ModifiableRule.ContactNotSystem;
            }
            return AddressImpl.ModifiableRule.ContactSystem;
        }
        return AddressImpl.ModifiableRule.Modifiable;
    }

    public SipServletRequest createAck() {
        Response response = this.getResponse();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transaction " + this.getTransaction()));
            logger.debug((Object)("originalRequest " + this.originalRequest));
        }
        if (this.getTransaction() == null && this.originalRequest != null && !"INVITE".equals(this.getMethod()) && !"INVITE".equals(this.originalRequest.getMethod()) || this.getTransaction() != null && !"INVITE".equals(((SIPTransaction)this.getTransaction()).getMethod()) || response.getStatusCode() >= 100 && response.getStatusCode() < 200 || this.isAckGenerated) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transaction state " + ((SIPTransaction)this.getTransaction()).getMethod() + " status code " + response.getStatusCode() + " isAckGenerated " + this.isAckGenerated));
            }
            throw new IllegalStateException("the transaction state is such that it doesn't allow an ACK to be sent now, e.g. the original request was not an INVITE, or this response is provisional only, or an ACK has already been generated");
        }
        MobicentsSipSession session = this.getSipSession();
        Dialog dialog = session.getSessionCreatingDialog();
        CSeqHeader cSeqHeader = (CSeqHeader)response.getHeader("CSeq");
        SipServletRequestImpl sipServletAckRequest = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dialog to create the ack Request " + dialog));
            }
            Request ackRequest = dialog.createAck(cSeqHeader.getSeqNumber());
            ackRequest.removeHeader("Via");
            if (logger.isInfoEnabled()) {
                logger.info((Object)("ackRequest just created " + ackRequest));
            }
            ListIterator routeHeaders = ackRequest.getHeaders("Route");
            ackRequest.removeHeader("Route");
            while (routeHeaders.hasNext()) {
                RouteHeader routeHeader = (RouteHeader)routeHeaders.next();
                String serverId = ((SipURI)routeHeader.getAddress().getURI()).getParameter("as");
                String routeAppNameHashed = ((SipURI)routeHeader.getAddress().getURI()).getParameter("appname");
                String routeAppName = null;
                if (routeAppNameHashed != null) {
                    routeAppName = this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationNameFromHash(routeAppNameHashed);
                }
                if (routeAppName != null && this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationServerId().equalsIgnoreCase(serverId) && routeAppName.equals(this.getSipSession().getKey().getApplicationName())) continue;
                ackRequest.addHeader((Header)routeHeader);
            }
            sipServletAckRequest = (SipServletRequestImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(ackRequest, this.getSipSession(), this.getTransaction(), dialog, false);
            this.isAckGenerated = true;
        }
        catch (InvalidArgumentException e) {
            logger.error((Object)"Impossible to create the ACK", (Throwable)e);
        }
        catch (SipException e) {
            logger.error((Object)"Impossible to create the ACK", (Throwable)e);
        }
        return sipServletAckRequest;
    }

    public SipServletRequest createPrack() throws Rel100Exception {
        Response response = this.getResponse();
        if (response.getStatusCode() == 100 && response.getStatusCode() >= 200 || this.isPrackGenerated) {
            throw new IllegalStateException("the transaction state is such that it doesn't allow a PRACK to be sent now, or this response is provisional only, or a PRACK has already been generated");
        }
        if (!"INVITE".equals(this.getTransaction().getRequest().getMethod())) {
            throw new Rel100Exception(1);
        }
        MobicentsSipSession session = this.getSipSession();
        Dialog dialog = session.getSessionCreatingDialog();
        SipServletRequestImpl sipServletPrackRequest = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dialog to create the prack Request " + dialog));
            }
            Request prackRequest = dialog.createPrack(response);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("prackRequest just created " + prackRequest));
            }
            prackRequest.removeHeader("Via");
            SipApplicationDispatcher sipApplicationDispatcher = this.sipFactoryImpl.getSipApplicationDispatcher();
            String branch = JainSipUtils.createBranch(session.getSipApplicationSession().getKey().getId(), sipApplicationDispatcher.getHashFromApplicationName(session.getSipApplicationSession().getKey().getApplicationName()));
            ViaHeader viaHeader = JainSipUtils.createViaHeader(this.sipFactoryImpl.getSipNetworkInterfaceManager(), prackRequest, branch, session.getOutboundInterface());
            prackRequest.addHeader((Header)viaHeader);
            ListIterator routeHeaders = prackRequest.getHeaders("Route");
            prackRequest.removeHeader("Route");
            while (routeHeaders.hasNext()) {
                RouteHeader routeHeader = (RouteHeader)routeHeaders.next();
                String serverId = ((SipURI)routeHeader.getAddress().getURI()).getParameter("as");
                String routeAppNameHashed = ((SipURI)routeHeader.getAddress().getURI()).getParameter("appname");
                String routeAppName = null;
                if (routeAppNameHashed != null) {
                    routeAppName = this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationNameFromHash(routeAppNameHashed);
                }
                if (routeAppName != null && this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationServerId().equalsIgnoreCase(serverId) && routeAppName.equals(this.getSipSession().getKey().getApplicationName())) continue;
                prackRequest.addHeader((Header)routeHeader);
            }
            sipServletPrackRequest = (SipServletRequestImpl)this.sipFactoryImpl.getMobicentsSipServletMessageFactory().createSipServletRequest(prackRequest, this.getSipSession(), this.getTransaction(), dialog, false);
            this.isPrackGenerated = true;
        }
        catch (SipException e) {
            logger.error((Object)"Impossible to create the ACK", (Throwable)e);
        }
        return sipServletPrackRequest;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return null;
    }

    public Proxy getProxy() {
        if (this.proxyBranch != null) {
            return this.proxyBranch.getProxy();
        }
        return this.getSipSession().getProxy();
    }

    public String getReasonPhrase() {
        return this.getResponse().getReasonPhrase();
    }

    public SipServletRequest getRequest() {
        return this.originalRequest;
    }

    public int getStatus() {
        return this.getResponse().getStatusCode();
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public void sendReliably() throws Rel100Exception {
        int statusCode = this.getStatus();
        if (statusCode == 100 || statusCode >= 200) {
            throw new Rel100Exception(0);
        }
        if (!"INVITE".equals(this.originalRequest.getMethod())) {
            throw new Rel100Exception(1);
        }
        if (!this.containsRel100(this.originalRequest.getMessage())) {
            throw new Rel100Exception(2);
        }
        try {
            this.send(true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setStatus(int statusCode) {
        try {
            this.getResponse().setStatusCode(statusCode);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setStatus(int statusCode, String reasonPhrase) {
        try {
            Response response = this.getResponse();
            response.setStatusCode(statusCode);
            response.setReasonPhrase(reasonPhrase);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void flushBuffer() throws IOException {
    }

    public int getBufferSize() {
        return 0;
    }

    public Locale getLocale() {
        return null;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int arg0) {
    }

    public void setLocale(Locale arg0) {
    }

    @Override
    public void send() throws IOException {
        this.send(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(boolean sendReliably) throws IOException {
        if (this.isMessageSent) {
            throw new IllegalStateException("message already sent");
        }
        if (this.hasBeenReceived) {
            throw new IllegalStateException("this response was received from downstream");
        }
        try {
            Dialog dialog;
            Response response = this.getResponse();
            int statusCode = response.getStatusCode();
            MobicentsSipSession session = this.getSipSession();
            MobicentsSipApplicationSession sipApplicationSession = session.getSipApplicationSession();
            MobicentsSipApplicationSessionKey sipAppSessionKey = sipApplicationSession.getKey();
            MobicentsProxy proxy = session.getProxy();
            if (proxy != null && proxy.getFinalBranchForSubsequentRequests() == null && this.proxyBranch != null && this.proxyBranch.getRecordRoute() && statusCode > 100 && statusCode <= 606) {
                SipURI sipURI = JainSipUtils.createRecordRouteURI(this.sipFactoryImpl.getSipNetworkInterfaceManager(), (Message)response);
                sipURI.setParameter("as", this.sipFactoryImpl.getSipApplicationDispatcher().getApplicationServerId());
                sipURI.setParameter("appname", this.sipFactoryImpl.getSipApplicationDispatcher().getHashFromApplicationName(session.getKey().getApplicationName()));
                sipURI.setParameter("app_id", sipAppSessionKey.getId());
                sipURI.setLrParam();
                Address recordRouteAddress = SipFactoryImpl.addressFactory.createAddress((URI)sipURI);
                RecordRouteHeader recordRouteHeader = SipFactoryImpl.headerFactory.createRecordRouteHeader(recordRouteAddress);
                response.addFirst((Header)recordRouteHeader);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Record Route added to the response " + recordRouteHeader));
                }
            }
            ServerTransaction transaction = (ServerTransaction)this.getTransaction();
            session.updateStateOnResponse((MobicentsSipServletResponse)this, false);
            if ("SUBSCRIBE".equals(this.getMethod()) && statusCode >= 200 && statusCode <= 300 && session.getProxy() == null) {
                session.addSubscription((MobicentsSipServletMessage)this);
            }
            if (sendReliably) {
                if (!this.containsRel100((Message)response)) {
                    RequireHeader requireHeader = SipFactoryImpl.headerFactory.createRequireHeader("100rel");
                    response.addHeader((Header)requireHeader);
                }
                RSeqHeader rseqHeader = SipFactoryImpl.headerFactory.createRSeqHeader(this.getTransactionApplicationData().getRseqNumber().getAndIncrement());
                response.addHeader((Header)rseqHeader);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sending response " + this.message));
            }
            if (this.originalRequest == null && proxy != null) {
                String txid = ((ViaHeader)this.message.getHeader("Via")).getBranch();
                TransactionApplicationData tad = (TransactionApplicationData)proxy.getTransactionMap().get(txid);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to recover lost transaction for proxy: " + txid));
                }
                if (tad != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Recovering lost transaction from the proxy transaction map is succesful: " + txid));
                    }
                    this.originalRequest = (SipServletRequestImpl)tad.getSipServletMessage();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("original req " + this.originalRequest));
                if (this.originalRequest != null) {
                    logger.debug((Object)("original req routing state " + (Object)((Object)this.originalRequest.getRoutingState())));
                }
                if (transaction != null) {
                    logger.debug((Object)("transaction dialog " + transaction.getDialog()));
                }
            }
            if (!"CANCEL".equals(this.originalRequest.getMethod()) && (RoutingState.INITIAL.equals((Object)this.originalRequest.getRoutingState()) || RoutingState.RELAYED.equals((Object)this.originalRequest.getRoutingState())) && transaction.getDialog() == null && JainSipUtils.DIALOG_CREATING_METHODS.contains(this.getMethod())) {
                String transport = JainSipUtils.findTransport((Message)transaction.getRequest());
                SipProvider sipProvider = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
                Dialog dialog2 = null;
                if (statusCode != 100 && statusCode < 300) {
                    dialog2 = sipProvider.getNewDialog((Transaction)transaction);
                    ((DialogExt)dialog2).disableSequenceNumberValidation();
                }
                session.setSessionCreatingDialog(dialog2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("created following dialog since the application is acting as an endpoint " + dialog2));
                }
            }
            Dialog dialog3 = dialog = transaction == null ? null : transaction.getDialog();
            if (dialog != null) {
                TransactionApplicationData originalRequestAppData = this.originalRequest.getTransactionApplicationData();
                if (originalRequestAppData != null) {
                    dialog.setApplicationData((Object)originalRequestAppData);
                }
                ((TransactionApplicationData)dialog.getApplicationData()).setTransaction((Transaction)transaction);
            }
            if (statusCode >= 200 && statusCode <= 606) {
                this.originalRequest.setRoutingState(RoutingState.FINAL_RESPONSE_SENT);
            }
            if (this.originalRequest != null) {
                this.originalRequest.setResponse(this);
                if (this.originalRequest.getTransaction() != null && this.originalRequest.getTransaction().getApplicationData() != null && ((TransactionApplicationData)this.originalRequest.getTransaction().getApplicationData()).getSipServletMessage() != null && ((TransactionApplicationData)this.originalRequest.getTransaction().getApplicationData()).getSipServletMessage() instanceof SipServletRequestImpl) {
                    ((SipServletRequestImpl)((TransactionApplicationData)this.originalRequest.getTransaction().getApplicationData()).getSipServletMessage()).setResponse(this);
                }
            }
            session.access();
            sipApplicationSession.access();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = sipApplicationSession.getSipContext().getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                if (transaction == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sending response statelessly " + this.message));
                    }
                    String transport = JainSipUtils.findTransport(((SipServletRequestImpl)this.getRequest()).getMessage());
                    SipProvider sipProvider = this.sipFactoryImpl.getSipNetworkInterfaceManager().findMatchingListeningPoint(transport, false).getSipProvider();
                    sipProvider.sendResponse((Response)this.message);
                } else if (sendReliably) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sending response reliably " + this.message));
                    }
                    dialog.sendReliableProvisionalResponse((Response)this.message);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sending response " + this.message + " through tx " + transaction));
                    }
                    if (proxy != null && transaction.getDialog() != null && transaction instanceof SIPServerTransaction) {
                        ((SIPServerTransaction)transaction).setDialog(null, null);
                    }
                    transaction.sendResponse((Response)this.message);
                    this.sipFactoryImpl.getSipApplicationDispatcher().updateResponseStatistics((Response)this.message, false);
                    if (dialog != null) {
                        session.setSessionCreatingDialog(dialog);
                    }
                }
                this.isMessageSent = true;
                if (this.isProxiedResponse) {
                    this.isResponseForwardedUpstream = true;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IllegalStateException("an exception occured when sending the response " + this.message, e);
        }
    }

    public Iterator<String> getChallengeRealms() {
        ArrayList<String> realms = new ArrayList<String>();
        Response response = this.getResponse();
        if (response.getStatusCode() == 401) {
            WWWAuthenticateHeader authenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
            realms.add(authenticateHeader.getRealm());
        } else if (response.getStatusCode() == 407) {
            ProxyAuthenticateHeader authenticateHeader = (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate");
            realms.add(authenticateHeader.getRealm());
        }
        return realms.iterator();
    }

    public ProxyBranch getProxyBranch() {
        return this.proxyBranch;
    }

    public void setProxyBranch(MobicentsProxyBranch proxyBranch) {
        this.proxyBranch = proxyBranch;
        if (proxyBranch != null && this.getStatus() >= 200) {
            this.branchResponse = true;
        }
    }

    public boolean isBranchResponse() {
        return this.branchResponse;
    }

    public void setBranchResponse(boolean branchResponse) {
        this.branchResponse = branchResponse;
    }

    public boolean isCommitted() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            if (tx instanceof ClientTransaction && this.getStatus() >= 101 && this.getStatus() <= 199 && this.getHeader("RSeq") == null) {
                return this.proxyBranch == null;
            }
            if (tx instanceof ClientTransaction && this.getStatus() >= 101 && this.getStatus() <= 199 && this.getHeader("RSeq") != null && TransactionState.TERMINATED.equals((Object)tx.getState())) {
                return this.proxyBranch == null;
            }
            if (tx instanceof ClientTransaction && this.getStatus() >= 200 && this.getStatus() <= 999 && !"INVITE".equals(((SIPClientTransaction)tx).getMethod())) {
                return this.proxyBranch == null;
            }
            if (this.isResponseForwardedUpstream) {
                return true;
            }
            if (tx instanceof ClientTransaction && this.getStatus() >= 200 && this.getStatus() <= 999 && TransactionState.TERMINATED.equals((Object)tx.getState()) && this.isAckGenerated) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void checkMessageState() {
        if (this.isMessageSent || this.getTransaction() instanceof ClientTransaction) {
            throw new IllegalStateException("Message already sent or incoming message");
        }
    }

    public void setOriginalRequest(SipServletRequestImpl originalRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("original request set to " + originalRequest + " for response " + this.message));
        }
        this.originalRequest = originalRequest;
    }

    public void setProxiedResponse(boolean isProxiedResponse) {
        this.isProxiedResponse = isProxiedResponse;
    }

    public boolean isProxiedResponse() {
        return this.isProxiedResponse;
    }

    @Override
    public void setCharacterEncoding(String enc) {
        try {
            this.message.setContentEncoding(SipFactoryImpl.headerFactory.createContentEncodingHeader(enc));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Encoding " + enc + " not valid", ex);
        }
    }

    @Override
    public void cleanUp() {
        this.originalRequest = null;
        this.proxyBranch = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isProxyBranchSerialized;
        super.readExternal(in);
        String messageString = in.readUTF();
        try {
            this.message = SipFactoryImpl.messageFactory.createResponse(messageString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Message " + messageString + " previously serialized could not be reparsed", e);
        }
        boolean isOriginalRequestSerialized = in.readBoolean();
        if (isOriginalRequestSerialized) {
            this.originalRequest = (SipServletRequestImpl)in.readObject();
        }
        if (isProxyBranchSerialized = in.readBoolean()) {
            this.proxyBranch = (ProxyBranchImpl)in.readObject();
        }
        this.isProxiedResponse = in.readBoolean();
        this.isResponseForwardedUpstream = in.readBoolean();
        this.isAckGenerated = in.readBoolean();
        this.isPrackGenerated = in.readBoolean();
        this.hasBeenReceived = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.originalRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.originalRequest);
        }
        if (this.proxyBranch == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.proxyBranch);
        }
        out.writeBoolean(this.isProxiedResponse);
        out.writeBoolean(this.isResponseForwardedUpstream);
        out.writeBoolean(this.isAckGenerated);
        out.writeBoolean(this.isPrackGenerated);
        out.writeBoolean(this.hasBeenReceived);
    }

    public boolean isRetransmission() {
        return this.isRetransmission;
    }

    @Override
    public String getRemoteAddr() {
        if (!this.hasBeenReceived) {
            return null;
        }
        return super.getRemoteAddr();
    }

    @Override
    public int getRemotePort() {
        if (!this.hasBeenReceived) {
            return -1;
        }
        return super.getRemotePort();
    }
}

