/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.rfc5626;

import gov.nist.javax.sip.header.ims.PathHeader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.message.Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.JainSipUtils;
import org.mobicents.servlet.sip.core.HopImpl;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.message.SipServletRequestImpl;
import org.mobicents.servlet.sip.proxy.ProxyBranchImpl;
import org.mobicents.servlet.sip.proxy.ProxyImpl;
import org.mobicents.servlet.sip.rfc5626.IncorrectFlowIdentifierException;

public class RFC5626Helper {
    private static final Logger logger = Logger.getLogger(ProxyBranchImpl.class);
    private static final String ALGORITHM = "HmacSHA1";
    private static Mac mac = null;
    private static SecretKey secretKey = null;

    public static void checkRequest(ProxyBranchImpl proxyBranch, Request request, SipServletRequestImpl originalRequest) throws IncorrectFlowIdentifierException {
        if (!((ProxyImpl)proxyBranch.getProxy()).getSipOutboundSupport()) {
            return;
        }
        ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
        ProxyImpl proxy = (ProxyImpl)proxyBranch.getProxy();
        if (proxyBranch.isAddToPath() && request.getMethod().equalsIgnoreCase("REGISTER")) {
            if (contactHeader != null && contactHeader.getParameter("reg-id") != null) {
                int nbVias;
                ListIterator vias = request.getHeaders("Via");
                for (nbVias = 0; vias.hasNext() && nbVias <= 2; ++nbVias) {
                    vias.next();
                }
                if (nbVias == 2) {
                    PathHeader pathHeader = (PathHeader)request.getHeader("Path");
                    SipURI pathURI = (SipURI)pathHeader.getAddress().getURI();
                    String flowToken = RFC5626Helper.generateFlowToken(originalRequest);
                    try {
                        pathURI.setUser(flowToken);
                        pathURI.setParameter("ob", null);
                    }
                    catch (ParseException e) {
                        logger.error((Object)("Impossible to add the ob parameter to the following path header " + pathHeader + " or flow token " + flowToken), (Throwable)e);
                    }
                }
            }
        } else {
            RouteHeader poppedRouteHeader = originalRequest.getPoppedRouteHeader();
            boolean poppedRouteHasObParam = false;
            boolean contactHasObParam = false;
            if (poppedRouteHeader != null && poppedRouteHeader.getParameter("ob") != null) {
                poppedRouteHasObParam = true;
            }
            if (contactHeader != null && contactHeader.getParameter("reg-id") != null) {
                contactHasObParam = true;
            }
            SipURI poppedURI = (SipURI)poppedRouteHeader.getAddress().getURI();
            String user = poppedURI.getUser();
            HopImpl hop = null;
            if (user != null) {
                hop = RFC5626Helper.decodeFlowToken(user);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Hop " + hop + " poppedRouteHasObParam " + poppedRouteHasObParam + " contactHasObParam " + contactHasObParam + " InitialRemoteAddr " + originalRequest.getInitialRemoteAddr() + " InitialRemotePort " + originalRequest.getInitialRemotePort()));
                }
            }
            if (hop == null && !poppedRouteHasObParam && !contactHasObParam) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"no RFC5626 flow idenitifer, returning");
                }
                return;
            }
            if (hop != null && hop.getHost().equals(originalRequest.getInitialRemoteAddr()) && hop.getPort() == originalRequest.getInitialRemotePort() || hop == null && (contactHasObParam || poppedRouteHasObParam)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RFC5626 Outgoing Case " + request));
                }
                if (originalRequest.isInitial()) {
                    RFC5626Helper.addRecordRouteHeader(request, proxy.getSipFactoryImpl(), poppedURI);
                }
            } else if (hop != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RFC5626 Incoming Case " + request));
                }
                SipFactoryImpl sipFactoryImpl = proxy.getSipFactoryImpl();
                if (originalRequest.isInitial() && JainSipUtils.DIALOG_CREATING_METHODS.contains(originalRequest.getMethod())) {
                    RFC5626Helper.addRecordRouteHeader(request, sipFactoryImpl, poppedURI);
                }
                try {
                    SipURI routeURI = sipFactoryImpl.getAddressFactory().createSipURI(null, hop.getHost());
                    routeURI.setPort(hop.getPort());
                    routeURI.setTransportParam(hop.getTransport());
                    routeURI.setLrParam();
                    RouteHeader routeHeader = sipFactoryImpl.getHeaderFactory().createRouteHeader(sipFactoryImpl.getAddressFactory().createAddress((URI)routeURI));
                    request.addHeader((Header)routeHeader);
                }
                catch (ParseException e) {
                    logger.error((Object)("Impossible to parse the following popped URI " + poppedURI), (Throwable)e);
                }
            }
        }
    }

    private static void addRecordRouteHeader(Request request, SipFactoryImpl sipFactoryImpl, SipURI poppedURI) {
        try {
            SipURI recordRouteURI = (SipURI)((RecordRouteHeader)request.getHeader("Record-Route")).getAddress().getURI();
            SipURI newRecordRouteURI = (SipURI)sipFactoryImpl.getAddressFactory().createURI(recordRouteURI.toString());
            newRecordRouteURI.removeParameter("ob");
            newRecordRouteURI.setUser(poppedURI.getUser());
            RecordRouteHeader recordRouteHeader = sipFactoryImpl.getHeaderFactory().createRecordRouteHeader(sipFactoryImpl.getAddressFactory().createAddress((URI)newRecordRouteURI));
            request.removeFirst("Record-Route");
            request.addFirst((Header)recordRouteHeader);
        }
        catch (ParseException e) {
            logger.error((Object)("Impossible to parse the following popped URI " + poppedURI), (Throwable)e);
        }
        catch (SipException e) {
            logger.error((Object)"Impossible to add the following recordRouteHeader ", (Throwable)e);
        }
    }

    private static HopImpl decodeFlowToken(String user) throws IncorrectFlowIdentifierException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Decoding RFC 5626 Flow token " + user));
        }
        byte[] byteConcat = Base64.decodeBase64((byte[])user.getBytes());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Decoding RFC 5626 Flow token byteContact after base64 decoding is " + new String(byteConcat).trim()));
        }
        String concatenation = new String(byteConcat);
        int indexOfSlash = concatenation.indexOf("/");
        String hmac = concatenation.substring(0, indexOfSlash);
        String arrayS = concatenation.substring(indexOfSlash + 1, concatenation.length());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Decoding RFC 5626 Flow token recomputing hmac of array S " + arrayS));
        }
        byte[] recomputedHmac = mac.doFinal(arrayS.trim().getBytes());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Decoding RFC 5626 Flow token recomputed Hmac" + recomputedHmac));
        }
        recomputedHmac = new String(recomputedHmac).trim().getBytes();
        if (!Arrays.equals(hmac.trim().getBytes(), recomputedHmac)) {
            throw new IncorrectFlowIdentifierException("hmac " + hmac + " is different from the recomputed hmac " + new String(recomputedHmac).trim());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(arrayS, "_");
        String transport = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String initialRemoteAddress = stringTokenizer.nextToken();
        int initialRemotePort = Integer.parseInt(stringTokenizer.nextToken());
        return new HopImpl(initialRemoteAddress, initialRemotePort, transport);
    }

    private static String generateFlowToken(SipServletRequestImpl request) {
        StringBuffer arrayS = new StringBuffer();
        arrayS.append(request.getTransport());
        arrayS.append("_");
        arrayS.append(request.getLocalAddr());
        arrayS.append("_");
        arrayS.append(request.getLocalPort());
        arrayS.append("_");
        arrayS.append(request.getInitialRemoteAddr());
        arrayS.append("_");
        arrayS.append(request.getInitialRemotePort());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating RFC 5626 Flow token from " + arrayS));
        }
        byte[] byteArrayS = arrayS.toString().trim().getBytes();
        byte[] hmac = mac.doFinal(byteArrayS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating RFC 5626 Flow token hmac is " + new String(hmac).trim()));
        }
        hmac = new String(hmac).trim().getBytes();
        byte[] concatDelimiter = "/".getBytes();
        byte[] byteConcat = new byte[hmac.length + concatDelimiter.length + byteArrayS.length];
        System.arraycopy(hmac, 0, byteConcat, 0, hmac.length);
        System.arraycopy(concatDelimiter, 0, byteConcat, hmac.length, concatDelimiter.length);
        System.arraycopy(byteArrayS, 0, byteConcat, hmac.length + concatDelimiter.length, byteArrayS.length);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating RFC 5626 Flow token byteContact before base64 encoding is " + new String(byteConcat).trim()));
        }
        byte[] base64Encoded = Base64.encodeBase64((byte[])byteConcat);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating RFC 5626 Flow token byteContact after base64 encoding is " + new String(base64Encoded).trim()));
        }
        return new String(base64Encoded).trim();
    }

    static {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            keyGenerator.init(160);
            secretKey = keyGenerator.generateKey();
            mac = Mac.getInstance(ALGORITHM);
            mac.init(secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"Couldn't find algorithm HmacSHA1", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("Invalid Key " + secretKey), (Throwable)e);
        }
    }
}

