/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.sip;

import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

public abstract class SipServlet
extends GenericServlet {
    public static final String OUTBOUND_INTERFACES = "javax.servlet.sip.outboundInterfaces";
    public static final String SIP_FACTORY = "javax.servlet.sip.SipFactory";
    public static final String SIP_SESSIONS_UTIL = "javax.servlet.sip.SipSessionsUtil";
    public static final String SUPPORTED = "javax.servlet.sip.supported";
    public static final String SUPPORTED_RFCs = "javax.servlet.sip.supportedRfcs";
    public static final String PRACK_SUPPORTED = "javax.servlet.sip.100rel";
    public static final String TIMER_SERVICE = "javax.servlet.sip.TimerService";

    protected void doAck(SipServletRequest req) throws ServletException, IOException {
    }

    protected void doBranchResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doBye(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doCancel(SipServletRequest req) throws ServletException, IOException {
    }

    protected void doErrorResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doInfo(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doInvite(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doMessage(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notImplemented(req);
        }
    }

    protected void doNotify(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notImplemented(req);
        }
    }

    protected void doOptions(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doPrack(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doProvisionalResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doPublish(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notImplemented(req);
        }
    }

    protected void doRedirectResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doRefer(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doRegister(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doRequest(SipServletRequest req) throws ServletException, IOException {
        String m = req.getMethod();
        if ("INVITE".equals(m)) {
            this.doInvite(req);
        } else if ("ACK".equals(m)) {
            this.doAck(req);
        } else if ("OPTIONS".equals(m)) {
            this.doOptions(req);
        } else if ("BYE".equals(m)) {
            this.doBye(req);
        } else if ("CANCEL".equals(m)) {
            this.doCancel(req);
        } else if ("REGISTER".equals(m)) {
            this.doRegister(req);
        } else if ("SUBSCRIBE".equals(m)) {
            this.doSubscribe(req);
        } else if ("NOTIFY".equals(m)) {
            this.doNotify(req);
        } else if ("MESSAGE".equals(m)) {
            this.doMessage(req);
        } else if ("INFO".equals(m)) {
            this.doInfo(req);
        } else if ("REFER".equals(m)) {
            this.doRefer(req);
        } else if ("PUBLISH".equals(m)) {
            this.doPublish(req);
        } else if ("UPDATE".equals(m)) {
            this.doUpdate(req);
        } else if ("PRACK".equals(m)) {
            this.doPrack(req);
        } else if (req.isInitial()) {
            this.notHandled(req);
        }
    }

    protected void doResponse(SipServletResponse resp) throws ServletException, IOException {
        int status = resp.getStatus();
        if (status < 200) {
            this.doProvisionalResponse(resp);
        } else if (status < 300) {
            this.doSuccessResponse(resp);
        } else if (status < 400) {
            this.doRedirectResponse(resp);
        } else {
            this.doErrorResponse(resp);
        }
    }

    protected void doSubscribe(SipServletRequest req) throws ServletException, IOException {
        if (req.isInitial()) {
            this.notImplemented(req);
        }
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
    }

    protected void doUpdate(SipServletRequest req) throws ServletException, IOException {
    }

    public void log(String message) {
        this.getServletContext().log(message);
    }

    public void log(String message, Throwable t) {
        this.getServletContext().log(message, t);
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (req != null) {
            this.doRequest((SipServletRequest)req);
        } else {
            SipServletResponse response = (SipServletResponse)resp;
            if (response.isBranchResponse()) {
                this.doBranchResponse(response);
            } else {
                this.doResponse(response);
            }
        }
    }

    private void notHandled(SipServletRequest req) throws IOException {
        SipServletResponse resp = req.createResponse(500, "Request not handled by app");
        resp.send();
    }

    private void notImplemented(SipServletRequest req) throws IOException {
        SipServletResponse resp = req.createResponse(501, "Request not implemented");
        resp.send();
    }
}

