/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;

public abstract class TestHarness {
    private static final Logger logger = Logger.getLogger((String)"smpp.test");
    protected static final String LOG_FILE_NAME = "log.file.name";
    protected static String logFileName = "maplog.txt";

    protected TestHarness() {
        this.init();
    }

    public void init() {
        try {
            Properties tckProperties = new Properties();
            InputStream inStreamLog4j = TestHarness.class.getResourceAsStream("/log4j.properties");
            System.out.println("Input Stream = " + inStreamLog4j);
            Properties propertiesLog4j = new Properties();
            try {
                propertiesLog4j.load(inStreamLog4j);
                PropertyConfigurator.configure((Properties)propertiesLog4j);
            }
            catch (IOException e) {
                e.printStackTrace();
                BasicConfigurator.configure();
            }
            logger.debug((Object)"log4j configured");
            String lf = System.getProperties().getProperty(LOG_FILE_NAME);
            if (lf != null) {
                logFileName = lf;
            }
            try {
                logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), logFileName));
            }
            catch (FileNotFoundException fnfe) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

