/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.ihub;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.errors.AbsentSubscriberDiagnosticSM;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriberSM;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFactory;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSmsListener;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.NoteSubscriberPresentRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReadyForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReadyForSMResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SmsSignalInfo;
import org.mobicents.protocols.ss7.map.api.smstpdu.AddressField;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsSubmitTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsTpduType;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.service.sms.LocationInfoWithLMSIImpl;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.smsc.ihub.MAPSimulator;

public class MAPListener
implements MAPDialogListener,
MAPServiceSmsListener {
    private static final Logger logger = Logger.getLogger(MAPListener.class);
    private MAPSimulator iHubManagement = null;
    private final AtomicLong mapMessagesReceivedCounter = new AtomicLong(0L);
    private long currentMapMessageCount = 0L;
    private long now = System.currentTimeMillis();
    private final MAPErrorMessageFactory mAPErrorMessageFactory;

    protected MAPListener(MAPSimulator iHubManagement) {
        this.iHubManagement = iHubManagement;
        this.mAPErrorMessageFactory = this.iHubManagement.getMapProvider().getMAPErrorMessageFactory();
    }

    public void onDialogAccept(MAPDialog arg0, MAPExtensionContainer arg1) {
    }

    public void onDialogClose(MAPDialog arg0) {
    }

    public void onDialogDelimiter(MAPDialog dialog) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("onDialogDelimiter " + dialog.getState()));
        }
        Boolean falg = (Boolean)dialog.getUserObject();
        try {
            if (falg != null) {
                dialog.close(false);
            } else {
                dialog.send();
            }
        }
        catch (MAPException e) {
            logger.error((Object)"Error while trying to send or close dialog", (Throwable)e);
        }
    }

    public void onDialogNotice(MAPDialog arg0, MAPNoticeProblemDiagnostic arg1) {
    }

    public void onDialogProviderAbort(MAPDialog arg0, MAPAbortProviderReason arg1, MAPAbortSource arg2, MAPExtensionContainer arg3) {
    }

    public void onDialogRelease(MAPDialog dialog) {
    }

    public void onDialogRequest(MAPDialog dialog, AddressString arg1, AddressString arg2, MAPExtensionContainer arg3) {
        this.currentMapMessageCount = this.mapMessagesReceivedCounter.incrementAndGet();
        if (this.mapMessagesReceivedCounter.get() % 400L == 0L) {
            long temp = System.currentTimeMillis();
            logger.warn((Object)("Received 400 MAP Dialog requests in milli seconds " + (temp - this.now)));
            this.now = temp;
        }
    }

    public void onDialogRequestEricsson(MAPDialog arg0, AddressString arg1, AddressString arg2, AddressString arg3, AddressString arg4) {
    }

    public void onDialogTimeout(MAPDialog arg0) {
    }

    public void onDialogUserAbort(MAPDialog arg0, MAPUserAbortChoice arg1, MAPExtensionContainer arg2) {
    }

    public void onErrorComponent(MAPDialog arg0, Long arg1, MAPErrorMessage arg2) {
    }

    public void onInvokeTimeout(MAPDialog arg0, Long arg1) {
    }

    public void onMAPMessage(MAPMessage arg0) {
    }

    public void onAlertServiceCentreRequest(AlertServiceCentreRequest arg0) {
    }

    public void onAlertServiceCentreResponse(AlertServiceCentreResponse arg0) {
    }

    public void onForwardShortMessageRequest(ForwardShortMessageRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : onForwardShortMessageRequest=" + event));
        }
        MAPDialogSms mapDialogSms = event.getMAPDialog();
        try {
            if (this.currentMapMessageCount % 7L == 0L) {
                MAPErrorMessageAbsentSubscriberSM mapErrorMessage = this.mAPErrorMessageFactory.createMAPErrorMessageAbsentSubscriberSM(AbsentSubscriberDiagnosticSM.IMSIDetached, null, null);
                mapDialogSms.sendErrorComponent(Long.valueOf(event.getInvokeId()), (MAPErrorMessage)mapErrorMessage);
            } else {
                mapDialogSms.addForwardShortMessageResponse(event.getInvokeId());
            }
        }
        catch (MAPException e) {
            logger.error((Object)"Error while sending MAPErrorMessageAbsentSubscriberSM ", (Throwable)e);
        }
        mapDialogSms.setUserObject((Object)true);
    }

    public void onForwardShortMessageResponse(ForwardShortMessageResponse arg0) {
    }

    public void onInformServiceCentreRequest(InformServiceCentreRequest arg0) {
    }

    public void onMoForwardShortMessageRequest(MoForwardShortMessageRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rx : MoForwardShortMessageRequestIndication=" + request));
        }
        MAPDialogSms dialog = request.getMAPDialog();
        try {
            dialog.addMoForwardShortMessageResponse(request.getInvokeId(), null, null);
        }
        catch (MAPException e) {
            logger.error((Object)"Error while sending MoForwardShortMessageResponse ", (Throwable)e);
        }
        dialog.setUserObject((Object)true);
        try {
            SmsSignalInfo smsSignalInfo = request.getSM_RP_UI();
            SmsTpdu smsTpdu = smsSignalInfo.decodeTpdu(true);
            if (smsTpdu.getSmsTpduType() != SmsTpduType.SMS_SUBMIT) {
                logger.error((Object)("Rx : MoForwardShortMessageRequestIndication, but SmsTpduType is not SMS_SUBMIT. SmsTpdu=" + smsTpdu));
                return;
            }
            SmsSubmitTpdu smsSubmitTpdu = (SmsSubmitTpdu)smsTpdu;
            AddressField destinationAddress = smsSubmitTpdu.getDestinationAddress();
        }
        catch (MAPException e1) {
            logger.error((Object)"Error while decoding SmsSignalInfo ", (Throwable)e1);
        }
    }

    public void onMoForwardShortMessageResponse(MoForwardShortMessageResponse arg0) {
    }

    public void onMtForwardShortMessageRequest(MtForwardShortMessageRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : onMtForwardShortMessageIndication=" + event));
        }
        MAPDialogSms mapDialogSms = event.getMAPDialog();
        try {
            if (this.currentMapMessageCount % 7L == 0L) {
                MAPErrorMessageAbsentSubscriberSM mapErrorMessage = this.mAPErrorMessageFactory.createMAPErrorMessageAbsentSubscriberSM(AbsentSubscriberDiagnosticSM.IMSIDetached, null, null);
                mapDialogSms.sendErrorComponent(Long.valueOf(event.getInvokeId()), (MAPErrorMessage)mapErrorMessage);
            } else {
                mapDialogSms.addMtForwardShortMessageResponse(event.getInvokeId(), null, null);
            }
        }
        catch (MAPException e) {
            logger.error((Object)"Error while sending MAPErrorMessageAbsentSubscriberSM ", (Throwable)e);
        }
        mapDialogSms.setUserObject((Object)true);
    }

    public void onMtForwardShortMessageResponse(MtForwardShortMessageResponse arg0) {
    }

    public void onReportSMDeliveryStatusRequest(ReportSMDeliveryStatusRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : ReportSMDeliveryStatusRequest=" + event));
        }
        MAPDialogSms dialog = event.getMAPDialog();
        try {
            dialog.addReportSMDeliveryStatusResponse(event.getInvokeId(), event.getMsisdn(), null);
        }
        catch (MAPException e) {
            e.printStackTrace();
        }
        dialog.setUserObject((Object)true);
    }

    public void onReportSMDeliveryStatusResponse(ReportSMDeliveryStatusResponse arg0) {
    }

    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : SendRoutingInfoForSMRequestIndication=" + event));
        }
        IMSIImpl imsi = new IMSIImpl("410035001692061");
        ISDNAddressStringImpl nnn = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, "923330052001");
        LocationInfoWithLMSIImpl li = new LocationInfoWithLMSIImpl((ISDNAddressString)nnn, null, null, false, null);
        MAPDialogSms mapDialogSms = event.getMAPDialog();
        try {
            mapDialogSms.addSendRoutingInfoForSMResponse(event.getInvokeId(), (IMSI)imsi, (LocationInfoWithLMSI)li, null, null);
        }
        catch (MAPException e) {
            e.printStackTrace();
        }
        mapDialogSms.setUserObject((Object)true);
    }

    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse arg0) {
    }

    public void onRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem, boolean isLocalOriginated) {
    }

    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
    }

    public void onReadyForSMRequest(ReadyForSMRequest request) {
    }

    public void onReadyForSMResponse(ReadyForSMResponse response) {
    }

    public void onNoteSubscriberPresentRequest(NoteSubscriberPresentRequest request) {
    }
}

