/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import com.google.common.annotations.VisibleForTesting;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpResponse;

public class ForwardChainExpectation {
    private final MockServerClient mockServerClient;
    private final Expectation expectation;

    public ForwardChainExpectation(MockServerClient mockServerClient, Expectation expectation) {
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
    }

    public void respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    @VisibleForTesting
    Expectation getExpectation() {
        return this.expectation;
    }
}

