/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.stop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.mockserver.stop.Stoppable;

public class StopEventQueue {
    @VisibleForTesting
    protected final List<Stoppable> stoppables = new ArrayList<Stoppable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Stoppable stoppable) {
        List<Stoppable> list = this.stoppables;
        synchronized (list) {
            this.stoppables.add(stoppable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Stoppable stoppable) {
        List<Stoppable> list = this.stoppables;
        synchronized (list) {
            this.stoppables.remove(stoppable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Stoppable> list = this.stoppables;
        synchronized (list) {
            this.stoppables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> stopOthers(Stoppable currentStoppable) {
        this.unregister(currentStoppable);
        SettableFuture stopped = SettableFuture.create();
        try {
            List<Stoppable> list = this.stoppables;
            synchronized (list) {
                for (Stoppable stoppable : new ArrayList<Stoppable>(this.stoppables)) {
                    Future<?> future = stoppable.stop();
                    if (future != null) {
                        future.get();
                    }
                    this.unregister(stoppable);
                }
            }
            stopped.set((Object)"stopped");
        }
        catch (Exception e) {
            stopped.setException((Throwable)e);
        }
        return stopped;
    }
}

