/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import ch.qos.logback.classic.Level;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.socks.SocksInitRequestDecoder;
import io.netty.handler.codec.socks.SocksMessageEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.mockserver.proxy.filters.LogFilter;
import org.mockserver.proxy.http.HttpProxyHandler;
import org.mockserver.proxy.http.direct.DirectProxyUpstreamHandler;
import org.mockserver.proxy.interceptor.RequestInterceptor;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxy {
    private static final Logger logger = LoggerFactory.getLogger(HttpProxy.class);
    private final LogFilter logFilter = new LogFilter();
    private SettableFuture<String> hasStarted;
    private ProxySelector previousProxySelector;
    private EventLoopGroup bossGroup = new NioEventLoopGroup();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();

    public static ProxySelector proxySelector() {
        if (Boolean.parseBoolean(System.getProperty("defaultProxySet"))) {
            return ProxySelector.getDefault();
        }
        if (Boolean.parseBoolean(System.getProperty("proxySet"))) {
            return HttpProxy.createProxySelector(Proxy.Type.HTTP);
        }
        throw new IllegalStateException("ProxySelector can not be returned proxy has not been started yet");
    }

    private static ProxySelector createProxySelector(final Proxy.Type http) {
        return new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Arrays.asList(new Proxy(http, new InetSocketAddress(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")))));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                logger.error("Connection could not be established to proxy at socket [" + sa + "]", (Throwable)ioe);
            }
        };
    }

    Thread start(final Integer port, final Integer securePort, final Integer socksPort, final Integer directLocalPort, final Integer directLocalSecurePort, final String directRemoteHost, final Integer directRemotePort) {
        this.hasStarted = SettableFuture.create();
        Thread proxyThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ChannelFuture httpChannel = HttpProxy.this.createHTTPChannel(port, securePort);
                    ChannelFuture httpsChannel = HttpProxy.this.createHTTPSChannel(securePort);
                    ChannelFuture socksChannel = HttpProxy.this.createSOCKSChannel(socksPort, port);
                    ChannelFuture directChannel = HttpProxy.this.createDirectChannel(directLocalPort, directRemoteHost, directRemotePort);
                    ChannelFuture directSecureChannel = HttpProxy.this.createDirectSecureChannel(directLocalSecurePort, directRemoteHost, directRemotePort);
                    if (httpChannel != null) {
                        HttpProxy.this.proxyStarted(port, false);
                    }
                    if (socksChannel != null) {
                        HttpProxy.this.proxyStarted(socksPort, true);
                    }
                    HttpProxy.this.hasStarted.set((Object)"STARTED");
                    HttpProxy.this.waitForClose(httpChannel);
                    HttpProxy.this.waitForClose(httpsChannel);
                    HttpProxy.this.waitForClose(socksChannel);
                    HttpProxy.this.waitForClose(directChannel);
                    HttpProxy.this.waitForClose(directSecureChannel);
                }
                catch (Exception ie) {
                    logger.error("Exception while running proxy channels", (Throwable)ie);
                }
                finally {
                    HttpProxy.this.bossGroup.shutdownGracefully();
                    HttpProxy.this.workerGroup.shutdownGracefully();
                }
            }
        });
        proxyThread.start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            logger.debug("Exception while waiting for proxy to complete starting up", (Throwable)e);
        }
        return proxyThread;
    }

    public void overrideLogLevel(String level) {
        Logger rootLogger = LoggerFactory.getLogger((String)"org.mockserver");
        if (rootLogger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)rootLogger).setLevel(Level.toLevel((String)level));
        }
    }

    private void waitForClose(ChannelFuture httpChannel) throws InterruptedException {
        if (httpChannel != null) {
            httpChannel.channel().closeFuture().sync();
        }
    }

    private ChannelFuture createHTTPChannel(Integer port, final Integer securePort) throws ExecutionException, InterruptedException {
        boolean condition;
        boolean bl = condition = port != null;
        if (condition) {
            logger.info("Starting HTTP proxy & HTTPS CONNECT port [" + port + "]");
        }
        return this.createBootstrap(condition, new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(HttpServerCodec.class.getSimpleName(), (ChannelHandler)new HttpServerCodec());
                pipeline.addLast(HttpProxyHandler.class.getSimpleName(), (ChannelHandler)new HttpProxyHandler(HttpProxy.this.logFilter, HttpProxy.this, securePort != null ? new InetSocketAddress(securePort) : null, false));
            }
        }, port, true);
    }

    private ChannelFuture createHTTPSChannel(final Integer securePort) throws ExecutionException, InterruptedException {
        boolean condition;
        boolean bl = condition = securePort != null;
        if (condition) {
            logger.info("Starting HTTPS proxy port [" + securePort + "]");
        }
        return this.createBootstrap(condition, new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
                engine.setUseClientMode(false);
                pipeline.addLast(SslHandler.class.getSimpleName(), (ChannelHandler)new SslHandler(engine));
                pipeline.addLast(HttpServerCodec.class.getSimpleName(), (ChannelHandler)new HttpServerCodec());
                pipeline.addLast(HttpProxyHandler.class.getSimpleName(), (ChannelHandler)new HttpProxyHandler(HttpProxy.this.logFilter, HttpProxy.this, securePort != null ? new InetSocketAddress(securePort) : null, true));
            }
        }, securePort, true);
    }

    private ChannelFuture createSOCKSChannel(Integer socksPort, final Integer port) throws ExecutionException, InterruptedException {
        boolean condition;
        boolean bl = condition = socksPort != null && port != null;
        if (condition) {
            logger.info("Starting SOCKS proxy port [" + socksPort + "]");
        }
        return this.createBootstrap(condition, new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(SocksInitRequestDecoder.class.getSimpleName(), (ChannelHandler)new SocksInitRequestDecoder());
                pipeline.addLast(SocksMessageEncoder.class.getSimpleName(), (ChannelHandler)new SocksMessageEncoder());
                pipeline.addLast(HttpProxyHandler.class.getSimpleName(), (ChannelHandler)new HttpProxyHandler(HttpProxy.this.logFilter, HttpProxy.this, new InetSocketAddress(port), false));
            }
        }, socksPort, true);
    }

    private ChannelFuture createDirectChannel(Integer directLocalPort, final String directRemoteHost, final Integer directRemotePort) throws ExecutionException, InterruptedException {
        boolean condition;
        boolean bl = condition = directLocalPort != null && directRemoteHost != null && directRemotePort != null;
        if (condition) {
            logger.info("Starting Direct proxy from port [" + directLocalPort + "] to host [" + directRemoteHost + ":" + directRemotePort + "]");
        }
        return this.createBootstrap(condition, new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                InetSocketAddress remoteSocketAddress = new InetSocketAddress(directRemoteHost, (int)directRemotePort);
                pipeline.addLast(new ChannelHandler[]{new DirectProxyUpstreamHandler(remoteSocketAddress, false, 0x100000, new RequestInterceptor(remoteSocketAddress), "                -->")});
            }
        }, directLocalPort, false);
    }

    private ChannelFuture createDirectSecureChannel(Integer directLocalSecurePort, final String directRemoteHost, final Integer directRemotePort) throws ExecutionException, InterruptedException {
        boolean condition;
        boolean bl = condition = directLocalSecurePort != null && directRemoteHost != null && directRemotePort != null;
        if (condition) {
            logger.info("Starting Direct SSL proxy from port [" + directLocalSecurePort + "] to host [" + directRemoteHost + ":" + directRemotePort + "]");
        }
        return this.createBootstrap(condition, new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
                engine.setUseClientMode(false);
                pipeline.addLast("ssl inbound", (ChannelHandler)new SslHandler(engine));
                InetSocketAddress remoteSocketAddress = new InetSocketAddress(directRemoteHost, (int)directRemotePort);
                pipeline.addLast(new ChannelHandler[]{new DirectProxyUpstreamHandler(remoteSocketAddress, true, 0x100000, new RequestInterceptor(remoteSocketAddress), "                -->")});
            }
        }, directLocalSecurePort, false);
    }

    private ChannelFuture createBootstrap(boolean condition, ChannelInitializer<SocketChannel> childHandler, Integer port, boolean autoRead) throws ExecutionException, InterruptedException {
        final SettableFuture hasConnected = SettableFuture.create();
        if (condition) {
            ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(childHandler).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.AUTO_READ, (Object)autoRead).bind(port.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        hasConnected.set((Object)future);
                    } else {
                        hasConnected.setException(future.cause());
                    }
                }
            });
        } else {
            hasConnected.set(null);
        }
        return (ChannelFuture)hasConnected.get();
    }

    protected void proxyStarted(Integer port, boolean socksProxy) {
        System.setProperty("proxySet", "true");
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("java.net.useSystemProxies", "true");
        System.setProperty("http.proxyPort", port.toString());
        if (socksProxy) {
            this.previousProxySelector = ProxySelector.getDefault();
            System.setProperty("defaultProxySet", "true");
            System.setProperty("socksProxyHost", "127.0.0.1");
            System.setProperty("socksProxyPort", port.toString());
            ProxySelector.setDefault(HttpProxy.createProxySelector(Proxy.Type.SOCKS));
        }
    }

    protected void proxyStopping() {
        ProxySelector.setDefault(this.previousProxySelector);
        System.clearProperty("proxySet");
        System.clearProperty("defaultProxySet");
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("java.net.useSystemProxies");
    }

    public void stop() {
        try {
            this.proxyStopping();
            this.workerGroup.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
            this.bossGroup.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (Exception ie) {
            logger.trace("Exception while waiting for MockServer to stop", (Throwable)ie);
        }
    }

    public boolean isRunning() {
        if (this.hasStarted.isDone()) {
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException e) {
                logger.trace("Exception while waiting for MockServer to confirm running status", (Throwable)e);
            }
            return !this.bossGroup.isShuttingDown() && !this.workerGroup.isShuttingDown();
        }
        return false;
    }
}

