/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.base.Strings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.filters.Filter;
import org.mockserver.filters.Filters;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.filters.LogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.SSLFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Proxy server;
    private final LogFilter logFilter;
    private final Filters filters = new Filters();
    private LogFormatter logFormatter = new LogFormatter(this.logger);
    private NettyHttpClient httpClient = new NettyHttpClient();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public HttpProxyHandler(Proxy server, LogFilter logFilter) {
        super(false);
        this.server = server;
        this.logFilter = logFilter;
        this.filters.withFilter(new HttpRequest(), (Filter)new HopByHopHeaderFilter());
        this.filters.withFilter(new HttpRequest(), (Filter)logFilter);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        try {
            if (request.getMethod().getValue().equals("CONNECT")) {
                PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                SSLFactory.addSubjectAlternativeName((String)request.getPath().getValue());
                ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler()});
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead((Object)request);
            } else if (request.matches("PUT", "/status")) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/clear")) {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                this.logFilter.clear(httpRequest);
                this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/reset")) {
                this.logFilter.reset();
                this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/dumpToLog")) {
                this.logFilter.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()), request.hasQueryStringParameter("type", "java"));
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/retrieve")) {
                Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.OK, this.expectationSerializer.serialize(expectations), "application/json");
            } else if (request.matches("PUT", "/verify")) {
                Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                this.logFormatter.infoLog("verifying:{}", new Object[]{verification});
                String result = this.logFilter.verify(verification);
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, "plain/text");
                }
            } else if (request.matches("PUT", "/verifySequence")) {
                VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                String result = this.logFilter.verify(verificationSequence);
                this.logFormatter.infoLog("verifying sequence:{}", new Object[]{verificationSequence});
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, "plain/text");
                }
            } else if (request.matches("PUT", "/stop")) {
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                ctx.flush();
                ctx.close();
                this.server.stop();
            } else {
                HttpResponse response = this.sendRequest(ctx.channel(), this.filters.applyOnRequestFilters(request));
                this.logFormatter.infoLog("returning response:{}" + System.getProperty("line.separator") + " for request:{}", new Object[]{response, request});
                this.writeResponse(ctx, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + request, (Throwable)e);
            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private HttpResponse sendRequest(Channel channel, HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpResponse httpResponse;
            InetSocketAddress inetSocketAddress = (InetSocketAddress)channel.attr(HttpProxy.REMOTE_SOCKET).get();
            if (inetSocketAddress != null) {
                if (inetSocketAddress.getPort() == 443 || inetSocketAddress.getPort() == 8443) {
                    httpRequest.setSecure(true);
                }
            } else if (!Strings.isNullOrEmpty((String)httpRequest.getFirstHeader("Host"))) {
                String[] hostHeaderParts = httpRequest.getFirstHeader("Host").split(":");
                Integer port = httpRequest.isSecure() ? 443 : 80;
                if (hostHeaderParts.length > 1) {
                    port = Integer.parseInt(hostHeaderParts[1]);
                }
                inetSocketAddress = new InetSocketAddress(hostHeaderParts[0], (int)port);
            } else {
                this.logger.error("Host header must be provided for requests being forwarded, the following request does not include the \"Host\" header:" + System.getProperty("line.separator") + httpRequest);
                throw new IllegalArgumentException("Host header must be provided for requests being forwarded");
            }
            if ((httpResponse = this.filters.applyOnResponseFilters(httpRequest, this.httpClient.sendRequest(OutboundHttpRequest.outboundRequest((InetSocketAddress)inetSocketAddress, (String)"", (HttpRequest)httpRequest)))) != null) {
                return httpResponse;
            }
        }
        return HttpResponse.notFoundResponse();
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        this.writeResponse(ctx, request, HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body).updateHeader(Header.header((String)"Content-Type", (String[])new String[]{contentType + "; charset=utf-8"})));
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        response.updateHeader(Header.header((String)"Content-Length", (int)response.getBody().getRawBytes().length));
        if (request.isKeepAlive()) {
            response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"keep-alive"}));
            ctx.write((Object)response);
        } else {
            response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"close"}));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("Connection reset by peer")) {
            this.logger.warn("Exception caught by MockServer handler closing pipeline", cause);
        }
        ctx.close();
    }
}

