/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mockserver.character.Character;
import org.mockserver.configuration.IntegerStringListParser;
import org.mockserver.mockserver.MockServerBuilder;
import org.mockserver.proxy.ProxyBuilder;
import org.mockserver.stop.StopEventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final String SERVER_PORT_KEY = "serverPort";
    private static final String PROXY_PORT_KEY = "proxyPort";
    private static final String PROXY_REMOTE_PORT_KEY = "proxyRemotePort";
    private static final String PROXY_REMOTE_HOST_KEY = "proxyRemoteHost";
    static final String USAGE;
    private static final Logger LOGGER;
    private static final IntegerStringListParser INTEGER_STRING_LIST_PARSER;
    @VisibleForTesting
    static ProxyBuilder httpProxyBuilder;
    @VisibleForTesting
    static MockServerBuilder mockServerBuilder;
    @VisibleForTesting
    static StopEventQueue stopEventQueue;
    @VisibleForTesting
    static PrintStream outputPrintStream;
    @VisibleForTesting
    static Runtime runtime;
    private static boolean usagePrinted;

    public static void main(String ... arguments) {
        usagePrinted = false;
        Map<String, String> parsedArguments = Main.parseArguments(arguments);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(Character.NEW_LINE + Character.NEW_LINE + "Using command line options: " + Joiner.on(", ").withKeyValueSeparator("=").join(parsedArguments) + Character.NEW_LINE);
        }
        if (parsedArguments.size() > 0 && Main.validateArguments(parsedArguments)) {
            if (parsedArguments.containsKey(SERVER_PORT_KEY)) {
                mockServerBuilder.withStopEventQueue(stopEventQueue).withHTTPPort(INTEGER_STRING_LIST_PARSER.toArray(parsedArguments.get(SERVER_PORT_KEY))).build();
            }
            if (parsedArguments.containsKey(PROXY_PORT_KEY)) {
                ProxyBuilder proxyBuilder = httpProxyBuilder.withStopEventQueue(stopEventQueue).withLocalPort(Integer.parseInt(parsedArguments.get(PROXY_PORT_KEY)));
                if (parsedArguments.containsKey(PROXY_REMOTE_PORT_KEY)) {
                    String remoteHost = parsedArguments.get(PROXY_REMOTE_HOST_KEY);
                    if (Strings.isNullOrEmpty(remoteHost)) {
                        remoteHost = "localhost";
                    }
                    proxyBuilder.withDirect(remoteHost, Integer.parseInt(parsedArguments.get(PROXY_REMOTE_PORT_KEY)));
                }
                proxyBuilder.build();
            }
        } else {
            Main.showUsage();
        }
    }

    private static boolean validateArguments(Map<String, String> parsedArguments) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        Main.validatePortListArgument(parsedArguments, SERVER_PORT_KEY, errorMessages);
        Main.validatePortArgument(parsedArguments, PROXY_PORT_KEY, errorMessages);
        Main.validatePortArgument(parsedArguments, PROXY_REMOTE_PORT_KEY, errorMessages);
        Main.validateHostnameArgument(parsedArguments, PROXY_REMOTE_HOST_KEY, errorMessages);
        if (!errorMessages.isEmpty()) {
            int maxLengthMessage = 0;
            for (String errorMessage : errorMessages) {
                if (errorMessage.length() <= maxLengthMessage) continue;
                maxLengthMessage = errorMessage.length();
            }
            outputPrintStream.println(Character.NEW_LINE + "   " + Strings.padEnd("", maxLengthMessage, '='));
            for (String errorMessage : errorMessages) {
                outputPrintStream.println("   " + errorMessage);
            }
            outputPrintStream.println("   " + Strings.padEnd("", maxLengthMessage, '=') + Character.NEW_LINE);
            return false;
        }
        return true;
    }

    private static void validatePortArgument(Map<String, String> parsedArguments, String argumentKey, List<String> errorMessages) {
        if (parsedArguments.containsKey(argumentKey) && !parsedArguments.get(argumentKey).matches("^\\d+$")) {
            errorMessages.add(argumentKey + " value \"" + parsedArguments.get(argumentKey) + "\" is invalid, please specify a port i.e. \"1080\"");
        }
    }

    private static void validatePortListArgument(Map<String, String> parsedArguments, String argumentKey, List<String> errorMessages) {
        if (parsedArguments.containsKey(argumentKey) && !parsedArguments.get(argumentKey).matches("^\\d+(,\\d+)*$")) {
            errorMessages.add(argumentKey + " value \"" + parsedArguments.get(argumentKey) + "\" is invalid, please specify a comma separated list of ports i.e. \"1080,1081,1082\"");
        }
    }

    private static void validateHostnameArgument(Map<String, String> parsedArguments, String argumentKey, List<String> errorMessages) {
        String validIpAddressRegex = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
        String validHostnameRegex = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";
        if (parsedArguments.containsKey(argumentKey) && !parsedArguments.get(argumentKey).matches(validIpAddressRegex) && !parsedArguments.get(argumentKey).matches(validHostnameRegex)) {
            errorMessages.add(argumentKey + " value \"" + parsedArguments.get(argumentKey) + "\" is invalid, please specify a host name i.e. \"localhost\" or \"127.0.0.1\"");
        }
    }

    private static Map<String, String> parseArguments(String ... arguments) {
        HashMap<String, String> parsedArguments = new HashMap<String, String>();
        Iterator<String> argumentsIterator = Arrays.asList(arguments).iterator();
        while (argumentsIterator.hasNext()) {
            String argumentName = argumentsIterator.next();
            if (argumentsIterator.hasNext()) {
                String argumentValue = argumentsIterator.next();
                if (!(Main.parsePort(parsedArguments, SERVER_PORT_KEY, argumentName, argumentValue) || Main.parsePort(parsedArguments, PROXY_PORT_KEY, argumentName, argumentValue) || Main.parsePort(parsedArguments, PROXY_REMOTE_PORT_KEY, argumentName, argumentValue) || "-proxyRemoteHost".equalsIgnoreCase(argumentName))) {
                    Main.showUsage();
                    break;
                }
                if (!"-proxyRemoteHost".equalsIgnoreCase(argumentName)) continue;
                parsedArguments.put(PROXY_REMOTE_HOST_KEY, argumentValue);
                continue;
            }
            Main.showUsage();
            break;
        }
        return parsedArguments;
    }

    private static boolean parsePort(Map<String, String> parsedArguments, String key, String argumentName, String argumentValue) {
        if (argumentName.equals("-" + key)) {
            parsedArguments.put(key, argumentValue);
            return true;
        }
        return false;
    }

    private static void showUsage() {
        if (!usagePrinted) {
            outputPrintStream.print(USAGE);
            runtime.exit(1);
            usagePrinted = true;
        }
    }

    static {
        if (System.getProperty("logback.configurationFile") == null) {
            System.setProperty("logback.configurationFile", "example_logback.xml");
            System.setProperty("mockserver.logLevel", "WARN");
        }
        USAGE = "   java -jar <path to mockserver-jetty-jar-with-dependencies.jar> [-serverPort <port>] [-proxyPort <port>] [-proxyRemotePort <port>] [-proxyRemoteHost <hostname>]" + Character.NEW_LINE + "                                                                                       " + Character.NEW_LINE + "     valid options are:                                                                " + Character.NEW_LINE + "        -serverPort <port>           Specifies the HTTP and HTTPS port(s) for the      " + Character.NEW_LINE + "                                     MockServer. Port unification is used to           " + Character.NEW_LINE + "                                     support HTTP and HTTPS on the same port(s).       " + Character.NEW_LINE + "                                                                                       " + Character.NEW_LINE + "        -proxyPort <port>            Specifies the HTTP, HTTPS, SOCKS and HTTP         " + Character.NEW_LINE + "                                     CONNECT port for proxy. Port unification          " + Character.NEW_LINE + "                                     supports for all protocols on the same port.      " + Character.NEW_LINE + "                                                                                       " + Character.NEW_LINE + "        -proxyRemotePort <port>      Specifies the port to forward all proxy           " + Character.NEW_LINE + "                                     requests to (i.e. all requests received on        " + Character.NEW_LINE + "                                     portPort). This setting is used to enable         " + Character.NEW_LINE + "                                     the port forwarding mode therefore this           " + Character.NEW_LINE + "                                     option disables the HTTP, HTTPS, SOCKS and        " + Character.NEW_LINE + "                                     HTTP CONNECT support.                             " + Character.NEW_LINE + "                                                                                       " + Character.NEW_LINE + "        -proxyRemoteHost <hostname>  Specified the host to forward all proxy           " + Character.NEW_LINE + "                                     requests to (i.e. all requests received on        " + Character.NEW_LINE + "                                     portPort). This setting is ignored unless         " + Character.NEW_LINE + "                                     proxyRemotePort has been specified. If no         " + Character.NEW_LINE + "                                     value is provided for proxyRemoteHost when        " + Character.NEW_LINE + "                                     proxyRemotePort has been specified,               " + Character.NEW_LINE + "                                     proxyRemoteHost will default to \"localhost\".    " + Character.NEW_LINE + "                                                                                       " + Character.NEW_LINE + "   i.e. java -jar ./mockserver-jetty-jar-with-dependencies.jar -serverPort 1080 -proxyPort 1090 -proxyRemotePort 80 -proxyRemoteHost www.mock-server.com" + Character.NEW_LINE + "                                                                                       " + Character.NEW_LINE;
        LOGGER = LoggerFactory.getLogger(Main.class);
        INTEGER_STRING_LIST_PARSER = new IntegerStringListParser();
        httpProxyBuilder = new ProxyBuilder();
        mockServerBuilder = new MockServerBuilder();
        stopEventQueue = new StopEventQueue();
        outputPrintStream = System.out;
        runtime = Runtime.getRuntime();
        usagePrinted = false;
    }
}

