/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.model.BinaryBodyDTO;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.JsonBodyDTO;
import org.mockserver.client.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.client.serialization.model.ParameterBodyDTO;
import org.mockserver.client.serialization.model.RegexBodyDTO;
import org.mockserver.client.serialization.model.StringBodyDTO;
import org.mockserver.client.serialization.model.XPathBodyDTO;
import org.mockserver.client.serialization.model.XmlBodyDTO;
import org.mockserver.client.serialization.model.XmlSchemaBodyDTO;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyDTODeserializer
extends StdDeserializer<BodyDTO> {
    private static final Logger logger = LoggerFactory.getLogger(BodyDTODeserializer.class);
    private static Map<String, Body.Type> fieldNameToType = new HashMap<String, Body.Type>();
    private final Base64Converter base64Converter = new Base64Converter();

    public BodyDTODeserializer() {
        super(BodyDTO.class);
    }

    @Override
    public BodyDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        Enum type = null;
        boolean not = false;
        MediaType contentType = null;
        Charset charset = null;
        MatchType matchType = JsonBody.DEFAULT_MATCH_TYPE;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (currentToken == JsonToken.START_OBJECT) {
            while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
                jsonParser.nextToken();
                if (jsonParser.getCurrentToken() == JsonToken.FIELD_NAME && jsonParser.getText().equalsIgnoreCase("type")) {
                    jsonParser.nextToken();
                    try {
                        type = Body.Type.valueOf(jsonParser.getText());
                    }
                    catch (IllegalArgumentException iae) {
                        logger.debug("Ignoring invalid value for \"type\" field of \"" + jsonParser.getText() + "\"");
                    }
                }
                if (jsonParser.getCurrentToken() == JsonToken.FIELD_NAME && this.containsIgnoreCase(jsonParser.getText(), "string", "regex", "json", "jsonSchema", "xpath", "xml", "xmlSchema", "base64Bytes") && type != Body.Type.PARAMETERS) {
                    String fieldName = jsonParser.getText().toLowerCase();
                    if (fieldNameToType.containsKey(fieldName)) {
                        type = fieldNameToType.get(fieldName);
                    }
                    jsonParser.nextToken();
                    if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                        valueJsonValue = jsonParser.getText();
                    }
                }
                if (jsonParser.getCurrentToken() == JsonToken.FIELD_NAME && jsonParser.getText().equalsIgnoreCase("not")) {
                    jsonParser.nextToken();
                    not = Boolean.parseBoolean(jsonParser.getText());
                }
                if (jsonParser.getCurrentToken() == JsonToken.FIELD_NAME && jsonParser.getText().equalsIgnoreCase("matchType")) {
                    jsonParser.nextToken();
                    try {
                        matchType = MatchType.valueOf(jsonParser.getText());
                    }
                    catch (IllegalArgumentException iae) {
                        logger.warn("Ignoring incorrect JsonBodyMatchType with value \"" + jsonParser.getText() + "\"");
                    }
                }
                if (jsonParser.getCurrentToken() == JsonToken.FIELD_NAME && jsonParser.getText().equalsIgnoreCase("contentType")) {
                    jsonParser.nextToken();
                    try {
                        contentType = MediaType.parse(jsonParser.getText());
                    }
                    catch (IllegalArgumentException uce) {
                        logger.warn("Ignoring unsupported MediaType with value \"" + jsonParser.getText() + "\"");
                    }
                }
                if (jsonParser.getCurrentToken() == JsonToken.FIELD_NAME && jsonParser.getText().equalsIgnoreCase("charset")) {
                    jsonParser.nextToken();
                    try {
                        charset = Charset.forName(jsonParser.getText());
                    }
                    catch (UnsupportedCharsetException uce) {
                        logger.warn("Ignoring unsupported Charset with value \"" + jsonParser.getText() + "\"");
                    }
                    catch (IllegalCharsetNameException icne) {
                        logger.warn("Ignoring invalid Charset with value \"" + jsonParser.getText() + "\"");
                    }
                }
                if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME || !this.containsIgnoreCase(jsonParser.getText(), "parameters", "value")) continue;
                jsonParser.nextToken();
                if (!jsonParser.isExpectedStartArrayToken()) continue;
                int objectDepth = 1;
                NottableString parameterName = NottableString.string("");
                ArrayList<NottableString> parameterValues = new ArrayList<NottableString>();
                while (objectDepth > 0) {
                    JsonToken token = jsonParser.getCurrentToken();
                    switch (token) {
                        case START_ARRAY: {
                            break;
                        }
                        case END_ARRAY: {
                            --objectDepth;
                            break;
                        }
                        case START_OBJECT: {
                            ++objectDepth;
                            parameterName = NottableString.string("");
                            parameterValues = new ArrayList();
                            break;
                        }
                        case END_OBJECT: {
                            if (--objectDepth < 1) break;
                            parameters.add(new Parameter(parameterName, parameterValues));
                            break;
                        }
                        case FIELD_NAME: {
                            if (jsonParser.getText().equalsIgnoreCase("name")) {
                                jsonParser.nextToken();
                                parameterName = this.parseNottableString(jsonParser);
                                break;
                            }
                            if (!jsonParser.getText().equalsIgnoreCase("values") || jsonParser.nextToken() != JsonToken.START_ARRAY) break;
                            while (jsonParser.nextToken() != null && jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                                parameterValues.add(this.parseNottableString(jsonParser));
                            }
                            break;
                        }
                        case VALUE_TRUE: {
                            break;
                        }
                    }
                    if (objectDepth <= 0) continue;
                    jsonParser.nextToken();
                }
            }
            if (type != null) {
                switch (1.$SwitchMap$org$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null) {
                            return new BinaryBodyDTO(new BinaryBody(this.base64Converter.base64StringToBytes(valueJsonValue), contentType), (Boolean)not);
                        }
                        return new BinaryBodyDTO(new BinaryBody(this.base64Converter.base64StringToBytes(valueJsonValue)), (Boolean)not);
                    }
                    case 2: {
                        if (contentType != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, contentType, matchType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, charset, matchType), (Boolean)not);
                        }
                        return new JsonBodyDTO(new JsonBody(valueJsonValue, matchType), (Boolean)not);
                    }
                    case 3: {
                        return new JsonSchemaBodyDTO(new JsonSchemaBody(valueJsonValue), (Boolean)not);
                    }
                    case 4: {
                        return new ParameterBodyDTO(new ParameterBody(parameters), (Boolean)not);
                    }
                    case 5: {
                        return new RegexBodyDTO(new RegexBody(valueJsonValue), (Boolean)not);
                    }
                    case 6: {
                        if (contentType != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, charset), (Boolean)not);
                        }
                        return new StringBodyDTO(new StringBody(valueJsonValue), (Boolean)not);
                    }
                    case 7: {
                        if (contentType != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, charset), (Boolean)not);
                        }
                        return new XmlBodyDTO(new XmlBody(valueJsonValue), (Boolean)not);
                    }
                    case 8: {
                        return new XmlSchemaBodyDTO(new XmlSchemaBody(valueJsonValue), (Boolean)not);
                    }
                    case 9: {
                        return new XPathBodyDTO(new XPathBody(valueJsonValue), (Boolean)not);
                    }
                }
            }
        } else if (currentToken == JsonToken.VALUE_STRING) {
            return new StringBodyDTO(new StringBody(jsonParser.getText()));
        }
        return null;
    }

    private NottableString parseNottableString(JsonParser jsonParser) throws IOException {
        NottableString nottableString = null;
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            JsonToken currentToken;
            boolean isNot = false;
            String value = "";
            while ((currentToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
                switch (currentToken) {
                    case START_ARRAY: {
                        break;
                    }
                    case START_OBJECT: {
                        break;
                    }
                    case END_OBJECT: {
                        break;
                    }
                    case FIELD_NAME: {
                        if (jsonParser.getText().equalsIgnoreCase("not")) {
                            isNot = jsonParser.nextToken() == JsonToken.VALUE_TRUE;
                            break;
                        }
                        if (!jsonParser.getText().equalsIgnoreCase("value")) break;
                        jsonParser.nextToken();
                        value = jsonParser.getText();
                        break;
                    }
                    case VALUE_TRUE: {
                        break;
                    }
                }
            }
            nottableString = NottableString.string(value, isNot);
        } else if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            String text = jsonParser.getText();
            nottableString = text.startsWith("!") ? NottableString.not(text.replaceFirst("^!", "")) : NottableString.string(text);
        }
        return nottableString;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }

    static {
        fieldNameToType.put("base64Bytes".toLowerCase(), Body.Type.BINARY);
        fieldNameToType.put("json".toLowerCase(), Body.Type.JSON);
        fieldNameToType.put("jsonSchema".toLowerCase(), Body.Type.JSON_SCHEMA);
        fieldNameToType.put("parameters".toLowerCase(), Body.Type.PARAMETERS);
        fieldNameToType.put("regex".toLowerCase(), Body.Type.REGEX);
        fieldNameToType.put("string".toLowerCase(), Body.Type.STRING);
        fieldNameToType.put("xml".toLowerCase(), Body.Type.XML);
        fieldNameToType.put("xmlSchema".toLowerCase(), Body.Type.XML_SCHEMA);
        fieldNameToType.put("xpath".toLowerCase(), Body.Type.XPATH);
    }
}

