/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.deserializers.collections;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.model.KeysToMultiValues;
import org.mockserver.model.NottableString;

public abstract class KeysToMultiValuesDeserializer<T extends KeysToMultiValues>
extends StdDeserializer<T> {
    KeysToMultiValuesDeserializer(Class<T> valueClass) {
        super(valueClass);
    }

    public abstract T build();

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            return this.deserializeArray(p, ctxt, ctxt.getNodeFactory());
        }
        if (p.isExpectedStartObjectToken()) {
            return this.deserializeObject(p, ctxt, ctxt.getNodeFactory());
        }
        return (T)((KeysToMultiValues)ctxt.handleUnexpectedToken(this._valueClass, p));
    }

    private T deserializeObject(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonToken t;
        T enteries = this.build();
        NottableString key = NottableString.string("");
        block5: while (true) {
            t = p.nextToken();
            switch (t.id()) {
                case 5: {
                    key = NottableString.deserializeNottableString(ctxt.readValue(p, String.class));
                    continue block5;
                }
                case 3: {
                    ((KeysToMultiValues)enteries).withEntry(key, NottableString.deserializeNottableStrings(ctxt.readValue(p, List.class)));
                    continue block5;
                }
                case 2: {
                    return enteries;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + (Object)((Object)t) + "\" id: \"" + t.id() + "\" text: \"" + p.getText());
    }

    private T deserializeArray(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonToken t;
        T entries = this.build();
        NottableString key = null;
        List<NottableString> values = new ArrayList<NottableString>();
        block8: while (true) {
            t = p.nextToken();
            switch (t.id()) {
                case 4: {
                    return entries;
                }
                case 1: {
                    key = null;
                    values = new ArrayList();
                    continue block8;
                }
                case 5: {
                    continue block8;
                }
                case 6: {
                    key = NottableString.deserializeNottableString(ctxt.readValue(p, String.class));
                    continue block8;
                }
                case 3: {
                    values = NottableString.deserializeNottableStrings(ctxt.readValue(p, List.class));
                    continue block8;
                }
                case 2: {
                    ((KeysToMultiValues)entries).withEntry(key, values);
                    continue block8;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + (Object)((Object)t) + "\" id: \"" + t.id() + "\" text: \"" + p.getText());
    }
}

